/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Properties;
import javax.sql.DataSource;
import org.frameworkset.tran.DataImportException;

public class DBConfig {
    private String statusTableDML;
    private String statusHistoryTableDML;
    private Integer jdbcFetchSize;
    private String dbDriver;
    private String dbUrl;
    private String dbUser;
    @JsonIgnore
    private DataSource dataSource;
    private boolean enableBalance;
    private String balance = "roundbin";
    private boolean removeAbandoned;
    private int connectionTimeout = 5000;
    private int maxWait = 3000;
    private int maxIdleTime = 600;
    @JsonIgnore
    private String dbPassword;
    private int initSize = 10;
    private int minIdleSize = 10;
    private int maxSize = 20;
    public static String sqlitex_createStatusTableSQL = "create table $statusTableName (ID varchar(100)," + "lasttime number(20)," + "lastvalue number(20)," + "strLastValue varchar(2000)," + "lastvaluetype number(1)," + "status number(1) ," + "filePath varchar(500) ," + "relativeParentDir varchar(500) ," + "fileId varchar(500) ," + "jobId varchar(500) ," + "jobType varchar(500) ," + "PRIMARY KEY (ID))";
    public static String sqlitex_createHistoryStatusTableSQL = "create table $historyStatusTableName (ID varchar(100)," + "lasttime number(20)," + "lastvalue number(20)," + "strLastValue varchar(2000)," + "lastvaluetype number(1)," + "status number(1) ," + "filePath varchar(500) ," + "relativeParentDir varchar(500) ," + "fileId varchar(500) ," + "jobId varchar(500) ," + "jobType varchar(500) ," + "statusId number(10)) ";
    public static final String mysql_createStatusTableSQL = "CREATE TABLE $statusTableName ( ID varchar(100) NOT NULL comment '\u552f\u4e00\u6807\u8bc6', lasttime bigint(20) NOT NULL comment '\u6700\u540e\u8bb0\u5f55\u65f6\u95f4\u6233', " + "lastvalue bigint(20) NOT NULL comment '\u6700\u540e\u8bb0\u5f55\u65f6\u95f4\u6233'," + "strLastValue varchar(2000) comment '\u589e\u91cf\u5b57\u6bb5\u503c\uff0c\u5b58\u50a8\u5b57\u7b26\u4e32\u5f62\u5f0f\u7684\u589e\u91cf\u503c\uff0c\u6bd4\u5982LocalDateTime'," + "lastvaluetype int(1) NOT NULL comment '\u503c\u7c7b\u578b 0-\u6570\u5b57 1-\u65e5\u671f 2-LocalDateTime'," + "status int(1)  comment '\u6570\u636e\u91c7\u96c6\u5b8c\u6210\u72b6\u6001\uff1a0-\u91c7\u96c6\u4e2d  1-\u5b8c\u6210  \u9002\u7528\u4e8e\u6587\u4ef6\u65e5\u5fd7\u91c7\u96c6 \u9ed8\u8ba4\u503c 0'," + "filePath varchar(500)  comment '\u65e5\u5fd7\u6587\u4ef6\u8def\u5f84'," + "relativeParentDir varchar(500)  comment '\u65e5\u5fd7\u6587\u4ef6\u5b50\u76ee\u5f55\u76f8\u5bf9\u8def\u5f84,relativeParentDir'," + "fileId varchar(500)  comment '\u65e5\u5fd7\u6587\u4ef6indoe\u6807\u8bc6'," + "jobId varchar(500)  comment '\u4f5c\u4e1aid'," + "jobType varchar(500)  comment '\u4f5c\u4e1a\u8f93\u5165\u63d2\u4ef6\u7c7b\u578b'," + "PRIMARY KEY(ID)) comment '\u589e\u91cf\u72b6\u6001\u540c\u6b65\u8868' ENGINE=InnoDB";
    public static final String oracle_createStatusTableSQL = "CREATE TABLE $statusTableName ( ID varchar2(100) NOT NULL, lasttime NUMBER(20) NOT NULL," + " lastvalue NUMBER(20) NOT NULL, " + "strLastValue varchar2(2000)," + "lastvaluetype NUMBER(1) NOT NULL," + "status number(1) ," + "filePath varchar2(500) ," + "relativeParentDir varchar2(500) ," + "fileId varchar2(500) ," + "jobId varchar2(500) ," + "jobType varchar2(500) ," + "constraint $statusTableName_PK primary key(ID))";
    public static final String dm_createStatusTableSQL = "CREATE TABLE $statusTableName ( ID varchar2(100) NOT NULL, lasttime NUMBER(20) NOT NULL, lastvalue NUMBER(20) NOT NULL, " + "strLastValue varchar2(2000)," + "lastvaluetype NUMBER(1) NOT NULL," + "status number(1) ," + "filePath varchar2(500) ," + "relativeParentDir varchar2(500) ," + "fileId varchar2(500) ," + "jobId varchar2(500) ," + "jobType varchar2(500) ," + "constraint $statusTableName_PK primary key(ID))";
    public static final String sqlserver_createStatusTableSQL = "CREATE TABLE $statusTableName (ID varchar(100) NOT NULL,lasttime bigint NOT NULL,lastvalue bigint NOT NULL," + "strLastValue varchar(2000)," + "lastvaluetype INT NOT NULL," + "status INT ," + "filePath varchar(500) ," + "relativeParentDir varchar(500) ," + "fileId varchar(500) ," + "jobId varchar(500) ," + "jobType varchar(500) ," + "constraint $statusTableName_PK primary key(ID))";
    public static final String postgresql_createStatusTableSQL = "CREATE TABLE $statusTableName (ID varchar(100) NOT NULL,lasttime bigint NOT NULL,lastvalue bigint NOT NULL," + "strLastValue varchar(2000)," + "lastvaluetype INT NOT NULL," + "status INT ," + "filePath varchar(500) ," + "relativeParentDir varchar(500) ," + "fileId varchar(500) ," + "jobId varchar(500) ," + "jobType varchar(500) ," + "primary key(ID))";
    public static final String mysql_createHistoryStatusTableSQL = "CREATE TABLE $historyStatusTableName ( ID varchar(100) NOT NULL comment '\u5386\u53f2\u8bb0\u5f55\u552f\u4e00\u6807\u8bc6', lasttime bigint(20) NOT NULL comment '\u6700\u540e\u540c\u6b65\u65f6\u95f4\u6233', lastvalue bigint(20) NOT NULL comment '\u6700\u540e\u8bb0\u5f55\u503c', " + "strLastValue varchar(2000) comment '\u589e\u91cf\u5b57\u6bb5\u503c\uff0c\u5b58\u50a8\u5b57\u7b26\u4e32\u5f62\u5f0f\u7684\u589e\u91cf\u503c\uff0c\u6bd4\u5982LocalDateTime'," + "lastvaluetype int(1) NOT NULL comment '\u503c\u7c7b\u578b 0-\u6570\u5b57 1-\u65e5\u671f 2-LocalDateTime'," + "status int(1)  comment '\u6570\u636e\u91c7\u96c6\u5b8c\u6210\u72b6\u6001\uff1a0-\u91c7\u96c6\u4e2d  1-\u5b8c\u6210  \u9002\u7528\u4e8e\u6587\u4ef6\u65e5\u5fd7\u91c7\u96c6 \u9ed8\u8ba4\u503c 0'," + "filePath varchar(500)  comment '\u65e5\u5fd7\u6587\u4ef6\u8def\u5f84'," + "relativeParentDir varchar(500)  comment '\u65e5\u5fd7\u6587\u4ef6\u5b50\u76ee\u5f55\u76f8\u5bf9\u8def\u5f84,relativeParentDir'," + "fileId varchar(500)  comment '\u65e5\u5fd7\u6587\u4ef6indoe\u6807\u8bc6'," + "jobId varchar(500)  comment '\u4f5c\u4e1aid 6.7.7\u7248\u672c\u65b0\u589e'," + "jobType varchar(500)  comment '\u4f5c\u4e1a\u8f93\u5165\u63d2\u4ef6\u7c7b\u578b 6.7.7\u7248\u672c\u65b0\u589e'," + "statusId varchar(100)  comment '\u589e\u91cf\u72b6\u6001\u552f\u4e00\u6807\u8bc6' ) comment '\u589e\u91cf\u72b6\u6001\u540c\u6b65\u8bb0\u5f55\u5386\u53f2\u8868' ENGINE=InnoDB";
    public static final String oracle_createHistoryStatusTableSQL = "CREATE TABLE $historyStatusTableName ( ID varchar2(100) NOT NULL, lasttime NUMBER(10) NOT NULL, lastvalue NUMBER(10) NOT NULL, " + "strLastValue varchar2(2000)," + "lastvaluetype NUMBER(1) NOT NULL," + "status number(1) ," + "filePath varchar2(500) ," + "relativeParentDir varchar2(500) ," + "fileId varchar2(500) ," + "jobId varchar2(500) ," + "jobType varchar2(500) ," + "statusId varchar2(100) )";
    public static final String dm_createHistoryStatusTableSQL = "CREATE TABLE $historyStatusTableName ( ID varchar2(100) NOT NULL, lasttime NUMBER(10) NOT NULL, lastvalue NUMBER(10) NOT NULL," + "strLastValue varchar2(2000)," + " lastvaluetype NUMBER(1) NOT NULL," + "status number(1) ," + "filePath varchar2(500) ," + "relativeParentDir varchar2(500) ," + "fileId varchar2(500) ," + "jobId varchar2(500) ," + "jobType varchar2(500) ," + "statusId varchar2(100) )";
    public static final String sqlserver_createHistoryStatusTableSQL = "CREATE TABLE $historyStatusTableName (ID varchar(100),lasttime bigint NOT NULL,lastvalue bigint NOT NULL," + "strLastValue varchar(2000)," + "lastvaluetype INT NOT NULL," + "status INT ," + "filePath varchar(500) ," + "relativeParentDir varchar(500) ," + "fileId varchar(500) ," + "jobId varchar(500) ," + "jobType varchar(500) ," + "statusId varchar(100) )";
    public static final String postgresql_createHistoryStatusTableSQL = "CREATE TABLE $historyStatusTableName (ID varchar(100),lasttime bigint NOT NULL,lastvalue bigint NOT NULL," + "strLastValue varchar(2000)," + "lastvaluetype INT NOT NULL," + "status INT ," + "filePath varchar(500) ," + "relativeParentDir varchar(500) ," + "fileId varchar(500) ," + "jobId varchar(500) ," + "jobType varchar(500) ," + "statusId varchar(100) )";
    private boolean showSql;
    private boolean usePool = false;
    private String dbtype;
    private String dbAdaptor;
    private boolean columnLableUpperCase;
    private boolean enableDBTransaction = false;
    private Properties connectionProperties;
    private String dbInfoEncryptClass;
    private String validateSQL;
    private String dbName;
    public static final String db_name_key = "db.name";
    public static final String db_user_key = "db.user";
    public static final String db_password_key = "db.password";
    public static final String db_driver_key = "db.driver";
    public static final String db_enableDBTransaction_key = "db.enableDBTransaction";
    public static final String db_url_key = "db.url";
    public static final String db_usePool_key = "db.usePool";
    public static final String db_validateSQL_key = "db.validateSQL";
    public static final String db_dbInfoEncryptClass_key = "db.dbInfoEncryptClass";
    public static final String db_removeAbandoned_key = "db.removeAbandoned";
    public static final String db_connectionTimeout_key = "db.connectionTimeout";
    public static final String db_maxWait_key = "db.maxWait";
    public static final String db_maxIdleTime_key = "db.maxIdleTime";
    public static final String db_enableBalance_key = "db.enableBalance";
    public static final String db_balance_key = "db.balance";
    public static final String db_showsql_key = "db.showsql";
    public static final String db_jdbcFetchSize_key = "db.jdbcFetchSize";
    public static final String db_initSize_key = "db.initSize";
    public static final String db_minIdleSize_key = "db.minIdleSize";
    public static final String db_maxSize_key = "db.maxSize";
    public static final String db_statusTableDML_key = "db.statusTableDML";
    public static final String db_dbAdaptor_key = "db.dbAdaptor";
    public static final String db_dbtype_key = "db.dbtype";
    public static final String db_columnLableUpperCase_key = "db.columnLableUpperCase";

    public String getDbDriver() {
        return this.dbDriver;
    }

    public static String getCreateStatusTableSQL(String dbtype) {
        if (dbtype.equals("mysql")) {
            return mysql_createStatusTableSQL;
        }
        if (dbtype.equals("oracle")) {
            return oracle_createStatusTableSQL;
        }
        if (dbtype.equals("dm")) {
            return dm_createStatusTableSQL;
        }
        if (dbtype.equals("mssql")) {
            return sqlserver_createStatusTableSQL;
        }
        if (dbtype.equals("sqlitex")) {
            return sqlitex_createStatusTableSQL;
        }
        if (dbtype.equals("postgresql")) {
            return postgresql_createStatusTableSQL;
        }
        throw new DataImportException("getCreateStatusTableSQL failed: unsupport dbtype " + dbtype + ". Use ImportBuilder to set StatusTableSQL like:" + mysql_createStatusTableSQL);
    }

    public static String getCreateHistoryStatusTableSQL(String dbtype) {
        if (dbtype.equals("mysql")) {
            return mysql_createHistoryStatusTableSQL;
        }
        if (dbtype.equals("oracle")) {
            return oracle_createHistoryStatusTableSQL;
        }
        if (dbtype.equals("dm")) {
            return dm_createHistoryStatusTableSQL;
        }
        if (dbtype.equals("mssql")) {
            return sqlserver_createHistoryStatusTableSQL;
        }
        if (dbtype.equals("sqlitex")) {
            return sqlitex_createHistoryStatusTableSQL;
        }
        if (dbtype.equals("postgresql")) {
            return postgresql_createHistoryStatusTableSQL;
        }
        throw new DataImportException("getCreateHistoryStatusTableSQL failed: unsupport dbtype " + dbtype + ". Use ImportBuilder to set HistoryStatusTableSQL like:" + mysql_createHistoryStatusTableSQL);
    }

    public static String getStatusTableDefaultValue(String dbtype) {
        if (dbtype.equals("mysql")) {
            return "null";
        }
        if (dbtype.equals("oracle")) {
            return "null";
        }
        if (dbtype.equals("dm")) {
            return "null";
        }
        if (dbtype.equals("sqlserver")) {
            return "null";
        }
        if (dbtype.equals("sqlitex")) {
            return "0";
        }
        if (dbtype.equals("postgresql")) {
            return "null";
        }
        return "null";
    }

    public static String getStatusTableType(String dbtype) {
        if (dbtype.equals("mysql")) {
            return "VARCHAR";
        }
        if (dbtype.equals("oracle")) {
            return "VARCHAR2";
        }
        if (dbtype.equals("dm")) {
            return "VARCHAR2";
        }
        if (dbtype.equals("sqlserver")) {
            return "VARCHAR";
        }
        if (dbtype.equals("sqlitex")) {
            return "VARCHAR";
        }
        if (dbtype.equals("postgresql")) {
            return "VARCHAR";
        }
        return "VARCHAR";
    }

    public static String getStatusTableTypeNumber(String dbtype) {
        if (dbtype.equals("mysql")) {
            return "int";
        }
        if (dbtype.equals("oracle")) {
            return "number";
        }
        if (dbtype.equals("dm")) {
            return "number";
        }
        if (dbtype.equals("sqlserver")) {
            return "int";
        }
        if (dbtype.equals("sqlitex")) {
            return "number";
        }
        if (dbtype.equals("postgresql")) {
            return "int";
        }
        return "int";
    }

    public static String getStatusTableTypeBigNumber(String dbtype) {
        if (dbtype.equals("mysql")) {
            return "bigint";
        }
        if (dbtype.equals("oracle")) {
            return "number";
        }
        if (dbtype.equals("dm")) {
            return "number";
        }
        if (dbtype.equals("sqlserver")) {
            return "bigint";
        }
        if (dbtype.equals("sqlitex")) {
            return "number";
        }
        if (dbtype.equals("postgresql")) {
            return "bigint";
        }
        return "bigint";
    }

    public void setDbDriver(String dbDriver) {
        this.dbDriver = dbDriver;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    @JsonIgnore
    public String getDbPassword() {
        return this.dbPassword;
    }

    @JsonIgnore
    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public String getValidateSQL() {
        return this.validateSQL;
    }

    public void setValidateSQL(String validateSQL) {
        this.validateSQL = validateSQL;
    }

    public Integer getJdbcFetchSize() {
        return this.jdbcFetchSize;
    }

    public void setJdbcFetchSize(Integer jdbcFetchSize) {
        this.jdbcFetchSize = jdbcFetchSize;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public boolean isUsePool() {
        return this.usePool;
    }

    public void setUsePool(boolean usePool) {
        this.usePool = usePool;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getMinIdleSize() {
        return this.minIdleSize;
    }

    public void setMinIdleSize(int minIdleSize) {
        this.minIdleSize = minIdleSize;
    }

    public int getInitSize() {
        return this.initSize;
    }

    public void setInitSize(int initSize) {
        this.initSize = initSize;
    }

    public String getStatusTableDML() {
        return this.statusTableDML;
    }

    public void setStatusTableDML(String statusTableDML) {
        this.statusTableDML = statusTableDML;
    }

    public String getDbtype() {
        return this.dbtype;
    }

    public void setDbtype(String dbtype) {
        this.dbtype = dbtype;
    }

    public String getDbAdaptor() {
        return this.dbAdaptor;
    }

    public void setDbAdaptor(String dbAdaptor) {
        this.dbAdaptor = dbAdaptor;
    }

    public boolean isEnableDBTransaction() {
        return this.enableDBTransaction;
    }

    public void setEnableDBTransaction(boolean enableDBTransaction) {
        this.enableDBTransaction = enableDBTransaction;
    }

    public boolean isColumnLableUpperCase() {
        return this.columnLableUpperCase;
    }

    public void setColumnLableUpperCase(boolean columnLableUpperCase) {
        this.columnLableUpperCase = columnLableUpperCase;
    }

    public String getDbInfoEncryptClass() {
        return this.dbInfoEncryptClass;
    }

    public void setDbInfoEncryptClass(String dbInfoEncryptClass) {
        this.dbInfoEncryptClass = dbInfoEncryptClass;
    }

    public boolean isRemoveAbandoned() {
        return this.removeAbandoned;
    }

    public void setRemoveAbandoned(boolean removeAbandoned) {
        this.removeAbandoned = removeAbandoned;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(int maxWait) {
        this.maxWait = maxWait;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public String getStatusHistoryTableDML() {
        return this.statusHistoryTableDML;
    }

    public void setStatusHistoryTableDML(String statusHistoryTableDML) {
        this.statusHistoryTableDML = statusHistoryTableDML;
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public void setConnectionProperties(Properties connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public void addConnectionProperty(String name, Object value) {
        if (this.connectionProperties == null) {
            this.connectionProperties = new Properties();
        }
        this.connectionProperties.put(name, value);
    }

    public String getBalance() {
        return this.balance;
    }

    public void setBalance(String balance) {
        this.balance = balance;
    }

    public boolean isEnableBalance() {
        return this.enableBalance;
    }

    public void setEnableBalance(boolean enableBalance) {
        this.enableBalance = enableBalance;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

