/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import com.frameworkset.common.poolman.util.DBConf;
import com.frameworkset.common.poolman.util.DBStartResult;
import com.frameworkset.common.poolman.util.SQLManager;
import com.frameworkset.common.poolman.util.SQLUtil;
import com.frameworkset.orm.annotation.BatchContext;
import com.frameworkset.util.SimpleStringUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.DestroyPolicy;
import org.frameworkset.tran.ExportCount;
import org.frameworkset.tran.JobCountDownLatch;
import org.frameworkset.tran.Record;
import org.frameworkset.tran.TranErrorWrapper;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.config.DynamicParam;
import org.frameworkset.tran.config.DynamicParamContext;
import org.frameworkset.tran.config.JobInputParamGroup;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.exception.ImportExceptionUtil;
import org.frameworkset.tran.listener.JobClosedListener;
import org.frameworkset.tran.metrics.MetricsLogLevel;
import org.frameworkset.tran.metrics.MetricsLogReport;
import org.frameworkset.tran.metrics.TaskMetrics;
import org.frameworkset.tran.plugin.InputPlugin;
import org.frameworkset.tran.plugin.OutputPlugin;
import org.frameworkset.tran.plugin.metrics.output.ETLMetrics;
import org.frameworkset.tran.schedule.AfterCallException;
import org.frameworkset.tran.schedule.CallInterceptor;
import org.frameworkset.tran.schedule.PreCallException;
import org.frameworkset.tran.schedule.ScheduleAssert;
import org.frameworkset.tran.schedule.ScheduleEndCall;
import org.frameworkset.tran.schedule.ScheduleService;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.schedule.timer.TimeUtil;
import org.frameworkset.tran.status.BaseStatusManager;
import org.frameworkset.tran.status.DefaultStatusManager;
import org.frameworkset.tran.status.InitLastValueClumnName;
import org.frameworkset.tran.status.LastValueWrapper;
import org.frameworkset.tran.status.LoadCurrentStatus;
import org.frameworkset.tran.status.SetLastValueType;
import org.frameworkset.tran.status.SingleStatusManager;
import org.frameworkset.tran.status.StatusManager;
import org.frameworkset.tran.util.TranUtil;
import org.frameworkset.util.ResourceEnd;
import org.frameworkset.util.ResourceStart;
import org.frameworkset.util.ResourceStartResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTranPluginImpl
implements DataTranPlugin {
    protected static Logger logger = LoggerFactory.getLogger(DataTranPluginImpl.class);
    protected InputPlugin inputPlugin;
    protected OutputPlugin outputPlugin;
    private ExportCount exportCount;
    protected StatusManager statusManager;
    protected ScheduleAssert scheduleAssert;
    protected DBStartResult dbStartResult = new DBStartResult();
    protected ImportContext importContext;
    protected ScheduleService scheduleService;
    protected Thread delayThread;
    protected Thread scheduledEndThread;
    private Object startEndScheduleThreadLock = new Object();
    protected boolean initOtherDSes;
    protected boolean initDefaultDS;
    protected volatile int status = -1;
    protected volatile CountDownLatch latch = null;
    protected volatile boolean hasTran = false;
    protected ReentrantLock lock = new ReentrantLock();
    private AtomicInteger tranCounts = new AtomicInteger(0);
    protected Object latchLock = new Object();
    private DestroyPolicy destroyPolicy;
    private TranErrorWrapper errorWrapper;
    private volatile boolean forceStop = false;
    private List<ResourceStartResult> resourceStartResults;

    @Override
    public ExportCount getExportCount() {
        return this.exportCount;
    }

    @Override
    public boolean useFilePointer() {
        return false;
    }

    @Override
    public InputPlugin getInputPlugin() {
        return this.inputPlugin;
    }

    @Override
    public OutputPlugin getOutputPlugin() {
        return this.outputPlugin;
    }

    @Override
    public StatusManager getStatusManager() {
        return this.statusManager;
    }

    @Override
    public ScheduleAssert getScheduleAssert() {
        return this.scheduleAssert;
    }

    @Override
    public void setScheduleAssert(ScheduleAssert scheduleAssert) {
        this.scheduleAssert = scheduleAssert;
    }

    protected LastValueWrapper compareValue(LastValueWrapper oldValue, LastValueWrapper newValue) {
        if (this.max(oldValue.getLastValue(), newValue.getLastValue())) {
            return newValue;
        }
        return oldValue;
    }

    @Override
    public LastValueWrapper maxLastValue(LastValueWrapper oldValue, Record record) {
        LastValueWrapper newValue = record.getLastValueWrapper();
        return this.compareValue(oldValue, newValue);
    }

    @Override
    public LastValueWrapper maxNumberLastValue(LastValueWrapper oldValue, LastValueWrapper newValue) {
        return this.compareValue(oldValue, newValue);
    }

    protected boolean max(Object oldValue, Object newValue) {
        return BaseStatusManager.max(this.importContext.getLastValueType(), oldValue, newValue);
    }

    @Override
    public Map getJobInputParams(TaskContext taskContext) {
        Map<String, DynamicParam> dynamicParams;
        Map _params = this.importContext.getJobInputParams();
        HashMap params = new HashMap();
        if (_params != null && _params.size() > 0) {
            params.putAll(_params);
        }
        if ((dynamicParams = this.importContext.getJobDynamicInputParams()) == null || dynamicParams.size() == 0) {
            return params;
        }
        Iterator<Map.Entry<String, DynamicParam>> iterator = dynamicParams.entrySet().iterator();
        DynamicParamContext dynamicParamContext = new DynamicParamContext();
        dynamicParamContext.setImportContext(this.importContext);
        dynamicParamContext.setTaskContext(taskContext);
        while (iterator.hasNext()) {
            Map.Entry<String, DynamicParam> entry = iterator.next();
            Object value = null;
            try {
                value = entry.getValue().getValue(entry.getKey(), dynamicParamContext);
            }
            catch (DataImportException e) {
                throw e;
            }
            catch (Exception e) {
                throw ImportExceptionUtil.buildDataImportException(this.importContext.getOutputPlugin(), this.importContext, "get value of " + entry.getKey() + " failed:", (Throwable)e);
            }
            if (value == null) continue;
            params.put(entry.getKey(), value);
        }
        return params;
    }

    @Override
    public boolean hasJobInputParamGroups() {
        return this.importContext.getJobInputParamGroups() != null && this.importContext.getJobInputParamGroups().size() > 0;
    }

    @Override
    public List<Map> getJobInputParamGroups(TaskContext taskContext) {
        List<JobInputParamGroup> jobInputParamGroups = this.importContext.getJobInputParamGroups();
        if (jobInputParamGroups == null) {
            return null;
        }
        ArrayList<Map> _jobInputParamGroups = new ArrayList<Map>(jobInputParamGroups.size());
        for (JobInputParamGroup jobInputParamGroup : jobInputParamGroups) {
            Map<String, DynamicParam> dynamicParams;
            Map _params = jobInputParamGroup.getJobInputParams();
            HashMap params = new HashMap();
            if (_params != null && _params.size() > 0) {
                params.putAll(_params);
            }
            if ((dynamicParams = jobInputParamGroup.getJobDynamicInputParams()) != null && dynamicParams.size() > 0) {
                Iterator<Map.Entry<String, DynamicParam>> iterator = dynamicParams.entrySet().iterator();
                DynamicParamContext dynamicParamContext = new DynamicParamContext();
                dynamicParamContext.setImportContext(this.importContext);
                dynamicParamContext.setTaskContext(taskContext);
                while (iterator.hasNext()) {
                    Map.Entry<String, DynamicParam> entry = iterator.next();
                    Object value = null;
                    try {
                        value = entry.getValue().getValue(entry.getKey(), dynamicParamContext);
                    }
                    catch (DataImportException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        ImportExceptionUtil.buildDataImportException(this.importContext.getOutputPlugin(), this.importContext, "get value of " + entry.getKey() + " failed:", (Throwable)e);
                    }
                    if (value == null) continue;
                    params.put(entry.getKey(), value);
                }
            }
            _jobInputParamGroups.add(params);
        }
        return _jobInputParamGroups;
    }

    @Override
    public Map getJobInputParams(DynamicParamContext dynamicParamContext) {
        Map<String, DynamicParam> dynamicParams;
        Map _params = this.importContext.getJobInputParams();
        HashMap params = new HashMap();
        if (_params != null && _params.size() > 0) {
            params.putAll(_params);
        }
        if ((dynamicParams = this.importContext.getJobDynamicOutputParams()) == null || dynamicParams.size() == 0) {
            return params;
        }
        for (Map.Entry<String, DynamicParam> entry : dynamicParams.entrySet()) {
            Object value = null;
            try {
                value = entry.getValue().getValue(entry.getKey(), dynamicParamContext);
            }
            catch (DataImportException e) {
                throw e;
            }
            catch (Exception e) {
                throw ImportExceptionUtil.buildDataImportException(this.importContext.getOutputPlugin(), this.importContext, "get value of " + entry.getKey() + " failed:", (Throwable)e);
            }
            if (value == null) continue;
            params.put(entry.getKey(), value);
        }
        return params;
    }

    @Override
    public Map getJobOutputParams(TaskContext taskContext) {
        Map<String, DynamicParam> dynamicParams;
        Map _params = this.importContext.getJobOutputParams();
        HashMap params = new HashMap();
        if (_params != null && _params.size() > 0) {
            params.putAll(_params);
        }
        if ((dynamicParams = this.importContext.getJobDynamicOutputParams()) == null || dynamicParams.size() == 0) {
            return params;
        }
        Iterator<Map.Entry<String, DynamicParam>> iterator = dynamicParams.entrySet().iterator();
        DynamicParamContext dynamicParamContext = new DynamicParamContext();
        dynamicParamContext.setImportContext(this.importContext);
        dynamicParamContext.setTaskContext(taskContext);
        while (iterator.hasNext()) {
            Map.Entry<String, DynamicParam> entry = iterator.next();
            Object value = null;
            try {
                value = entry.getValue().getValue(entry.getKey(), dynamicParamContext);
            }
            catch (DataImportException e) {
                throw e;
            }
            catch (Exception e) {
                throw ImportExceptionUtil.buildDataImportException(this.importContext.getOutputPlugin(), this.importContext, "get value of " + entry.getKey() + " failed:", (Throwable)e);
            }
            if (value == null) continue;
            params.put(entry.getKey(), value);
        }
        return params;
    }

    @Override
    public Map getJobOutputParams(DynamicParamContext dynamicParamContext) {
        Map<String, DynamicParam> dynamicParams;
        Map _params = this.importContext.getJobOutputParams();
        HashMap params = new HashMap();
        if (_params != null && _params.size() > 0) {
            params.putAll(_params);
        }
        if ((dynamicParams = this.importContext.getJobDynamicOutputParams()) == null || dynamicParams.size() == 0) {
            return params;
        }
        for (Map.Entry<String, DynamicParam> entry : dynamicParams.entrySet()) {
            Object value = null;
            try {
                value = entry.getValue().getValue(entry.getKey(), dynamicParamContext);
            }
            catch (DataImportException e) {
                throw e;
            }
            catch (Exception e) {
                throw ImportExceptionUtil.buildDataImportException(this.importContext.getOutputPlugin(), this.importContext, "get value of " + entry.getKey() + " failed:", (Throwable)e);
            }
            if (value == null) continue;
            params.put(entry.getKey(), value);
        }
        return params;
    }

    @Override
    public boolean isSchedulePaussed(boolean autoPause) {
        if (this.scheduleAssert != null) {
            boolean paused;
            boolean bl = paused = !this.scheduleAssert.assertSchedule(autoPause);
            if (paused) {
                this.scheduleAssert.pausedAwait();
            }
        }
        return false;
    }

    @Override
    public BaseDataTran createBaseDataTran(TaskContext taskContext, TranResultSet tranResultSet, JobCountDownLatch countDownLatch, Status currentStatus) {
        return this.outputPlugin.createBaseDataTran(taskContext, tranResultSet, countDownLatch, currentStatus);
    }

    @Override
    public void callTran(BaseDataTran baseDataTran) {
        try {
            baseDataTran.tran();
        }
        catch (DataImportException dataImportException) {
            throw dataImportException;
        }
        catch (RuntimeException dataImportException) {
            throw dataImportException;
        }
        finally {
            baseDataTran.stop2ndClearResultsetQueue(true);
        }
    }

    @Override
    public void doImportData(TaskContext taskContext) {
        if (this.checkTranToStop()) {
            return;
        }
        this.inputPlugin.doImportData(taskContext);
    }

    @Override
    public void addStatus(Status currentStatus) throws DataImportException {
        if (this.statusManager.isIncreamentImport()) {
            this.statusManager.addStatus(currentStatus);
        }
    }

    @Override
    public boolean isComplete(Status status) {
        return status.getStatus() == 1;
    }

    public boolean isLostFile(Status status) {
        return status.getStatus() == 2;
    }

    @Override
    public Context buildContext(TaskContext taskContext, Record record, BatchContext batchContext) {
        return this.inputPlugin.buildContext(taskContext, record, batchContext);
    }

    @Override
    public String getLastValueVarName() {
        return this.inputPlugin.getLastValueVarName();
    }

    @Override
    public Long getTimeRangeLastValue() {
        return this.inputPlugin.getTimeRangeLastValue();
    }

    public DataTranPluginImpl(ImportContext importContext) {
        this.importContext = importContext;
        importContext.setDataTranPlugin(this);
    }

    @Override
    public ImportContext getImportContext() {
        return this.importContext;
    }

    @Override
    public void setImportContext(ImportContext importContext) {
        this.importContext = importContext;
    }

    protected boolean isPrintTaskLog() {
        return this.importContext.isPrintTaskLog() && logger.isInfoEnabled();
    }

    @Override
    public void preCall(TaskContext taskContext) {
        List<CallInterceptor> callInterceptors = this.importContext.getCallInterceptors();
        if (callInterceptors == null || callInterceptors.size() == 0) {
            return;
        }
        for (CallInterceptor callInterceptor : callInterceptors) {
            try {
                callInterceptor.preCall(taskContext);
            }
            catch (DataImportException e) {
                throw new PreCallException(e);
            }
            catch (Exception e) {
                throw new PreCallException(e);
            }
        }
        TranUtil.initTaskContextSQLInfo(taskContext, this.importContext);
    }

    @Override
    public void afterCall(TaskContext taskContext) {
        List<CallInterceptor> callInterceptors = this.importContext.getCallInterceptors();
        if (callInterceptors == null || callInterceptors.size() == 0) {
            return;
        }
        CallInterceptor callInterceptor = null;
        for (int j = callInterceptors.size() - 1; j >= 0; --j) {
            callInterceptor = callInterceptors.get(j);
            try {
                callInterceptor.afterCall(taskContext);
                continue;
            }
            catch (Exception e) {
                logger.error("afterCall failed:", (Throwable)e);
                this.throwException(taskContext, new AfterCallException("afterCall failed:", e));
            }
        }
    }

    @Override
    public void throwException(TaskContext taskContext, Throwable e) {
        List<CallInterceptor> callInterceptors = this.importContext.getCallInterceptors();
        if (callInterceptors == null || callInterceptors.size() == 0) {
            logger.error("afterCall failed:", e);
            return;
        }
        CallInterceptor callInterceptor = null;
        for (int j = callInterceptors.size() - 1; j >= 0; --j) {
            callInterceptor = callInterceptors.get(j);
            try {
                callInterceptor.throwException(taskContext, e);
                continue;
            }
            catch (Exception e1) {
                logger.error("afterCall failed:", (Throwable)e1);
            }
        }
    }

    @Override
    public void reportJobMetricDebug(TaskContext taskContext, String msg) {
        if (!MetricsLogLevel.isDebugEnabled(this.importContext.getMetricsLogLevel())) {
            return;
        }
        MetricsLogReport metricsLogReport = this.importContext.getMetricsLogReport();
        if (metricsLogReport == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("reportJobMetricDebug:{}", (Object)msg);
            }
            return;
        }
        try {
            if (taskContext == null) {
                taskContext = new TaskContext(this.importContext, true);
            }
            metricsLogReport.reportJobMetricDebug(taskContext, msg);
        }
        catch (Exception e1) {
            logger.error("reportJobMetricDebug failed:" + msg, (Throwable)e1);
        }
    }

    @Override
    public void reportJobMetricErrorLog(TaskContext taskContext, String msg, Throwable e) {
        if (!MetricsLogLevel.isErrorEnabled(this.importContext.getMetricsLogLevel())) {
            return;
        }
        MetricsLogReport metricsLogReport = this.importContext.getMetricsLogReport();
        if (metricsLogReport == null) {
            if (logger.isErrorEnabled()) {
                logger.error("reportMetricErrorLog:" + msg, e);
            }
            return;
        }
        try {
            if (taskContext == null) {
                taskContext = new TaskContext(this.importContext, true);
            }
            metricsLogReport.reportJobMetricErrorLog(taskContext, msg, e);
        }
        catch (Exception e1) {
            logger.error("reportMetricErrorLog failed:" + msg, (Throwable)e1);
        }
    }

    @Override
    public void reportJobMetricLog(TaskContext taskContext, String msg) {
        if (!MetricsLogLevel.isInfoEnabled(this.importContext.getMetricsLogLevel())) {
            return;
        }
        MetricsLogReport metricsLogReport = this.importContext.getMetricsLogReport();
        if (metricsLogReport == null) {
            if (logger.isInfoEnabled()) {
                logger.info("reportMetricLog:{}", (Object)msg);
            }
            return;
        }
        try {
            if (taskContext == null) {
                taskContext = new TaskContext(this.importContext, true);
            }
            metricsLogReport.reportJobMetricLog(taskContext, msg);
        }
        catch (Exception e1) {
            logger.error("reportMetricLog:{}", (Object)msg);
        }
    }

    @Override
    public void reportJobMetricWarn(TaskContext taskContext, String msg) {
        if (!MetricsLogLevel.isWarnEnabled(this.importContext.getMetricsLogLevel())) {
            return;
        }
        MetricsLogReport metricsLogReport = this.importContext.getMetricsLogReport();
        if (metricsLogReport == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("reportMetricWarn:{}", (Object)msg);
            }
            return;
        }
        try {
            if (taskContext == null) {
                taskContext = new TaskContext(this.importContext, true);
            }
            metricsLogReport.reportJobMetricWarn(taskContext, msg);
        }
        catch (Exception e1) {
            logger.error("reportMetricWarn:{}", (Object)msg);
        }
    }

    @Override
    public void reportTaskMetricErrorLog(TaskMetrics taskMetrics, String msg, Throwable e) {
        if (!MetricsLogLevel.isErrorEnabled(this.importContext.getMetricsLogLevel())) {
            return;
        }
        MetricsLogReport metricsLogReport = this.importContext.getMetricsLogReport();
        if (metricsLogReport == null) {
            logger.error("reportTaskMetricErrorLog:" + msg, e);
            return;
        }
        try {
            metricsLogReport.reportTaskMetricErrorLog(taskMetrics, msg, e);
        }
        catch (Exception e1) {
            logger.error("reportTaskMetricErrorLog:" + msg, e);
        }
    }

    @Override
    public void reportTaskMetricLog(TaskMetrics taskMetrics, String msg) {
        if (!MetricsLogLevel.isInfoEnabled(this.importContext.getMetricsLogLevel())) {
            return;
        }
        MetricsLogReport metricsLogReport = this.importContext.getMetricsLogReport();
        if (metricsLogReport == null) {
            if (logger.isInfoEnabled()) {
                logger.info("reportTaskMetricLog:{}", (Object)msg);
            }
            return;
        }
        try {
            metricsLogReport.reportTaskMetricLog(taskMetrics, msg);
        }
        catch (Exception e1) {
            logger.error("reportTaskMetricLog:" + msg, (Throwable)e1);
        }
    }

    @Override
    public void reportTaskMetricWarn(TaskMetrics taskMetrics, String msg) {
        if (!MetricsLogLevel.isWarnEnabled(this.importContext.getMetricsLogLevel())) {
            return;
        }
        MetricsLogReport metricsLogReport = this.importContext.getMetricsLogReport();
        if (metricsLogReport == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("reportTaskMetricWarn:{}", (Object)msg);
            }
            return;
        }
        try {
            metricsLogReport.reportTaskMetricWarn(taskMetrics, msg);
        }
        catch (Exception e1) {
            logger.error("reportTaskMetricWarn:" + msg, (Throwable)e1);
        }
    }

    @Override
    public void reportTaskMetricDebug(TaskMetrics taskMetrics, String msg) {
        if (!MetricsLogLevel.isDebugEnabled(this.importContext.getMetricsLogLevel())) {
            return;
        }
        MetricsLogReport metricsLogReport = this.importContext.getMetricsLogReport();
        if (metricsLogReport == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("reportTaskMetricDebug:{}", (Object)msg);
            }
            return;
        }
        try {
            metricsLogReport.reportTaskMetricDebug(taskMetrics, msg);
        }
        catch (Exception e1) {
            logger.error("reportTaskMetricDebug:" + msg, (Throwable)e1);
        }
    }

    @Override
    public boolean isEnableAutoPauseScheduled() {
        return true;
    }

    protected void delay() {
        Long deyLay = this.importContext.getDeyLay();
        Date date = this.importContext.getScheduleDate();
        long _delay = 0L;
        if (date != null) {
            _delay = date.getTime() - System.currentTimeMillis();
        } else if (deyLay != null && deyLay > 0L) {
            _delay = deyLay;
        }
        final long tmp = _delay;
        if (tmp > 0L) {
            this.delayThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(tmp);
                    }
                    catch (InterruptedException e) {
                        logger.info("job delay is interrupted.");
                    }
                }
            }, "Datatran-DelayThread");
            this.delayThread.start();
            try {
                this.delayThread.join();
            }
            catch (InterruptedException e) {
                logger.info("job delay join is interrupted.");
            }
            this.delayThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startEndScheduleThread(boolean scheduled, final ScheduleEndCall scheduleEndCall) {
        Date scheduleEndDate = this.importContext.getScheduleEndDate();
        if (scheduled && scheduleEndDate != null) {
            if (this.importContext.isExecuteOneTime()) {
                logger.info("\u4e00\u6b21\u6027\u6267\u884c\u4f5c\u4e1a\uff0c\u5ffd\u7565Start EndSchedule Thread\uff1ascheduleEndDate[{}]", (Object)DateFormatUtils.format((Date)scheduleEndDate, (String)"yyyy-MM-dd HH:mm:ss.SSS"));
                return;
            }
            Object object = this.startEndScheduleThreadLock;
            synchronized (object) {
                if (this.scheduledEndThread == null) {
                    final long waitTime = scheduleEndDate.getTime() - System.currentTimeMillis();
                    this.scheduledEndThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (waitTime > 0L) {
                                try {
                                    Thread.sleep(waitTime);
                                    scheduleEndCall.call(true);
                                }
                                catch (InterruptedException interruptedException) {}
                            } else {
                                scheduleEndCall.call(true);
                            }
                        }
                    }, "Datatran-ScheduledEndThread");
                    this.scheduledEndThread.setDaemon(true);
                    this.scheduledEndThread.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void importData(ScheduleEndCall scheduleEndCall) throws DataImportException {
        if (this.checkTranToStop()) {
            return;
        }
        if (this.scheduleService == null || this.importContext.isExecuteOneTime()) {
            this.delay();
            if (this.checkTranToStop()) {
                return;
            }
            long importStartTime = System.currentTimeMillis();
            TaskContext taskContext = this.inputPlugin.isEnablePluginTaskIntercept() ? new TaskContext(this.importContext) : null;
            Exception exception = null;
            try {
                if (this.inputPlugin.isEnablePluginTaskIntercept()) {
                    this.preCall(taskContext);
                }
                this.inputPlugin.doImportData(taskContext);
                if (this.inputPlugin.isEnablePluginTaskIntercept()) {
                    this.afterCall(taskContext);
                }
                long importEndTime = System.currentTimeMillis();
                if (this.isPrintTaskLog()) {
                    logger.info("Execute job Take " + (importEndTime - importStartTime) + " ms");
                }
                if (this.importContext.getDataTranPlugin().isMultiTran()) return;
                this.importContext.finishAndWaitTran(exception);
                return;
            }
            catch (Exception e) {
                try {
                    if (this.inputPlugin.isEnablePluginTaskIntercept()) {
                        this.throwException(taskContext, e);
                    }
                    logger.error("scheduleImportData failed:", (Throwable)e);
                    exception = e;
                    if (this.importContext.getDataTranPlugin().isMultiTran()) return;
                    this.importContext.finishAndWaitTran(exception);
                    return;
                }
                catch (Throwable throwable) {
                    if (this.importContext.getDataTranPlugin().isMultiTran()) throw throwable;
                    this.importContext.finishAndWaitTran(exception);
                    throw throwable;
                }
            }
        }
        try {
            if (!this.importContext.isExternalTimer()) {
                Date scheduleEndDate = this.importContext.getScheduleEndDate();
                Date now = new Date();
                if (scheduleEndDate != null && now.after(scheduleEndDate)) {
                    logger.info("Job scheduleEndDate reached,Ignore schedule this job.");
                    return;
                }
                boolean scheduled = this.scheduleService.timeSchedule();
                this.startEndScheduleThread(scheduled, scheduleEndCall);
                return;
            } else {
                this.startEndScheduleThread(true, scheduleEndCall);
                if (this.scheduleService.isSchedulePaused(this.isEnableAutoPauseScheduled()) && this.checkTranToStop()) {
                    if (!logger.isInfoEnabled()) return;
                    logger.info("Schedule Task has stopped,stop resume schedule.");
                    return;
                }
                this.scheduleService.externalTimeSchedule();
            }
            return;
        }
        catch (DataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw ImportExceptionUtil.buildDataImportException(this.importContext, e);
        }
    }

    public void beforeInit() {
        this.inputPlugin.beforeInit();
        this.outputPlugin.beforeInit();
    }

    @Override
    public void initStatusTableId() {
        this.inputPlugin.initStatusTableId();
    }

    @Override
    public void loadCurrentStatus(List<Status> statuses) {
    }

    @Override
    public String getJobType() {
        return this.inputPlugin.getJobType();
    }

    @Override
    public LoadCurrentStatus getLoadCurrentStatus() {
        return this.statusManager.getLoadCurrentStatus();
    }

    protected void initStatusManager() {
        this.statusManager = new SingleStatusManager(this);
    }

    private void _initStatusManager() {
        if (this.importContext.isAsynFlushStatus()) {
            this.initStatusManager();
        } else {
            this.statusManager = new DefaultStatusManager(this);
        }
        this.statusManager.initTableAndStatus(this.getInitLastValueClumnName());
    }

    protected InitLastValueClumnName getInitLastValueClumnName() {
        return new InitLastValueClumnName(){

            @Override
            public void initLastValueClumnName() {
                DataTranPluginImpl.this.statusManager.initLastValueClumnName();
            }
        };
    }

    @Override
    public SetLastValueType getSetLastValueType() {
        return new SetLastValueType(){

            @Override
            public void set() {
                DataTranPluginImpl.this.statusManager.initLastValueType();
            }
        };
    }

    public void initDefaultDS() {
        if (this.initDefaultDS) {
            return;
        }
        try {
            DBConfig dbConfig = this.importContext.getDefaultDBConfig();
            if (dbConfig != null) {
                DataTranPluginImpl.initDS(this.dbStartResult, dbConfig);
            }
        }
        finally {
            this.initDefaultDS = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initOtherDSes() {
        if (this.initOtherDSes) {
            return;
        }
        try {
            List<DBConfig> dbConfigs = this.importContext.getOhterDBConfigs();
            if (dbConfigs != null && dbConfigs.size() > 0) {
                for (DBConfig dbConfig : dbConfigs) {
                    DataTranPluginImpl.initDS(this.dbStartResult, dbConfig);
                }
            }
        }
        finally {
            this.initOtherDSes = true;
        }
    }

    public static void initDS(DBStartResult dbStartResult, DBConfig dbConfig) {
        if (dbConfig != null) {
            if (SimpleStringUtil.isEmpty((String)dbConfig.getDbName())) {
                throw new DataImportException("dbname can not be empty in DBConfig " + SimpleStringUtil.object2json((Object)dbConfig));
            }
            if (!dbStartResult.contain(dbConfig.getDbName())) {
                if (SimpleStringUtil.isNotEmpty((String)dbConfig.getDbDriver()) && SimpleStringUtil.isEmpty((String)dbConfig.getDbUrl())) {
                    throw new DataImportException("DbUrl can not be empty in DBConfig " + SimpleStringUtil.object2json((Object)dbConfig));
                }
                if (SimpleStringUtil.isEmpty((String)dbConfig.getDbDriver()) && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbUrl())) {
                    throw new DataImportException("DbDriver can not be empty in DBConfig " + SimpleStringUtil.object2json((Object)dbConfig));
                }
            }
        }
        if (dbConfig != null && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbName()) && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbDriver()) && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbUrl()) && !dbStartResult.contain(dbConfig.getDbName())) {
            DBConf temConf = new DBConf();
            temConf.setPoolname(dbConfig.getDbName());
            temConf.setDriver(dbConfig.getDbDriver());
            temConf.setJdbcurl(dbConfig.getDbUrl());
            temConf.setUsername(dbConfig.getDbUser());
            temConf.setPassword(dbConfig.getDbPassword());
            temConf.setReadOnly(null);
            temConf.setTxIsolationLevel(null);
            temConf.setValidationQuery(dbConfig.getValidateSQL());
            temConf.setJndiName(dbConfig.getDbName() + "_jndi");
            temConf.setInitialConnections(dbConfig.getInitSize());
            temConf.setMinimumSize(dbConfig.getMinIdleSize());
            temConf.setMaximumSize(dbConfig.getMaxSize());
            temConf.setUsepool(dbConfig.isUsePool());
            temConf.setExternal(false);
            temConf.setExternaljndiName(null);
            temConf.setShowsql(dbConfig.isShowSql());
            temConf.setEncryptdbinfo(false);
            temConf.setQueryfetchsize(dbConfig.getJdbcFetchSize() == null ? null : dbConfig.getJdbcFetchSize());
            temConf.setDbAdaptor(dbConfig.getDbAdaptor());
            temConf.setDbtype(dbConfig.getDbtype());
            temConf.setColumnLableUpperCase(dbConfig.isColumnLableUpperCase());
            temConf.setDbInfoEncryptClass(dbConfig.getDbInfoEncryptClass());
            temConf.setConnectionTimeout(dbConfig.getConnectionTimeout());
            temConf.setMaxIdleTime(dbConfig.getMaxIdleTime());
            temConf.setMaxWait(dbConfig.getMaxWait());
            temConf.setConnectionProperties(dbConfig.getConnectionProperties());
            temConf.setEnableBalance(dbConfig.isEnableBalance());
            temConf.setBalance(dbConfig.getBalance());
            temConf.setDatasource(dbConfig.getDataSource());
            boolean ret = SQLManager.startPool((DBConf)temConf);
            if (ret) {
                dbStartResult.addDBStartResult(temConf.getPoolname());
            }
        } else if (dbConfig.getDataSource() != null) {
            DBConf temConf = new DBConf();
            temConf.setPoolname(dbConfig.getDbName());
            temConf.setJndiName(dbConfig.getDbName() + "_jndi");
            temConf.setDriver(dbConfig.getDbDriver());
            temConf.setShowsql(dbConfig.isShowSql());
            temConf.setQueryfetchsize(dbConfig.getJdbcFetchSize() == null ? null : dbConfig.getJdbcFetchSize());
            temConf.setDbAdaptor(dbConfig.getDbAdaptor());
            temConf.setDbtype(dbConfig.getDbtype());
            temConf.setColumnLableUpperCase(dbConfig.isColumnLableUpperCase());
            temConf.setDatasource(dbConfig.getDataSource());
            boolean ret = SQLManager.startPool((DBConf)temConf);
            if (ret) {
                dbStartResult.addDBStartResult(temConf.getPoolname());
            }
        }
    }

    @Override
    public void init(ImportContext importContext) {
        this.importContext = importContext;
        this.importContext.initJobcontext();
        this.importContext.initETLMetrics();
        this.exportCount = new ExportCount();
        this.inputPlugin = importContext.getInputPlugin();
        this.outputPlugin = importContext.getOutputPlugin();
        this.inputPlugin.setDataTranPlugin(this);
        this.outputPlugin.setDataTranPlugin(this);
        this.initDefaultDS();
        this.initOtherDSes();
        this.beforeInit();
        this.inputPlugin.init();
        this.outputPlugin.init();
        this.initSchedule();
        this._initStatusManager();
        this.inputPlugin.afterInit();
        this.outputPlugin.afterInit();
    }

    @Override
    public boolean isMultiTran() {
        return this.inputPlugin.isMultiTran();
    }

    @Override
    public String getLastValueClumnName() {
        return this.statusManager.getLastValueClumnName();
    }

    @Override
    public boolean isContinueOnError() {
        return this.importContext.isContinueOnError();
    }

    @Override
    public Status getCurrentStatus() {
        return this.statusManager.getCurrentStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initLatch() {
        Object object = this.latchLock;
        synchronized (object) {
            if (this.latch == null || this.latch.getCount() == 0L) {
                this.latch = new CountDownLatch(1);
            }
        }
    }

    @Override
    public void setHasTran() {
        this.lock.lock();
        try {
            this.initLatch();
            this.tranCounts.incrementAndGet();
            this.hasTran = true;
            if (this.status == 3 || this.status == -1) {
                this.status = 0;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void latchCountDown() {
        Object object = this.latchLock;
        synchronized (object) {
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
    }

    public void checkHasTranAndSetPLUGIN_STOPREADY() {
        this.lock.lock();
        try {
            if (!this.hasTran) {
                this.status = this.status != 2 ? 3 : 6;
                this.latchCountDown();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isHasTran() {
        this.lock.lock();
        try {
            boolean bl = this.hasTran;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static void stopDatasources(DBStartResult dbStartResult) {
        Map dbs;
        if (dbStartResult != null && (dbs = dbStartResult.getDbstartResult()) != null && dbs.size() > 0) {
            for (Map.Entry entry : dbs.entrySet()) {
                String db = (String)entry.getKey();
                try {
                    SQLUtil.stopPool((String)db);
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("SQLUtil.stopPool(" + db + ") failed:", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void setNoTran() {
        this._setNoTran(true);
    }

    protected void _setNoTran(boolean modifyStatus) {
        this.lock.lock();
        try {
            int count = this.tranCounts.decrementAndGet();
            if (count <= 0) {
                this.hasTran = false;
                if (modifyStatus) {
                    this.status = this.status != 2 ? 3 : 6;
                    this.latchCountDown();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isStopCollectData() {
        return this.inputPlugin.isStopCollectData();
    }

    @Override
    public boolean isPluginStopREADY() {
        return this.status == 3 || this.status == 6;
    }

    @Override
    public boolean isPluginStopAppending() {
        this.lock.lock();
        try {
            boolean bl = this.status == 2 || this.status == 6;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean checkTranToStop() {
        this.lock.lock();
        try {
            boolean bl = this.status == 2 || this.status == 6 || this.status == 5;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void canFinishTran(boolean onceTaskFinish) {
        try {
            CountDownLatch countDownLatch = null;
            Object object = this.latchLock;
            synchronized (object) {
                countDownLatch = this.latch;
            }
            if (countDownLatch != null) {
                countDownLatch.await();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void checkTranFinished(boolean onceTaskFinished) {
        this.canFinishTran(onceTaskFinished);
    }

    protected void destroyExportResultHandler() {
        this.importContext.getOutputConfig().destroyExportResultHandler();
    }

    protected void _afterDestory(boolean onceTaskFinished, boolean waitTranStop, boolean fromScheduleEnd, Throwable throwable) {
        this.checkTranFinished(onceTaskFinished);
        this.destroyExportResultHandler();
        this.stopMetrics();
        if (this.statusManager != null) {
            this.statusManager.stop();
        }
        this.endAction();
        this.inputPlugin.destroy(waitTranStop);
        this.outputPlugin.destroy(waitTranStop);
        this.statusManager.stopStatusDatasource();
        DataTranPluginImpl.stopDatasources(this.dbStartResult);
        this.status = 5;
        this.importContext.cleanResource();
        List<JobClosedListener> jobClosedListeners = this.importContext.getJobClosedListeners();
        if (jobClosedListeners != null && jobClosedListeners.size() > 0) {
            for (JobClosedListener jobClosedListener : jobClosedListeners) {
                try {
                    jobClosedListener.jobClosed(this.importContext, throwable);
                }
                catch (Exception e) {
                    logger.warn("Execute jobclose callback failed: ", (Throwable)e);
                }
            }
        }
    }

    private void endAction() {
        if (this.importContext.getEndAction() != null) {
            try {
                this.importContext.getEndAction().endAction();
            }
            catch (Exception e) {
                logger.error("importContext.getEndAction().endAction failed:", (Throwable)e);
            }
        }
    }

    private void stopMetrics() {
        List<ETLMetrics> etlMetrics = this.importContext.getMetrics();
        if (etlMetrics != null && etlMetrics.size() > 0) {
            for (ETLMetrics etlMetric : etlMetrics) {
                try {
                    etlMetric.stopMetrics();
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
        if ((etlMetrics = this.importContext.getOutputConfig().getMetrics()) != null && etlMetrics.size() > 0) {
            for (ETLMetrics etlMetric : etlMetrics) {
                try {
                    etlMetric.stopMetrics();
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void finishAndWaitTran(Throwable throwable) {
        if (this.checkTranToStop()) {
            return;
        }
        logger.info("Finish datatran job begin.");
        if (this.scheduleService != null) {
            this.scheduleService.stop();
        }
        if (throwable != null) {
            try {
                this.inputPlugin.stopCollectData();
            }
            catch (Exception e) {
                logger.warn("", (Throwable)e);
            }
            try {
                this.outputPlugin.stopCollectData();
            }
            catch (Exception e) {
                logger.warn("", (Throwable)e);
            }
        }
        if (this.delayThread != null) {
            try {
                this.delayThread.interrupt();
                this.delayThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.scheduledEndThread != null) {
            try {
                this.scheduledEndThread.interrupt();
                this.scheduledEndThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.scheduledEndThread = null;
        }
        this._afterDestory(true, true, false, throwable);
        logger.info("Finish datatran job completed.");
    }

    protected void PLUGIN_STOPAPPENDING() {
        this.lock.lock();
        try {
            if (this.status != 3) {
                if (this.hasTran) {
                    this.status = 2;
                } else {
                    this.status = 6;
                    this.latchCountDown();
                }
            } else {
                this.status = 6;
                this.latchCountDown();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public DestroyPolicy getDestroyPolicy() {
        return this.destroyPolicy;
    }

    @Override
    public void destroy(DestroyPolicy destroyPolicy) {
        if (this.checkTranToStop()) {
            return;
        }
        this.destroyPolicy = destroyPolicy;
        final boolean waitTranStop = destroyPolicy.isWaitTranStopped();
        final boolean fromScheduleEnd = destroyPolicy.isFromScheduleEnd();
        if (logger.isInfoEnabled()) {
            logger.info("Destroy datatran job begin with waitTranStop {} fromScheduleEnd {}", (Object)waitTranStop, (Object)fromScheduleEnd);
        }
        this.PLUGIN_STOPAPPENDING();
        if (this.scheduleAssert != null) {
            this.scheduleAssert.stopAndInteruptPause();
        }
        if (this.scheduleService != null) {
            this.scheduleService.stop();
        }
        try {
            this.inputPlugin.stopCollectData();
        }
        catch (Exception e) {
            logger.warn("", (Throwable)e);
        }
        try {
            this.outputPlugin.stopCollectData();
        }
        catch (Exception e) {
            logger.warn("", (Throwable)e);
        }
        if (this.delayThread != null) {
            try {
                this.delayThread.interrupt();
                this.delayThread.join();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!fromScheduleEnd && this.scheduledEndThread != null) {
            try {
                this.scheduledEndThread.interrupt();
                this.scheduledEndThread.join();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.scheduledEndThread = null;
        }
        if (waitTranStop) {
            this._afterDestory(false, waitTranStop, fromScheduleEnd, null);
            if (logger.isInfoEnabled()) {
                logger.info("Destroy datatran job complete with waitTranStop {} fromScheduleEnd {}", (Object)waitTranStop, (Object)fromScheduleEnd);
            }
        } else {
            Thread stopThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    DataTranPluginImpl.this._afterDestory(false, waitTranStop, fromScheduleEnd, null);
                    if (logger.isInfoEnabled()) {
                        logger.info("Destroy datatran job complete with waitTranStop {} fromScheduleEnd {}", (Object)waitTranStop, (Object)fromScheduleEnd);
                    }
                }
            }, "Destroy-DataTranPlugin-Thread");
            stopThread.start();
        }
    }

    @Override
    public Object[] putLastParamValue(Map params) {
        return this.statusManager.putLastParamValue(params);
    }

    @Override
    public boolean isIncreamentImport() {
        return this.statusManager.isIncreamentImport();
    }

    @Override
    public Map getParamValue(Map params) {
        return this.statusManager.getParamValue(params);
    }

    @Override
    public int getLastValueType() {
        return this.statusManager.getLastValueType();
    }

    @Override
    public boolean isSingleLastValueType() {
        return true;
    }

    @Override
    public void flushLastValue(LastValueWrapper lastValueWrapper, Status currentStatus, boolean reachEOFClosed) {
        this.statusManager.flushLastValue(lastValueWrapper, currentStatus, reachEOFClosed);
    }

    @Override
    public boolean needUpdateLastValueWrapper(Integer lastValueType, LastValueWrapper oldValue, LastValueWrapper newValue) {
        return BaseStatusManager.needUpdate(lastValueType, oldValue.getLastValue(), newValue.getLastValue());
    }

    @Override
    public void handleOldedTasks(List<Status> olded) {
        this.statusManager.handleOldedTasks(olded);
    }

    @Override
    public void handleOldedTask(Status olded) {
        this.statusManager.handleOldedTask(olded);
    }

    @Override
    public ScheduleService getScheduleService() {
        return this.scheduleService;
    }

    public TranErrorWrapper getErrorWrapper() {
        return this.errorWrapper;
    }

    @Override
    public void setErrorWrapper(TranErrorWrapper errorWrapper) {
        this.errorWrapper = errorWrapper;
    }

    @Override
    public void setForceStop() {
        this.forceStop = true;
    }

    @Override
    public boolean assertCondition() {
        if (this.forceStop) {
            return false;
        }
        if (this.errorWrapper != null) {
            return this.errorWrapper.assertCondition();
        }
        return true;
    }

    public boolean assertCondition(Exception e) {
        if (this.errorWrapper != null) {
            return this.errorWrapper.assertCondition(e);
        }
        return true;
    }

    public void initSchedule() {
        if (this.importContext.getScheduleConfig() != null) {
            this.scheduleService = new ScheduleService();
            this.scheduleService.setEnablePluginTaskIntercept(this.inputPlugin.isEnablePluginTaskIntercept());
            this.scheduleService.init(this.importContext);
        }
    }

    @Override
    public void initResources(ResourceStart resourceStart) {
        try {
            ResourceStartResult resourceStartResult = resourceStart.startResource();
            if (resourceStartResult != null) {
                if (this.resourceStartResults == null) {
                    this.resourceStartResults = new ArrayList<ResourceStartResult>();
                }
                this.resourceStartResults.add(resourceStartResult);
            }
        }
        catch (DataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataImportException("Resource Start failed:", e);
        }
    }

    @Override
    public void destroyResources(ResourceEnd resourceEnd) {
        if (this.resourceStartResults != null) {
            for (ResourceStartResult resourceStartResult : this.resourceStartResults) {
                try {
                    resourceEnd.endResource(resourceStartResult);
                }
                catch (Exception e) {
                    logger.error("End Resource failed:", (Throwable)e);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void initLastValueStatus(Status currentStatus, BaseStatusManager baseStatusManager) throws Exception {
        LastValueWrapper lastValueWrapper = currentStatus.getCurrentLastValueWrapper();
        if (this.importContext.isLastValueDateType()) {
            Object configLastValue = this.importContext.getConfigLastValue();
            if (configLastValue == null) {
                lastValueWrapper.setLastValue(baseStatusManager.getInitLastDate());
                return;
            }
            if (configLastValue instanceof Date) {
                lastValueWrapper.setLastValue(configLastValue);
                return;
            }
            if (configLastValue instanceof Long) {
                lastValueWrapper.setLastValue(new Date((Long)configLastValue));
                return;
            }
            if (configLastValue instanceof BigDecimal) {
                lastValueWrapper.setLastValue(new Date(((BigDecimal)configLastValue).longValue()));
                return;
            }
            if (configLastValue instanceof Integer) {
                lastValueWrapper.setLastValue(new Date(((Integer)configLastValue).intValue()));
                return;
            }
            if (!logger.isInfoEnabled()) throw ImportExceptionUtil.buildDataImportException(this.importContext, "TIMESTAMP TYPE Last Value Illegal:" + configLastValue);
            logger.info("TIMESTAMP TYPE Last Value Illegal:{}", configLastValue);
            throw ImportExceptionUtil.buildDataImportException(this.importContext, "TIMESTAMP TYPE Last Value Illegal:" + configLastValue);
        }
        if (this.importContext.isLastValueNumberType()) {
            if (this.importContext.getConfigLastValue() != null) {
                lastValueWrapper.setLastValue(this.importContext.getConfigLastValue());
                return;
            }
            lastValueWrapper.setLastValue(0L);
            return;
        }
        if (!this.importContext.isLastValueLocalDateTimeType()) return;
        Object configLastValue = this.importContext.getConfigLastValue();
        if (configLastValue == null) {
            lastValueWrapper.setLastValue(baseStatusManager.getInitLastLocalDateTime());
            return;
        }
        if (configLastValue instanceof String) {
            LocalDateTime localDateTime = TimeUtil.localDateTime((String)((String)configLastValue));
            lastValueWrapper.setLastValue(localDateTime);
            lastValueWrapper.setStrLastValue((String)configLastValue);
            return;
        }
        if (configLastValue instanceof LocalDateTime) {
            lastValueWrapper.setLastValue(configLastValue);
            lastValueWrapper.setStrLastValue(TimeUtil.changeLocalDateTime2String((LocalDateTime)((LocalDateTime)configLastValue), (String)this.importContext.getLastValueDateformat()));
            return;
        }
        if (!logger.isInfoEnabled()) throw ImportExceptionUtil.buildDataImportException(this.importContext, "TIMESTAMP TYPE Last Value Illegal:" + configLastValue);
        logger.info("TIMESTAMP TYPE Last Value Illegal:{}", configLastValue);
        throw ImportExceptionUtil.buildDataImportException(this.importContext, "TIMESTAMP TYPE Last Value Illegal:" + configLastValue);
    }
}

