/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.Record;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.exception.ImportExceptionUtil;
import org.frameworkset.tran.schedule.TaskContext;

public abstract class LastValue
implements TranResultSet {
    protected ImportContext importContext;
    protected BaseDataTran baseDataTran;
    protected Record record;
    private volatile int status = 0;
    private Object stopLock = new Object();

    @Override
    public BaseDataTran getBaseDataTran() {
        return this.baseDataTran;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStop() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.status == 1 || this.status == 3;
        }
    }

    @Override
    public TaskContext getRecordTaskContext() {
        return this.record.getTaskContext();
    }

    @Override
    public Record getCurrentRecord() {
        return this.record;
    }

    public boolean isStop(boolean forceStop) {
        if (forceStop) {
            return this.isStop();
        }
        return this.isStopFromException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopFromException() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.status == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean exception) {
        if (this.status != 0) {
            return;
        }
        Object object = this.stopLock;
        synchronized (object) {
            if (this.status != 0) {
                return;
            }
            this.status = !exception ? 1 : 3;
        }
    }

    @Override
    public Map<String, Object> getMetaDatas() {
        return this.record.getMetaDatas();
    }

    @Override
    public int getAction() {
        return this.record.getAction();
    }

    @Override
    public TaskContext getTaskContext() {
        return this.baseDataTran.getTaskContext();
    }

    @Override
    public void setBaseDataTran(BaseDataTran baseDataTran) {
        this.baseDataTran = baseDataTran;
    }

    public void setImportContext(ImportContext importContext) {
        this.importContext = importContext;
    }

    @Override
    public Object getValue(String colName) throws DataImportException {
        Object value = this.record.getValue(colName);
        return value;
    }

    @Override
    public Object getLastValue(String colName) throws DataImportException {
        try {
            if (this.importContext.getLastValueType() == null || this.importContext.getLastValueType() == 0) {
                return this.getValue(this.importContext.getLastValueColumnName());
            }
            if (this.importContext.getLastValueType() == 1) {
                if (this.importContext.getLastValueDateformat() == null || this.importContext.getLastValueDateformat().equals("")) {
                    return this.getDateTimeValue(this.importContext.getLastValueColumnName());
                }
                return this.getDateTimeValue(this.importContext.getLastValueColumnName(), this.importContext.getLastValueDateformat());
            }
            if (this.importContext.getLastValueType() == 2) {
                return this.getLocalDateTimeValue(this.importContext.getLastValueColumnName());
            }
            if (this.importContext.getLastValueType() == 3) {
                if (this.importContext.getLastValueColumnName() != null) {
                    return this.getValue(this.importContext.getLastValueColumnName());
                }
                return null;
            }
        }
        catch (DataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw ImportExceptionUtil.buildDataImportException(this.importContext, e);
        }
        throw ImportExceptionUtil.buildDataImportException(this.importContext, "Unsupport last value type:" + this.importContext.getLastValueType());
    }

    @Override
    public Object getLastOffsetValue() throws DataImportException {
        Record record = this.getCurrentRecord();
        return record.getOffset();
    }

    @Override
    public Object getLastValue() {
        if (!this.importContext.useFilePointer()) {
            if (this.importContext.getLastValueColumnName() == null) {
                return -1;
            }
            return this.getLastValue(this.importContext.getLastValueColumnName());
        }
        return this.getLastOffsetValue();
    }

    @Override
    public Date getDateTimeValue(String colName) throws DataImportException {
        return this.record.getDateTimeValue(colName);
    }

    @Override
    public Date getDateTimeValue(String colName, String format) throws DataImportException {
        return this.record.getDateTimeValue(colName, format);
    }

    @Override
    public LocalDateTime getLocalDateTimeValue(String colName) throws DataImportException {
        return this.record.getLocalDateTimeValue(colName);
    }
}

