/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.tran.context.ImportContext;

public class TranErrorWrapper {
    protected ImportContext importContext;
    protected volatile Throwable error;
    private Lock lock = new ReentrantLock();
    private boolean stopFromError;

    public TranErrorWrapper(ImportContext importContext) {
        this.importContext = importContext;
    }

    public Throwable throwError() throws Exception {
        return this.error;
    }

    public void setError(Throwable error) {
        if (this.error == null) {
            this.lock.lock();
            try {
                if (this.error == null) {
                    this.error = error;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public boolean exceptionOccur(Throwable e) {
        return e != null || this.error != null;
    }

    public Throwable getError(Throwable exception) {
        return exception != null ? exception : this.error;
    }

    public boolean assertCondition() {
        return this.assertCondition(this.error);
    }

    public boolean assertCondition(Throwable e) {
        if (this.error == null && e != null) {
            this.setError(e);
        }
        boolean bl = this.stopFromError = this.exceptionOccur(e) && !this.importContext.isContinueOnError();
        if (this.stopFromError) {
            return false;
        }
        return TranErrorWrapper.assertCondition(this.importContext);
    }

    public boolean isStopFromError() {
        return this.stopFromError;
    }

    private static boolean assertCondition(ImportContext importContext) {
        return !importContext.isCurrentStoped();
    }
}

