/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.context;

import com.frameworkset.orm.annotation.BatchContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.DataRefactor;
import org.frameworkset.tran.DataStream;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.DestroyPolicy;
import org.frameworkset.tran.EndAction;
import org.frameworkset.tran.ExportCount;
import org.frameworkset.tran.ImportEndAction;
import org.frameworkset.tran.ImportStartAction;
import org.frameworkset.tran.Record;
import org.frameworkset.tran.WrapedExportResultHandler;
import org.frameworkset.tran.config.BaseImportConfig;
import org.frameworkset.tran.config.DynamicParam;
import org.frameworkset.tran.config.ImportBuilder;
import org.frameworkset.tran.config.InputConfig;
import org.frameworkset.tran.config.JobInputParamGroup;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.context.JobContext;
import org.frameworkset.tran.jobflow.context.JobFlowExecuteContext;
import org.frameworkset.tran.jobflow.context.JobFlowNodeExecuteContext;
import org.frameworkset.tran.listener.JobClosedListener;
import org.frameworkset.tran.metrics.BaseMetricsLogReport;
import org.frameworkset.tran.metrics.ETLMetricsCallInterceptor;
import org.frameworkset.tran.metrics.JobTaskMetrics;
import org.frameworkset.tran.metrics.MetricsLogReport;
import org.frameworkset.tran.plugin.InputPlugin;
import org.frameworkset.tran.plugin.OutputPlugin;
import org.frameworkset.tran.plugin.metrics.output.ETLMetrics;
import org.frameworkset.tran.plugin.metrics.output.MetricsOutputConfig;
import org.frameworkset.tran.plugin.multi.output.MultiOutputConfig;
import org.frameworkset.tran.record.SplitHandler;
import org.frameworkset.tran.schedule.CallInterceptor;
import org.frameworkset.tran.schedule.ScheduleConfig;
import org.frameworkset.tran.schedule.ScheduleService;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.status.LastValueWrapper;
import org.frameworkset.util.ResourceEnd;
import org.frameworkset.util.ResourceStart;
import org.frameworkset.util.concurrent.ThreadPoolFactory;

public class BaseImportContext
extends BaseMetricsLogReport
implements ImportContext {
    protected BaseImportConfig baseImportConfig;
    protected InputConfig inputConfig;
    protected OutputConfig outputConfig;
    protected JobContext jobContext;
    protected EndAction endAction;
    private DataStream dataStream;
    private boolean currentStoped = false;
    private ExecutorService blockedExecutor;
    private Object blockedExecutorLock = new Object();

    @Override
    public int getMetricsLogLevel() {
        return this.baseImportConfig.getMetricsLogLevel();
    }

    @Override
    public JobContext getJobContext() {
        return this.jobContext;
    }

    @Override
    public Object getJobContextData(String name) {
        return this.jobContext.getJobData(name);
    }

    @Override
    public boolean isSerial() {
        return this.getStoreBatchSize() <= 0;
    }

    @Override
    public boolean isParallelBatch() {
        return this.getStoreBatchSize() > 0 && this.getThreadCount() > 0 && this.isParallel();
    }

    @Override
    public boolean isBatch() {
        return this.getStoreBatchSize() > 0;
    }

    public void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
    }

    @Override
    public JobTaskMetrics createJobTaskMetrics() {
        return this.getOutputPlugin().createJobTaskMetrics();
    }

    @Override
    public ImportStartAction getImportStartAction() {
        return this.baseImportConfig.getImportStartAction();
    }

    @Override
    public DBConfig getDefaultDBConfig() {
        return this.baseImportConfig.getDefaultDBConfig();
    }

    @Override
    public List<DBConfig> getOhterDBConfigs() {
        return this.baseImportConfig.getConfigs();
    }

    @Override
    public DataTranPlugin buildDataTranPlugin() {
        return this.inputConfig.buildDataTranPlugin(this);
    }

    @Override
    public boolean isIncreamentImport() {
        return this.dataTranPlugin.isIncreamentImport();
    }

    public void setBaseImportConfig(BaseImportConfig baseImportConfig) {
        this.baseImportConfig = baseImportConfig;
    }

    public void setInputConfig(InputConfig inputConfig) {
        this.inputConfig = inputConfig;
    }

    public void setOutputConfig(OutputConfig outputConfig) {
        this.outputConfig = outputConfig;
    }

    public void afterBuild(ImportBuilder importBuilder) {
        this.inputConfig.afterBuild(importBuilder, this);
        this.outputConfig.afterBuild(importBuilder, this);
        if (this.baseImportConfig.isFlushMetricsOnScheduleTaskCompleted()) {
            List<ETLMetrics> metrics = null;
            if (this.getMetrics() != null && this.getMetrics().size() > 0) {
                metrics = this.getMetrics();
            } else if (this.outputConfig instanceof MetricsOutputConfig) {
                metrics = this.outputConfig.getMetrics();
            }
            importBuilder.addCallInterceptor(new ETLMetricsCallInterceptor(metrics, this), true);
            this.baseImportConfig.setCallInterceptors(importBuilder.taskCallInterceptors());
        }
    }

    @Override
    public ImportContext addResourceStart(ResourceStart resourceStart) {
        if (resourceStart != null) {
            this.dataTranPlugin.initResources(resourceStart);
        }
        return this;
    }

    @Override
    public void destroyResources(ResourceEnd resourceEnd) {
        if (resourceEnd != null) {
            this.dataTranPlugin.destroyResources(resourceEnd);
        }
    }

    @Override
    public InputConfig getInputConfig() {
        return this.inputConfig;
    }

    @Override
    public OutputConfig getOutputConfig() {
        return this.outputConfig;
    }

    @Override
    public <T extends OutputConfig> T getOutputConfig(Class<T> outputConfigClass) {
        if (outputConfigClass.isInstance(this.outputConfig)) {
            return (T)this.outputConfig;
        }
        if (this.outputConfig instanceof MultiOutputConfig) {
            return ((MultiOutputConfig)this.outputConfig).getOutputConfig(outputConfigClass);
        }
        return null;
    }

    @Override
    public <T extends OutputConfig> List<T> getOutputConfigs(Class<T> outputConfigClass) {
        if (outputConfigClass.isInstance(this.outputConfig)) {
            ArrayList<OutputConfig> ts = new ArrayList<OutputConfig>(1);
            ts.add(this.outputConfig);
            return ts;
        }
        if (this.outputConfig instanceof MultiOutputConfig) {
            return ((MultiOutputConfig)this.outputConfig).getOutputConfigs(outputConfigClass);
        }
        return null;
    }

    @Override
    public InputPlugin getInputPlugin() {
        if (this.dataTranPlugin != null && this.dataTranPlugin.getInputPlugin() != null) {
            return this.dataTranPlugin.getInputPlugin();
        }
        return this.inputConfig.getInputPlugin(this);
    }

    @Override
    public OutputPlugin getOutputPlugin() {
        if (this.dataTranPlugin != null && this.dataTranPlugin.getOutputPlugin() != null) {
            return this.dataTranPlugin.getOutputPlugin();
        }
        return this.outputConfig.getOutputPlugin(this);
    }

    @Override
    public boolean isLastValueColumnSetted() {
        return this.baseImportConfig.isLastValueColumnSetted();
    }

    @Override
    public Map getJobOutputParams() {
        return this.baseImportConfig.getJobOutputParams();
    }

    @Override
    public List<JobClosedListener> getJobClosedListeners() {
        return this.baseImportConfig.getJobClosedListeners();
    }

    @Override
    public Map getJobInputParams() {
        return this.baseImportConfig.getJobInputParams();
    }

    @Override
    public List<JobInputParamGroup> getJobInputParamGroups() {
        return this.baseImportConfig.getJobInputParamGroups();
    }

    @Override
    public Map<String, DynamicParam> getJobDynamicInputParams() {
        return this.baseImportConfig.getJobDynamicInputParams();
    }

    @Override
    public Map<String, DynamicParam> getJobDynamicOutputParams() {
        return this.baseImportConfig.getJobDynamicOutputParams();
    }

    @Override
    public String[] getExportColumns() {
        return this.baseImportConfig.getExportColumns();
    }

    @Override
    public boolean useFilePointer() {
        return this.dataTranPlugin.useFilePointer();
    }

    public BaseImportContext() {
    }

    @Override
    public long getLogsendTaskMetric() {
        return this.baseImportConfig.getLogsendTaskMetric();
    }

    @Override
    public boolean serialAllData() {
        return this.baseImportConfig.isSerialAllData();
    }

    @Override
    public Integer increamentEndOffset() {
        return this.baseImportConfig.getIncreamentEndOffset();
    }

    @Override
    public boolean isNumberTypeTimestamp() {
        return this.baseImportConfig.isNumberTypeTimestamp();
    }

    @Override
    public boolean isAsynFlushStatus() {
        return this.baseImportConfig.isAsynFlushStatus();
    }

    @Override
    public long getAsynFlushStatusInterval() {
        return this.baseImportConfig.getAsynFlushStatusInterval();
    }

    @Override
    public SplitHandler getSplitHandler() {
        return this.baseImportConfig.getSplitHandler();
    }

    @Override
    public String getSplitFieldName() {
        return this.baseImportConfig.getSplitFieldName();
    }

    @Override
    public Context buildContext(TaskContext taskContext, Record record, BatchContext batchContext) {
        return this.dataTranPlugin.buildContext(taskContext, record, batchContext);
    }

    @Override
    public Long getTimeRangeLastValue() {
        return this.dataTranPlugin.getTimeRangeLastValue();
    }

    @Override
    public long getFlushInterval() {
        return this.baseImportConfig.getFlushInterval();
    }

    @Override
    public boolean isIgnoreNullValueField() {
        return this.baseImportConfig.isIgnoreNullValueField();
    }

    @Override
    public boolean isSortLastValue() {
        return this.baseImportConfig.isSortLastValue();
    }

    @Override
    public long getAsynResultPollTimeOut() {
        return this.baseImportConfig.getAsynResultPollTimeOut();
    }

    @Override
    public Integer getFetchSize() {
        return this.baseImportConfig.getFetchSize();
    }

    public void init() {
    }

    @Override
    public int getTranDataBufferQueue() {
        return this.baseImportConfig.getTranDataBufferQueue();
    }

    public BaseImportContext(BaseImportConfig baseImportConfig) {
        this.baseImportConfig = baseImportConfig;
    }

    @Override
    public ExportCount getExportCount() {
        return this.dataTranPlugin.getExportCount();
    }

    @Override
    public void setStatusTableId(int hashCode) {
        this.baseImportConfig.setStatusTableId(this.buildStatusId(hashCode));
    }

    @Override
    public String buildStatusId(int hashCode) {
        String jobId = this.getJobId();
        String jobType = this.getJobType();
        if (jobId != null) {
            Integer statusIdPolicy = this.getStatusIdPolicy();
            if (statusIdPolicy != null && statusIdPolicy == 1) {
                return jobType + "-" + jobId;
            }
            return jobType + "-" + jobId + "-" + hashCode;
        }
        return jobType + "-" + hashCode;
    }

    @Override
    public Integer getStatusIdPolicy() {
        return this.getInputConfig().getStatusIdPolicy(this);
    }

    @Override
    public DataRefactor getDataRefactor() {
        return this.baseImportConfig.getDataRefactor();
    }

    @Override
    public String getApplicationPropertiesFile() {
        return this.baseImportConfig.getApplicationPropertiesFile();
    }

    public List<DBConfig> getConfigs() {
        return this.baseImportConfig.getConfigs();
    }

    @Override
    public boolean isPrintTaskLog() {
        return this.baseImportConfig.isPrintTaskLog();
    }

    @Override
    public void setDataRefactor(DataRefactor dataRefactor) {
        this.baseImportConfig.setDataRefactor(dataRefactor);
    }

    @Override
    public void destroy(DestroyPolicy destroyPolicy) {
        if (this.dataTranPlugin != null) {
            this.dataTranPlugin.destroy(destroyPolicy);
        }
    }

    @Override
    public void finishAndWaitTran(Throwable throwable) {
        if (this.dataTranPlugin != null) {
            this.dataTranPlugin.finishAndWaitTran(throwable);
        }
    }

    @Override
    public void registEndAction(EndAction endAction) {
        this.endAction = endAction;
    }

    @Override
    public EndAction getEndAction() {
        return this.endAction;
    }

    @Override
    public void cleanResource() {
        try {
            if (this.blockedExecutor != null) {
                ThreadPoolFactory.shutdownExecutor((ExecutorService)this.blockedExecutor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.currentStoped = true;
    }

    @Override
    public boolean isContinueOnError() {
        return this.baseImportConfig.isContinueOnError();
    }

    @Override
    public boolean assertCondition() {
        return this.dataTranPlugin.assertCondition();
    }

    @Override
    public List<CallInterceptor> getCallInterceptors() {
        return this.baseImportConfig.getCallInterceptors();
    }

    @Override
    public MetricsLogReport getMetricsLogReport() {
        return this.baseImportConfig.getMetricsLogReport();
    }

    @Override
    public boolean isCurrentStoped() {
        return this.currentStoped;
    }

    @Override
    public ScheduleConfig getScheduleConfig() {
        return this.baseImportConfig.getScheduleConfig();
    }

    @Override
    public boolean isExecuteOneTime() {
        ScheduleConfig scheduleConfig = this.getScheduleConfig();
        if (scheduleConfig != null) {
            return scheduleConfig.isExecuteOneTime();
        }
        return false;
    }

    @Override
    public Boolean getFixedRate() {
        return this.baseImportConfig.getScheduleConfig().getFixedRate();
    }

    @Override
    public ScheduleService getScheduleService() {
        return this.dataTranPlugin.getScheduleService();
    }

    @Override
    public BaseImportConfig getImportConfig() {
        return this.baseImportConfig;
    }

    @Override
    public Boolean isConfigIncreamentImport() {
        return this.baseImportConfig.getIncreamentImport();
    }

    @Override
    public int getMaxRetry() {
        return this.baseImportConfig.getMaxRetry();
    }

    @Override
    public boolean isAsyn() {
        return this.baseImportConfig.isAsyn();
    }

    @Override
    public boolean validateIncreamentConfig() {
        String column;
        Integer type;
        if (this.isConfigIncreamentImport() != null && this.isConfigIncreamentImport().booleanValue()) {
            return this.baseImportConfig.getImportIncreamentConfig() != null && this.baseImportConfig.getImportIncreamentConfig().validate();
        }
        return this.baseImportConfig.getImportIncreamentConfig() == null || (type = this.baseImportConfig.getImportIncreamentConfig().getLastValueType()) == null || type != 1 && type != 2 || (column = this.baseImportConfig.getImportIncreamentConfig().getLastValueColumn()) != null && !column.trim().equals("");
    }

    @Override
    public WrapedExportResultHandler getExportResultHandler(OutputConfig outputConfig) {
        WrapedExportResultHandler wrapedExportResultHandler = outputConfig.getExportResultHandler();
        if (wrapedExportResultHandler == null) {
            wrapedExportResultHandler = this.getExportResultHandler();
        }
        return wrapedExportResultHandler;
    }

    @Override
    public WrapedExportResultHandler getExportResultHandler() {
        return this.outputConfig.getExportResultHandler();
    }

    @Override
    public void flushLastValue(LastValueWrapper lastValue, Status currentStatus) {
        this.flushLastValue(lastValue, currentStatus, false);
    }

    @Override
    public void flushLastValue(LastValueWrapper lastValue, Status currentStatus, boolean reachEOFClosed) {
        this.dataTranPlugin.flushLastValue(lastValue, currentStatus, reachEOFClosed);
    }

    @Override
    public boolean isLastValueDateType() {
        return this.baseImportConfig.isLastValueDateType();
    }

    @Override
    public boolean isLastValueNumberType() {
        return this.baseImportConfig.isLastValueNumberType();
    }

    @Override
    public boolean isLastValueStringType() {
        return this.baseImportConfig.isLastValueStringType();
    }

    @Override
    public boolean isLastValueLocalDateTimeType() {
        return this.baseImportConfig.isLastValueLocalDateTimeType();
    }

    @Override
    public Integer getLastValueType() {
        return this.baseImportConfig.getLastValueType();
    }

    @Override
    public DBConfig getStatusDbConfig() {
        return this.baseImportConfig.getStatusDbConfig();
    }

    @Override
    public boolean isExternalTimer() {
        return this.baseImportConfig.isExternalTimer();
    }

    @Override
    public String getLastValueColumn() {
        return this.baseImportConfig.getLastValueColumn();
    }

    @Override
    public String getLastValueColumnName() {
        return this.dataTranPlugin.getLastValueClumnName();
    }

    @Override
    public boolean isImportIncreamentConfigSetted() {
        return this.baseImportConfig.isImportIncreamentConfigSetted();
    }

    @Override
    public Object getConfigLastValue() {
        return this.baseImportConfig.getConfigLastValue();
    }

    @Override
    public String getLastValueStoreTableName() {
        return this.baseImportConfig.getLastValueStoreTableName();
    }

    @Override
    public String getLastValueStorePath() {
        return this.baseImportConfig.getLastValueStorePath();
    }

    @Override
    public String getLastValueStorePassword() {
        return this.baseImportConfig.getLastValueStorePassword();
    }

    @Override
    public boolean needUpdateLastValueWrapper(LastValueWrapper oldValue, LastValueWrapper newValue) {
        return this.dataTranPlugin.needUpdateLastValueWrapper(this.getLastValueType(), oldValue, newValue);
    }

    @Override
    public LastValueWrapper max(LastValueWrapper oldValue, Record record) {
        return this.dataTranPlugin.maxLastValue(oldValue, record);
    }

    public void setLastValueDateformat(String lastValueDateformat) {
        this.baseImportConfig.setLastValueDateformat(lastValueDateformat);
    }

    @Override
    public String getLastValueDateformat() {
        return this.baseImportConfig.getLastValueDateformat();
    }

    @Override
    public void setLastValueType(int lastValueType) {
        this.baseImportConfig.setLastValueType(lastValueType);
    }

    @Override
    public int getThreadCount() {
        return this.baseImportConfig.getThreadCount();
    }

    @Override
    public boolean isParallel() {
        return this.baseImportConfig.isParallel();
    }

    @Override
    public int getQueue() {
        return this.baseImportConfig.getQueue();
    }

    @Override
    public void resume() {
        this.currentStoped = false;
    }

    @Override
    public String getDateFormat() {
        return this.baseImportConfig.getDateFormat();
    }

    @Override
    public String getLocale() {
        return this.baseImportConfig.getLocale();
    }

    @Override
    public String getTimeZone() {
        return this.baseImportConfig.getTimeZone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutorService buildThreadPool() {
        if (this.blockedExecutor != null) {
            return this.blockedExecutor;
        }
        Object object = this.blockedExecutorLock;
        synchronized (object) {
            if (this.blockedExecutor == null) {
                this.blockedExecutor = ThreadPoolFactory.buildThreadPool((String)"DataTranTaskThread", (String)"DataTranTaskThread", (int)this.getThreadCount(), (int)this.getQueue(), (long)-1L, (int)1000);
            }
        }
        return this.blockedExecutor;
    }

    @Override
    public Integer getStoreBatchSize() {
        if (this.baseImportConfig.getScheduleBatchSize() == null) {
            return this.baseImportConfig.getBatchSize();
        }
        return this.baseImportConfig.getScheduleBatchSize();
    }

    @Override
    public String getStatusTableId() {
        return this.baseImportConfig.getStatusTableId();
    }

    @Override
    public boolean isFromFirst() {
        return this.baseImportConfig.isFromFirst();
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.baseImportConfig.setBatchSize(batchSize);
    }

    @Override
    public boolean isSchedulePaused(boolean autoPause) {
        return this.dataTranPlugin.isSchedulePaussed(autoPause);
    }

    @Override
    public List<ImportEndAction> getImportEndActions() {
        return this.baseImportConfig.getImportEndActions();
    }

    @Override
    public String getJobName() {
        return this.baseImportConfig.getJobName();
    }

    @Override
    public Date getScheduleDate() {
        return this.baseImportConfig.getScheduleDate();
    }

    @Override
    public Date getScheduleEndDate() {
        return this.baseImportConfig.getScheduleEndDate();
    }

    @Override
    public Long getDeyLay() {
        return this.baseImportConfig.getDeyLay();
    }

    @Override
    public String getJobId() {
        return this.baseImportConfig.getJobId();
    }

    @Override
    public String getJobType() {
        return this.dataTranPlugin.getJobType();
    }

    @Override
    public String getDataTimeField() {
        return this.baseImportConfig.getDataTimeField();
    }

    @Override
    public List<ETLMetrics> getMetrics() {
        return this.baseImportConfig.getMetrics();
    }

    @Override
    public boolean isUseDefaultMapData() {
        return this.baseImportConfig.isUseDefaultMapData();
    }

    @Override
    public Integer getTimeWindowType() {
        return this.baseImportConfig.getTimeWindowType();
    }

    @Override
    public boolean isFlushMetricsOnScheduleTaskCompleted() {
        return this.baseImportConfig.isFlushMetricsOnScheduleTaskCompleted();
    }

    @Override
    public boolean isCleanKeysWhenflushMetricsOnScheduleTaskCompleted() {
        return this.baseImportConfig.isCleanKeysWhenflushMetricsOnScheduleTaskCompleted();
    }

    @Override
    public boolean isWaitCompleteWhenflushMetricsOnScheduleTaskCompleted() {
        return this.baseImportConfig.isWaitCompleteWhenflushMetricsOnScheduleTaskCompleted();
    }

    @Override
    public DataStream getDataStream() {
        return this.dataStream;
    }

    public void setDataStream(DataStream dataStream) {
        this.dataStream = dataStream;
    }

    @Override
    public void shutDownJob(Throwable throwable, boolean waitTranStopped, boolean fromScheduleEnd) {
        if (this.dataStream != null) {
            this.dataStream.destroy(throwable, waitTranStopped, fromScheduleEnd);
        }
    }

    @Override
    public void initETLMetrics() {
        List<ETLMetrics> metrics = this.baseImportConfig.getMetrics();
        if (metrics == null) {
            metrics = this.outputConfig.getMetrics();
        }
        if (metrics != null && metrics.size() > 0) {
            for (ETLMetrics metrics_ : metrics) {
                metrics_.setImportContext(this);
                metrics_.init();
            }
        }
    }

    @Override
    public void initJobcontext() {
        this.jobContext.setDataTranPlugin(this.dataTranPlugin);
        if (this.baseImportConfig.getInitJobContextCall() != null) {
            try {
                this.baseImportConfig.getInitJobContextCall().initJobContext(this.jobContext);
            }
            catch (Exception e) {
                throw new DataImportException(e);
            }
        }
    }

    @Override
    public void resetMetricsLogLevel(int metricsLogLevel) {
        this.baseImportConfig.resetMetricsLogLevel(metricsLogLevel);
    }

    @Override
    public JobFlowNodeExecuteContext getJobFlowNodeExecuteContext() {
        return this.jobContext.getJobFlowNodeExecuteContext();
    }

    @Override
    public JobFlowExecuteContext getJobFlowExecuteContext() {
        return this.jobContext.getJobFlowExecuteContext();
    }
}

