/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.context;

import com.frameworkset.orm.annotation.BatchContext;
import com.frameworkset.orm.annotation.ESIndexWrapper;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.client.ResultUtil;
import org.frameworkset.spi.geoip.GeoIPUtil;
import org.frameworkset.spi.geoip.IpInfo;
import org.frameworkset.tran.ColumnData;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.DataRefactor;
import org.frameworkset.tran.FieldMeta;
import org.frameworkset.tran.Record;
import org.frameworkset.tran.TranMeta;
import org.frameworkset.tran.cdc.TableMapping;
import org.frameworkset.tran.config.BaseImportConfig;
import org.frameworkset.tran.config.ClientOptions;
import org.frameworkset.tran.config.ImportBuilder;
import org.frameworkset.tran.config.InputConfig;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.context.JobContext;
import org.frameworkset.tran.context.RecordSpecialConfigsContext;
import org.frameworkset.tran.jobflow.context.JobFlowExecuteContext;
import org.frameworkset.tran.jobflow.context.JobFlowNodeExecuteContext;
import org.frameworkset.tran.metrics.BaseMetricsLogReport;
import org.frameworkset.tran.metrics.TaskMetrics;
import org.frameworkset.tran.record.RecordOutpluginSpecialConfig;
import org.frameworkset.tran.record.ValueConvert;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.schedule.timer.TimeUtil;
import org.frameworkset.util.ClassUtil;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextImpl
extends BaseMetricsLogReport
implements Context {
    private static Logger logger = LoggerFactory.getLogger(ContextImpl.class);
    private TableMapping tableMapping;
    private String recordKeyField;
    protected List<FieldMeta> fieldValues;
    protected Map<String, FieldMeta> valuesIdxByName;
    protected Map<String, FieldMeta> fieldMetaMap;
    private boolean useBatchContextIndexName = false;
    protected Map<String, String> newfieldNames;
    protected Map<String, ColumnData> newfieldName2ndColumnDatas;
    protected BaseImportConfig baseImportConfig;
    protected BatchContext batchContext;
    protected boolean drop;
    protected int action = 0;
    protected TaskMetrics taskMetrics;
    protected ESIndexWrapper esIndexWrapper;
    protected ImportContext importContext;
    protected TaskContext taskContext;
    protected CommonRecord commonRecord;
    protected Record record;
    protected Object messageKey;
    private Map<String, Object> tempDatas;
    private RecordSpecialConfigsContext recordSpecialConfigsContext;

    public ContextImpl(TaskContext taskContext, ImportContext importContext, Record record, BatchContext batchContext) {
        super(importContext.getDataTranPlugin());
        this.baseImportConfig = importContext.getImportConfig();
        this.importContext = importContext;
        OutputConfig outputConfig = importContext.getOutputConfig();
        this.recordSpecialConfigsContext = new RecordSpecialConfigsContext(importContext);
        outputConfig.initRecordSpecialConfigsContext(this.recordSpecialConfigsContext, false);
        InputConfig inputConfig = importContext.getInputConfig();
        inputConfig.initRecordSpecialConfigsContext(this.recordSpecialConfigsContext);
        this.batchContext = batchContext;
        this.record = record;
        this.taskContext = taskContext != null ? taskContext : record.getTaskContext();
    }

    @Override
    public TranMeta getMetaData() {
        return this.record.getMetaData();
    }

    @Override
    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    @Override
    public void setIndex(String index) {
        this.recordSpecialConfigsContext.addRecordSpecialConfig("index", index);
    }

    @Override
    public void setIndexType(String indexType) {
        this.recordSpecialConfigsContext.addRecordSpecialConfig("indexType", indexType);
    }

    @Override
    public Map<String, Object> getGeoipConfig() {
        return this.baseImportConfig.getGeoipConfig();
    }

    @Override
    public Map<String, Object> getMetaDatas() {
        return this.record.getMetaDatas();
    }

    @Override
    public Map<String, Object> getUpdateFromDatas() {
        return this.record.getUpdateFromDatas();
    }

    @Override
    public void afterRefactor() throws Exception {
        this.recordSpecialConfigsContext.afterRefactor(this);
    }

    @Override
    public void setClientOptions(ClientOptions clientOptions) {
        this.recordSpecialConfigsContext.addRecordSpecialConfig("clientOptions", clientOptions);
    }

    @Override
    public Object getSpecialConfig(OutputConfig outputConfig, String name) {
        RecordOutpluginSpecialConfig recordOutpluginSpecialConfig = this.recordSpecialConfigsContext.getRecordOutpluginSpecialConfig(outputConfig.getOutputPlugin());
        if (recordOutpluginSpecialConfig != null) {
            return recordOutpluginSpecialConfig.getSpecialConfig(name);
        }
        return null;
    }

    @Override
    public List<FieldMeta> getGlobalFieldValues() {
        return this.baseImportConfig.getFieldValues();
    }

    @Override
    public Boolean getUseLowcase() {
        return this.baseImportConfig.getUseLowcase();
    }

    @Override
    public Object getValue(int i, String colName, int sqlType) throws Exception {
        return this.record.getValue(i, colName, sqlType);
    }

    @Override
    public Object getValue(String fieldName, int sqlType) throws DataImportException {
        return this.record.getValue(fieldName, sqlType);
    }

    @Override
    public Boolean getUseJavaName() {
        return this.baseImportConfig.getUseJavaName();
    }

    @Override
    public DateFormateMeta getDateFormateMeta() {
        return this.baseImportConfig.getDateFormateMeta();
    }

    @Override
    public void refactorData() throws Exception {
        DataRefactor dataRefactor = this.baseImportConfig.getDataRefactor();
        if (dataRefactor != null) {
            dataRefactor.refactor(this);
        }
    }

    @Override
    public ImportContext getImportContext() {
        return this.importContext;
    }

    @Override
    public List<FieldMeta> getFieldValues() {
        return this.fieldValues;
    }

    @Override
    public Map<String, FieldMeta> getFieldMetaMap() {
        return this.fieldMetaMap;
    }

    @Override
    public Object getJobContextData(String name) {
        return this.getJobContext().getJobData(name);
    }

    @Override
    public Object getTaskContextData(String name) {
        return this.getTaskContext().getTaskData(name);
    }

    @Override
    public Context addFieldValue(String fieldName, Object value) {
        if (this.fieldValues == null) {
            this.fieldValues = new ArrayList<FieldMeta>();
            this.valuesIdxByName = new LinkedHashMap<String, FieldMeta>();
        }
        FieldMeta fieldMeta = ImportBuilder.addFieldValue(this.fieldValues, fieldName, value);
        this.valuesIdxByName.put(fieldName, fieldMeta);
        return this;
    }

    @Override
    public Context addFieldValues(Object bean) {
        return this.addFieldValues(bean, true);
    }

    @Override
    public Context addFieldValues(Object bean, boolean ignoreNullField) {
        if (bean == null) {
            return this;
        }
        if (bean instanceof Map) {
            return this.addMapFieldValues((Map)bean);
        }
        ClassUtil.ClassInfo beanInfo = ClassUtil.getClassInfo(bean.getClass());
        List attributes = beanInfo.getPropertyDescriptors();
        Object value = null;
        String name = null;
        for (int i = 0; attributes != null && i < attributes.size(); ++i) {
            ClassUtil.PropertieDescription property = (ClassUtil.PropertieDescription)attributes.get(i);
            if (!property.canread()) continue;
            try {
                value = property.getValue(bean);
                name = property.getName();
                if (value == null && ignoreNullField) continue;
                this.addFieldValue(name, value);
                continue;
            }
            catch (InvocationTargetException e1) {
                logger.error("\u83b7\u53d6\u5c5e\u6027[" + beanInfo.getName() + "." + property.getName() + "]\u503c\u5931\u8d25\uff1a", e1.getTargetException());
                continue;
            }
            catch (Exception e1) {
                logger.error("\u83b7\u53d6\u5c5e\u6027[" + beanInfo.getName() + "." + property.getName() + "]\u503c\u5931\u8d25\uff1a", (Throwable)e1);
            }
        }
        return this;
    }

    @Override
    public Context addMapFieldValues(Map<String, Object> values) {
        return this.addMapFieldValues(values, true);
    }

    @Override
    public Context addMapFieldValues(Map<String, Object> values, boolean ignoreNullField) {
        if (values == null || values.size() == 0) {
            return this;
        }
        Iterator<Map.Entry<String, Object>> iterator = values.entrySet().iterator();
        Object value = null;
        String name = null;
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            name = entry.getKey();
            value = entry.getValue();
            if (value == null && ignoreNullField) continue;
            this.addFieldValue(name, value);
        }
        return this;
    }

    @Override
    public Context addFieldValue(String fieldName, String dateFormat, Object value) {
        if (this.fieldValues == null) {
            this.fieldValues = new ArrayList<FieldMeta>();
            this.valuesIdxByName = new LinkedHashMap<String, FieldMeta>();
        }
        FieldMeta fieldMeta = ImportBuilder.addFieldValue(this.fieldValues, fieldName, dateFormat, value, this.baseImportConfig.getLocale(), this.baseImportConfig.getTimeZone());
        this.valuesIdxByName.put(fieldName, fieldMeta);
        return this;
    }

    @Override
    public Context addFieldValue(String fieldName, String dateFormat, Object value, String locale, String timeZone) {
        if (this.fieldValues == null) {
            this.fieldValues = new ArrayList<FieldMeta>();
            this.valuesIdxByName = new LinkedHashMap<String, FieldMeta>();
        }
        FieldMeta fieldMeta = ImportBuilder.addFieldValue(this.fieldValues, fieldName, dateFormat, value, locale, timeZone);
        this.valuesIdxByName.put(fieldName, fieldMeta);
        return this;
    }

    @Override
    public Context addIgnoreFieldMapping(String sourceFieldName) {
        if (this.fieldMetaMap == null) {
            this.fieldMetaMap = new HashMap<String, FieldMeta>();
        }
        ImportBuilder.addIgnoreFieldMapping(this.fieldMetaMap, sourceFieldName);
        return this;
    }

    @Override
    @Deprecated
    public String getDBName() {
        return this.recordSpecialConfigsContext.getDBName();
    }

    @Override
    public long getLongValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.longValue((Object)value, (Long)0L);
    }

    @Override
    public String getStringValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.stringValue((Object)value, null);
    }

    @Override
    public String getStringValue(String fieldName, ValueConvert valueConvert) throws Exception {
        Object value = this.getValue(fieldName);
        return (String)valueConvert.convert(value);
    }

    @Override
    public String getStringValue(String fieldName, String defaultValue) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.stringValue((Object)value, (String)defaultValue);
    }

    @Override
    public boolean getBooleanValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.booleanValue((Object)value, (boolean)false);
    }

    @Override
    public boolean getBooleanValue(String fieldName, ValueConvert valueConvert) throws Exception {
        Object value = this.getValue(fieldName);
        return (Boolean)valueConvert.convert(value);
    }

    @Override
    public boolean getBooleanValue(String fieldName, boolean defaultValue) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.booleanValue((Object)value, (boolean)defaultValue);
    }

    @Override
    public double getDoubleValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.doubleValue((Object)value, (Double)0.0);
    }

    @Override
    public float getFloatValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.floatValue((Object)value, (Float)Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public int getIntegerValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.intValue((Object)value, (Integer)0);
    }

    @Override
    public Date getDateValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            LocalDateTime localDateTime = TimeUtil.localDateTime((String)((String)value));
            return TimeUtil.convertLocalDatetime((LocalDateTime)localDateTime);
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof LocalDateTime) {
            return TimeUtil.convertLocalDatetime((LocalDateTime)((LocalDateTime)value));
        }
        if (value instanceof LocalDate) {
            return TimeUtil.convertLocalDate((LocalDate)((LocalDate)value));
        }
        if (value instanceof BigDecimal) {
            return new Date(((BigDecimal)value).longValue());
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        throw new IllegalArgumentException("Convert date value failed:" + value);
    }

    @Override
    public LocalDateTime getLocalDateTime(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return TimeUtil.localDateTime((String)((String)value));
        }
        if (value instanceof Date) {
            return TimeUtil.date2LocalDateTime((Date)((Date)value));
        }
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        if (value instanceof LocalDate) {
            return TimeUtil.date2LocalDateTime((Date)TimeUtil.convertLocalDate((LocalDate)((LocalDate)value)));
        }
        if (value instanceof BigDecimal) {
            return TimeUtil.date2LocalDateTime((Date)new Date(((BigDecimal)value).longValue()));
        }
        if (value instanceof Long) {
            return TimeUtil.date2LocalDateTime((Date)new Date((Long)value));
        }
        throw new IllegalArgumentException("Convert date value failed:" + value);
    }

    @Override
    public Date getDateValue(String fieldName, String dateFormat) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
        return this.getDateValue(fieldName, simpleDateFormat);
    }

    @Override
    public Date getDateValue(String fieldName, DateFormat dateFormat) throws Exception {
        Object value = this.getValue(fieldName);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof LocalDateTime) {
            return TimeUtil.convertLocalDatetime((LocalDateTime)((LocalDateTime)value));
        }
        if (value instanceof LocalDate) {
            return TimeUtil.convertLocalDate((LocalDate)((LocalDate)value));
        }
        if (value instanceof BigDecimal) {
            return new Date(((BigDecimal)value).longValue());
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof String) {
            return dateFormat.parse((String)value);
        }
        throw new IllegalArgumentException("Convert date value failed:" + value);
    }

    @Override
    public Object getResultSetValue(String fieldName) {
        Object value = this.record.getValue(fieldName);
        return TimeUtil.convertLocalDate((Object)value);
    }

    @Override
    public Object getValue(String fieldName, ValueConvert valueConvert) throws Exception {
        FieldMeta fieldMeta = null;
        if (this.valuesIdxByName != null) {
            fieldMeta = this.valuesIdxByName.get(fieldName);
        }
        if (fieldMeta == null) {
            fieldMeta = this.baseImportConfig.getValueIdxByName(fieldName);
        }
        Object value = null;
        value = fieldMeta != null ? fieldMeta.getValue() : this.record.getValue(fieldName);
        return valueConvert.convert(value);
    }

    @Override
    public Object getValue(String fieldName) throws Exception {
        FieldMeta fieldMeta = null;
        if (this.valuesIdxByName != null) {
            fieldMeta = this.valuesIdxByName.get(fieldName);
        }
        if (fieldMeta == null) {
            fieldMeta = this.baseImportConfig.getValueIdxByName(fieldName);
        }
        Object value = null;
        value = fieldMeta != null ? fieldMeta.getValue() : this.record.getValue(fieldName);
        return TimeUtil.convertLocalDate((Object)value);
    }

    @Override
    public Object getMetaValue(String fieldName) throws Exception {
        return this.record.getMetaValue(fieldName);
    }

    @Override
    public FieldMeta getMappingName(String sourceFieldName) {
        FieldMeta fieldMeta;
        if (this.fieldMetaMap != null && (fieldMeta = this.fieldMetaMap.get(sourceFieldName)) != null) {
            return fieldMeta;
        }
        return this.baseImportConfig.getMappingName(sourceFieldName);
    }

    @Override
    public boolean isDrop() {
        return this.drop;
    }

    @Override
    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    @Override
    public IpInfo getIpInfo(String fieldName) throws Exception {
        Object _ip = this.getValue(fieldName);
        if (_ip == null) {
            return null;
        }
        GeoIPUtil geoIPUtil = BaseImportConfig.getGeoIPUtil(this.getGeoipConfig());
        if (geoIPUtil != null) {
            return geoIPUtil.getIpInfo(String.valueOf(_ip));
        }
        return null;
    }

    @Override
    public IpInfo getIpInfoByIp(String ip) {
        if (BaseImportConfig.getGeoIPUtil(this.getGeoipConfig()) != null) {
            return BaseImportConfig.getGeoIPUtil(this.getGeoipConfig()).getIpInfo(ip);
        }
        return null;
    }

    @Override
    public void newName2ndData(String fieldName, String newFieldName, Object newFieldValue) throws Exception {
        this.addFieldValue(newFieldName, newFieldValue);
        if (!fieldName.equals(newFieldName)) {
            this.addIgnoreFieldMapping(fieldName);
        }
    }

    @Override
    public BatchContext getBatchContext() {
        return this.batchContext;
    }

    @Override
    public Object getRecord() {
        return this.record.getData();
    }

    @Override
    public Record getCurrentRecord() {
        return this.record;
    }

    @Override
    public void markRecoredInsert() {
        this.action = 0;
    }

    @Override
    public void markRecoredUpdate() {
        this.action = 1;
    }

    @Override
    public void markRecoredReplace() {
        this.action = 6;
    }

    @Override
    public void setAction(int action) {
        this.action = action;
    }

    @Override
    public void markRecoredDelete() {
        this.action = 2;
    }

    @Override
    public void markRecoredDDL() {
        this.action = 5;
    }

    @Override
    public boolean isInsert() {
        return this.action == 0;
    }

    @Override
    public boolean isUpdate() {
        return this.action == 1;
    }

    @Override
    public boolean isReplace() {
        return this.action == 6;
    }

    @Override
    public boolean isDDL() {
        return this.action == 5;
    }

    @Override
    public boolean isDelete() {
        return this.action == 2;
    }

    @Override
    public int getAction() {
        return this.action;
    }

    @Override
    public boolean isUseBatchContextIndexName() {
        return this.useBatchContextIndexName;
    }

    @Override
    public void setUseBatchContextIndexName(boolean useBatchContextIndexName) {
        this.useBatchContextIndexName = useBatchContextIndexName;
    }

    @Override
    public boolean removed() {
        return this.record.removed();
    }

    @Override
    public boolean reachEOFClosed() {
        return this.record.reachEOFClosed();
    }

    @Override
    public JobContext getJobContext() {
        if (this.importContext != null) {
            return this.importContext.getJobContext();
        }
        return null;
    }

    @Override
    public void setCommonRecord(CommonRecord commonRecord) {
        this.commonRecord = commonRecord;
    }

    @Override
    public CommonRecord getCommonRecord() {
        return this.commonRecord;
    }

    @Override
    public Object getKeys() {
        return this.record.getKeys();
    }

    @Override
    public Map<String, Object> getTempDatas() {
        return this.tempDatas;
    }

    @Override
    public void addTempData(String name, Object tmpData) {
        if (this.tempDatas == null) {
            this.tempDatas = new LinkedHashMap<String, Object>();
        }
        this.tempDatas.put(name, tmpData);
    }

    @Override
    public TableMapping getTableMapping() {
        return this.tableMapping;
    }

    @Override
    public void setTableMapping(TableMapping tableMapping) {
        this.tableMapping = tableMapping;
    }

    @Override
    public String getRecordKeyField() {
        return this.recordKeyField;
    }

    @Override
    public void setRecordKeyField(String recordKeyField) {
        this.recordKeyField = recordKeyField;
    }

    @Override
    public void setKafkaTopic(String topic) {
        this.addTempData("_____kafka.topic", topic);
    }

    @Override
    public void reportJobMetricErrorLog(String msg, Throwable e) {
        this.reportJobMetricErrorLog(this.taskContext, msg, e);
    }

    @Override
    public void reportJobMetricLog(String msg) {
        this.reportJobMetricLog(this.taskContext, msg);
    }

    @Override
    public void reportJobMetricWarn(String msg) {
        this.reportJobMetricWarn(this.taskContext, msg);
    }

    @Override
    public void reportJobMetricDebug(String msg) {
        this.reportJobMetricDebug(this.taskContext, msg);
    }

    @Override
    public void reportTaskMetricErrorLog(String msg, Throwable e) {
        if (this.taskMetrics != null) {
            this.reportTaskMetricErrorLog(this.taskMetrics, msg, e);
        } else {
            this.reportJobMetricErrorLog(msg, e);
        }
    }

    @Override
    public void reportTaskMetricLog(String msg) {
        if (this.taskMetrics != null) {
            this.reportTaskMetricLog(this.taskMetrics, msg);
        } else {
            this.reportJobMetricLog(msg);
        }
    }

    @Override
    public void reportTaskMetricDebug(String msg) {
        if (this.taskMetrics != null) {
            this.reportTaskMetricDebug(this.taskMetrics, msg);
        } else {
            this.reportJobMetricDebug(msg);
        }
    }

    @Override
    public void reportTaskMetricWarn(String msg) {
        if (this.taskMetrics != null) {
            this.reportTaskMetricWarn(this.taskMetrics, msg);
        } else {
            this.reportJobMetricWarn(msg);
        }
    }

    @Override
    public TaskMetrics getTaskMetrics() {
        return this.taskMetrics;
    }

    @Override
    public void setTaskMetrics(TaskMetrics taskMetrics) {
        this.taskMetrics = taskMetrics;
    }

    @Override
    public void setMessageKey(Object messageKey) {
        this.messageKey = messageKey;
    }

    @Override
    public Object getMessageKey() {
        return this.messageKey;
    }

    @Override
    public RecordSpecialConfigsContext getRecordSpecialConfigsContext() {
        return this.recordSpecialConfigsContext;
    }

    @Override
    public void resolveRecordColumnInfo(String name, Object temp, FieldMeta fieldMeta) {
        this.recordSpecialConfigsContext.resolveRecordColumnInfo(name, temp, fieldMeta, this);
    }

    @Override
    public JobFlowNodeExecuteContext getJobFlowNodeExecuteContext() {
        return this.importContext.getJobFlowNodeExecuteContext();
    }

    @Override
    public JobFlowExecuteContext getJobFlowExecuteContext() {
        return this.importContext.getJobFlowExecuteContext();
    }

    @Override
    public String getJobFlowId() {
        return this.getJobFlowExecuteContext().getJobFlowId();
    }

    @Override
    public String getJobFlowName() {
        return this.getJobFlowExecuteContext().getJobFlowName();
    }

    @Override
    public String getJobFlowNodeId() {
        return this.getJobFlowNodeExecuteContext().getNodeId();
    }

    @Override
    public String getJobFlowNodeName() {
        return this.getJobFlowNodeExecuteContext().getNodeName();
    }

    @Override
    public String getContainerJobFlowNodeId() {
        return this.getContainerJobFlowNodeExecuteContext().getNodeId();
    }

    @Override
    public String getContainerJobFlowNodeName() {
        return this.getContainerJobFlowNodeExecuteContext().getNodeName();
    }

    @Override
    public Object getJobFlowContextData(String name) {
        return this.getJobFlowExecuteContext().getContextData(name);
    }

    @Override
    public Object getJobFlowContextData(String name, Object defaultValue) {
        return this.getJobFlowExecuteContext().getContextData(name, defaultValue);
    }

    @Override
    public Object getJobFlowNodeContextData(String name) {
        return this.getJobFlowNodeExecuteContext().getContextData(name);
    }

    @Override
    public Object getJobFlowNodeContextData(String name, Object defaultValue) {
        return this.getJobFlowNodeExecuteContext().getContextData(name, defaultValue);
    }

    @Override
    public Object getContainerJobFlowNodeContextData(String name) {
        return this.getContainerJobFlowNodeExecuteContext().getContextData(name);
    }

    @Override
    public Object getContainerJobFlowNodeContextData(String name, Object defaultValue) {
        return this.getContainerJobFlowNodeExecuteContext().getContextData(name, defaultValue);
    }

    @Override
    public void addJobFlowNodeContextData(String name, Object data) {
        this.getJobFlowNodeExecuteContext().addContextData(name, data);
    }

    @Override
    public void addJobFlowContextData(String name, Object data) {
        this.getJobFlowExecuteContext().addContextData(name, data);
    }

    @Override
    public void addContainerJobFlowNodeContextData(String name, Object data) {
        this.getContainerJobFlowNodeExecuteContext().addContextData(name, data);
    }

    public JobFlowNodeExecuteContext getContainerJobFlowNodeExecuteContext() {
        return this.importContext.getJobFlowNodeExecuteContext().getContainerJobFlowNodeExecuteContext();
    }
}

