/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.context;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.frameworkset.tran.jobflow.JobFlow;
import org.frameworkset.tran.jobflow.JobFlowNode;
import org.frameworkset.tran.jobflow.context.JobFlowExecuteContext;
import org.frameworkset.tran.jobflow.context.JobFlowNodeExecuteContext;
import org.frameworkset.tran.metrics.BaseMetricsLogReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobContext
extends BaseMetricsLogReport {
    private static Logger logger = LoggerFactory.getLogger(JobContext.class);
    private Map<String, Object> jobDatas = new LinkedHashMap<String, Object>();
    private Date jobStartTime = new Date();
    private Date endStartTime;
    private JobFlowNode jobFlowNode;
    private JobFlow jobFlow;

    public Date getJobStartTime() {
        return this.jobStartTime;
    }

    public void setEndStartTime(Date endStartTime) {
        this.endStartTime = endStartTime;
    }

    public Date getEndStartTime() {
        return this.endStartTime;
    }

    public JobContext addJobData(String name, Object value) {
        this.jobDatas.put(name, value);
        return this;
    }

    public JobContext addJobDatas(Map params) {
        if (params != null) {
            this.jobDatas.putAll(params);
        }
        return this;
    }

    public void release() {
        this.jobDatas.clear();
        this.jobDatas = null;
    }

    public Object getJobData(String name) {
        return this.jobDatas.get(name);
    }

    @Override
    public void reportJobMetricErrorLog(String msg, Throwable e) {
        super.reportJobMetricErrorLog(null, msg, e);
    }

    @Override
    public void reportJobMetricLog(String msg) {
        super.reportJobMetricLog(null, msg);
    }

    @Override
    public void reportJobMetricWarn(String msg) {
        super.reportJobMetricWarn(null, msg);
    }

    @Override
    public void reportJobMetricDebug(String msg) {
        super.reportJobMetricDebug(null, msg);
    }

    public JobFlowNode getJobFlowNode() {
        return this.jobFlowNode;
    }

    public void setJobFlowNode(JobFlowNode jobFlowNode) {
        if (jobFlowNode != null) {
            this.jobFlowNode = jobFlowNode;
            this.jobFlow = jobFlowNode.getJobFlow();
        }
    }

    public JobFlow getJobFlow() {
        return this.jobFlow;
    }

    public JobFlowExecuteContext getJobFlowExecuteContext() {
        if (this.jobFlowNode != null) {
            return this.jobFlowNode.getJobFlow().getJobFlowExecuteContext();
        }
        return null;
    }

    public JobFlowNodeExecuteContext getJobFlowNodeExecuteContext() {
        if (this.jobFlowNode != null) {
            return this.jobFlowNode.getJobFlowNodeExecuteContext();
        }
        return null;
    }

    public JobFlowNodeExecuteContext getContainerJobFlowNodeExecuteContext() {
        return this.getJobFlowNodeExecuteContext().getContainerJobFlowNodeExecuteContext();
    }

    public Object getJobFlowContextData(String name) {
        return this.getJobFlowExecuteContext().getContextData(name);
    }

    public Object getJobFlowContextData(String name, Object defaultValue) {
        return this.getJobFlowExecuteContext().getContextData(name, defaultValue);
    }

    public Object getJobFlowNodeContextData(String name) {
        return this.getJobFlowNodeExecuteContext().getContextData(name);
    }

    public Object getJobFlowNodeContextData(String name, Object defaultValue) {
        return this.getJobFlowNodeExecuteContext().getContextData(name, defaultValue);
    }

    public Object getContainerJobFlowNodeContextData(String name) {
        return this.getContainerJobFlowNodeExecuteContext().getContextData(name);
    }

    public Object getContainerJobFlowNodeContextData(String name, Object defaultValue) {
        return this.getContainerJobFlowNodeExecuteContext().getContextData(name, defaultValue);
    }

    public void addJobFlowNodeContextData(String name, Object data) {
        this.getJobFlowNodeExecuteContext().addContextData(name, data);
    }

    public void addJobFlowContextData(String name, Object data) {
        this.getJobFlowExecuteContext().addContextData(name, data);
    }

    public void addContainerJobFlowNodeContextData(String name, Object data) {
        this.getContainerJobFlowNodeExecuteContext().addContextData(name, data);
    }

    public String getJobFlowId() {
        return this.getJobFlowExecuteContext().getJobFlowId();
    }

    public String getJobFlowName() {
        return this.getJobFlowExecuteContext().getJobFlowName();
    }

    public String getJobFlowNodeId() {
        return this.getJobFlowNodeExecuteContext().getNodeId();
    }

    public String getJobFlowNodeName() {
        return this.getJobFlowNodeExecuteContext().getNodeName();
    }

    public String getContainerJobFlowNodeId() {
        return this.getContainerJobFlowNodeExecuteContext().getNodeId();
    }

    public String getContainerJobFlowNodeName() {
        return this.getContainerJobFlowNodeExecuteContext().getNodeName();
    }
}

