/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.exception;

import java.util.List;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.OutputPlugin;
import org.slf4j.Logger;

public class ImportExceptionUtil {
    public static DataImportException buildDataImportException(ImportContext importContext, String error) {
        if (importContext != null) {
            StringBuilder builder = new StringBuilder();
            String jobName = importContext.getJobName();
            String jobId = importContext.getJobId();
            String jobType = importContext.getJobType();
            builder.append("jobName=").append(jobName).append(",jobId=").append(jobId).append(",jobType=").append(jobType).append(",errorinfo=").append(error);
            return new DataImportException(builder.toString());
        }
        return new DataImportException(error);
    }

    public static void loginfo(Logger logger, ImportContext importContext, String loginfo, OutputPlugin outputPlugin) {
        if (logger.isInfoEnabled()) {
            if (importContext != null) {
                StringBuilder builder = new StringBuilder();
                String jobName = importContext.getJobName();
                String jobId = importContext.getJobId();
                String jobType = importContext.getJobType();
                builder.append("jobName=").append(jobName).append(",jobId=").append(jobId).append(",inputJobType=").append(jobType).append(",outputJobType=").append(outputPlugin.getJobType()).append(",log:").append(loginfo);
                logger.info(builder.toString());
            } else {
                logger.info(loginfo);
            }
        }
    }

    public static DataImportException buildDataImportException(ImportContext importContext, String error, List<Throwable> throwables, OutputPlugin outputPlugin) {
        DataImportException dataImportException = null;
        if (importContext != null) {
            StringBuilder builder = new StringBuilder();
            String jobName = importContext.getJobName();
            String jobId = importContext.getJobId();
            String jobType = importContext.getJobType();
            builder.append("jobName=").append(jobName).append(",jobId=").append(jobId).append(",inputjobType=").append(jobType).append(",outputJobType=").append(outputPlugin.getJobType()).append(",errorinfo=").append(error);
            dataImportException = new DataImportException(builder.toString());
        } else {
            dataImportException = new DataImportException(error);
        }
        for (Throwable throwable : throwables) {
            dataImportException.addSuppressed(throwable);
        }
        return dataImportException;
    }

    public static DataImportException buildDataImportException(OutputPlugin outputPlugin, ImportContext importContext, String error, Throwable throwable) {
        if (importContext != null) {
            StringBuilder builder = new StringBuilder();
            String jobName = importContext.getJobName();
            String jobId = importContext.getJobId();
            String jobType = importContext.getJobType();
            builder.append("jobName=").append(jobName).append(",jobId=").append(jobId).append(",inputJobType=").append(jobType).append(",outputJobType=").append(outputPlugin.getJobType()).append(",errorinfo=").append(error);
            return new DataImportException(builder.toString(), throwable);
        }
        return new DataImportException(error, throwable);
    }

    public static DataImportException buildDataImportException(ImportContext importContext, Throwable throwable) {
        if (importContext != null) {
            StringBuilder builder = new StringBuilder();
            String jobName = importContext.getJobName();
            String jobId = importContext.getJobId();
            String jobType = importContext.getJobType();
            builder.append("jobName=").append(jobName).append(",jobId=").append(jobId).append(",inputjobType=").append(jobType).append(",outputJobType=").append(importContext.getOutputPlugin().getJobType());
            return new DataImportException(builder.toString(), throwable);
        }
        return new DataImportException(throwable);
    }

    public static DataImportException buildDataImportException(String jobName, String jobId, String jobType, String error) {
        StringBuilder builder = new StringBuilder();
        builder.append("jobName=").append(jobName).append(",jobId=").append(jobId).append(",jobType=").append(jobType).append(",errorinfo=").append(error);
        return new DataImportException(builder.toString());
    }

    public static DataImportException buildDataImportException(String jobName, String jobId, String jobType, String error, Throwable throwable) {
        StringBuilder builder = new StringBuilder();
        builder.append("jobName=").append(jobName).append(",jobId=").append(jobId).append(",jobType=").append(jobType).append(",errorinfo=").append(error);
        return new DataImportException(builder.toString(), throwable);
    }

    public static DataImportException buildDataImportException(String jobName, String jobId, String jobType, Throwable throwable) {
        StringBuilder builder = new StringBuilder();
        builder.append("jobName=").append(jobName).append(",jobId=").append(jobId).append(",jobType=").append(jobType);
        return new DataImportException(builder.toString(), throwable);
    }
}

