/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.metrics;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.frameworkset.tran.metrics.ImportCount;

public class ParallImportCount
extends ImportCount {
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock readLock = this.lock.readLock();
    private Lock writeLock = this.lock.writeLock();

    @Override
    public long getTotalCount() {
        this.readLock.lock();
        try {
            long l = this.totalCount;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getFailedCount() {
        this.readLock.lock();
        try {
            long l = this.failedCount;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getIgnoreTotalCount() {
        this.readLock.lock();
        try {
            long l = this.ignoreTotalCount;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] increamentFailedCount(long failedCount) {
        this.writeLock.lock();
        try {
            this.failedCount = failedCount + this.failedCount;
            this.totalCount += failedCount;
            long[] lArray = new long[]{this.failedCount, this.totalCount};
            return lArray;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long increamentIgnoreTotalCount() {
        this.writeLock.lock();
        try {
            ++this.ignoreTotalCount;
            ++this.totalCount;
            long l = this.ignoreTotalCount;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long getSuccessCount() {
        this.readLock.lock();
        try {
            long l = this.successCount;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] increamentSuccessCount(long successCount) {
        this.writeLock.lock();
        try {
            this.successCount += successCount;
            this.totalCount += successCount;
            long[] lArray = new long[]{this.successCount, this.totalCount};
            return lArray;
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

