/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.metrics;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.context.JobContext;
import org.frameworkset.tran.metrics.MetricsMapData;
import org.frameworkset.tran.metrics.TaskMetrics;
import org.frameworkset.tran.metrics.TimeWindowExportResultHandler;
import org.frameworkset.tran.metrics.entity.MapData;
import org.frameworkset.tran.metrics.entity.TimeMetric;
import org.frameworkset.tran.status.LastValueWrapper;

public class TimeTaskMetric
extends TimeMetric {
    private TimeWindowExportResultHandler timeWindowExportResultHandler;
    private Date jobStartTime;
    private Date taskStartTime;
    private Date taskEndTime;
    private long totalRecords;
    private long totalFailedRecords;
    private long totalIgnoreRecords;
    private long totalSuccessRecords;
    private long successRecords;
    private long failedRecords;
    private long ignoreRecords;
    private long records;
    private int taskNo;
    private String jobNo;
    private String jobId;
    private String jobName;
    private LastValueWrapper lastValue;
    private Object result;
    private JobContext jobContext;
    private ImportContext importContext;

    public TimeTaskMetric(TimeWindowExportResultHandler timeWindowExportResultHandler) {
        this.timeWindowExportResultHandler = timeWindowExportResultHandler;
    }

    public String getJobId() {
        return this.jobId;
    }

    public ImportContext getImportContext() {
        return this.importContext;
    }

    public JobContext getJobContext() {
        return this.jobContext;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public void setTotalRecords(long totalRecords) {
        this.totalRecords = totalRecords;
    }

    public long getSuccessRecords() {
        return this.successRecords;
    }

    public void setSuccessRecords(long successRecords) {
        this.successRecords = successRecords;
    }

    public long getTotalFailedRecords() {
        return this.totalFailedRecords;
    }

    public void setTotalFailedRecords(long totalFailedRecords) {
        this.totalFailedRecords = totalFailedRecords;
    }

    public long getTotalIgnoreRecords() {
        return this.totalIgnoreRecords;
    }

    public void setTotalIgnoreRecords(long totalIgnoreRecords) {
        this.totalIgnoreRecords = totalIgnoreRecords;
    }

    public long getFailedRecords() {
        return this.failedRecords;
    }

    public void setFailedRecords(long failedRecords) {
        this.failedRecords = failedRecords;
    }

    public long getIgnoreRecords() {
        return this.ignoreRecords;
    }

    public void setIgnoreRecords(long ignoreRecords) {
        this.ignoreRecords = ignoreRecords;
    }

    public int getTaskNo() {
        return this.taskNo;
    }

    public void setTaskNo(int taskNo) {
        this.taskNo = taskNo;
    }

    public String getJobNo() {
        return this.jobNo;
    }

    public void setJobNo(String jobNo) {
        this.jobNo = jobNo;
    }

    public long getTotalSuccessRecords() {
        return this.totalSuccessRecords;
    }

    public void setTotalSuccessRecords(long totalSuccessRecords) {
        this.totalSuccessRecords = totalSuccessRecords;
    }

    public Date getJobStartTime() {
        return this.jobStartTime;
    }

    public void setJobStartTime(Date jobStartTime) {
        this.jobStartTime = jobStartTime;
    }

    public Date getTaskStartTime() {
        return this.taskStartTime;
    }

    public void setTaskStartTime(Date taskStartTime) {
        this.taskStartTime = taskStartTime;
    }

    public Date getTaskEndTime() {
        return this.taskEndTime;
    }

    public void setTaskEndTime(Date taskEndTime) {
        this.taskEndTime = taskEndTime;
    }

    public String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder builder = new StringBuilder();
        if (this.jobNo != null) {
            builder.append("{jobNo:").append(this.jobNo);
        } else {
            builder.append("{jobNo:-");
        }
        builder.append(", taskNo:").append(this.taskNo);
        if (this.jobStartTime != null) {
            builder.append(", jobStartTime:").append(dateFormat.format(this.jobStartTime));
        } else {
            builder.append(", jobStartTime:-");
        }
        if (this.taskStartTime != null) {
            builder.append(", taskStartTime:").append(dateFormat.format(this.taskStartTime));
        } else {
            builder.append(", taskStartTime:-");
        }
        if (this.taskEndTime != null) {
            builder.append(", taskEndTime:").append(dateFormat.format(this.taskEndTime));
        } else {
            builder.append(", taskEndTime:-");
        }
        builder.append(", totalRecords:").append(this.totalRecords).append(", totalSuccessRecords:").append(this.totalSuccessRecords).append(", totalIgnoreRecords:").append(this.totalIgnoreRecords).append(", totalFailedRecords:").append(this.totalFailedRecords).append(", successRecords:").append(this.successRecords).append(", failedRecords:").append(this.failedRecords).append(", lastValue:").append(this.lastValue).append(", elapsedTime:").append(this.getElapsed()).append("ms}");
        return builder.toString();
    }

    public long getElapsed() {
        if (this.getTaskStartTime() != null && this.getTaskEndTime() != null) {
            return this.getTaskEndTime().getTime() - this.getTaskStartTime().getTime();
        }
        return -1L;
    }

    public long getRecords() {
        return this.records;
    }

    public void setRecords(long records) {
        this.records = records;
    }

    public LastValueWrapper getLastValue() {
        return this.lastValue;
    }

    public void setLastValue(LastValueWrapper lastValue) {
        this.lastValue = lastValue;
    }

    public void init(MapData firstData) {
        MetricsMapData metricsMapData = (MetricsMapData)firstData;
        TaskMetrics taskMetrics = (TaskMetrics)firstData.getData();
        this.jobId = taskMetrics.getJobId();
        this.jobNo = taskMetrics.getJobNo();
        this.jobName = taskMetrics.getJobName();
        this.taskStartTime = taskMetrics.getTaskStartTime();
        this.jobStartTime = taskMetrics.getJobStartTime();
        this.taskEndTime = taskMetrics.getTaskEndTime();
        this.jobContext = metricsMapData.getJobContext();
        this.importContext = metricsMapData.getImportContext();
        this.taskNo = taskMetrics.getTaskNo();
        this.lastValue = taskMetrics.getLastValue();
        this.result = metricsMapData.getResult();
    }

    public void incr(MapData data) {
        TaskMetrics taskMetrics = (TaskMetrics)data.getData();
        MetricsMapData metricsMapData = (MetricsMapData)data;
        this.successRecords = taskMetrics.getSuccessRecords() + this.successRecords;
        this.failedRecords = taskMetrics.getFailedRecords() + this.failedRecords;
        this.ignoreRecords = taskMetrics.getIgnoreRecords() + this.ignoreRecords;
        this.records = taskMetrics.getRecords() + this.records;
        this.compareAndSet(taskMetrics, metricsMapData);
    }

    private void compareAndSet(TaskMetrics taskMetrics, MetricsMapData metricsMapData) {
        if (this.totalRecords < taskMetrics.getTotalRecords()) {
            this.totalRecords = taskMetrics.getTotalRecords();
        }
        if (this.totalFailedRecords < taskMetrics.getTotalFailedRecords()) {
            this.totalFailedRecords = taskMetrics.getTotalFailedRecords();
        }
        if (this.totalIgnoreRecords < taskMetrics.getTotalIgnoreRecords()) {
            this.totalIgnoreRecords = taskMetrics.getTotalIgnoreRecords();
        }
        if (this.totalSuccessRecords < taskMetrics.getTotalSuccessRecords()) {
            this.totalSuccessRecords = taskMetrics.getTotalSuccessRecords();
        }
        boolean setResult = false;
        if (this.taskNo >= 0) {
            if (this.taskNo < taskMetrics.getTaskNo()) {
                this.taskNo = taskMetrics.getTaskNo();
                this.result = metricsMapData.getResult();
            }
            setResult = true;
        }
        if (this.taskEndTime != null && taskMetrics.getTaskEndTime() != null && this.taskEndTime.before(taskMetrics.getTaskEndTime())) {
            this.taskEndTime = taskMetrics.getTaskEndTime();
        }
        if (this.taskStartTime != null && taskMetrics.getTaskStartTime() != null && this.taskStartTime.after(taskMetrics.getTaskStartTime())) {
            this.taskStartTime = taskMetrics.getTaskStartTime();
            if (!setResult) {
                this.result = metricsMapData.getResult();
            }
        }
        if (this.lastValue != null) {
            if (this.importContext.getLastValueType() == 0) {
                this.lastValue = this.importContext.getDataTranPlugin().maxNumberLastValue(this.lastValue, taskMetrics.getLastValue());
            } else if (this.importContext.getLastValueType() == 1) {
                Object _lastValue = this.lastValue.getLastValue();
                if (_lastValue instanceof Number) {
                    Number ts = (Number)_lastValue;
                    Number nts = (Number)taskMetrics.getLastValue().getLastValue();
                    if (nts.longValue() > ts.longValue()) {
                        this.lastValue = taskMetrics.getLastValue();
                    }
                } else {
                    Date ts = (Date)_lastValue;
                    Date nts = (Date)taskMetrics.getLastValue().getLastValue();
                    if (nts.after(ts)) {
                        this.lastValue = taskMetrics.getLastValue();
                    }
                }
            } else if (this.importContext.getLastValueType() == 2) {
                LocalDateTime ts = (LocalDateTime)this.lastValue.getLastValue();
                LocalDateTime nts = (LocalDateTime)taskMetrics.getLastValue().getLastValue();
                if (nts.isAfter(ts)) {
                    this.lastValue = taskMetrics.getLastValue();
                }
            } else if (this.importContext.getLastValueType() == 3) {
                // empty if block
            }
        }
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }
}

