/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.metrics;

import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import org.frameworkset.tran.BaseExportResultHandler;
import org.frameworkset.tran.ExportResultHandler;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.metrics.MetricsMapData;
import org.frameworkset.tran.metrics.MetricsTaskcommand;
import org.frameworkset.tran.metrics.TaskMetrics;
import org.frameworkset.tran.metrics.TimeTaskMetric;
import org.frameworkset.tran.metrics.entity.KeyMetric;
import org.frameworkset.tran.metrics.entity.MapData;
import org.frameworkset.tran.metrics.entity.MetricKey;
import org.frameworkset.tran.metrics.job.KeyMetricBuilder;
import org.frameworkset.tran.metrics.job.Metrics;
import org.frameworkset.tran.metrics.job.MetricsConfig;
import org.frameworkset.tran.metrics.job.builder.MetricBuilder;
import org.frameworkset.tran.task.TaskCommand;

public class TimeWindowExportResultHandler<RESULT>
extends BaseExportResultHandler<RESULT> {
    private Metrics keyMetrics;
    private String metricKeyPrex;

    public TimeWindowExportResultHandler(final String metricKeyPrex, final ExportResultHandler exportResultHandler, final OutputConfig outputConfig) {
        super(exportResultHandler, outputConfig);
        this.metricKeyPrex = metricKeyPrex;
        this.keyMetrics = new Metrics(Metrics.MetricsType_TimeMetircs){

            public void builderMetrics() {
                this.addMetricBuilder(new MetricBuilder(){

                    public MetricKey buildMetricKey(MapData mapData) {
                        TaskMetrics taskMetrics = (TaskMetrics)mapData.getData();
                        StringBuilder mkey = new StringBuilder();
                        mkey.append(metricKeyPrex).append("-").append(taskMetrics.getJobNo());
                        return new MetricKey(mkey.toString());
                    }

                    public KeyMetricBuilder metricBuilder() {
                        return () -> new TimeTaskMetric(TimeWindowExportResultHandler.this);
                    }
                });
                this.setSegmentBoundSize(5000000);
                this.setTimeWindows(outputConfig.getMetricsAggWindow());
            }

            public void persistent(Collection<KeyMetric> metrics) {
                metrics.forEach(keyMetric -> {
                    TimeTaskMetric timeTaskMetric = (TimeTaskMetric)((Object)keyMetric);
                    MetricsTaskcommand metricsTaskcommand = new MetricsTaskcommand();
                    metricsTaskcommand.setOutputPlugin(outputConfig.getOutputPlugin());
                    metricsTaskcommand.setOutputConfig(outputConfig);
                    metricsTaskcommand.setImportContext(timeTaskMetric.getImportContext());
                    metricsTaskcommand.setJobContext(timeTaskMetric.getJobContext());
                    TaskMetrics taskMetrics = new TaskMetrics();
                    taskMetrics.setJobName(timeTaskMetric.getJobName());
                    taskMetrics.setJobId(timeTaskMetric.getJobId());
                    taskMetrics.setJobNo(timeTaskMetric.getJobNo());
                    taskMetrics.setLastValue(timeTaskMetric.getLastValue());
                    taskMetrics.setJobStartTime(timeTaskMetric.getJobStartTime());
                    taskMetrics.setTaskStartTime(timeTaskMetric.getTaskStartTime());
                    taskMetrics.setTaskEndTime(timeTaskMetric.getTaskEndTime());
                    taskMetrics.setTotalRecords(timeTaskMetric.getTotalRecords());
                    taskMetrics.setTotalFailedRecords(timeTaskMetric.getTotalFailedRecords());
                    taskMetrics.setTotalIgnoreRecords(timeTaskMetric.getTotalIgnoreRecords());
                    taskMetrics.setTotalSuccessRecords(timeTaskMetric.getTotalSuccessRecords());
                    taskMetrics.setSuccessRecords(timeTaskMetric.getSuccessRecords());
                    taskMetrics.setFailedRecords(timeTaskMetric.getFailedRecords());
                    taskMetrics.setIgnoreRecords(timeTaskMetric.getIgnoreRecords());
                    taskMetrics.setRecords(timeTaskMetric.getRecords());
                    taskMetrics.setTaskNo(timeTaskMetric.getTaskNo());
                    metricsTaskcommand.setTaskMetrics(taskMetrics);
                    exportResultHandler.success(metricsTaskcommand, timeTaskMetric.getResult());
                });
            }
        };
        this.keyMetrics.init();
    }

    @Override
    public void destroy() {
        if (this.keyMetrics != null) {
            this.keyMetrics.stopMetrics();
        }
    }

    @Override
    public void success(TaskCommand<RESULT> taskCommand, RESULT result) {
        TaskMetrics taskMetrics = taskCommand.getTaskMetrics();
        MetricsMapData mapData = new MetricsMapData();
        mapData.setDataTime(new Date());
        DateFormat dayFormat = MetricsConfig.getDayFormat();
        DateFormat hourFormat = MetricsConfig.getHourFormat();
        DateFormat minuteFormat = MetricsConfig.getMinuteFormat();
        mapData.setDayFormat(dayFormat);
        mapData.setHourFormat(hourFormat);
        mapData.setMinuteFormat(minuteFormat);
        mapData.setResult(result);
        mapData.setData(taskMetrics);
        mapData.setJobContext(taskCommand.getJobContext());
        mapData.setImportContext(taskCommand.getImportContext());
        this.keyMetrics.map((MapData)mapData);
    }

    public String getMetricKeyPrex() {
        return this.metricKeyPrex;
    }
}

