/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin;

import com.frameworkset.orm.annotation.BatchContext;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.FieldMeta;
import org.frameworkset.tran.Record;
import org.frameworkset.tran.TranMeta;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ContextImpl;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.context.RecordSpecialConfigsContext;
import org.frameworkset.tran.exception.ImportExceptionUtil;
import org.frameworkset.tran.metrics.JobTaskMetrics;
import org.frameworkset.tran.plugin.OutputPlugin;
import org.frameworkset.tran.record.RecordColumnInfo;
import org.frameworkset.tran.record.SplitKeys;
import org.frameworkset.tran.schedule.TaskContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePlugin {
    private static Logger logger = LoggerFactory.getLogger(BasePlugin.class);
    protected DataTranPlugin dataTranPlugin;
    protected ImportContext importContext;
    protected OutputConfig pluginOutputConfig;
    private volatile boolean stopCollectData;
    protected static Object dummy = new Object();

    public BasePlugin(OutputConfig pluginOutputConfig, ImportContext importContext) {
        this.importContext = importContext;
        this.pluginOutputConfig = pluginOutputConfig;
        pluginOutputConfig.setOutputPlugin((OutputPlugin)((Object)this));
    }

    public BasePlugin(ImportContext importContext) {
        this.importContext = importContext;
    }

    public OutputConfig getOutputConfig() {
        return this.pluginOutputConfig;
    }

    public abstract void afterInit();

    public abstract void beforeInit();

    public abstract void init();

    public boolean isMultiTran() {
        return false;
    }

    public void stopCollectData() {
        this.stopCollectData = true;
    }

    public boolean isStopCollectData() {
        return this.stopCollectData;
    }

    public ImportContext getImportContext() {
        return this.importContext;
    }

    public Object formatLastDateValue(Date date) {
        return date;
    }

    public Object formatLastLocalDateTimeValue(LocalDateTime localDateTime) {
        return localDateTime;
    }

    public void setDataTranPlugin(DataTranPlugin dataTranPlugin) {
        this.dataTranPlugin = dataTranPlugin;
    }

    public boolean isEnablePluginTaskIntercept() {
        return true;
    }

    public String getLastValueVarName() {
        return this.importContext.getLastValueColumn();
    }

    public boolean isEnableAutoPauseScheduled() {
        return true;
    }

    public Context buildContext(TaskContext taskContext, Record record, BatchContext batchContext) {
        return new ContextImpl(taskContext, this.importContext, record, batchContext);
    }

    public Long getTimeRangeLastValue() {
        return null;
    }

    public JobTaskMetrics createJobTaskMetrics() {
        return new JobTaskMetrics();
    }

    private void logColumnsInfo() {
        if (logger.isDebugEnabled()) {
            logger.debug("Export Columns is null,you can set Export Columns in importconfig or not.");
        }
    }

    protected CommonRecord buildRecord(CommonRecord dbRecord, Context context) {
        SplitKeys splitKeys;
        boolean isSplitKeys;
        Object keys;
        dbRecord.setAction(context.getAction());
        dbRecord.setTempDatas(context.getTempDatas());
        dbRecord.setMetaDatas(context.getMetaDatas());
        dbRecord.setTableMapping(context.getTableMapping());
        dbRecord.setRecordKeyField(context.getRecordKeyField());
        dbRecord.setRecordKey(context.getMessageKey());
        dbRecord.setKeys(context.getKeys());
        ImportContext importContext = context.getImportContext();
        String[] columns = importContext.getExportColumns();
        boolean useResultKeys = false;
        String[] splitColumns = null;
        if (columns == null) {
            keys = context.getKeys();
            if (keys != null) {
                isSplitKeys = keys instanceof SplitKeys;
                if (!isSplitKeys) {
                    useResultKeys = true;
                    if (keys instanceof Set) {
                        Set _keys = (Set)keys;
                        columns = _keys.toArray(new String[_keys.size()]);
                    } else {
                        columns = (String[])keys;
                    }
                } else {
                    splitKeys = (SplitKeys)keys;
                    if (splitKeys.getBaseKeys() != null) {
                        Object baseKeys = splitKeys.getBaseKeys();
                        useResultKeys = true;
                        if (baseKeys instanceof Set) {
                            Set _keys = (Set)baseKeys;
                            columns = _keys.toArray(new String[_keys.size()]);
                        } else {
                            columns = (String[])baseKeys;
                        }
                    }
                    splitColumns = splitKeys.getSplitKeys();
                }
            } else {
                this.logColumnsInfo();
            }
        } else {
            keys = context.getKeys();
            if (keys != null && (isSplitKeys = keys instanceof SplitKeys)) {
                splitKeys = (SplitKeys)keys;
                splitColumns = splitKeys.getSplitKeys();
            }
        }
        TranMeta metaData = context.getMetaData();
        Boolean useJavaName = context.getUseJavaName();
        Boolean useLowcase = context.getUseLowcase();
        if (useJavaName == null) {
            useJavaName = false;
        }
        if (useLowcase == null) {
            useLowcase = false;
        }
        Object temp = null;
        HashMap<String, Object> addedFields = new HashMap<String, Object>();
        List<FieldMeta> fieldValueMetas = context.getFieldValues();
        this.appendFieldValues(dbRecord, columns, fieldValueMetas, addedFields, useResultKeys, context);
        this.appendSplitFieldValues(dbRecord, splitColumns, addedFields, context);
        fieldValueMetas = context.getGlobalFieldValues();
        this.appendFieldValues(dbRecord, columns, fieldValueMetas, addedFields, useResultKeys, context);
        String varName = null;
        String colName = null;
        for (int i = 0; columns != null && i < columns.length; ++i) {
            colName = columns[i];
            FieldMeta fieldMeta = context.getMappingName(colName);
            if (fieldMeta != null) {
                if (fieldMeta.getIgnore() != null && fieldMeta.getIgnore().booleanValue()) continue;
                varName = fieldMeta.getTargetFieldName();
                if (varName == null || varName.equals("")) {
                    throw ImportExceptionUtil.buildDataImportException(importContext, "fieldName[" + colName + "]\u540d\u79f0\u6620\u5c04\u914d\u7f6e\u9519\u8bef\uff1avarName=" + varName);
                }
            } else {
                varName = useResultKeys && metaData != null && metaData.getColumnCount() > 0 ? (useJavaName.booleanValue() ? metaData.getColumnJavaNameByIndex(i) : (useLowcase == false ? colName : metaData.getColumnLabelLowerByIndex(i))) : colName;
            }
            if (addedFields.get(varName) != null) continue;
            int sqlType = useResultKeys && metaData != null ? metaData.getColumnTypeByIndex(i) : -1;
            temp = context.getValue(colName, sqlType);
            Object recordColumnInfo = null;
            if (temp == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("\u5b57\u6bb5\u503c[\u76ee\u6807\u5217{},\u6e90\u5217{}]\u7684\u503c\u4e3anull\uff01", (Object)varName, (Object)colName);
                }
            } else if (temp instanceof Date) {
                context.resolveRecordColumnInfo(varName, temp, fieldMeta);
            }
            dbRecord.addData(varName, temp);
        }
        if (splitColumns != null && splitColumns.length > 0) {
            BasePlugin.handleIgnoreFieldsAgain();
        }
        return dbRecord;
    }

    private static void handleIgnoreFieldsAgain() {
    }

    public RecordColumnInfo resolveRecordColumnInfo(Object value, FieldMeta fieldMeta, Context context) {
        return null;
    }

    private void appendSplitFieldValues(CommonRecord record, String[] splitColumns, Map<String, Object> addedFields, Context context) {
        if (splitColumns == null || splitColumns.length == 0) {
            return;
        }
        String varName = null;
        for (String fieldName : splitColumns) {
            FieldMeta fieldMeta = context.getMappingName(fieldName);
            if (fieldMeta != null) {
                if (fieldMeta.getIgnore() != null && fieldMeta.getIgnore().booleanValue()) continue;
                varName = fieldMeta.getTargetFieldName();
                if (varName == null || varName.equals("")) {
                    throw ImportExceptionUtil.buildDataImportException(context.getImportContext(), "fieldName[" + fieldName + "]\u540d\u79f0\u6620\u5c04\u914d\u7f6e\u9519\u8bef\uff1avarName=" + varName);
                }
            } else {
                varName = fieldName;
            }
            if (addedFields.containsKey(varName)) continue;
            this.addRecordValue(record, varName, context.getCurrentRecord().getValue(fieldName), fieldMeta, context);
            addedFields.put(varName, dummy);
        }
    }

    private void addRecordValue(CommonRecord record, String fieldName, Object value, FieldMeta fieldMeta, Context context) {
        context.resolveRecordColumnInfo(fieldName, value, fieldMeta);
        record.addData(fieldName, value);
    }

    private void appendFieldValues(CommonRecord record, String[] columns, List<FieldMeta> fieldValueMetas, Map<String, Object> addedFields, boolean useResultKeys, Context context) {
        if (fieldValueMetas == null || fieldValueMetas.size() == 0) {
            return;
        }
        if (columns != null && columns.length > 0) {
            for (FieldMeta fieldMeta : fieldValueMetas) {
                String fieldName = fieldMeta.getTargetFieldName();
                if (addedFields.containsKey(fieldName)) continue;
                boolean matched = false;
                for (String name : columns) {
                    if (!name.equals(fieldName)) continue;
                    this.addRecordValue(record, name, fieldMeta.getValue(), fieldMeta, context);
                    addedFields.put(name, dummy);
                    matched = true;
                    break;
                }
                if (!useResultKeys || matched) continue;
                this.addRecordValue(record, fieldName, fieldMeta.getValue(), fieldMeta, context);
                addedFields.put(fieldName, dummy);
            }
        } else {
            for (FieldMeta fieldMeta : fieldValueMetas) {
                String fieldName = fieldMeta.getTargetFieldName();
                if (addedFields.containsKey(fieldName)) continue;
                this.addRecordValue(record, fieldName, fieldMeta.getValue(), fieldMeta, context);
                addedFields.put(fieldName, dummy);
            }
        }
    }

    public void buildRecordOutpluginSpecialConfig(CommonRecord dataRecord, Context context) throws Exception {
    }

    protected void buildRecordOutpluginSpecialConfigs(CommonRecord dataRecord, Context context) throws Exception {
        this.buildRecordOutpluginSpecialConfig(dataRecord, context);
    }

    public CommonRecord buildRecord(Context context) throws Exception {
        CommonRecord dataRecord = new CommonRecord();
        this.buildRecord(dataRecord, context);
        this.buildRecordOutpluginSpecialConfigs(dataRecord, context);
        RecordSpecialConfigsContext recordSpecialConfigsContext = context.getRecordSpecialConfigsContext();
        dataRecord.setRecordOutpluginSpecialConfigs(recordSpecialConfigsContext.getRecordOutpluginSpecialConfigs());
        dataRecord.setRecordOutpluginSpecialConfig(recordSpecialConfigsContext.getRecordOutpluginSpecialConfig());
        return dataRecord;
    }
}

