/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.db.input;

import com.frameworkset.util.SimpleStringUtil;
import java.sql.ResultSet;
import java.util.Properties;
import javax.sql.DataSource;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.config.ImportBuilder;
import org.frameworkset.tran.config.InputConfig;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.InputPlugin;
import org.frameworkset.tran.plugin.db.BaseDBConfig;
import org.frameworkset.tran.plugin.db.input.DBInputDataTranPlugin;
import org.frameworkset.tran.plugin.db.input.DBRecordBuilder;
import org.frameworkset.tran.record.RecordBuidler;

public class DBInputConfig
extends BaseDBConfig
implements InputConfig {
    private String sourceDbname;
    protected String sql;
    private String sqlFilepath;
    protected String sqlName;
    private Boolean enableDBTransaction;
    private Integer fetchSize;
    private boolean enableLocalDate;
    private Boolean parallelDatarefactor;
    private RecordBuidler<ResultSet> recordBuidler;

    public DBInputConfig setEnableLocalDate(boolean enableLocalDate) {
        this.enableLocalDate = enableLocalDate;
        return this;
    }

    @Override
    public boolean isParallelDatarefactor() {
        if (this.parallelDatarefactor != null) {
            return this.parallelDatarefactor;
        }
        return false;
    }

    @Override
    public DBInputConfig setParallelDatarefactor(boolean parallelDatarefactor) {
        this.parallelDatarefactor = parallelDatarefactor;
        return this;
    }

    @Override
    public boolean enableLocalDate() {
        return this.enableLocalDate;
    }

    public String getSourceDbname() {
        return this.sourceDbname;
    }

    public String getDBName() {
        DBConfig dbConfig = this.getDbConfig();
        if (dbConfig != null && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbName())) {
            return dbConfig.getDbName();
        }
        if (this.sourceDbname != null) {
            return this.sourceDbname;
        }
        return null;
    }

    public DBConfig getDbConfig() {
        if (this.dbConfig == null && this.sourceDbname != null) {
            return (DBConfig)this.dbConfigMap.get(this.sourceDbname);
        }
        return this.dbConfig;
    }

    public DBInputConfig setDbConfig(DBConfig dbConfig) {
        this.dbConfig = dbConfig;
        if (dbConfig != null && SimpleStringUtil.isNotEmpty((String)dbConfig.getDbName())) {
            this.dbConfigMap.put(dbConfig.getDbName(), dbConfig);
        }
        return this;
    }

    public DBInputConfig setSql(String sql) {
        this.sql = sql;
        return this;
    }

    public String getSql() {
        return this.sql;
    }

    public DBInputConfig setSqlFilepath(String sqlFilepath) {
        this.sqlFilepath = sqlFilepath;
        return this;
    }

    public String getSqlFilepath() {
        return this.sqlFilepath;
    }

    public DBInputConfig setSqlName(String sqlName) {
        this.sqlName = sqlName;
        return this;
    }

    public String getSqlName() {
        return this.sqlName;
    }

    @Override
    public void build(ImportContext importContext, ImportBuilder importBuilder) {
        if (SimpleStringUtil.isEmpty((String)this.getSql()) && (SimpleStringUtil.isEmpty((String)this.getSqlFilepath()) || SimpleStringUtil.isEmpty((String)this.getSqlName()))) {
            throw new DataImportException("Input sql is not setted.");
        }
        if (this.dbConfig == null) {
            this.dbConfig = importBuilder.getDefaultDBConfig();
            this.dbConfigMap.put(this.dbConfig.getDbName(), this.dbConfig);
        }
        if (this.dbConfig == null) {
            throw new DataImportException("Source DB Config not config to dbinputconfig.");
        }
        if (SimpleStringUtil.isEmpty((String)this.sourceDbname)) {
            this.sourceDbname = this.dbConfig.getDbName();
        }
        if (importBuilder.isSetFetchSized() && this.fetchSize == null) {
            this.fetchSize = importBuilder.getFetchSize();
        }
        if (this.fetchSize != null) {
            this._setJdbcFetchSize(this.fetchSize);
        }
        if (this.isParallelDatarefactor() && this.recordBuidler == null) {
            this.recordBuidler = new DBRecordBuilder();
        }
        if (this.dbConfig != null) {
            this.dbConfig.setDataSource(this.dataSource);
        }
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public InputPlugin getInputPlugin(ImportContext importContext) {
        return new DBInputDataTranPlugin(importContext);
    }

    public DBInputConfig setColumnLableUpperCase(boolean columnLableUpperCase) {
        this._setColumnLableUpperCase(columnLableUpperCase);
        return this;
    }

    public DBInputConfig setDbInitSize(int dbInitSize) {
        this._setDbInitSize(dbInitSize);
        return this;
    }

    public DBInputConfig setDbMaxSize(int dbMaxSize) {
        this._setDbMaxSize(dbMaxSize);
        return this;
    }

    public DBInputConfig setDbMinIdleSize(int dbMinIdleSize) {
        this._setDbMinIdleSize(dbMinIdleSize);
        return this;
    }

    public DBInputConfig setDbDriver(String dbDriver) {
        this._setDbDriver(dbDriver);
        return this;
    }

    public DBInputConfig setEnableDBTransaction(boolean enableDBTransaction) {
        this._setEnableDBTransaction(enableDBTransaction);
        return this;
    }

    public DBInputConfig setDbUrl(String dbUrl) {
        this._setDbUrl(dbUrl);
        return this;
    }

    public DBInputConfig setDbAdaptor(String dbAdaptor) {
        this._setDbAdaptor(dbAdaptor);
        return this;
    }

    public DBInputConfig setDbtype(String dbtype) {
        this._setDbtype(dbtype);
        return this;
    }

    public DBInputConfig setDbUser(String dbUser) {
        this._setDbUser(dbUser);
        return this;
    }

    public DBInputConfig setDbPassword(String dbPassword) {
        this._setDbPassword(dbPassword);
        return this;
    }

    public DBInputConfig setValidateSQL(String validateSQL) {
        this._setValidateSQL(validateSQL);
        return this;
    }

    public DBInputConfig setUsePool(boolean usePool) {
        this._setUsePool(usePool);
        return this;
    }

    public DBInputConfig setDbInfoEncryptClass(String dbInfoEncryptClass) {
        this._setDbInfoEncryptClass(dbInfoEncryptClass);
        return this;
    }

    public DBInputConfig setJdbcFetchSize(Integer jdbcFetchSize) {
        this.fetchSize = jdbcFetchSize;
        return this;
    }

    public DBInputConfig setRemoveAbandoned(boolean removeAbandoned) {
        this._setRemoveAbandoned(removeAbandoned);
        return this;
    }

    public DBInputConfig setConnectionTimeout(int connectionTimeout) {
        this._setConnectionTimeout(connectionTimeout);
        return this;
    }

    public DBInputConfig setMaxWait(int maxWait) {
        this._setMaxWait(maxWait);
        return this;
    }

    public DBInputConfig setMaxIdleTime(int maxIdleTime) {
        this._setMaxIdleTime(maxIdleTime);
        return this;
    }

    public DBConfig getDBConfig(String dbname) {
        return (DBConfig)this.dbConfigMap.get(dbname);
    }

    public Boolean getEnableDBTransaction() {
        return this.enableDBTransaction;
    }

    public DBInputConfig setDbName(String dbName) {
        this._setDbName(dbName);
        this.sourceDbname = dbName;
        return this;
    }

    public DBInputConfig setShowSql(boolean showsql) {
        this._setShowSql(showsql);
        return this;
    }

    public DBInputConfig setConnectionProperties(Properties connectionProperties) {
        this._setConnectionProperties(connectionProperties);
        return this;
    }

    public DBInputConfig addConnectionProperty(String name, Object value) {
        this._addConnectionProperty(name, value);
        return this;
    }

    public DBInputConfig setEnableDBTransaction(Boolean enableDBTransaction) {
        this.enableDBTransaction = enableDBTransaction;
        return this;
    }

    public DBInputConfig setBalance(String balance) {
        this._setBalance(balance);
        return this;
    }

    public DBInputConfig setEnableBalance(boolean enableBalance) {
        this._setEnableBalance(enableBalance);
        return this;
    }

    @Override
    public RecordBuidler<ResultSet> getRecordBuidler() {
        return this.recordBuidler;
    }

    @Override
    public DBInputConfig setRecordBuidler(RecordBuidler recordBuidler) {
        this.recordBuidler = recordBuidler;
        return this;
    }

    public DBInputConfig setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }
}

