/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.db.input;

import com.frameworkset.common.poolman.StatementInfo;
import com.frameworkset.orm.adapter.DB;
import java.sql.ResultSet;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.exception.ImportExceptionUtil;
import org.frameworkset.tran.plugin.db.input.JDBCTranMetaData;
import org.frameworkset.tran.plugin.db.input.LocalDateJDBCResultRecord;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.schedule.timer.TimeUtil;

public class JDBCResultRecord
extends LocalDateJDBCResultRecord {
    public JDBCResultRecord(TaskContext taskContext, ImportContext importContext, ResultSet resultSet, JDBCTranMetaData metaData, DB dbadapter, StatementInfo statementInfo) {
        super(taskContext, importContext, resultSet, metaData, dbadapter, statementInfo);
    }

    @Override
    public Object getValue(int i, String colName, int sqlType) throws DataImportException {
        try {
            if (this.record != null) {
                Object value = this.record.get(colName);
                value = TimeUtil.convertLocalDate2Date(value);
                return value;
            }
            if (!this.isOracleTimestamp(sqlType)) {
                Object value = this.resultSet.getObject(i + 1);
                value = TimeUtil.convertLocalDate2Date((Object)value);
                return value;
            }
            return this.resultSet.getTimestamp(i + 1);
        }
        catch (Exception ex) {
            throw ImportExceptionUtil.buildDataImportException(this.importContext.getOutputPlugin(), this.importContext, "getValue(  " + i + ", " + colName + "," + sqlType + ")", (Throwable)ex);
        }
    }

    @Override
    public Object getValue(String colName, int sqlType) throws DataImportException {
        if (colName == null) {
            return null;
        }
        try {
            if (this.record != null) {
                Object value = this.record.get(colName);
                value = TimeUtil.convertLocalDate2Date(value);
                return value;
            }
            if (!this.isOracleTimestamp(sqlType)) {
                Object value = this.resultSet.getObject(colName);
                value = TimeUtil.convertLocalDate2Date((Object)value);
                return value;
            }
            return this.resultSet.getTimestamp(colName);
        }
        catch (Exception ex) {
            throw ImportExceptionUtil.buildDataImportException(this.importContext.getOutputPlugin(), this.importContext, "getValue(  " + colName + "," + sqlType + ")", (Throwable)ex);
        }
    }

    @Override
    public Object getValue(String colName) {
        if (colName == null) {
            return null;
        }
        try {
            Object value = null;
            value = this.record != null ? (Object)this.record.get(colName) : this.resultSet.getObject(colName);
            value = TimeUtil.convertLocalDate2Date((Object)value);
            return value;
        }
        catch (Exception ex) {
            throw ImportExceptionUtil.buildDataImportException(this.importContext.getOutputPlugin(), this.importContext, "getValue(" + colName + ")", (Throwable)ex);
        }
    }
}

