/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.db.input;

import com.frameworkset.common.poolman.StatementInfo;
import com.frameworkset.common.poolman.sql.PoolManResultSetMetaData;
import com.frameworkset.orm.adapter.DB;
import java.sql.ResultSet;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.LastValue;
import org.frameworkset.tran.TranMeta;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.exception.ImportExceptionUtil;
import org.frameworkset.tran.plugin.db.input.JDBCResultRecord;
import org.frameworkset.tran.plugin.db.input.JDBCTranMetaData;
import org.frameworkset.tran.plugin.db.input.LocalDateJDBCResultRecord;
import org.frameworkset.tran.record.NextAssert;
import org.frameworkset.tran.schedule.TaskContext;

public class JDBCResultSet
extends LastValue
implements TranResultSet {
    protected ResultSet resultSet;
    protected JDBCTranMetaData metaData;
    protected DB dbadapter;
    protected boolean enableLocalDate;
    protected boolean parallelDatarefactor;
    protected TaskContext taskContext;
    protected StatementInfo statementInfo;

    public JDBCResultSet() {
    }

    public JDBCResultSet(TaskContext taskContext, ImportContext importContext, ResultSet resultSet, JDBCTranMetaData metaData, DB dbadapter, boolean enableLocalDate, StatementInfo statementInfo) {
        this.resultSet = resultSet;
        this.importContext = importContext;
        this.metaData = metaData;
        this.dbadapter = dbadapter;
        this.enableLocalDate = enableLocalDate;
        this.parallelDatarefactor = importContext.getInputConfig().isParallelDatarefactor();
        this.taskContext = taskContext;
        this.statementInfo = statementInfo;
        if (!this.parallelDatarefactor) {
            this.record = !enableLocalDate ? new JDBCResultRecord(taskContext, importContext, resultSet, metaData, dbadapter, statementInfo) : new LocalDateJDBCResultRecord(taskContext, importContext, resultSet, metaData, dbadapter, statementInfo);
            this.record.setTranMeta(this.getMetaData());
        }
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public DB getDbadapter() {
        return this.dbadapter;
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    @Override
    public TranMeta getMetaData() {
        return this.metaData;
    }

    @Override
    public Object getRecord() {
        return this.getResultSet();
    }

    @Override
    public Object getMetaValue(String fieldName) {
        return this.getValue(fieldName);
    }

    public void setMetaData(PoolManResultSetMetaData metaData) {
        this.metaData = new JDBCTranMetaData(metaData);
    }

    public void setDbadapter(DB dbadapter) {
        this.dbadapter = dbadapter;
    }

    @Override
    public Object getValue(int i, String colName, int sqlType) throws DataImportException {
        return this.record.getValue(i, colName, sqlType);
    }

    @Override
    public Object getKeys() {
        return this.record.getKeys();
    }

    @Override
    public Object getValue(String colName, int sqlType) throws DataImportException {
        return this.record.getValue(colName, sqlType);
    }

    @Override
    public NextAssert next() throws DataImportException {
        NextAssert nextAssert = new NextAssert();
        try {
            if (this.isStop() || this.importContext.getInputPlugin().isStopCollectData()) {
                return nextAssert;
            }
            nextAssert.setHasNext(this.resultSet.next());
            if (nextAssert.isHasNext() && this.parallelDatarefactor) {
                this.record = !this.enableLocalDate ? new JDBCResultRecord(this.taskContext, this.importContext, this.resultSet, this.metaData, this.dbadapter, this.statementInfo) : new LocalDateJDBCResultRecord(this.taskContext, this.importContext, this.resultSet, this.metaData, this.dbadapter, this.statementInfo);
                this.record.setTranMeta(this.getMetaData());
            }
            return nextAssert;
        }
        catch (Exception e) {
            throw ImportExceptionUtil.buildDataImportException(this.importContext, e);
        }
    }
}

