/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.db.input;

import com.frameworkset.common.poolman.StatementInfo;
import com.frameworkset.orm.adapter.DB;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.exception.ImportExceptionUtil;
import org.frameworkset.tran.plugin.db.input.DBRecordBuilderContext;
import org.frameworkset.tran.plugin.db.input.JDBCTranMetaData;
import org.frameworkset.tran.record.BaseRecord;
import org.frameworkset.tran.record.RecordBuidler;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.schedule.timer.TimeUtil;

public class LocalDateJDBCResultRecord
extends BaseRecord {
    protected ResultSet resultSet;
    protected JDBCTranMetaData metaData;
    protected DB dbadapter;
    protected Map<String, Object> record;

    public LocalDateJDBCResultRecord(TaskContext taskContext, ImportContext importContext, ResultSet resultSet, JDBCTranMetaData metaData, DB dbadapter, StatementInfo statementInfo) {
        super(taskContext, importContext);
        this.metaData = metaData;
        this.dbadapter = dbadapter;
        RecordBuidler recordBuidler = importContext.getInputConfig().getRecordBuidler();
        if (recordBuidler != null) {
            DBRecordBuilderContext dbRecordBuilderContext = new DBRecordBuilderContext();
            dbRecordBuilderContext.setDataTranPlugin(importContext.getDataTranPlugin());
            dbRecordBuilderContext.setStatementInfo(statementInfo);
            dbRecordBuilderContext.setResultSet(resultSet);
            dbRecordBuilderContext.setImportContext(importContext);
            dbRecordBuilderContext.setTaskContext(taskContext);
            this.record = recordBuidler.build(dbRecordBuilderContext);
        } else {
            this.resultSet = resultSet;
        }
    }

    protected boolean isOracleTimestamp(int sqlType) {
        return this.dbadapter.isOracleTimestamp(sqlType);
    }

    @Override
    public Object getValue(int i, String colName, int sqlType) throws DataImportException {
        try {
            if (this.record != null) {
                Object value = this.record.get(colName);
                value = TimeUtil.convertLocalDate((Object)value);
                return value;
            }
            if (!this.isOracleTimestamp(sqlType)) {
                Object value = this.resultSet.getObject(i + 1);
                value = TimeUtil.convertLocalDate((Object)value);
                return value;
            }
            return this.resultSet.getTimestamp(i + 1);
        }
        catch (Exception ex) {
            throw ImportExceptionUtil.buildDataImportException(this.importContext.getOutputPlugin(), this.importContext, "getValue(  " + i + ", " + colName + "," + sqlType + ")", (Throwable)ex);
        }
    }

    @Override
    public Date getDateTimeValue(String colName) throws DataImportException {
        if (colName == null) {
            return null;
        }
        if (this.record != null) {
            Date value = (Date)this.record.get(colName);
            return value;
        }
        try {
            Timestamp value = this.resultSet.getTimestamp(colName);
            return value;
        }
        catch (Exception e) {
            try {
                java.sql.Date value = this.resultSet.getDate(colName);
                return value;
            }
            catch (Exception ex) {
                throw ImportExceptionUtil.buildDataImportException(this.importContext.getOutputPlugin(), this.importContext, "getValue(" + colName + ")", (Throwable)ex);
            }
        }
    }

    @Override
    public Date getDateTimeValue(String colName, String dateformat) throws DataImportException {
        if (colName == null) {
            return null;
        }
        if (this.record != null) {
            Date value = (Date)this.record.get(colName);
            return value;
        }
        try {
            Timestamp value = this.resultSet.getTimestamp(colName);
            return value;
        }
        catch (Exception e) {
            try {
                java.sql.Date value = this.resultSet.getDate(colName);
                return value;
            }
            catch (Exception ex) {
                throw ImportExceptionUtil.buildDataImportException(this.importContext.getOutputPlugin(), this.importContext, "getValue(" + colName + ")", (Throwable)ex);
            }
        }
    }

    @Override
    public Object getValue(String colName, int sqlType) throws DataImportException {
        if (colName == null) {
            return null;
        }
        try {
            if (this.record != null) {
                Object value = this.record.get(colName);
                value = TimeUtil.convertLocalDate((Object)value);
                return value;
            }
            if (!this.isOracleTimestamp(sqlType)) {
                Object value = this.resultSet.getObject(colName);
                value = TimeUtil.convertLocalDate((Object)value);
                return value;
            }
            return this.resultSet.getTimestamp(colName);
        }
        catch (Exception ex) {
            throw ImportExceptionUtil.buildDataImportException(this.importContext.getOutputPlugin(), this.importContext, "getValue(  " + colName + "," + sqlType + ")", (Throwable)ex);
        }
    }

    @Override
    public Object getValue(String colName) {
        if (colName == null) {
            return null;
        }
        try {
            if (this.record != null) {
                Object value = this.record.get(colName);
                value = TimeUtil.convertLocalDate((Object)value);
                return value;
            }
            Object value = this.resultSet.getObject(colName);
            value = TimeUtil.convertLocalDate((Object)value);
            return value;
        }
        catch (Exception ex) {
            throw ImportExceptionUtil.buildDataImportException(this.importContext.getOutputPlugin(), this.importContext, "getValue(" + colName + ")", (Throwable)ex);
        }
    }

    @Override
    public Object getKeys() {
        if (this.metaData == null || this.metaData.getPoolManResultSetMetaData() == null) {
            return null;
        }
        return this.metaData.getPoolManResultSetMetaData().get_columnLabel();
    }

    @Override
    public Object getData() {
        if (this.record != null) {
            return this.record;
        }
        return this.resultSet;
    }

    @Override
    public Object getMetaValue(String metaName) {
        return this.getValue(metaName);
    }

    @Override
    public long getOffset() {
        return 0L;
    }
}

