/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.db.output;

import java.util.ArrayList;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.exception.ImportExceptionUtil;
import org.frameworkset.tran.plugin.db.TranSQLInfo;
import org.frameworkset.tran.plugin.db.output.MultiSQLConf2DBTaskCommandImpl;
import org.frameworkset.tran.task.TaskCommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base2DBTaskCommandImpl
extends MultiSQLConf2DBTaskCommandImpl {
    private static final Logger blogger = LoggerFactory.getLogger(Base2DBTaskCommandImpl.class);

    public Base2DBTaskCommandImpl(TaskCommandContext taskCommandContext, boolean needBatch, OutputConfig outputConfig) {
        super(taskCommandContext, needBatch, outputConfig);
        if (this.dbOutputConfig.optimize()) {
            this.sortData();
        }
    }

    private void sortData() {
        ArrayList<CommonRecord> _idatas = new ArrayList<CommonRecord>();
        ArrayList<CommonRecord> _udatas = new ArrayList<CommonRecord>();
        ArrayList<CommonRecord> _ddatas = new ArrayList<CommonRecord>();
        for (int i = 0; this.records != null && i < this.records.size(); ++i) {
            CommonRecord dbRecord = (CommonRecord)this.records.get(i);
            if (dbRecord.isInsert()) {
                _idatas.add(dbRecord);
                continue;
            }
            if (dbRecord.isUpdate()) {
                _udatas.add(dbRecord);
                continue;
            }
            _ddatas.add(dbRecord);
        }
        if (_udatas.size() == 0 && _ddatas.size() == 0 || _idatas.size() == 0 && _ddatas.size() == 0 || _idatas.size() == 0 && _udatas.size() == 0) {
            return;
        }
        this.records.clear();
        if (_idatas.size() > 0) {
            this.records.addAll(_idatas);
        }
        if (_udatas.size() > 0) {
            this.records.addAll(_udatas);
        }
        if (_ddatas.size() > 0) {
            this.records.addAll(_ddatas);
        }
    }

    @Override
    protected String getSQL(CommonRecord record) {
        if (record.isInsert()) {
            TranSQLInfo insertSqlinfo = this.dbOutputConfig.getTargetSqlInfo(this.taskContext);
            return insertSqlinfo.getSql();
        }
        if (record.isUpdate()) {
            TranSQLInfo updateSqlinfo = this.dbOutputConfig.getTargetUpdateSqlInfo(this.taskContext);
            return updateSqlinfo.getSql();
        }
        if (record.isDelete()) {
            TranSQLInfo deleteSqlinfo = this.dbOutputConfig.getTargetDeleteSqlInfo(this.taskContext);
            return deleteSqlinfo.getSql();
        }
        throw ImportExceptionUtil.buildDataImportException(this.importContext, "record action type must be insert or update or delete record.");
    }
}

