/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.db.output;

import org.frameworkset.tran.BaseCommonRecordDataTran;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.db.output.Base2DBTaskCommandImpl;
import org.frameworkset.tran.plugin.db.output.DBOutputConfig;
import org.frameworkset.tran.plugin.db.output.MultiSQLConf2DBTaskCommandImpl;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.BaseParrelTranCommand;
import org.frameworkset.tran.task.BaseSerialTranCommand;
import org.frameworkset.tran.task.TaskCall;
import org.frameworkset.tran.task.TaskCommand;
import org.frameworkset.tran.task.TaskCommandContext;

public class DBOutPutDataTran
extends BaseCommonRecordDataTran {
    protected DBOutputConfig dbOutputConfig;

    public DBOutPutDataTran(BaseDataTran baseDataTran) {
        super(baseDataTran);
    }

    @Override
    public void init() {
        super.init();
        if (this.dbOutputConfig == null) {
            this.dbOutputConfig = (DBOutputConfig)this.getOutputPlugin().getOutputConfig();
        }
        StringBuilder builder = new StringBuilder();
        DBConfig dbConfig = this.dbOutputConfig.getTargetDBConfig(this.taskContext);
        if (dbConfig == null) {
            dbConfig = this.dbOutputConfig.getTargetDBConfig();
        }
        if (dbConfig != null) {
            builder.append("Import data to db[").append(dbConfig.getDbName()).append("]");
        } else {
            String targetDBName = this.dbOutputConfig.getTargetDBName(this.taskContext);
            if (targetDBName == null) {
                targetDBName = this.dbOutputConfig.getTargetDbname();
            }
            builder.append("Import data to db[").append(targetDBName).append("]");
        }
        this.taskInfo = builder.toString();
    }

    @Override
    public TaskCommand buildTaskCommand(TaskCommandContext taskCommandContext) {
        MultiSQLConf2DBTaskCommandImpl taskCommand = null;
        DBOutputConfig dbOutputConfig = this.dbOutputConfig;
        if (dbOutputConfig == null) {
            dbOutputConfig = (DBOutputConfig)this.outputPlugin.getOutputConfig();
        }
        taskCommand = !dbOutputConfig.isMultiSQLConf() ? new Base2DBTaskCommandImpl(taskCommandContext, false, dbOutputConfig) : new MultiSQLConf2DBTaskCommandImpl(taskCommandContext, false, dbOutputConfig);
        return taskCommand;
    }

    public DBOutPutDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, ImportContext importContext, Status currentStatus) {
        super(taskContext, jdbcResultSet, importContext, currentStatus);
    }

    @Override
    protected void initTranTaskCommand() {
        this.parrelTranCommand = new BaseParrelTranCommand(){

            @Override
            public int hanBatchActionTask(TaskCommandContext taskCommandContext) {
                if (taskCommandContext.containData()) {
                    taskCommandContext.increamentTaskNo();
                    TaskCommand taskCommand = DBOutPutDataTran.this._buildTaskCommand(taskCommandContext);
                    taskCommandContext.addTask(taskCommand);
                }
                return taskCommandContext.getTaskNo();
            }
        };
        this.serialTranCommand = new BaseSerialTranCommand(){

            private int action(TaskCommandContext taskCommandContext) {
                if (taskCommandContext.containData()) {
                    taskCommandContext.increamentTaskNo();
                    TaskCommand taskCommand = DBOutPutDataTran.this._buildTaskCommand(taskCommandContext);
                    TaskCall.call(taskCommand);
                }
                return taskCommandContext.getTaskNo();
            }

            @Override
            public int hanBatchActionTask(TaskCommandContext taskCommandContext) {
                return this.action(taskCommandContext);
            }

            @Override
            public int endSerialActionTask(TaskCommandContext taskCommandContext) {
                return this.action(taskCommandContext);
            }
        };
    }
}

