/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.db.output;

import com.frameworkset.common.poolman.DBOptionsPreparedDBUtil;
import com.frameworkset.common.poolman.DBUtil;
import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.common.poolman.Param;
import com.frameworkset.common.poolman.StatementInfo;
import com.frameworkset.util.SimpleStringUtil;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.persitent.type.BaseTypeMethod;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.exception.ImportExceptionUtil;
import org.frameworkset.tran.plugin.db.TranSQLInfo;
import org.frameworkset.tran.plugin.db.output.DBOutputConfig;
import org.frameworkset.tran.plugin.db.output.DDLConf;
import org.frameworkset.tran.record.RecordOutpluginSpecialConfig;
import org.frameworkset.tran.task.BaseTaskCommand;
import org.frameworkset.tran.task.TaskCommandContext;
import org.frameworkset.tran.task.TaskFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSQLConf2DBTaskCommandImpl
extends BaseTaskCommand<String> {
    protected DBOutputConfig dbOutputConfig;
    protected String taskInfo;
    protected boolean needBatch;
    private static final Logger logger = LoggerFactory.getLogger(MultiSQLConf2DBTaskCommandImpl.class);
    protected int tryCount;
    private Map<String, List<CommonRecord>> dbRecords;
    private Map<String, List<CommonRecord>> ddlRecords;

    public MultiSQLConf2DBTaskCommandImpl(TaskCommandContext taskCommandContext, boolean needBatch, OutputConfig outputConfig) {
        super(outputConfig, taskCommandContext);
        this.needBatch = needBatch;
        this.dbOutputConfig = (DBOutputConfig)outputConfig;
    }

    private void debugDB(String name) {
        DBUtil.debugStatus((String)name);
    }

    protected String getSQL(CommonRecord record) {
        if (record.isInsert()) {
            TranSQLInfo insertSqlinfo = this.dbOutputConfig.getTargetSqlInfo(this.taskContext, record);
            return insertSqlinfo.getSql();
        }
        if (record.isUpdate()) {
            TranSQLInfo updateSqlinfo = this.dbOutputConfig.getTargetUpdateSqlInfo(this.taskContext, record);
            return updateSqlinfo.getSql();
        }
        if (record.isDelete()) {
            TranSQLInfo deleteSqlinfo = this.dbOutputConfig.getTargetDeleteSqlInfo(this.taskContext, record);
            return deleteSqlinfo.getSql();
        }
        if (record.isDDL()) {
            return (String)record.getData("ddl");
        }
        throw ImportExceptionUtil.buildDataImportException(this.importContext, "record action type must be insert or update or delete record.");
    }

    protected TranSQLInfo getTranSQLInfo(CommonRecord record) {
        if (record.isInsert()) {
            TranSQLInfo insertSqlinfo = this.dbOutputConfig.getTargetSqlInfo(this.taskContext, record);
            return insertSqlinfo;
        }
        if (record.isUpdate()) {
            TranSQLInfo updateSqlinfo = this.dbOutputConfig.getTargetUpdateSqlInfo(this.taskContext, record);
            return updateSqlinfo;
        }
        if (record.isDelete()) {
            TranSQLInfo deleteSqlinfo = this.dbOutputConfig.getTargetDeleteSqlInfo(this.taskContext, record);
            return deleteSqlinfo;
        }
        throw ImportExceptionUtil.buildDataImportException(this.importContext, "record action type must be insert or update or delete record.");
    }

    @Override
    public String execute() {
        String data = null;
        if (this.records.size() > 0) {
            data = !this.dbOutputConfig.isMultiSQLConfTargetDBName() ? this.singleTargetDBExecute() : this.multiTargetDBExecute();
        } else {
            this.logNodatas(logger);
        }
        this.finishTask();
        return data;
    }

    private String singleTargetDBExecute() {
        if (this.importContext.getMaxRetry() > 0 && this.tryCount >= this.importContext.getMaxRetry()) {
            throw new TaskFailedException("task execute failed:reached max retry times " + this.importContext.getMaxRetry());
        }
        ++this.tryCount;
        String dbname = this.dbOutputConfig.getTargetDBName(this.taskContext);
        if (dbname == null) {
            dbname = this.dbOutputConfig.getTargetDbname();
        }
        return this._execute(this.records, dbname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _execute(List<CommonRecord> datas, String dbname) {
        String data;
        block65: {
            data = null;
            StatementInfo stmtInfo = null;
            Statement statement = null;
            Connection con_ = null;
            int batchsize = this.importContext.getStoreBatchSize();
            try {
                con_ = DBUtil.getConection((String)dbname);
                stmtInfo = new StatementInfo(dbname, null, false, con_, false);
                stmtInfo.init();
                String oldSql = null;
                String sql = null;
                if (batchsize <= 1 || !this.needBatch) {
                    ArrayList resources = null;
                    Iterator<CommonRecord> iterator = datas.iterator();
                    while (iterator.hasNext()) {
                        CommonRecord dbRecord;
                        CommonRecord record = dbRecord = iterator.next();
                        RecordOutpluginSpecialConfig recordOutpluginSpecialConfig = record.getRecordOutpluginSpecialConfig(this.getOutputPlugin());
                        List recordParams = (List)recordOutpluginSpecialConfig.getSpecialConfig("recordParams");
                        sql = this.getSQL(record);
                        if (oldSql == null) {
                            oldSql = sql;
                            statement = stmtInfo.prepareStatement(sql, "DB output taskCommand statement:{}");
                        } else if (!oldSql.equals(sql)) {
                            try {
                                statement.executeBatch();
                            }
                            finally {
                                DBOptionsPreparedDBUtil.releaseResources(resources);
                                try {
                                    statement.close();
                                }
                                catch (Exception exception) {}
                            }
                            oldSql = sql;
                            statement = stmtInfo.prepareStatement(sql, "DB output taskCommand statement:{}");
                        }
                        if (this.dbOutputConfig.getStatementHandler() == null) {
                            BaseTypeMethod baseTypeMethod = null;
                            for (int i = 0; i < recordParams.size(); ++i) {
                                Param param = (Param)recordParams.get(i);
                                baseTypeMethod = param.getMethod();
                                if (baseTypeMethod == null) {
                                    stmtInfo.getDbadapter().setObject((PreparedStatement)statement, null, param.getIndex(), param.getData());
                                    continue;
                                }
                                if (resources == null) {
                                    resources = new ArrayList();
                                }
                                baseTypeMethod.action(stmtInfo, param, (PreparedStatement)statement, null, resources);
                            }
                        } else {
                            this.dbOutputConfig.getStatementHandler().handler((PreparedStatement)statement, record);
                        }
                        try {
                            statement.addBatch();
                        }
                        catch (SQLException e) {
                            throw new NestedSQLException(record.toString(), (Throwable)e);
                        }
                    }
                    if (statement == null) break block65;
                    try {
                        statement.executeBatch();
                        break block65;
                    }
                    finally {
                        DBOptionsPreparedDBUtil.releaseResources(resources);
                    }
                }
                ArrayList resources = null;
                int point = batchsize - 1;
                int count = 0;
                Iterator<CommonRecord> iterator = datas.iterator();
                while (iterator.hasNext()) {
                    CommonRecord dbRecord;
                    CommonRecord record = dbRecord = iterator.next();
                    RecordOutpluginSpecialConfig recordOutpluginSpecialConfig = record.getRecordOutpluginSpecialConfig(this.getOutputPlugin());
                    List recordParams = (List)recordOutpluginSpecialConfig.getSpecialConfig("recordParams");
                    sql = this.getSQL(record);
                    if (oldSql == null) {
                        oldSql = sql;
                        statement = stmtInfo.prepareStatement(sql, "DB output taskCommand statement:{}");
                    } else if (!oldSql.equals(sql)) {
                        if (count > 0) {
                            try {
                                statement.executeBatch();
                            }
                            finally {
                                DBOptionsPreparedDBUtil.releaseResources(resources);
                                try {
                                    statement.close();
                                }
                                catch (Exception param) {}
                            }
                        }
                        count = 0;
                        oldSql = sql;
                        statement = stmtInfo.prepareStatement(sql, "DB output taskCommand statement:{}");
                    }
                    if (this.dbOutputConfig.getStatementHandler() == null) {
                        BaseTypeMethod baseTypeMethod = null;
                        for (int i = 0; i < recordParams.size(); ++i) {
                            Param param = (Param)recordParams.get(i);
                            baseTypeMethod = param.getMethod();
                            if (baseTypeMethod == null) {
                                stmtInfo.getDbadapter().setObject((PreparedStatement)statement, null, param.getIndex(), param.getData());
                                continue;
                            }
                            if (resources == null) {
                                resources = new ArrayList();
                            }
                            baseTypeMethod.action(stmtInfo, param, (PreparedStatement)statement, null, resources);
                        }
                    } else {
                        this.dbOutputConfig.getStatementHandler().handler((PreparedStatement)statement, record);
                    }
                    statement.addBatch();
                    if (count > 0 && count % point == 0) {
                        try {
                            statement.executeBatch();
                        }
                        finally {
                            DBOptionsPreparedDBUtil.releaseResources(resources);
                        }
                        statement.clearBatch();
                        count = 0;
                        continue;
                    }
                    ++count;
                }
                if (count <= 0) break block65;
                try {
                    statement.executeBatch();
                }
                finally {
                    DBOptionsPreparedDBUtil.releaseResources(resources);
                }
            }
            catch (BatchUpdateException error) {
                if (stmtInfo != null) {
                    try {
                        stmtInfo.errorHandle((Exception)error);
                    }
                    catch (SQLException ex) {
                        throw ImportExceptionUtil.buildDataImportException(this.outputPlugin, this.importContext, this.taskInfo, (Throwable)error);
                    }
                }
                throw ImportExceptionUtil.buildDataImportException(this.outputPlugin, this.importContext, this.taskInfo, (Throwable)error);
            }
            catch (Exception e) {
                if (stmtInfo != null) {
                    try {
                        stmtInfo.errorHandle(e);
                    }
                    catch (SQLException ex) {
                        throw ImportExceptionUtil.buildDataImportException(this.outputPlugin, this.importContext, this.taskInfo, (Throwable)e);
                    }
                }
                throw ImportExceptionUtil.buildDataImportException(this.outputPlugin, this.importContext, this.taskInfo, (Throwable)e);
            }
            finally {
                if (stmtInfo != null) {
                    stmtInfo.dofinally();
                }
                if (con_ != null) {
                    try {
                        con_.close();
                    }
                    catch (Exception exception) {}
                }
                stmtInfo = null;
            }
        }
        return data;
    }

    private String _executeDDL(List<CommonRecord> datas, String dbname) {
        String data = null;
        StatementInfo stmtInfo = null;
        Statement statement = null;
        Connection con_ = null;
        try {
            con_ = DBUtil.getConection((String)dbname);
            stmtInfo = new StatementInfo(dbname, null, false, con_, false);
            stmtInfo.init();
            String sql = null;
            List resources = null;
            Iterator<CommonRecord> iterator = datas.iterator();
            while (iterator.hasNext()) {
                CommonRecord dbRecord;
                CommonRecord record = dbRecord = iterator.next();
                try {
                    sql = this.getSQL(record);
                    statement = stmtInfo.prepareStatement(sql, "DB output taskCommand statement:{}");
                    statement.executeUpdate();
                }
                catch (SQLException e) {
                    if (this.dbOutputConfig.isIgnoreDDLSynError()) {
                        logger.warn("Ignore Syn ddl[" + sql + "] failed:", (Throwable)e);
                        continue;
                    }
                    throw ImportExceptionUtil.buildDataImportException(this.outputPlugin, this.importContext, "Syn ddl[" + sql + "] failed:", (Throwable)e);
                }
                catch (Exception e) {
                    throw ImportExceptionUtil.buildDataImportException(this.outputPlugin, this.importContext, "Syn ddl[" + sql + "] failed:", (Throwable)e);
                }
                finally {
                    DBOptionsPreparedDBUtil.releaseResources(resources);
                    try {
                        statement.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (BatchUpdateException error) {
            if (stmtInfo != null) {
                try {
                    stmtInfo.errorHandle((Exception)error);
                }
                catch (SQLException ex) {
                    throw ImportExceptionUtil.buildDataImportException(this.outputPlugin, this.importContext, this.taskInfo, (Throwable)error);
                }
            }
            throw ImportExceptionUtil.buildDataImportException(this.outputPlugin, this.importContext, this.taskInfo, (Throwable)error);
        }
        catch (Exception e) {
            if (stmtInfo != null) {
                try {
                    stmtInfo.errorHandle(e);
                }
                catch (SQLException ex) {
                    throw ImportExceptionUtil.buildDataImportException(this.outputPlugin, this.importContext, this.taskInfo, (Throwable)e);
                }
            }
            throw ImportExceptionUtil.buildDataImportException(this.outputPlugin, this.importContext, this.taskInfo, (Throwable)e);
        }
        finally {
            if (stmtInfo != null) {
                stmtInfo.dofinally();
            }
            if (con_ != null) {
                try {
                    con_.close();
                }
                catch (Exception exception) {}
            }
            stmtInfo = null;
        }
        return data;
    }

    private void splitRecords() {
        if (this.dbRecords != null || this.ddlRecords != null) {
            return;
        }
        String dbname = this.dbOutputConfig.getTargetDBName(this.taskContext);
        if (dbname == null) {
            dbname = this.dbOutputConfig.getTargetDbname();
        }
        LinkedHashMap<String, List<CommonRecord>> dbRecords = new LinkedHashMap<String, List<CommonRecord>>();
        LinkedHashMap<String, List<CommonRecord>> ddlRecords = new LinkedHashMap<String, List<CommonRecord>>();
        for (CommonRecord dbRecord : this.records) {
            List<CommonRecord> temp;
            List<String> tmpDBNames;
            if (!dbRecord.isDDL()) {
                TranSQLInfo tranSQLInfo = this.getTranSQLInfo(dbRecord);
                tmpDBNames = null;
                if (tranSQLInfo.getTargetDBNames() != null) {
                    tmpDBNames = tranSQLInfo.getTargetDBNames();
                } else {
                    tmpDBNames = new ArrayList<String>(1);
                    tmpDBNames.add(dbname);
                }
                for (String tmpDBName : tmpDBNames) {
                    temp = (ArrayList<CommonRecord>)dbRecords.get(tmpDBName);
                    if (temp == null) {
                        temp = new ArrayList<CommonRecord>();
                        dbRecords.put(tmpDBName, temp);
                    }
                    temp.add(dbRecord);
                }
                continue;
            }
            DDLConf ddlConf = this.dbOutputConfig.getDDLConf(this.taskContext, dbRecord);
            tmpDBNames = null;
            if (ddlConf != null && SimpleStringUtil.isNotEmpty((String)ddlConf.getTargetDbName())) {
                tmpDBNames = ddlConf.getTargetDbNames();
            } else {
                tmpDBNames = new ArrayList<String>(1);
                tmpDBNames.add(dbname);
            }
            for (String tmpDBName : tmpDBNames) {
                temp = (List)ddlRecords.get(tmpDBName);
                if (temp == null) {
                    temp = new ArrayList();
                    ddlRecords.put(tmpDBName, temp);
                }
                temp.add(dbRecord);
            }
        }
        this.ddlRecords = ddlRecords;
        this.dbRecords = dbRecords;
    }

    private String multiTargetDBExecute() {
        this.splitRecords();
        String data = null;
        if (this.importContext.getMaxRetry() > 0 && this.tryCount >= this.importContext.getMaxRetry()) {
            throw new TaskFailedException("task execute failed:reached max retry times " + this.importContext.getMaxRetry());
        }
        ++this.tryCount;
        Iterator<Map.Entry<String, List<CommonRecord>>> iterator = null;
        if (this.ddlRecords != null) {
            for (Map.Entry<String, List<CommonRecord>> entry : this.ddlRecords.entrySet()) {
                this._executeDDL(entry.getValue(), entry.getKey());
            }
        }
        if (this.dbRecords != null) {
            for (Map.Entry<String, List<CommonRecord>> entry : this.dbRecords.entrySet()) {
                this._execute(entry.getValue(), entry.getKey());
            }
        }
        return data;
    }

    @Override
    public int getTryCount() {
        return this.tryCount;
    }
}

