/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.es.input;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.frameworkset.util.SimpleStringUtil;
import org.frameworkset.tran.config.ClientOptions;
import org.frameworkset.tran.config.ImportBuilder;
import org.frameworkset.tran.config.InputConfig;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.BaseConfig;
import org.frameworkset.tran.plugin.InputPlugin;
import org.frameworkset.tran.plugin.es.ESConfig;
import org.frameworkset.tran.plugin.es.ESField;
import org.frameworkset.tran.plugin.es.input.ElasticsearchInputDataTranPlugin;
import org.frameworkset.tran.plugin.es.input.QueryUrlFunction;

public class ElasticsearchInputConfig
extends BaseConfig
implements InputConfig {
    private String sourceElasticsearch = "default";
    private String scrollLiveTime = "100m";
    private String queryUrl;
    @JsonIgnore
    private QueryUrlFunction queryUrlFunction;
    private String dslFile;
    private String dslName;
    private String dslNamespace;
    private String dsl;
    private boolean sliceQuery;
    private int sliceSize;
    private ESConfig esConfig;
    private ClientOptions clientOptions;

    public ElasticsearchInputConfig setDslNamespace(String dslNamespace) {
        this.dslNamespace = dslNamespace;
        return this;
    }

    public String getSourceElasticsearch() {
        return this.sourceElasticsearch;
    }

    public ElasticsearchInputConfig setSourceElasticsearch(String sourceElasticsearch) {
        this.sourceElasticsearch = sourceElasticsearch;
        return this;
    }

    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    public ElasticsearchInputConfig setClientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public ElasticsearchInputConfig setEsIdField(ESField esIdField) {
        if (this.clientOptions == null) {
            this.clientOptions = new ClientOptions();
        }
        this.clientOptions.setIdField(esIdField);
        return this;
    }

    public ElasticsearchInputConfig setRefreshOption(String refreshOption) {
        if (this.clientOptions == null) {
            this.clientOptions = new ClientOptions();
        }
        this.clientOptions.setRefreshOption(refreshOption);
        return this;
    }

    public ElasticsearchInputConfig setEsConfig(ESConfig esConfig) {
        this.esConfig = esConfig;
        return this;
    }

    @Override
    public void build(ImportContext importContext, ImportBuilder importBuilder) {
        if (SimpleStringUtil.isNotEmpty((String)this.dsl)) {
            if (SimpleStringUtil.isEmpty((String)this.dslName)) {
                this.dslName = "datatranDslName";
            }
            if (SimpleStringUtil.isEmpty((String)this.dslNamespace)) {
                this.dslNamespace = "datatranDslName" + SimpleStringUtil.getUUID();
            }
        }
    }

    public ESConfig getEsConfig() {
        return this.esConfig;
    }

    @Override
    public InputPlugin getInputPlugin(ImportContext importContext) {
        return new ElasticsearchInputDataTranPlugin(importContext);
    }

    public String getScrollLiveTime() {
        return this.scrollLiveTime;
    }

    public ElasticsearchInputConfig setScrollLiveTime(String scrollLiveTime) {
        this.scrollLiveTime = scrollLiveTime;
        return this;
    }

    public String getQueryUrl() {
        return this.queryUrl;
    }

    public ElasticsearchInputConfig setQueryUrl(String queryUrl) {
        this.queryUrl = queryUrl;
        return this;
    }

    public QueryUrlFunction getQueryUrlFunction() {
        return this.queryUrlFunction;
    }

    public ElasticsearchInputConfig setQueryUrlFunction(QueryUrlFunction queryUrlFunction) {
        this.queryUrlFunction = queryUrlFunction;
        return this;
    }

    public String getDslFile() {
        return this.dslFile;
    }

    public ElasticsearchInputConfig setDslFile(String dslFile) {
        this.dslFile = dslFile;
        return this;
    }

    public String getDslName() {
        return this.dslName;
    }

    public ElasticsearchInputConfig setDslName(String dslName) {
        this.dslName = dslName;
        return this;
    }

    public boolean isSliceQuery() {
        return this.sliceQuery;
    }

    public ElasticsearchInputConfig setSliceQuery(boolean sliceQuery) {
        this.sliceQuery = sliceQuery;
        return this;
    }

    public int getSliceSize() {
        return this.sliceSize;
    }

    public ElasticsearchInputConfig setSliceSize(int sliceSize) {
        this.sliceSize = sliceSize;
        return this;
    }

    public ElasticsearchInputConfig addSourceElasticsearch(String name, String sourceElasticsearch) {
        this.sourceElasticsearch = sourceElasticsearch;
        if (this.esConfig == null) {
            this.esConfig = new ESConfig();
        }
        return this.addElasticsearchProperty(name, sourceElasticsearch);
    }

    public ElasticsearchInputConfig addElasticsearchProperty(String name, String value) {
        if (this.esConfig == null) {
            this.esConfig = new ESConfig();
        }
        this.esConfig.addElasticsearchProperty(name, value);
        return this;
    }

    public String getDsl() {
        return this.dsl;
    }

    public ElasticsearchInputConfig setDsl(String dsl) {
        this.dsl = dsl;
        return this;
    }

    public String getDslNamespace() {
        return this.dslNamespace;
    }
}

