/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.es.output;

import org.frameworkset.tran.BaseCommonRecordDataTran;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.es.output.ElasticsearchOutputConfig;
import org.frameworkset.tran.plugin.es.output.TaskCommandImpl;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.BaseParrelTranCommand;
import org.frameworkset.tran.task.BaseSerialTranCommand;
import org.frameworkset.tran.task.TaskCall;
import org.frameworkset.tran.task.TaskCommand;
import org.frameworkset.tran.task.TaskCommandContext;

public class BaseElasticsearchDataTran
extends BaseCommonRecordDataTran {
    protected ElasticsearchOutputConfig elasticsearchOutputConfig;

    public BaseElasticsearchDataTran(BaseDataTran baseDataTran) {
        super(baseDataTran);
    }

    public BaseElasticsearchDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, ImportContext importContext, Status currentStatus) {
        super(taskContext, jdbcResultSet, importContext, currentStatus);
        this.elasticsearchOutputConfig = (ElasticsearchOutputConfig)importContext.getOutputConfig();
    }

    @Override
    protected void initTranTaskCommand() {
        this.parrelTranCommand = new BaseParrelTranCommand(){

            @Override
            public int hanBatchActionTask(TaskCommandContext taskCommandContext) {
                if (taskCommandContext.containData()) {
                    taskCommandContext.increamentTaskNo();
                    TaskCommandImpl taskCommand = (TaskCommandImpl)BaseElasticsearchDataTran.this._buildTaskCommand(taskCommandContext);
                    taskCommandContext.addTask(taskCommand);
                }
                return taskCommandContext.getTaskNo();
            }
        };
        this.serialTranCommand = new BaseSerialTranCommand(){

            @Override
            public int hanBatchActionTask(TaskCommandContext taskCommandContext) {
                return BaseElasticsearchDataTran.this.processDataSerial(taskCommandContext);
            }

            @Override
            public int endSerialActionTask(TaskCommandContext taskCommandContext) {
                return BaseElasticsearchDataTran.this.processDataSerial(taskCommandContext);
            }
        };
    }

    @Override
    public TaskCommand buildTaskCommand(TaskCommandContext taskCommandContext) {
        return new TaskCommandImpl(taskCommandContext, (ElasticsearchOutputConfig)this.outputPlugin.getOutputConfig());
    }

    @Override
    public void init() {
        super.init();
        if (this.elasticsearchOutputConfig == null) {
            this.elasticsearchOutputConfig = (ElasticsearchOutputConfig)this.outputPlugin.getOutputConfig();
        }
        this.taskInfo = "import data to elasticsearch[" + this.elasticsearchOutputConfig.getTargetElasticsearch() + "] " + " IndexName[" + this.elasticsearchOutputConfig.getEsIndexWrapper().getIndex() + "] IndexType[" + this.elasticsearchOutputConfig.getEsIndexWrapper().getType() + "] start.";
    }

    protected int processDataSerial(TaskCommandContext taskCommandContext) {
        if (taskCommandContext.containData()) {
            taskCommandContext.increamentTaskNo();
            TaskCommandImpl taskCommand = (TaskCommandImpl)this._buildTaskCommand(taskCommandContext);
            TaskCall.call(taskCommand);
        }
        return taskCommandContext.getTaskNo();
    }
}

