/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.es.output;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.frameworkset.orm.annotation.ESIndexWrapper;
import java.util.List;
import org.frameworkset.tran.DefaultEsIdGenerator;
import org.frameworkset.tran.EsIdGenerator;
import org.frameworkset.tran.ExportResultHandler;
import org.frameworkset.tran.WrapedExportResultHandler;
import org.frameworkset.tran.config.ClientOptions;
import org.frameworkset.tran.config.ImportBuilder;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.context.RecordSpecialConfigsContext;
import org.frameworkset.tran.exception.ImportExceptionUtil;
import org.frameworkset.tran.plugin.BaseConfig;
import org.frameworkset.tran.plugin.OutputPlugin;
import org.frameworkset.tran.plugin.es.ESConfig;
import org.frameworkset.tran.plugin.es.ESField;
import org.frameworkset.tran.plugin.es.input.ESExportResultHandler;
import org.frameworkset.tran.plugin.es.output.ElasticsearchOutputDataTranPlugin;
import org.frameworkset.tran.record.RecordOutpluginSpecialConfig;

public class ElasticsearchOutputConfig
extends BaseConfig
implements OutputConfig {
    private String index;
    private String indexType;
    private transient EsIdGenerator esIdGenerator = new DefaultEsIdGenerator(this);
    private boolean discardBulkResponse = true;
    private boolean debugResponse;
    private ESIndexWrapper esIndexWrapper;
    private ESConfig esConfig;
    private ClientOptions clientOptions;
    private String targetElasticsearch = "default";
    public static final String SPECIALCONFIG_INDEX_NAME = "index";
    public static final String SPECIALCONFIG_INDEXTYPE_NAME = "indexType";
    public static final String SPECIALCONFIG_ESINDEXWRAPPER_NAME = "esIndexWrapper";
    public static final String SPECIALCONFIG_CLIENTOPTIONS_NAME = "clientOptions";
    public static final String SPECIALCONFIG_ESID_NAME = "esId";
    public static final String SPECIALCONFIG_PARENTID_NAME = "parentId";
    public static final String SPECIALCONFIG_ROUTING_NAME = "routing";
    public static final String SPECIALCONFIG_VERSION_NAME = "version";
    public static final String SPECIALCONFIG_OPERATION_NAME = "operation";
    public static final String SPECIALCONFIG_JDBCGETVARIABLEVALUE_NAME = "jdbcGetVariableValue";

    @Override
    public void initRecordSpecialConfigsContext(RecordSpecialConfigsContext recordSpecialConfigsContext, boolean fromMultiOutput) {
        RecordOutpluginSpecialConfig recordOutpluginSpecialConfig = new RecordOutpluginSpecialConfig(this);
        if (!fromMultiOutput) {
            recordSpecialConfigsContext.setRecordOutpluginSpecialConfig(recordOutpluginSpecialConfig);
        } else {
            recordSpecialConfigsContext.addRecordOutpluginSpecialConfig(this.outputPlugin, recordOutpluginSpecialConfig);
        }
    }

    public boolean isDiscardBulkResponse() {
        return this.discardBulkResponse;
    }

    public ElasticsearchOutputConfig setDiscardBulkResponse(boolean discardBulkResponse) {
        this.discardBulkResponse = discardBulkResponse;
        return this;
    }

    public boolean isDebugResponse() {
        return this.debugResponse;
    }

    private void checkclientOptions() {
        if (this.clientOptions == null) {
            this.clientOptions = new ClientOptions();
        }
    }

    private void copy(ClientOptions oldClientOptions, ClientOptions newClientOptions) {
        if (oldClientOptions.getIdField() != null) {
            newClientOptions.setIdField(oldClientOptions.getIdField());
        }
        if (oldClientOptions.getRefreshOption() != null) {
            newClientOptions.setRefreshOption(oldClientOptions.getRefreshOption());
        }
    }

    public ElasticsearchOutputConfig setClientOptions(ClientOptions clientOptions) {
        if (this.clientOptions != null) {
            this.copy(this.clientOptions, clientOptions);
        }
        this.clientOptions = clientOptions;
        return this;
    }

    public ElasticsearchOutputConfig setEsParentIdValue(String esParentIdValue) {
        this.checkclientOptions();
        this.clientOptions.setEsParentIdValue(esParentIdValue);
        return this;
    }

    public ElasticsearchOutputConfig setEsVersionValue(Object esVersionValue) {
        this.checkclientOptions();
        this.clientOptions.setVersion(esVersionValue);
        return this;
    }

    public ElasticsearchOutputConfig setEsDetectNoop(Object esDetectNoop) {
        this.checkclientOptions();
        this.clientOptions.setDetectNoop(esDetectNoop);
        return this;
    }

    public ElasticsearchOutputConfig setDebugResponse(boolean debugResponse) {
        this.debugResponse = debugResponse;
        return this;
    }

    public ESIndexWrapper getEsIndexWrapper() {
        return this.esIndexWrapper;
    }

    public ElasticsearchOutputConfig setEsIndexWrapper(ESIndexWrapper esIndexWrapper) {
        this.esIndexWrapper = esIndexWrapper;
        return this;
    }

    @JsonIgnore
    public EsIdGenerator getEsIdGenerator() {
        return this.esIdGenerator;
    }

    @JsonIgnore
    public ElasticsearchOutputConfig setEsIdGenerator(EsIdGenerator esIdGenerator) {
        if (esIdGenerator != null) {
            this.esIdGenerator = esIdGenerator;
        }
        return this;
    }

    public ESConfig getEsConfig() {
        return this.esConfig;
    }

    public ElasticsearchOutputConfig setTargetElasticsearch(String targetElasticsearch) {
        this.targetElasticsearch = targetElasticsearch;
        return this;
    }

    public String getTargetElasticsearch() {
        return this.targetElasticsearch;
    }

    public ElasticsearchOutputConfig setEsConfig(ESConfig esConfig) {
        this.esConfig = esConfig;
        return this;
    }

    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    public ElasticsearchOutputConfig addElasticsearchProperty(String name, String value) {
        if (this.esConfig == null) {
            this.esConfig = new ESConfig();
        }
        this.esConfig.addElasticsearchProperty(name, value);
        return this;
    }

    public ElasticsearchOutputConfig addTargetElasticsearch(String name, String targetElasticsearch) {
        this.targetElasticsearch = targetElasticsearch;
        return this.addElasticsearchProperty(name, targetElasticsearch);
    }

    @Override
    public void build(ImportContext importContext, ImportBuilder importBuilder) {
        if (this.targetElasticsearch == null) {
            this.targetElasticsearch = "default";
        }
        if (this.index != null) {
            ESIndexWrapper esIndexWrapper = new ESIndexWrapper(this.index, this.indexType);
            this.setEsIndexWrapper(esIndexWrapper);
        }
        if (this.getEsIndexWrapper() == null) {
            throw ImportExceptionUtil.buildDataImportException(importContext, "Global Elasticsearch index must be setted, please check your import job builder config.");
        }
    }

    @Override
    public OutputPlugin getOutputPlugin(ImportContext importContext) {
        return new ElasticsearchOutputDataTranPlugin(this, importContext);
    }

    public String getIndex() {
        return this.index;
    }

    public ElasticsearchOutputConfig setIndex(String index) {
        this.index = index;
        return this;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public ElasticsearchOutputConfig setIndexType(String indexType) {
        this.indexType = indexType;
        return this;
    }

    @Override
    public WrapedExportResultHandler buildExportResultHandler(ExportResultHandler exportResultHandler) {
        ESExportResultHandler esExportResultHandler = new ESExportResultHandler(exportResultHandler, this);
        this.exportResultHandler = esExportResultHandler;
        return esExportResultHandler;
    }

    public ElasticsearchOutputConfig setTimeout(String timeout) {
        this.checkclientOptions();
        this.clientOptions.setTimeout(timeout);
        return this;
    }

    public ElasticsearchOutputConfig setMasterTimeout(String masterTimeout) {
        this.checkclientOptions();
        this.clientOptions.setMasterTimeout(masterTimeout);
        return this;
    }

    public ElasticsearchOutputConfig setWaitForActiveShards(Integer waitForActiveShards) {
        this.checkclientOptions();
        this.clientOptions.setWaitForActiveShards(waitForActiveShards);
        return this;
    }

    public ElasticsearchOutputConfig setSourceUpdateExcludes(List<String> sourceUpdateExcludes) {
        this.checkclientOptions();
        this.clientOptions.setSourceUpdateExcludes(sourceUpdateExcludes);
        return this;
    }

    public ElasticsearchOutputConfig setSourceUpdateIncludes(List<String> sourceUpdateIncludes) {
        this.checkclientOptions();
        this.clientOptions.setSourceUpdateIncludes(sourceUpdateIncludes);
        return this;
    }

    public ElasticsearchOutputConfig setRefreshOption(String refreshOption) {
        this.checkclientOptions();
        this.clientOptions.setRefreshOption(refreshOption);
        return this;
    }

    public ElasticsearchOutputConfig setEsVersionType(String esVersionType) {
        this.checkclientOptions();
        this.clientOptions.setVersionType(esVersionType);
        return this;
    }

    public ElasticsearchOutputConfig setEsVersionField(String esVersionField) {
        this.checkclientOptions();
        if (!esVersionField.startsWith("meta:")) {
            this.clientOptions.setVersionField(new ESField(false, esVersionField));
        } else {
            this.clientOptions.setVersionField(new ESField(true, esVersionField.substring(5)));
        }
        return this;
    }

    public ElasticsearchOutputConfig setEsReturnSource(Boolean esReturnSource) {
        this.checkclientOptions();
        this.clientOptions.setReturnSource(esReturnSource);
        return this;
    }

    public ElasticsearchOutputConfig setEsRetryOnConflict(Integer esRetryOnConflict) {
        this.checkclientOptions();
        this.clientOptions.setEsRetryOnConflict(esRetryOnConflict);
        return this;
    }

    public ElasticsearchOutputConfig setEsDocAsUpsert(Boolean esDocAsUpsert) {
        this.checkclientOptions();
        this.clientOptions.setDocasupsert(esDocAsUpsert);
        return this;
    }

    public ElasticsearchOutputConfig setRoutingValue(String routingValue) {
        this.checkclientOptions();
        this.clientOptions.setRouting(routingValue);
        return this;
    }

    public ElasticsearchOutputConfig setFilterPath(String filterPath) {
        this.checkclientOptions();
        this.clientOptions.setFilterPath(filterPath);
        return this;
    }

    public ElasticsearchOutputConfig setRoutingField(String routingField) {
        this.checkclientOptions();
        if (!routingField.startsWith("meta:")) {
            this.clientOptions.setRoutingField(new ESField(false, routingField));
        } else {
            this.clientOptions.setRoutingField(new ESField(true, routingField.substring(5)));
        }
        return this;
    }

    public ElasticsearchOutputConfig setEsParentIdField(String esParentIdField) {
        this.checkclientOptions();
        if (!esParentIdField.startsWith("meta:")) {
            this.clientOptions.setParentIdField(new ESField(false, esParentIdField));
        } else {
            this.clientOptions.setParentIdField(new ESField(true, esParentIdField.substring(5)));
        }
        return this;
    }

    public ElasticsearchOutputConfig setEsIdField(String esIdField) {
        this.checkclientOptions();
        if (!esIdField.startsWith("meta:")) {
            this.clientOptions.setIdField(new ESField(false, esIdField));
        } else {
            this.clientOptions.setIdField(new ESField(true, esIdField.substring(5)));
        }
        return this;
    }

    @Override
    public void afterRefactor(RecordOutpluginSpecialConfig recordOutpluginSpecialConfig, Context context) throws Exception {
        ClientOptions clientOptions;
        String index = recordOutpluginSpecialConfig.getSpecialStringConfig(SPECIALCONFIG_INDEX_NAME);
        String indexType = recordOutpluginSpecialConfig.getSpecialStringConfig(SPECIALCONFIG_INDEXTYPE_NAME);
        ESIndexWrapper esIndexWrapper = null;
        if (index != null && !index.equals("")) {
            esIndexWrapper = indexType == null ? new ESIndexWrapper(index, null) : new ESIndexWrapper(index, indexType);
        }
        if (esIndexWrapper == null) {
            esIndexWrapper = this.esIndexWrapper;
        }
        if (esIndexWrapper != null) {
            recordOutpluginSpecialConfig.addRecordSpecialConfigOnly(SPECIALCONFIG_ESINDEXWRAPPER_NAME, esIndexWrapper);
        }
        if ((clientOptions = (ClientOptions)recordOutpluginSpecialConfig.getSpecialConfig(SPECIALCONFIG_CLIENTOPTIONS_NAME)) == null && (clientOptions = this.clientOptions) != null) {
            recordOutpluginSpecialConfig.addRecordSpecialConfigOnly(SPECIALCONFIG_CLIENTOPTIONS_NAME, clientOptions);
        }
        recordOutpluginSpecialConfig.addRecordSpecialConfigOnly(SPECIALCONFIG_ESID_NAME, this.getEsIdGenerator().genId(context));
        ESField esField = clientOptions != null ? clientOptions.getParentIdField() : null;
        Object parentId = null;
        if (esField != null) {
            parentId = !esField.isMeta() ? context.getValue(esField.getField()) : context.getMetaValue(esField.getField());
        } else {
            Object object = parentId = clientOptions != null ? clientOptions.getEsParentIdValue() : null;
        }
        if (parentId != null) {
            recordOutpluginSpecialConfig.addRecordSpecialConfigOnly(SPECIALCONFIG_PARENTID_NAME, parentId);
        }
        esField = clientOptions != null ? clientOptions.getRoutingField() : null;
        Object routing = null;
        if (esField != null) {
            routing = !esField.isMeta() ? context.getValue(esField.getField()) : context.getMetaValue(esField.getField());
        } else {
            Object object = routing = clientOptions != null ? clientOptions.getRouting() : null;
        }
        if (routing != null) {
            recordOutpluginSpecialConfig.addRecordSpecialConfigOnly(SPECIALCONFIG_ROUTING_NAME, routing);
        }
        esField = clientOptions != null ? clientOptions.getVersionField() : null;
        Object version = null;
        if (esField != null) {
            version = !esField.isMeta() ? context.getValue(esField.getField()) : context.getMetaValue(esField.getField());
        } else {
            Object object = version = clientOptions != null ? clientOptions.getVersion() : null;
        }
        if (version != null) {
            recordOutpluginSpecialConfig.addRecordSpecialConfigOnly(SPECIALCONFIG_VERSION_NAME, version);
        }
        String operation = null;
        operation = context.isInsert() ? SPECIALCONFIG_INDEX_NAME : (context.isUpdate() ? "update" : (context.isDelete() ? "delete" : SPECIALCONFIG_INDEX_NAME));
        recordOutpluginSpecialConfig.addRecordSpecialConfigOnly(SPECIALCONFIG_OPERATION_NAME, operation);
    }

    @Override
    public Object preHandleSpecialConfig(String name, Object value) {
        if (name.equals(SPECIALCONFIG_CLIENTOPTIONS_NAME)) {
            ClientOptions clientOptions = (ClientOptions)value;
            if (this.getClientOptions() != null && clientOptions != null && clientOptions.getParentClientOptions() == null) {
                clientOptions.setParentClientOptions(this.getClientOptions());
            }
        }
        return value;
    }
}

