/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.es.output;

import java.util.Date;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.FieldMeta;
import org.frameworkset.tran.JobCountDownLatch;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.OutputPlugin;
import org.frameworkset.tran.plugin.db.output.JDBCGetVariableValue;
import org.frameworkset.tran.plugin.es.BaseESPlugin;
import org.frameworkset.tran.plugin.es.output.AsynESOutPutDataTran;
import org.frameworkset.tran.plugin.es.output.BaseElasticsearchDataTran;
import org.frameworkset.tran.plugin.es.output.ElasticsearchOutputConfig;
import org.frameworkset.tran.record.RecordColumnInfo;
import org.frameworkset.tran.record.RecordOutpluginSpecialConfig;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.util.annotations.DateFormateMeta;

public class ElasticsearchOutputDataTranPlugin
extends BaseESPlugin
implements OutputPlugin {
    protected ElasticsearchOutputConfig elasticsearchOutputConfig;
    private ClientInterface[] clientInterfaces;

    public ElasticsearchOutputDataTranPlugin(OutputConfig pluginOutputConfig, ImportContext importContext) {
        super(pluginOutputConfig, importContext);
        this.elasticsearchOutputConfig = (ElasticsearchOutputConfig)pluginOutputConfig;
    }

    @Override
    public String getJobType() {
        return "ElasticsearchOutputDataTranPlugin";
    }

    @Override
    public void afterInit() {
        this.initClientInterfaces();
    }

    @Override
    public RecordColumnInfo resolveRecordColumnInfo(Object value, FieldMeta fieldMeta, Context context) {
        RecordColumnInfo recordColumnInfo = null;
        if (value != null && value instanceof Date) {
            DateFormateMeta dateFormateMeta = null;
            if (fieldMeta != null) {
                dateFormateMeta = fieldMeta.getDateFormateMeta();
            }
            if (dateFormateMeta == null) {
                dateFormateMeta = context.getDateFormateMeta();
            }
            recordColumnInfo = new RecordColumnInfo();
            recordColumnInfo.setDateTag(true);
            recordColumnInfo.setDateFormateMeta(dateFormateMeta);
        }
        return recordColumnInfo;
    }

    @Override
    public void buildRecordOutpluginSpecialConfig(CommonRecord dataRecord, Context context) throws Exception {
        RecordOutpluginSpecialConfig recordOutpluginSpecialConfig = context.getRecordSpecialConfigsContext().getRecordOutpluginSpecialConfig(this);
        if (recordOutpluginSpecialConfig != null) {
            JDBCGetVariableValue jdbcGetVariableValue = new JDBCGetVariableValue(dataRecord, context.getBatchContext());
            recordOutpluginSpecialConfig.addRecordSpecialConfigOnly("jdbcGetVariableValue", (Object)jdbcGetVariableValue);
        }
    }

    @Override
    public void beforeInit() {
        this.esConfig = this.elasticsearchOutputConfig.getEsConfig();
        this.applicationPropertiesFile = this.importContext.getApplicationPropertiesFile();
        this.initES();
    }

    @Override
    public void init() {
    }

    @Override
    public BaseDataTran createBaseDataTran(TaskContext taskContext, TranResultSet tranResultSet, JobCountDownLatch countDownLatch, Status currentStatus) {
        BaseElasticsearchDataTran db2ESDataTran = null;
        db2ESDataTran = countDownLatch == null ? new BaseElasticsearchDataTran(taskContext, tranResultSet, this.importContext, currentStatus) : new AsynESOutPutDataTran(taskContext, tranResultSet, this.importContext, countDownLatch, currentStatus);
        db2ESDataTran.initTran();
        return db2ESDataTran;
    }

    @Override
    public BaseDataTran createBaseDataTran(BaseDataTran baseDataTran) {
        AsynESOutPutDataTran dummyOutPutDataTran = new AsynESOutPutDataTran(baseDataTran);
        return dummyOutPutDataTran;
    }

    private void initClientInterfaces() {
        if (this.clientInterfaces == null) {
            String targetElasticsearch = this.elasticsearchOutputConfig.getTargetElasticsearch();
            if (targetElasticsearch != null) {
                String[] _elasticsearchs = targetElasticsearch.split(",");
                this.clientInterfaces = new ClientInterface[_elasticsearchs.length];
                for (int i = 0; i < _elasticsearchs.length; ++i) {
                    this.clientInterfaces[i] = ElasticSearchHelper.getRestClientUtil((String)_elasticsearchs[i]);
                }
            } else {
                this.clientInterfaces = new ClientInterface[1];
                this.clientInterfaces[0] = ElasticSearchHelper.getRestClientUtil((String)"default");
            }
        }
    }

    public ClientInterface[] getClientInterfaces() {
        return this.clientInterfaces;
    }
}

