/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.es.output;

import com.frameworkset.common.poolman.handle.ValueExchange;
import com.frameworkset.orm.annotation.ESIndexWrapper;
import com.frameworkset.util.SimpleStringUtil;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.client.ResponseHandler;
import org.frameworkset.elasticsearch.bulk.BulkActionConfig;
import org.frameworkset.elasticsearch.client.BuildTool;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.handler.ESVoidResponseHandler;
import org.frameworkset.elasticsearch.serial.CharEscapeUtil;
import org.frameworkset.elasticsearch.serial.SerialUtil;
import org.frameworkset.elasticsearch.template.ConfigDSLUtil;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.config.ClientOptions;
import org.frameworkset.tran.exception.ImportExceptionUtil;
import org.frameworkset.tran.plugin.db.output.JDBCGetVariableValue;
import org.frameworkset.tran.plugin.es.output.ElasticsearchOutputConfig;
import org.frameworkset.tran.plugin.es.output.ElasticsearchOutputDataTranPlugin;
import org.frameworkset.tran.record.RecordColumnInfo;
import org.frameworkset.tran.record.RecordOutpluginSpecialConfig;
import org.frameworkset.tran.task.BaseTaskCommand;
import org.frameworkset.tran.task.TaskCommand;
import org.frameworkset.tran.task.TaskCommandContext;
import org.frameworkset.tran.task.TaskFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCommandImpl
extends BaseTaskCommand<String> {
    private ElasticsearchOutputConfig elasticsearchOutputConfig;
    private ClientInterface[] clientInterfaces;
    private int tryCount;
    private String datas;
    private boolean versionUpper7;
    private static Logger logger = LoggerFactory.getLogger(TaskCommand.class);

    public TaskCommandImpl(TaskCommandContext taskCommandContext, ElasticsearchOutputConfig elasticsearchOutputConfig) {
        super(elasticsearchOutputConfig, taskCommandContext);
        this.elasticsearchOutputConfig = elasticsearchOutputConfig;
        ElasticsearchOutputDataTranPlugin elasticsearchOutputDataTranPlugin = (ElasticsearchOutputDataTranPlugin)elasticsearchOutputConfig.getOutputPlugin();
        this.clientInterfaces = elasticsearchOutputDataTranPlugin.getClientInterfaces();
        if (this.clientInterfaces != null && this.clientInterfaces.length > 0) {
            this.versionUpper7 = this.clientInterfaces[0].isVersionUpper7();
        }
    }

    public ClientInterface[] getClientInterfaces() {
        return this.clientInterfaces;
    }

    @Override
    public Object getDatas() {
        return this.datas;
    }

    public void buildMeta(CommonRecord elasticsearchCommonRecord, Writer writer, boolean upper7) throws Exception {
        String pipeline;
        Object versionType;
        Object version;
        RecordOutpluginSpecialConfig recordOutpluginSpecialConfig = elasticsearchCommonRecord.getRecordOutpluginSpecialConfig(this.outputConfig);
        Object id = recordOutpluginSpecialConfig.getSpecialConfig("esId");
        Object parentId = recordOutpluginSpecialConfig.getSpecialConfig("parentId");
        Object routing = recordOutpluginSpecialConfig.getSpecialConfig("routing");
        ClientOptions clientOptions = (ClientOptions)recordOutpluginSpecialConfig.getSpecialConfig("clientOptions");
        Object esRetryOnConflict = clientOptions != null ? clientOptions.getEsRetryOnConflict() : null;
        ESIndexWrapper esIndexWrapper = (ESIndexWrapper)recordOutpluginSpecialConfig.getSpecialConfig("esIndexWrapper");
        JDBCGetVariableValue jdbcGetVariableValue = (JDBCGetVariableValue)((Object)recordOutpluginSpecialConfig.getSpecialConfig("jdbcGetVariableValue"));
        writer.write("{ \"");
        writer.write((String)recordOutpluginSpecialConfig.getSpecialConfig("operation"));
        writer.write("\" : { \"_index\" : \"");
        if (esIndexWrapper == null) {
            throw ImportExceptionUtil.buildDataImportException(this.importContext, " ESIndex not seted.");
        }
        BuildTool.buildIndiceName((ESIndexWrapper)esIndexWrapper, (Writer)writer, (ESIndexWrapper.GetVariableValue)jdbcGetVariableValue);
        writer.write("\"");
        if (!upper7) {
            writer.write(", \"_type\" : \"");
            if (esIndexWrapper == null) {
                throw ImportExceptionUtil.buildDataImportException(this.importContext, " ESIndex type not seted.");
            }
            String indexType = BuildTool.buildIndiceType((ESIndexWrapper)esIndexWrapper, (ESIndexWrapper.GetVariableValue)jdbcGetVariableValue);
            if (indexType == null || indexType.equals("")) {
                throw ImportExceptionUtil.buildDataImportException(this.importContext, " ESIndex type not seted.");
            }
            writer.write(indexType);
            writer.write("\"");
        }
        if (id != null) {
            writer.write(", \"_id\" : ");
            BuildTool.buildId((Object)id, (Writer)writer, (boolean)true);
        }
        if (parentId != null) {
            writer.write(", \"parent\" : ");
            BuildTool.buildId((Object)parentId, (Writer)writer, (boolean)true);
        }
        if (routing != null) {
            if (!upper7) {
                writer.write(", \"_routing\" : ");
            } else {
                writer.write(", \"routing\" : ");
            }
            BuildTool.buildRouting((Object)routing, (Writer)writer, (boolean)true);
        }
        if (esRetryOnConflict != null) {
            if (!upper7) {
                writer.write(",\"_retry_on_conflict\":");
            } else {
                writer.write(",\"retry_on_conflict\":");
            }
            writer.write(String.valueOf(esRetryOnConflict));
        }
        if ((version = recordOutpluginSpecialConfig.getSpecialConfig("version")) != null) {
            if (!upper7) {
                writer.write(",\"_version\":");
            } else {
                writer.write(",\"version\":");
            }
            writer.write(String.valueOf(version));
        }
        Object object = versionType = clientOptions != null ? clientOptions.getVersionType() : null;
        if (versionType != null) {
            if (!upper7) {
                writer.write(",\"_version_type\":");
            } else {
                writer.write(",\"version_type\":");
            }
            writer.write(String.valueOf(versionType));
            writer.write("\"");
        }
        if (upper7) {
            Long if_primary_term;
            Long if_seq_no;
            Long l = if_seq_no = clientOptions != null ? clientOptions.getIfSeqNo() : null;
            if (if_seq_no != null) {
                writer.write(",\"if_seq_no\":");
                writer.write(String.valueOf(if_seq_no));
            }
            Long l2 = if_primary_term = clientOptions != null ? clientOptions.getIfPrimaryTerm() : null;
            if (if_primary_term != null) {
                writer.write(",\"if_primary_term\":");
                writer.write(String.valueOf(if_primary_term));
            }
        }
        String string = pipeline = clientOptions != null ? clientOptions.getPipeline() : null;
        if (pipeline != null) {
            writer.write(",\"pipeline\":\"");
            writer.write(pipeline);
            writer.write("\"");
        }
        if (elasticsearchCommonRecord.isInsert()) {
            String op_type;
            String string2 = op_type = clientOptions != null ? clientOptions.getOpType() : null;
            if (op_type != null) {
                writer.write(",\"op_type\":\"");
                writer.write(op_type);
                writer.write("\"");
            }
        }
        writer.write(" } }\n");
    }

    public void evalBuilk(Writer writer, CommonRecord elasticsearchCommonRecord, boolean upper7) throws Exception {
        RecordOutpluginSpecialConfig recordOutpluginSpecialConfig = elasticsearchCommonRecord.getRecordOutpluginSpecialConfig(this.outputConfig);
        if (elasticsearchCommonRecord.isInsert()) {
            this.buildMeta(elasticsearchCommonRecord, writer, upper7);
            this.serialResult(writer, elasticsearchCommonRecord);
            writer.write("\n");
        } else if (elasticsearchCommonRecord.isUpdate()) {
            List<String> sourceUpdateIncludes;
            List<String> sourceUpdateExcludes;
            Boolean esReturnSource;
            Object detect_noop;
            Object esDocAsUpsert;
            this.buildMeta(elasticsearchCommonRecord, writer, upper7);
            writer.write("{\"doc\":");
            this.serialResult(writer, elasticsearchCommonRecord);
            ClientOptions clientOptions = (ClientOptions)recordOutpluginSpecialConfig.getSpecialConfig("clientOptions");
            Object object = esDocAsUpsert = clientOptions != null ? clientOptions.getDocasupsert() : null;
            if (esDocAsUpsert != null) {
                writer.write(",\"doc_as_upsert\":");
                writer.write(String.valueOf(esDocAsUpsert));
            }
            Object object2 = detect_noop = clientOptions != null ? clientOptions.getDetectNoop() : null;
            if (detect_noop != null) {
                writer.write(",\"detect_noop\":");
                writer.write(detect_noop.toString());
            }
            Boolean bl = esReturnSource = clientOptions != null ? clientOptions.getReturnSource() : null;
            if (esReturnSource != null) {
                writer.write(",\"_source\":");
                writer.write(String.valueOf(esReturnSource));
            }
            List<String> list = sourceUpdateExcludes = clientOptions != null ? clientOptions.getSourceUpdateExcludes() : null;
            if (sourceUpdateExcludes != null && !upper7) {
                writer.write(",\"_source_excludes\":");
                SerialUtil.object2json(sourceUpdateExcludes, (Writer)writer);
            }
            List<String> list2 = sourceUpdateIncludes = clientOptions != null ? clientOptions.getSourceUpdateIncludes() : null;
            if (sourceUpdateIncludes != null && !upper7) {
                writer.write(",\"_source_includes\":");
                SerialUtil.object2json(sourceUpdateIncludes, (Writer)writer);
            }
            writer.write("}\n");
        } else if (elasticsearchCommonRecord.isDelete()) {
            this.evalDeleteBuilk(writer, elasticsearchCommonRecord, upper7);
        } else {
            this.buildMeta(elasticsearchCommonRecord, writer, upper7);
            this.serialResult(writer, elasticsearchCommonRecord);
            writer.write("\n");
        }
    }

    public void evalDeleteBuilk(Writer writer, CommonRecord elasticsearchCommonRecord, boolean isUpper7) throws Exception {
        this.buildMeta(elasticsearchCommonRecord, writer, isUpper7);
    }

    private void serialResult(Writer writer, CommonRecord dataRecord) throws Exception {
        writer.write("{");
        boolean hasSeted = false;
        Map<String, Object> datas = dataRecord.getDatas();
        Iterator<Map.Entry<String, Object>> iterator = datas.entrySet().iterator();
        RecordOutpluginSpecialConfig recordOutpluginSpecialConfig = dataRecord.getRecordOutpluginSpecialConfig(this.outputConfig);
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String colName = entry.getKey();
            if (colName.equals("_id")) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Field [_id] is a metadata field and cannot be added inside a document. Use the index API request parameters.");
                continue;
            }
            Object value = entry.getValue();
            if (value == null && this.importContext.isIgnoreNullValueField()) continue;
            if (hasSeted) {
                writer.write(",");
            } else {
                hasSeted = true;
            }
            writer.write("\"");
            writer.write(colName);
            writer.write("\":");
            if (value != null) {
                CharEscapeUtil charEscapeUtil;
                String dataStr;
                if (value instanceof String) {
                    writer.write("\"");
                    CharEscapeUtil charEscapeUtil2 = new CharEscapeUtil(writer);
                    charEscapeUtil2.writeString((String)value, true);
                    writer.write("\"");
                    continue;
                }
                if (value instanceof Date) {
                    RecordColumnInfo recordColumnInfo = recordOutpluginSpecialConfig.getRecordColumnInfo(colName);
                    DateFormat dateFormat = recordColumnInfo.getDateFormat();
                    String dataStr2 = ConfigDSLUtil.getDate((Date)((Date)value), (DateFormat)dateFormat);
                    writer.write("\"");
                    writer.write(dataStr2);
                    writer.write("\"");
                    continue;
                }
                if (value instanceof Clob) {
                    dataStr = ValueExchange.getStringFromClob((Clob)((Clob)value));
                    writer.write("\"");
                    charEscapeUtil = new CharEscapeUtil(writer);
                    charEscapeUtil.writeString(dataStr, true);
                    writer.write("\"");
                    continue;
                }
                if (value instanceof Blob) {
                    dataStr = ValueExchange.getStringFromBlob((Blob)((Blob)value));
                    writer.write("\"");
                    charEscapeUtil = new CharEscapeUtil(writer);
                    charEscapeUtil.writeString(dataStr, true);
                    writer.write("\"");
                    continue;
                }
                SimpleStringUtil.object2json((Object)value, (Writer)writer);
                continue;
            }
            writer.write("null");
        }
        writer.write("}");
    }

    private void buildDatas() throws Exception {
        if (this.records.size() == 0) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        CommonRecord elasticsearchCommonRecord = null;
        for (int i = 0; i < this.records.size(); ++i) {
            elasticsearchCommonRecord = (CommonRecord)this.records.get(i);
            this.evalBuilk((Writer)writer, elasticsearchCommonRecord, this.versionUpper7);
        }
        this.datas = writer.toString();
        builder = null;
    }

    @Override
    public String execute() throws Exception {
        String data = null;
        if (this.records.size() > 0) {
            if (this.importContext.getMaxRetry() > 0 && this.tryCount >= this.importContext.getMaxRetry()) {
                throw new TaskFailedException("task execute failed:reached max retry times " + this.importContext.getMaxRetry());
            }
            if (this.datas == null) {
                this.buildDatas();
            }
            ++this.tryCount;
            String actionUrl = BuildTool.buildActionUrl((BulkActionConfig)this.elasticsearchOutputConfig.getClientOptions(), (String)"took,errors,items.*._index,items.*._type,items.*._id,items.*.status,items.*.error");
            if (this.elasticsearchOutputConfig.isDebugResponse()) {
                for (ClientInterface clientInterface : this.clientInterfaces) {
                    data = clientInterface.executeHttp(actionUrl, this.datas, "post");
                }
                if (logger.isInfoEnabled()) {
                    logger.info(data);
                }
            } else {
                if (this.elasticsearchOutputConfig.isDiscardBulkResponse() && this.elasticsearchOutputConfig.getExportResultHandler() == null) {
                    for (ClientInterface clientInterface : this.clientInterfaces) {
                        ESVoidResponseHandler esVoidResponseHandler = new ESVoidResponseHandler();
                        clientInterface.executeHttp(actionUrl, this.datas, "post", (ResponseHandler)esVoidResponseHandler);
                        if (esVoidResponseHandler.getElasticSearchException() == null) continue;
                        throw ImportExceptionUtil.buildDataImportException(this.importContext, (Throwable)esVoidResponseHandler.getElasticSearchException());
                    }
                    return null;
                }
                for (ClientInterface clientInterface : this.clientInterfaces) {
                    data = clientInterface.executeHttp(actionUrl, this.datas, "post");
                }
            }
        } else {
            this.logNodatas(logger);
        }
        this.finishTask();
        return data;
    }

    @Override
    public int getTryCount() {
        return this.tryCount;
    }
}

