/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.http;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.frameworkset.elasticsearch.template.BaseTemplateContainerImpl;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.plugin.http.BaseHttpConfig;
import org.frameworkset.tran.plugin.http.DynamicHeader;
import org.frameworkset.tran.plugin.http.DynamicHeaderContext;
import org.frameworkset.tran.plugin.http.HttpConfigClientProxy;

public class HttpProxyHelper {
    private static Map<String, HttpConfigClientProxy> configDSLUtils = new ConcurrentHashMap<String, HttpConfigClientProxy>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpConfigClientProxy getHttpConfigClientProxy(String configDSLFile) {
        HttpConfigClientProxy httpConfigClientProxy = configDSLUtils.get(configDSLFile);
        if (httpConfigClientProxy != null) {
            return httpConfigClientProxy;
        }
        Map<String, HttpConfigClientProxy> map = configDSLUtils;
        synchronized (map) {
            httpConfigClientProxy = configDSLUtils.get(configDSLFile);
            if (httpConfigClientProxy != null) {
                return httpConfigClientProxy;
            }
            httpConfigClientProxy = new HttpConfigClientProxy(configDSLFile);
            configDSLUtils.put(configDSLFile, httpConfigClientProxy);
        }
        return httpConfigClientProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpConfigClientProxy getHttpConfigClientProxy(BaseTemplateContainerImpl templateContainer) {
        String namespace = templateContainer.getNamespace();
        HttpConfigClientProxy httpConfigClientProxy = configDSLUtils.get(namespace);
        if (httpConfigClientProxy != null) {
            return httpConfigClientProxy;
        }
        Map<String, HttpConfigClientProxy> map = configDSLUtils;
        synchronized (map) {
            httpConfigClientProxy = configDSLUtils.get(namespace);
            if (httpConfigClientProxy != null) {
                return httpConfigClientProxy;
            }
            httpConfigClientProxy = new HttpConfigClientProxy(templateContainer);
            configDSLUtils.put(namespace, httpConfigClientProxy);
        }
        return httpConfigClientProxy;
    }

    public static Map<String, String> getHttpHeaders(BaseHttpConfig basicHttpConfig, DynamicHeaderContext dynamicHeaderContext) throws DataImportException {
        Map<String, String> httpHeaders = basicHttpConfig.getHttpHeaders();
        Map<String, DynamicHeader> dynamicHeaders = basicHttpConfig.getDynamicHeaders();
        if (dynamicHeaders == null || dynamicHeaders.size() == 0) {
            return httpHeaders;
        }
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        if (httpHeaders != null && httpHeaders.size() > 0) {
            ret.putAll(httpHeaders);
        }
        for (Map.Entry<String, DynamicHeader> entry : dynamicHeaders.entrySet()) {
            String value = null;
            try {
                value = entry.getValue().getValue(entry.getKey(), dynamicHeaderContext);
            }
            catch (DataImportException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DataImportException("get value of " + entry.getKey() + " failed:", e);
            }
            if (value == null) continue;
            ret.put(entry.getKey(), value);
        }
        return ret;
    }
}

