/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.http.input;

import com.frameworkset.util.SimpleStringUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.config.ImportBuilder;
import org.frameworkset.tran.config.InputConfig;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.InputPlugin;
import org.frameworkset.tran.plugin.http.BaseHttpConfig;
import org.frameworkset.tran.plugin.http.DynamicHeader;
import org.frameworkset.tran.plugin.http.input.HttpInputDataTranPlugin;
import org.frameworkset.tran.plugin.http.input.HttpResultParser;

public class HttpInputConfig
extends BaseHttpConfig
implements InputConfig {
    private Map<String, Object> httpConfigs;
    private String sourceHttpPool;
    private String queryDslName;
    private String queryDsl;
    private String queryUrl;
    protected int queryThread = 5;
    protected int queryThreadQueue = 10;
    protected int queryResultQueue = 10;
    private int pageSize;
    public static final String defaultPagineFromKey = "httpPagineFrom";
    public static final String defaultPagineSizeKey = "httpPagineSize";
    public String pagineFromKey = "httpPagineFrom";
    public String pagineSizeKey = "httpPagineSize";
    private HttpResultParser httpResultParser;
    protected boolean dslSetted = true;
    private boolean pagine;

    public boolean isPagine() {
        return this.pagine;
    }

    public boolean isDslSetted() {
        return this.dslSetted;
    }

    public HttpInputConfig addDynamicHeader(String header, DynamicHeader dynamicHeader) {
        this._addDynamicHeader(header, dynamicHeader);
        return this;
    }

    public HttpResultParser getHttpResultParser() {
        return this.httpResultParser;
    }

    public HttpInputConfig setHttpResultParser(HttpResultParser httpResultParser) {
        this.httpResultParser = httpResultParser;
        return this;
    }

    public HttpInputConfig setPagine(boolean pagine) {
        this.pagine = pagine;
        return this;
    }

    public Map<String, Object> getHttpConfigs() {
        return this.httpConfigs;
    }

    private void checkConfigs() {
        if (this.httpConfigs == null) {
            this.httpConfigs = new LinkedHashMap<String, Object>();
        }
    }

    public HttpInputConfig addSourceHttpPoolName(String nameProperty, String httpPoolName) {
        this.checkConfigs();
        this.httpConfigs.put(nameProperty, httpPoolName);
        this.sourceHttpPool = httpPoolName;
        return this;
    }

    public HttpInputConfig addHttpInputConfig(String property, Object value) {
        this.checkConfigs();
        this.httpConfigs.put(property, value);
        return this;
    }

    public String getQueryDsl() {
        return this.queryDsl;
    }

    public HttpInputConfig setQueryDsl(String queryDsl) {
        this.queryDsl = queryDsl;
        return this;
    }

    public String getSourceHttpPool() {
        return this.sourceHttpPool;
    }

    public HttpInputConfig setSourceHttpPool(String sourceHttpPool) {
        this.sourceHttpPool = sourceHttpPool;
        return this;
    }

    public String getQueryDslName() {
        return this.queryDslName;
    }

    public HttpInputConfig setQueryDslName(String queryDslName) {
        this.queryDslName = queryDslName;
        return this;
    }

    public HttpInputConfig setPagineFromKey(String pagineFromKey) {
        this.pagineFromKey = pagineFromKey;
        return this;
    }

    public HttpInputConfig setPagineSizeKey(String pagineSizeKey) {
        this.pagineSizeKey = pagineSizeKey;
        return this;
    }

    public String getPagineFromKey() {
        return this.pagineFromKey;
    }

    public String getPagineSizeKey() {
        return this.pagineSizeKey;
    }

    @Override
    public void build(ImportContext importContext, ImportBuilder importBuilder) {
        if (SimpleStringUtil.isEmpty((String)this.httpMethod)) {
            this.httpMethod = "post";
        }
        if (this.httpMethod.equals("post")) {
            this.postMethod = true;
        } else if (this.httpMethod.equals("put")) {
            this.putMethod = true;
        } else if (this.httpMethod.equals("get")) {
            this.getMethod = true;
        }
        if (!(this.postMethod || this.putMethod || this.getMethod)) {
            throw new DataImportException("Input httpMethod must be post/put/get.");
        }
        if (SimpleStringUtil.isEmpty((String)this.getQueryDsl())) {
            if (SimpleStringUtil.isEmpty((String)this.getDslFile()) || SimpleStringUtil.isEmpty((String)this.getQueryDslName())) {
                this.dslSetted = false;
            }
        } else {
            if (SimpleStringUtil.isEmpty((String)this.queryDslName)) {
                this.queryDslName = "datatranQueryDslName";
            }
            if (SimpleStringUtil.isEmpty((String)this.dslNamespace)) {
                this.dslNamespace = "datatranQueryDslNamespace" + SimpleStringUtil.getUUID();
            }
        }
        if (SimpleStringUtil.isEmpty((String)this.pagineFromKey)) {
            this.pagineFromKey = defaultPagineFromKey;
        }
        if (SimpleStringUtil.isEmpty((String)this.pagineSizeKey)) {
            this.pagineSizeKey = defaultPagineSizeKey;
        }
        if (SimpleStringUtil.isEmpty((String)this.getQueryUrl())) {
            throw new DataImportException("Input http query url is not setted.");
        }
        this.pageSize = importBuilder.getFetchSize() > 0 ? importBuilder.getFetchSize() : 5000;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public InputPlugin getInputPlugin(ImportContext importContext) {
        return new HttpInputDataTranPlugin(importContext);
    }

    public String getQueryUrl() {
        return this.queryUrl;
    }

    public HttpInputConfig setQueryUrl(String queryUrl) {
        this.queryUrl = queryUrl;
        return this;
    }

    public HttpInputConfig setShowDsl(boolean showDsl) {
        this.showDsl = showDsl;
        return this;
    }

    public HttpInputConfig setDslFile(String dslFile) {
        this.dslFile = dslFile;
        return this;
    }

    public HttpInputConfig setDslNamespace(String dslNamespace) {
        this.dslNamespace = dslNamespace;
        return this;
    }

    public HttpInputConfig setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public HttpInputConfig addHttpHeaders(Map<String, String> _httpHeaders) {
        this._addHttpHeaders(_httpHeaders);
        return this;
    }

    public HttpInputConfig addHttpHeader(String header, String value) {
        this._addHttpHeader(header, value);
        return this;
    }

    public int getQueryThread() {
        return this.queryThread;
    }

    public HttpInputConfig setQueryThread(int queryThread) {
        this.queryThread = queryThread;
        return this;
    }

    public int getQueryThreadQueue() {
        return this.queryThreadQueue;
    }

    public HttpInputConfig setQueryThreadQueue(int queryThreadQueue) {
        this.queryThreadQueue = queryThreadQueue;
        return this;
    }

    public int getQueryResultQueue() {
        return this.queryResultQueue;
    }

    public HttpInputConfig setQueryResultQueue(int queryResultQueue) {
        this.queryResultQueue = queryResultQueue;
        return this;
    }
}

