/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.http.input;

import com.frameworkset.util.SimpleStringUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.frameworkset.elasticsearch.template.BaseTemplateContainerImpl;
import org.frameworkset.elasticsearch.template.BaseTemplateMeta;
import org.frameworkset.elasticsearch.template.DSLParserException;
import org.frameworkset.elasticsearch.template.TemplateMeta;
import org.frameworkset.spi.remote.http.HttpRequestProxy;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.exception.ImportExceptionUtil;
import org.frameworkset.tran.plugin.BasePlugin;
import org.frameworkset.tran.plugin.InputPlugin;
import org.frameworkset.tran.plugin.http.DynamicHeaderContext;
import org.frameworkset.tran.plugin.http.HttpConfigClientProxy;
import org.frameworkset.tran.plugin.http.HttpProxyHelper;
import org.frameworkset.tran.plugin.http.HttpResult;
import org.frameworkset.tran.plugin.http.input.HttpInputConfig;
import org.frameworkset.tran.plugin.http.input.HttpResultParserContext;
import org.frameworkset.tran.plugin.http.input.HttpTranResultset;
import org.frameworkset.tran.plugin.http.input.ParrelHttpTranResultset;
import org.frameworkset.tran.plugin.http.input.QueryAction;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.util.ResourceStartResult;
import org.frameworkset.util.concurrent.ThreadPoolFactory;

public class HttpInputDataTranPlugin
extends BasePlugin
implements InputPlugin {
    protected String jobType;
    private HttpInputConfig httpInputConfig;
    private ResourceStartResult resourceStartResult;
    private HttpConfigClientProxy httpConfigClientProxy;
    private ExecutorService blockedExecutor;

    public HttpInputDataTranPlugin(ImportContext importContext) {
        super(importContext);
        this.httpInputConfig = (HttpInputConfig)importContext.getInputConfig();
        this.jobType = "HttpInputDataTranPlugin";
    }

    @Override
    public String getJobType() {
        return this.jobType;
    }

    public HttpInputConfig getHttpInputConfig() {
        return this.httpInputConfig;
    }

    @Override
    public void initStatusTableId() {
        if (this.dataTranPlugin.isIncreamentImport()) {
            if (SimpleStringUtil.isNotEmpty((String)this.httpInputConfig.getQueryDsl())) {
                this.importContext.setStatusTableId((this.httpInputConfig.getQueryDsl() + "$$" + this.httpInputConfig.getQueryUrl()).hashCode());
            } else {
                this.importContext.setStatusTableId((this.httpInputConfig.getDslFile() + "$$" + this.httpInputConfig.getQueryDslName() + "$$" + this.httpInputConfig.getQueryUrl()).hashCode());
            }
        }
    }

    @Override
    public void doImportData(TaskContext taskContext) throws DataImportException {
        try {
            if (!this.importContext.isIncreamentImport()) {
                this.commonImportData(taskContext);
            } else {
                this.increamentImportData(taskContext);
            }
        }
        catch (DataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw ImportExceptionUtil.buildDataImportException(this.importContext, e);
        }
    }

    private void exportData(Map params, TaskContext taskContext) {
        QueryAction queryAction = this.buildQueryAction(params, taskContext);
        this.doTran(queryAction, taskContext);
    }

    private QueryAction buildQueryAction(final Map params, final TaskContext taskContext) {
        QueryAction queryAction = new QueryAction(){
            private int from;
            private boolean hasMore;

            @Override
            public HttpResult<Map> execute() {
                if (HttpInputDataTranPlugin.this.httpInputConfig.isPagine()) {
                    params.put(HttpInputDataTranPlugin.this.httpInputConfig.getPagineFromKey(), this.from);
                    int pageSize = HttpInputDataTranPlugin.this.httpInputConfig.getPageSize();
                    params.put(HttpInputDataTranPlugin.this.httpInputConfig.getPagineSizeKey(), pageSize);
                }
                HttpResult<Map> httpResult = null;
                HttpResultParserContext httpResultParserContext = null;
                if (HttpInputDataTranPlugin.this.httpInputConfig.getHttpResultParser() != null) {
                    httpResultParserContext = new HttpResultParserContext();
                    httpResultParserContext.setImportContext(HttpInputDataTranPlugin.this.importContext);
                    httpResultParserContext.setTaskContext(taskContext);
                }
                DynamicHeaderContext dynamicHeaderContext = null;
                if (HttpInputDataTranPlugin.this.httpInputConfig.getDynamicHeaders() != null) {
                    dynamicHeaderContext = new DynamicHeaderContext();
                    dynamicHeaderContext.setTaskContext(taskContext);
                    dynamicHeaderContext.setImportContext(HttpInputDataTranPlugin.this.importContext);
                }
                if (HttpInputDataTranPlugin.this.httpInputConfig.isPostMethod()) {
                    httpResult = HttpInputDataTranPlugin.this.httpInputConfig.isDslSetted() ? HttpInputDataTranPlugin.this.httpConfigClientProxy.sendBodyForList(HttpInputDataTranPlugin.this, httpResultParserContext, dynamicHeaderContext, params, Map.class) : HttpInputDataTranPlugin.this.httpConfigClientProxy.postForList(HttpInputDataTranPlugin.this, httpResultParserContext, dynamicHeaderContext, params, Map.class);
                } else if (HttpInputDataTranPlugin.this.httpInputConfig.isPutMethod()) {
                    httpResult = HttpInputDataTranPlugin.this.httpInputConfig.isDslSetted() ? HttpInputDataTranPlugin.this.httpConfigClientProxy.putBodyForList(HttpInputDataTranPlugin.this, httpResultParserContext, dynamicHeaderContext, params, Map.class) : HttpInputDataTranPlugin.this.httpConfigClientProxy.putForList(HttpInputDataTranPlugin.this, httpResultParserContext, dynamicHeaderContext, params, Map.class);
                } else if (HttpInputDataTranPlugin.this.httpInputConfig.isGetMethod()) {
                    httpResult = HttpInputDataTranPlugin.this.httpConfigClientProxy.httpGetforList(HttpInputDataTranPlugin.this, httpResultParserContext, dynamicHeaderContext, params, Map.class);
                }
                if (HttpInputDataTranPlugin.this.httpInputConfig.isPagine()) {
                    if (httpResult.size() == HttpInputDataTranPlugin.this.httpInputConfig.getPageSize()) {
                        this.hasMore = true;
                        this.from += HttpInputDataTranPlugin.this.httpInputConfig.getPageSize();
                    } else {
                        this.hasMore = false;
                    }
                }
                if (httpResult != null) {
                    httpResult.setQueryAction(this);
                }
                return httpResult;
            }

            @Override
            public boolean hasMore() {
                return this.hasMore;
            }
        };
        return queryAction;
    }

    private void parrelExportData(List<Map> paramGroups, TaskContext taskContext) {
        ArrayList<QueryAction> queryActions = new ArrayList<QueryAction>(paramGroups.size());
        for (Map params : paramGroups) {
            QueryAction queryAction = this.buildQueryAction(params, taskContext);
            queryActions.add(queryAction);
        }
        this.doParrelTran(queryActions, taskContext);
    }

    private void commonImportData(TaskContext taskContext) throws Exception {
        if (!this.dataTranPlugin.hasJobInputParamGroups()) {
            Map params = this.dataTranPlugin.getJobInputParams(taskContext);
            this.exportData(params, taskContext);
        } else {
            List<Map> paramGroups = this.dataTranPlugin.getJobInputParamGroups(taskContext);
            this.parrelExportData(paramGroups, taskContext);
        }
    }

    protected void doParrelTran(List<QueryAction> queryActions, TaskContext taskContext) {
        ParrelHttpTranResultset httpTranResultset = new ParrelHttpTranResultset(queryActions, this.importContext, this.blockedExecutor);
        httpTranResultset.init();
        BaseDataTran httpDataTran = this.dataTranPlugin.createBaseDataTran(taskContext, httpTranResultset, null, this.dataTranPlugin.getCurrentStatus());
        httpDataTran.initTran();
        this.dataTranPlugin.callTran(httpDataTran);
    }

    protected void doTran(QueryAction queryAction, TaskContext taskContext) {
        HttpTranResultset httpTranResultset = new HttpTranResultset(queryAction, this.importContext);
        httpTranResultset.init();
        BaseDataTran httpDataTran = this.dataTranPlugin.createBaseDataTran(taskContext, httpTranResultset, null, this.dataTranPlugin.getCurrentStatus());
        httpDataTran.initTran();
        this.dataTranPlugin.callTran(httpDataTran);
    }

    private void increamentImportData(TaskContext taskContext) throws Exception {
        if (!this.dataTranPlugin.hasJobInputParamGroups()) {
            Map params = this.dataTranPlugin.getJobInputParams(taskContext);
            params = this.dataTranPlugin.getParamValue(params);
            this.exportData(params, taskContext);
        } else {
            List<Map> paramGroups = this.dataTranPlugin.getJobInputParamGroups(taskContext);
            for (Map params : paramGroups) {
                this.dataTranPlugin.getParamValue(params);
            }
            this.parrelExportData(paramGroups, taskContext);
        }
    }

    @Override
    public void afterInit() {
        this.httpConfigClientProxy = SimpleStringUtil.isNotEmpty((String)this.httpInputConfig.getQueryDsl()) ? HttpProxyHelper.getHttpConfigClientProxy(new BaseTemplateContainerImpl(this.httpInputConfig.getDslNamespace()){

            protected Map<String, TemplateMeta> loadTemplateMetas(String namespace) {
                try {
                    BaseTemplateMeta baseTemplateMeta = new BaseTemplateMeta();
                    baseTemplateMeta.setName(HttpInputDataTranPlugin.this.httpInputConfig.getQueryDslName());
                    baseTemplateMeta.setNamespace(namespace);
                    baseTemplateMeta.setDslTemplate(HttpInputDataTranPlugin.this.httpInputConfig.getQueryDsl());
                    baseTemplateMeta.setMultiparser(Boolean.valueOf(true));
                    LinkedHashMap<String, TemplateMeta> templateMetaMap = new LinkedHashMap<String, TemplateMeta>();
                    templateMetaMap.put(baseTemplateMeta.getName(), (TemplateMeta)baseTemplateMeta);
                    return templateMetaMap;
                }
                catch (Exception e) {
                    throw new DSLParserException((Throwable)e);
                }
            }

            protected long getLastModifyTime(String namespace) {
                return -1L;
            }
        }) : HttpProxyHelper.getHttpConfigClientProxy(this.httpInputConfig.getDslFile());
        if (this.dataTranPlugin.hasJobInputParamGroups()) {
            this.blockedExecutor = ThreadPoolFactory.buildThreadPool((String)"HttpInputQueryThread", (String)"HttpInputQueryThread", (int)this.httpInputConfig.getQueryThread(), (int)this.httpInputConfig.getQueryThreadQueue(), (long)-1L, (int)1000);
        }
    }

    @Override
    public void beforeInit() {
    }

    @Override
    public void init() {
        if (this.httpInputConfig != null && this.httpInputConfig.getHttpConfigs() != null) {
            this.resourceStartResult = HttpRequestProxy.startHttpPools(this.httpInputConfig.getHttpConfigs());
        }
    }

    @Override
    public void destroy(boolean waitTranStop) {
        if (this.resourceStartResult != null) {
            HttpRequestProxy.stopHttpClients((ResourceStartResult)this.resourceStartResult);
        }
        if (this.blockedExecutor != null) {
            ThreadPoolFactory.shutdownExecutor((ExecutorService)this.blockedExecutor);
        }
    }
}

