/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.http.input;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.DefaultTranMetaData;
import org.frameworkset.tran.LastValue;
import org.frameworkset.tran.TranMeta;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.http.HttpResult;
import org.frameworkset.tran.plugin.http.input.HttpInputConfig;
import org.frameworkset.tran.plugin.http.input.HttpRecord;
import org.frameworkset.tran.plugin.http.input.QueryAction;
import org.frameworkset.tran.record.NextAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParrelHttpTranResultset
extends LastValue
implements TranResultSet {
    private static Logger logger = LoggerFactory.getLogger(ParrelHttpTranResultset.class);
    private BlockingQueue<HttpResult<Map>> httpResults;
    private HttpResult<Map> currentResult;
    private Map current;
    private Iterator<Map> iterator;
    private HttpInputConfig httpInputConfig;
    private ExecutorService blockedExecutor;
    private List<QueryAction> queryActions;
    private int tasks;
    private int completedQueryActions;
    private Object queryLock = new Object();
    private DataTranPlugin dataTranPlugin;

    public ParrelHttpTranResultset(List<QueryAction> queryActions, ImportContext importContext, ExecutorService blockedExecutor) {
        this.importContext = importContext;
        this.httpInputConfig = (HttpInputConfig)importContext.getInputConfig();
        this.queryActions = queryActions;
        this.tasks = queryActions.size();
        this.blockedExecutor = blockedExecutor;
        this.dataTranPlugin = importContext.getDataTranPlugin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeQueryAction() {
        Object object = this.queryLock;
        synchronized (object) {
            ++this.completedQueryActions;
        }
    }

    private void addResult(HttpResult<Map> httpResult) {
        this.httpResults.add(httpResult);
    }

    private void doQueryAction(final QueryAction queryAction) {
        this.blockedExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    HttpResult<Map> httpResult = queryAction.execute();
                    List<Map> datas = httpResult.getDatas();
                    if (datas != null && datas.size() > 0) {
                        try {
                            ParrelHttpTranResultset.this.httpResults.put(httpResult);
                        }
                        catch (InterruptedException e) {
                            ParrelHttpTranResultset.this.completeQueryAction();
                        }
                    } else {
                        ParrelHttpTranResultset.this.completeQueryAction();
                    }
                }
                catch (Throwable e) {
                    ParrelHttpTranResultset.this.completeQueryAction();
                    ParrelHttpTranResultset.this.dataTranPlugin.throwException(ParrelHttpTranResultset.this.getTaskContext(), e);
                }
            }
        });
    }

    private void parrelExecute() {
        for (QueryAction queryAction : this.queryActions) {
            this.doQueryAction(queryAction);
        }
    }

    public void init() {
        this.httpResults = new ArrayBlockingQueue<HttpResult<Map>>(this.httpInputConfig.getQueryResultQueue());
        this.parrelExecute();
    }

    @Override
    public Object getValue(int i, String colName, int sqlType) throws DataImportException {
        return this.getValue(colName);
    }

    @Override
    public Object getValue(String colName, int sqlType) throws DataImportException {
        return this.getValue(colName);
    }

    @Override
    public Date getDateTimeValue(String colName) throws DataImportException {
        return this.record.getDateTimeValue(colName);
    }

    @Override
    public NextAssert next() throws DataImportException {
        NextAssert nextAssert = new NextAssert();
        boolean hasNext = false;
        while (true) {
            if (this.isStop() || this.importContext.getInputPlugin().isStopCollectData()) {
                hasNext = false;
                break;
            }
            if (this.currentResult == null) {
                if (this.completedQueryActions < this.tasks) {
                    try {
                        this.currentResult = this.httpResults.poll(5000L, TimeUnit.MILLISECONDS);
                        if (this.currentResult == null) continue;
                        List<Map> datas = this.currentResult.getDatas();
                        this.iterator = datas.iterator();
                        this.current = this.iterator.next();
                        this.record = new HttpRecord(this.currentResult, this.current, this.getTaskContext(), this.importContext);
                        this.record.setTranMeta(this.getMetaData());
                        hasNext = true;
                    }
                    catch (InterruptedException e) {
                        hasNext = false;
                    }
                    break;
                }
                hasNext = false;
                break;
            }
            hasNext = this.iterator.hasNext();
            if (hasNext) {
                this.current = this.iterator.next();
                this.record = new HttpRecord(this.currentResult, this.current, this.getTaskContext(), this.importContext);
                this.record.setTranMeta(this.getMetaData());
                break;
            }
            if (this.currentResult.hasMore()) {
                if (this.isStop()) {
                    return nextAssert;
                }
                this.doQueryAction(this.currentResult.getQueryAction());
                this.currentResult = null;
                this.iterator = null;
                continue;
            }
            this.currentResult = null;
            this.iterator = null;
            this.completeQueryAction();
        }
        nextAssert.setHasNext(hasNext);
        return nextAssert;
    }

    @Override
    public TranMeta getMetaData() {
        return new DefaultTranMetaData(() -> DefaultTranMetaData.convert(this.current.keySet()));
    }

    @Override
    public Object getKeys() {
        if (this.record == null) {
            return null;
        }
        return this.record.getKeys();
    }

    @Override
    public Object getRecord() {
        return this.current;
    }

    @Override
    public Object getMetaValue(String fieldName) {
        return this.getValue(fieldName);
    }
}

