/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.http.output;

import java.io.Writer;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.spi.remote.http.HttpRequestProxy;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.config.DynamicParam;
import org.frameworkset.tran.config.DynamicParamContext;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.exception.ImportExceptionUtil;
import org.frameworkset.tran.plugin.http.DynamicHeaderContext;
import org.frameworkset.tran.plugin.http.HttpConfigClientProxy;
import org.frameworkset.tran.plugin.http.HttpProxyHelper;
import org.frameworkset.tran.plugin.http.output.HttpOutputConfig;
import org.frameworkset.tran.plugin.http.output.HttpOutputDataTranPlugin;
import org.frameworkset.tran.task.BaseTaskCommand;
import org.frameworkset.tran.task.TaskCommand;
import org.frameworkset.tran.task.TaskCommandContext;
import org.frameworkset.tran.task.TaskFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTaskCommandImpl
extends BaseTaskCommand<String> {
    private HttpOutputConfig httpOutputConfig;
    private int tryCount;
    private static Logger logger = LoggerFactory.getLogger(TaskCommand.class);
    private String datas;

    public HttpTaskCommandImpl(TaskCommandContext taskCommandContext, OutputConfig outputConfig) {
        super(outputConfig, taskCommandContext);
        this.httpOutputConfig = (HttpOutputConfig)outputConfig;
    }

    private String buildDatas() throws Exception {
        StringBuilder builder = new StringBuilder();
        BBossStringWriter bBossStringWriter = new BBossStringWriter(builder);
        CommonRecord record = null;
        for (int i = 0; i < this.records.size(); ++i) {
            record = (CommonRecord)this.records.get(i);
            if (i == 0) {
                if (this.httpOutputConfig.isJson()) {
                    bBossStringWriter.write("[");
                }
                this.httpOutputConfig.generateReocord(this.taskContext, this.taskMetrics, record, (Writer)bBossStringWriter);
                continue;
            }
            bBossStringWriter.write(this.httpOutputConfig.getLineSeparator());
            this.httpOutputConfig.generateReocord(this.taskContext, this.taskMetrics, record, (Writer)bBossStringWriter);
        }
        if (this.httpOutputConfig.isJson()) {
            bBossStringWriter.write("]");
        }
        return bBossStringWriter.toString();
    }

    @Override
    public Object getDatas() {
        return this.datas;
    }

    @Override
    public String execute() throws Exception {
        String data = null;
        if (this.records.size() > 0) {
            if (this.importContext.getMaxRetry() > 0 && this.tryCount >= this.importContext.getMaxRetry()) {
                throw new TaskFailedException("task execute failed:reached max retry times " + this.importContext.getMaxRetry());
            }
            ++this.tryCount;
            if (this.datas == null) {
                this.datas = this.buildDatas();
            }
            try {
                if (this.httpOutputConfig.isDirectSendData()) {
                    data = this.directSendData();
                }
                data = this.unDirectSendData();
            }
            catch (Exception e) {
                throw ImportExceptionUtil.buildDataImportException(this.outputPlugin, this.importContext, "\u53d1\u9001\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
        } else {
            this.logNodatas(logger);
        }
        this.finishTask();
        return data;
    }

    private String directSendData() {
        String data = null;
        HttpOutputDataTranPlugin httpOutputDataTranPlugin = (HttpOutputDataTranPlugin)this.outputPlugin;
        DynamicHeaderContext dynamicHeaderContext = null;
        if (this.httpOutputConfig.getDynamicHeaders() != null) {
            dynamicHeaderContext = new DynamicHeaderContext();
            dynamicHeaderContext.setDatas(this.datas);
            dynamicHeaderContext.setTaskContext(this.taskContext);
            dynamicHeaderContext.setTaskMetrics(this.taskMetrics);
            dynamicHeaderContext.setImportContext(httpOutputDataTranPlugin.getImportContext());
        }
        data = this.httpOutputConfig.isPostMethod() ? HttpRequestProxy.sendBody((String)this.httpOutputConfig.getTargetHttpPool(), (String)this.datas, (String)this.httpOutputConfig.getServiceUrl(), HttpProxyHelper.getHttpHeaders(this.httpOutputConfig, dynamicHeaderContext), (ContentType)ContentType.APPLICATION_JSON) : HttpRequestProxy.putJson((String)this.httpOutputConfig.getTargetHttpPool(), (String)this.datas, (String)this.httpOutputConfig.getServiceUrl(), HttpProxyHelper.getHttpHeaders(this.httpOutputConfig, dynamicHeaderContext));
        return data;
    }

    private String unDirectSendData() {
        String data = null;
        HttpOutputDataTranPlugin httpOutputDataTranPlugin = (HttpOutputDataTranPlugin)this.outputPlugin;
        HttpConfigClientProxy httpConfigClientProxy = httpOutputDataTranPlugin.getHttpConfigClientProxy();
        DynamicHeaderContext dynamicHeaderContext = null;
        if (this.httpOutputConfig.getDynamicHeaders() != null) {
            dynamicHeaderContext = new DynamicHeaderContext();
            dynamicHeaderContext.setDatas(this.datas);
            dynamicHeaderContext.setTaskContext(this.taskContext);
            dynamicHeaderContext.setTaskMetrics(this.taskMetrics);
            dynamicHeaderContext.setImportContext(httpOutputDataTranPlugin.getImportContext());
        }
        Map<String, DynamicParam> dynamicParams = this.importContext.getJobDynamicOutputParams();
        DynamicParamContext dynamicParamContext = null;
        if (dynamicParams != null && dynamicParams.size() > 0) {
            dynamicParamContext = new DynamicParamContext();
            dynamicParamContext.setImportContext(this.importContext);
            dynamicParamContext.setTaskContext(this.taskContext);
            dynamicParamContext.setDatas(this.datas);
        }
        Map params = this.importContext.getDataTranPlugin().getJobOutputParams(dynamicParamContext);
        params.put(this.httpOutputConfig.getDataKey(), this.datas);
        data = this.httpOutputConfig.isPostMethod() ? httpConfigClientProxy.sendBody(httpOutputDataTranPlugin, dynamicHeaderContext, params) : httpConfigClientProxy.putJson(httpOutputDataTranPlugin, dynamicHeaderContext, params);
        return data;
    }

    @Override
    public int getTryCount() {
        return this.tryCount;
    }
}

