/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.metrics.output;

import com.frameworkset.util.SimpleStringUtil;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.metrics.TaskMetrics;
import org.frameworkset.tran.metrics.job.Metrics;
import org.frameworkset.tran.metrics.job.MetricsLogAPI;
import org.frameworkset.tran.plugin.metrics.output.BuildMapData;
import org.frameworkset.tran.plugin.metrics.output.ETLMapData;
import org.frameworkset.tran.plugin.metrics.output.MetricsData;
import org.frameworkset.tran.plugin.metrics.output.SimpleBuildMapData;
import org.frameworkset.tran.schedule.TaskContext;

public abstract class ETLMetrics
extends Metrics {
    protected ImportContext importContext;
    private String dataTimeField;
    private SimpleBuildMapData buildMapData;

    public ETLMetrics() {
    }

    protected MetricsLogAPI buildMetricsLogAPI() {
        return new MetricsLogAPI<TaskContext, TaskMetrics>(){

            public void reportJobMetricErrorLog(TaskContext logcontext, String msg, Throwable e) {
                ETLMetrics.this.importContext.reportJobMetricErrorLog(logcontext, msg, e);
            }

            public void reportJobMetricErrorLog(String msg, Throwable e) {
                ETLMetrics.this.importContext.reportJobMetricErrorLog(msg, e);
            }

            public void reportJobMetricLog(String msg) {
                ETLMetrics.this.importContext.reportJobMetricLog(msg);
            }

            public void reportJobMetricWarn(String msg) {
                ETLMetrics.this.importContext.reportJobMetricWarn(msg);
            }

            public void reportJobMetricDebug(String msg) {
                ETLMetrics.this.importContext.reportJobMetricDebug(msg);
            }

            public void reportJobMetricLog(TaskContext logcontext, String msg) {
                ETLMetrics.this.importContext.reportJobMetricLog(logcontext, msg);
            }

            public void reportJobMetricWarn(TaskContext logcontext, String msg) {
                ETLMetrics.this.importContext.reportJobMetricWarn(logcontext, msg);
            }

            public void reportJobMetricDebug(TaskContext logcontext, String msg) {
                ETLMetrics.this.importContext.reportJobMetricDebug(logcontext, msg);
            }

            public void reportTaskMetricErrorLog(TaskMetrics logcontext, String msg, Throwable e) {
                ETLMetrics.this.importContext.reportTaskMetricErrorLog(logcontext, msg, e);
            }

            public void reportTaskMetricLog(TaskMetrics logcontext, String msg) {
                ETLMetrics.this.importContext.reportTaskMetricLog(logcontext, msg);
            }

            public void reportTaskMetricWarn(TaskMetrics logcontext, String msg) {
                if (logcontext != null && logcontext instanceof TaskMetrics) {
                    ETLMetrics.this.importContext.reportTaskMetricWarn(logcontext, msg);
                }
            }

            public void reportTaskMetricDebug(TaskMetrics logcontext, String msg) {
                if (logcontext != null && logcontext instanceof TaskMetrics) {
                    ETLMetrics.this.importContext.reportTaskMetricDebug(logcontext, msg);
                }
            }
        };
    }

    public ETLMetrics(int metricsType) {
        super(metricsType);
    }

    public ETLMetrics setBuildMapData(SimpleBuildMapData buildMapData) {
        this.buildMapData = buildMapData;
        return this;
    }

    public SimpleBuildMapData getBuildMapData() {
        return this.buildMapData;
    }

    public ETLMapData buildMapData(MetricsData metricsData) {
        ETLMapData etlMapData = null;
        if (this.buildMapData != null) {
            if (this.buildMapData instanceof BuildMapData) {
                etlMapData = this.buildMapData.buildMapData(metricsData);
            } else {
                etlMapData = this.buildMapData.buildMapData(metricsData);
                metricsData.setData(etlMapData, this);
            }
        } else {
            etlMapData = new ETLMapData();
            metricsData.setData(etlMapData, this);
        }
        etlMapData.setTaskMetrics(metricsData.getTaskMetrics());
        return etlMapData;
    }

    public String getDataTimeField(MetricsData metricsData) {
        if (SimpleStringUtil.isNotEmpty((String)this.dataTimeField)) {
            return this.dataTimeField;
        }
        return metricsData.getBuildMapDataContext().getDataTimeField();
    }

    public String getDataTimeField() {
        return this.dataTimeField;
    }

    public void setDataTimeField(String dataTimeField) {
        this.dataTimeField = dataTimeField;
    }

    public ImportContext getImportContext() {
        return this.importContext;
    }

    public void setImportContext(ImportContext importContext) {
        this.importContext = importContext;
    }
}

