/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.metrics.output;

import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.metrics.job.BuildMapDataContext;
import org.frameworkset.tran.plugin.metrics.output.MetricsOutputConfig;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.BaseTaskCommand;
import org.frameworkset.tran.task.BaseTranJob;
import org.frameworkset.tran.task.TaskCommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsTaskCommandImpl
extends BaseTaskCommand<String> {
    private Logger logger = LoggerFactory.getLogger(MetricsTaskCommandImpl.class);
    private TaskContext taskContext;
    private MetricsOutputConfig metricsOutputConfig;

    public MetricsTaskCommandImpl(TaskCommandContext taskCommandContext, OutputConfig outputConfig) {
        super(outputConfig, taskCommandContext);
        this.metricsOutputConfig = (MetricsOutputConfig)outputConfig;
        if (this.taskContext == null) {
            this.taskContext = new TaskContext(this.importContext);
            taskCommandContext.setTaskContext(this.taskContext);
        }
    }

    @Override
    public String execute() {
        if (this.records.size() > 0) {
            BuildMapDataContext buildMapDataContext = new BuildMapDataContext();
            String dataTimeField = this.metricsOutputConfig.getDataTimeField();
            buildMapDataContext.setDataTimeField(dataTimeField);
            if (this.metricsOutputConfig.getTimeWindowType() != null) {
                buildMapDataContext.setTimeWindowType(this.metricsOutputConfig.getTimeWindowType().intValue());
            }
            for (CommonRecord commonRecord : this.records) {
                BaseTranJob.map(commonRecord, this.taskMetrics, buildMapDataContext, this.metricsOutputConfig.getMetrics(), this.metricsOutputConfig.isUseDefaultMapData());
            }
        } else {
            this.logNodatas(this.logger);
        }
        this.finishTask();
        return null;
    }
}

