/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.multi.output;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.JobCountDownLatch;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.multi.output.MultiOutPutDataTran;
import org.frameworkset.tran.plugin.multi.output.MultiTaskCommandImpl;
import org.frameworkset.tran.plugin.multi.output.OutputRecordsFilter;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.TaskCommand;
import org.frameworkset.tran.task.TaskCommandContext;

public class FilterMultiOutPutDataTran
extends MultiOutPutDataTran {
    protected OutputRecordsFilter outputRecordsFilter;

    public FilterMultiOutPutDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, ImportContext importContext, JobCountDownLatch countDownLatch, Status currentStatus) {
        super(taskContext, jdbcResultSet, importContext, countDownLatch, currentStatus);
        this.outputRecordsFilter = this.multiOutputConfig.getOutputRecordsFilter();
    }

    public FilterMultiOutPutDataTran(BaseDataTran baseDataTran) {
        super(baseDataTran);
    }

    @Override
    public TaskCommand buildTaskCommand(TaskCommandContext taskCommandContext) {
        MultiTaskCommandImpl taskCommand = new MultiTaskCommandImpl(taskCommandContext, (records, executorService) -> {
            ArrayList<Future> tasks = new ArrayList<Future>();
            records = Collections.unmodifiableList(records);
            List<CommonRecord> filterRecords = null;
            for (BaseDataTran baseDataTran : this.baseDataTrans) {
                OutputConfig outputConfig = baseDataTran.getOutputConfig();
                filterRecords = this.outputRecordsFilter.filter(outputConfig, records);
                TaskCommand taskCommand1 = baseDataTran.buildTaskCommand(taskCommandContext);
                taskCommand1.setRecords(filterRecords);
                taskCommandContext.addMultiOutputTask(executorService, tasks, taskCommand1);
            }
            return tasks;
        }, this.outputPlugin.getOutputConfig());
        return taskCommand;
    }
}

