/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.multi.output;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.frameworkset.tran.AbstraCommonRecordOutPutDataTran;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.JobCountDownLatch;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.OutputPlugin;
import org.frameworkset.tran.plugin.multi.output.MultiOutputConfig;
import org.frameworkset.tran.plugin.multi.output.MultiOutputDataTranPlugin;
import org.frameworkset.tran.plugin.multi.output.MultiTaskCommandImpl;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.TaskCommand;
import org.frameworkset.tran.task.TaskCommandContext;
import org.slf4j.Logger;

public class MultiOutPutDataTran
extends AbstraCommonRecordOutPutDataTran {
    protected MultiOutputConfig multiOutputConfig;
    protected String taskInfo;
    protected List<BaseDataTran> baseDataTrans;

    @Override
    public void logTaskStart(Logger logger) {
        logger.info(this.taskInfo + " start.");
    }

    @Override
    public void init() {
        super.init();
        this.taskInfo = "Import data to MultiOutPut";
    }

    public MultiOutPutDataTran(TaskContext taskContext, TranResultSet jdbcResultSet, ImportContext importContext, JobCountDownLatch countDownLatch, Status currentStatus) {
        super(taskContext, jdbcResultSet, importContext, currentStatus);
        this.multiOutputConfig = (MultiOutputConfig)importContext.getOutputConfig();
        this.countDownLatch = countDownLatch;
    }

    public MultiOutPutDataTran(BaseDataTran baseDataTran) {
        super(baseDataTran);
    }

    @Override
    public void initTran() {
        super.initTran();
        MultiOutputDataTranPlugin multiOutputDataTranPlugin = (MultiOutputDataTranPlugin)this.outputPlugin;
        List<OutputPlugin> outputPlugins = multiOutputDataTranPlugin.getOutputPlugins();
        this.baseDataTrans = new ArrayList<BaseDataTran>();
        for (OutputPlugin outputPlugin : outputPlugins) {
            BaseDataTran baseDataTran = outputPlugin.createBaseDataTran(this);
            baseDataTran.setOutputPlugin(outputPlugin);
            baseDataTran.init();
            this.baseDataTrans.add(baseDataTran);
        }
    }

    @Override
    public TaskCommand buildTaskCommand(TaskCommandContext taskCommandContext) {
        MultiTaskCommandImpl taskCommand = new MultiTaskCommandImpl(taskCommandContext, (records, executorService) -> {
            ArrayList<Future> tasks = new ArrayList<Future>();
            for (BaseDataTran baseDataTran : this.baseDataTrans) {
                TaskCommand taskCommand1 = baseDataTran.buildTaskCommand(taskCommandContext);
                taskCommand1.setRecords(records);
                taskCommandContext.addMultiOutputTask(executorService, tasks, taskCommand1);
            }
            return tasks;
        }, this.outputPlugin.getOutputConfig());
        return taskCommand;
    }

    @Override
    public void stop(boolean fromException) {
        for (BaseDataTran baseDataTran : this.baseDataTrans) {
            baseDataTran.stop(fromException);
        }
        super.stop(fromException);
    }

    @Override
    public void stop2ndClearResultsetQueue(boolean fromException) {
        for (BaseDataTran baseDataTran : this.baseDataTrans) {
            baseDataTran.stop2ndClearResultsetQueue(fromException);
        }
        super.stop2ndClearResultsetQueue(fromException);
    }
}

