/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.multi.output;

import java.util.ArrayList;
import java.util.List;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.ExportResultHandler;
import org.frameworkset.tran.WrapedExportResultHandler;
import org.frameworkset.tran.config.ImportBuilder;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.context.RecordSpecialConfigsContext;
import org.frameworkset.tran.plugin.BaseConfig;
import org.frameworkset.tran.plugin.OutputPlugin;
import org.frameworkset.tran.plugin.metrics.output.ETLMetrics;
import org.frameworkset.tran.plugin.multi.output.MultiOutputDataTranPlugin;
import org.frameworkset.tran.plugin.multi.output.OutputRecordsFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiOutputConfig
extends BaseConfig
implements OutputConfig {
    private static final Logger logger = LoggerFactory.getLogger(MultiOutputConfig.class);
    private List<OutputConfig> outputConfigs;
    private boolean enableMultiExportResultHandler = true;
    private int pluginNo;
    private OutputRecordsFilter outputRecordsFilter;

    public MultiOutputConfig addOutputConfig(OutputConfig outputConfig) {
        if (outputConfig == null) {
            return this;
        }
        if (outputConfig instanceof MultiOutputConfig) {
            throw new DataImportException("MultiOutputConfig can't add to MultiOutputConfig!");
        }
        if (this.outputConfigs == null) {
            this.outputConfigs = new ArrayList<OutputConfig>();
        }
        outputConfig.setPluginNo(String.valueOf(this.pluginNo));
        outputConfig.setMultiOutputTran(true);
        ++this.pluginNo;
        this.outputConfigs.add(outputConfig);
        return this;
    }

    public OutputRecordsFilter getOutputRecordsFilter() {
        return this.outputRecordsFilter;
    }

    public MultiOutputConfig setOutputRecordsFilter(OutputRecordsFilter outputRecordsFilter) {
        this.outputRecordsFilter = outputRecordsFilter;
        return this;
    }

    public List<OutputConfig> getOutputConfigs() {
        return this.outputConfigs;
    }

    public int getOutputConfigSize() {
        return this.outputConfigs != null ? this.outputConfigs.size() : 0;
    }

    @Override
    public void build(ImportContext importContext, ImportBuilder importBuilder) {
        for (OutputConfig outputConfig : this.outputConfigs) {
            outputConfig.build(importContext, importBuilder);
        }
    }

    @Override
    public OutputPlugin getOutputPlugin(ImportContext importContext) {
        MultiOutputDataTranPlugin multiOutputDataTranPlugin = new MultiOutputDataTranPlugin(this, importContext);
        multiOutputDataTranPlugin.initOutputPlugins(importContext);
        return multiOutputDataTranPlugin;
    }

    @Override
    public void initRecordSpecialConfigsContext(RecordSpecialConfigsContext recordSpecialConfigsContext, boolean fromMultiOutput) {
        if (fromMultiOutput) {
            throw new DataImportException("MultiOutputConfig cann't be add to MultiOutputConfig plugin.");
        }
        for (OutputConfig outputConfig : this.outputConfigs) {
            outputConfig.initRecordSpecialConfigsContext(recordSpecialConfigsContext, true);
        }
    }

    public <T extends OutputConfig> T getOutputConfig(Class<T> outputConfigClass) {
        for (OutputConfig outputConfig : this.outputConfigs) {
            if (!outputConfigClass.isInstance(outputConfig)) continue;
            return (T)outputConfig;
        }
        return null;
    }

    public <T extends OutputConfig> List<T> getOutputConfigs(Class<T> outputConfigClass) {
        ArrayList<OutputConfig> ts = new ArrayList<OutputConfig>();
        for (OutputConfig outputConfig : this.outputConfigs) {
            if (!outputConfigClass.isInstance(outputConfig)) continue;
            ts.add(outputConfig);
        }
        return ts;
    }

    @Override
    public List<ETLMetrics> getMetrics() {
        ArrayList<ETLMetrics> ts = new ArrayList<ETLMetrics>();
        for (OutputConfig outputConfig : this.outputConfigs) {
            if (outputConfig.getMetrics() == null || outputConfig.getMetrics().size() <= 0) continue;
            ts.addAll(outputConfig.getMetrics());
        }
        return ts;
    }

    @Override
    public void destroyExportResultHandler() {
        super.destroyExportResultHandler();
        if (this.isEnableMultiExportResultHandler()) {
            for (OutputConfig outputConfig : this.outputConfigs) {
                outputConfig.destroyExportResultHandler();
            }
        }
    }

    public boolean isEnableMultiExportResultHandler() {
        return this.enableMultiExportResultHandler;
    }

    public MultiOutputConfig setEnableMultiExportResultHandler(boolean enableMultiExportResultHandler) {
        this.enableMultiExportResultHandler = enableMultiExportResultHandler;
        return this;
    }

    @Override
    public WrapedExportResultHandler buildExportResultHandler(ExportResultHandler exportResultHandler) {
        this.exportResultHandler = super.buildExportResultHandler(exportResultHandler);
        if (this.isEnableMultiExportResultHandler()) {
            for (OutputConfig outputConfig : this.outputConfigs) {
                outputConfig.buildExportResultHandler(exportResultHandler);
            }
        }
        return this.exportResultHandler;
    }
}

