/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.multi.output;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.JobCountDownLatch;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.context.Context;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.plugin.BasePlugin;
import org.frameworkset.tran.plugin.OutputPlugin;
import org.frameworkset.tran.plugin.multi.output.FilterMultiOutPutDataTran;
import org.frameworkset.tran.plugin.multi.output.MultiOutPutDataTran;
import org.frameworkset.tran.plugin.multi.output.MultiOutputConfig;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.util.concurrent.ThreadPoolFactory;

public class MultiOutputDataTranPlugin
extends BasePlugin
implements OutputPlugin {
    private MultiOutputConfig multiOutputConfig;
    private List<OutputPlugin> outputPlugins;
    private ExecutorService multiOutputExecutor;
    private Object multiOutputExecutorLock = new Object();

    public MultiOutputDataTranPlugin(OutputConfig pluginOutputConfig, ImportContext importContext) {
        super(pluginOutputConfig, importContext);
        this.multiOutputConfig = (MultiOutputConfig)pluginOutputConfig;
    }

    @Override
    public String getJobType() {
        return "MultiOutputDataTranPlugin";
    }

    public List<OutputPlugin> getOutputPlugins() {
        return this.outputPlugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService buildmultiOutputExecutor() {
        if (this.multiOutputExecutor != null) {
            return this.multiOutputExecutor;
        }
        Object object = this.multiOutputExecutorLock;
        synchronized (object) {
            if (this.multiOutputExecutor == null && this.multiOutputConfig.getOutputConfigSize() > 0) {
                this.multiOutputExecutor = ThreadPoolFactory.buildThreadPool((String)"MultiOutputExecutorThread", (String)"MultiOutputExecutorThread", (int)this.multiOutputConfig.getOutputConfigSize(), (int)100, (long)-1L, (int)1000);
            }
        }
        return this.multiOutputExecutor;
    }

    void initOutputPlugins(ImportContext importContext) {
        this.outputPlugins = new ArrayList<OutputPlugin>();
        for (OutputConfig outputConfig : this.multiOutputConfig.getOutputConfigs()) {
            this.outputPlugins.add(outputConfig.getOutputPlugin(importContext));
        }
    }

    @Override
    public void afterInit() {
        if (this.outputPlugins != null) {
            for (OutputPlugin outputPlugin : this.outputPlugins) {
                outputPlugin.afterInit();
            }
        }
    }

    @Override
    public void beforeInit() {
        if (this.outputPlugins != null) {
            for (OutputPlugin outputPlugin : this.outputPlugins) {
                outputPlugin.beforeInit();
            }
        }
    }

    @Override
    public void init() {
        if (this.outputPlugins != null) {
            for (OutputPlugin outputPlugin : this.outputPlugins) {
                outputPlugin.init();
            }
        }
    }

    @Override
    public BaseDataTran createBaseDataTran(TaskContext taskContext, TranResultSet tranResultSet, JobCountDownLatch countDownLatch, Status currentStatus) {
        MultiOutPutDataTran baseCommonRecordDataTran = null;
        baseCommonRecordDataTran = this.multiOutputConfig.getOutputRecordsFilter() == null ? new MultiOutPutDataTran(taskContext, tranResultSet, this.importContext, countDownLatch, currentStatus) : new FilterMultiOutPutDataTran(taskContext, tranResultSet, this.importContext, countDownLatch, currentStatus);
        ((BaseDataTran)baseCommonRecordDataTran).initTran();
        return baseCommonRecordDataTran;
    }

    @Override
    public BaseDataTran createBaseDataTran(BaseDataTran baseDataTran) {
        MultiOutPutDataTran baseCommonRecordDataTran = new MultiOutPutDataTran(baseDataTran);
        return baseCommonRecordDataTran;
    }

    @Override
    protected void buildRecordOutpluginSpecialConfigs(CommonRecord dataRecord, Context context) throws Exception {
        for (OutputPlugin outputPlugin : this.outputPlugins) {
            outputPlugin.buildRecordOutpluginSpecialConfig(dataRecord, context);
        }
    }

    @Override
    public void stopCollectData() {
        for (OutputPlugin outputPlugin : this.outputPlugins) {
            outputPlugin.stopCollectData();
        }
        super.stopCollectData();
    }

    @Override
    public void destroy(boolean waitTranStop) {
        for (OutputPlugin outputPlugin : this.outputPlugins) {
            outputPlugin.destroy(waitTranStop);
        }
    }

    @Override
    public void setDataTranPlugin(DataTranPlugin dataTranPlugin) {
        this.dataTranPlugin = dataTranPlugin;
        for (OutputPlugin outputPlugin : this.outputPlugins) {
            outputPlugin.setDataTranPlugin(dataTranPlugin);
        }
    }
}

