/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.plugin.multi.output;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.exception.ImportExceptionUtil;
import org.frameworkset.tran.plugin.multi.output.InnerCommandBuilder;
import org.frameworkset.tran.plugin.multi.output.MultiOutputConfig;
import org.frameworkset.tran.plugin.multi.output.MultiOutputDataTranPlugin;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.task.BaseTaskCommand;
import org.frameworkset.tran.task.TaskCommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTaskCommandImpl
extends BaseTaskCommand<String> {
    private static final Logger logger = LoggerFactory.getLogger(MultiTaskCommandImpl.class);
    private TaskContext taskContext;
    private MultiOutputConfig multiOutputConfig;
    private MultiOutputDataTranPlugin multiOutputDataTranPlugin;
    private InnerCommandBuilder innerCommandBuilder;

    public MultiTaskCommandImpl(TaskCommandContext taskCommandContext, InnerCommandBuilder innerCommandBuilder, OutputConfig outputConfig) {
        super(outputConfig, taskCommandContext);
        this.multiOutputConfig = (MultiOutputConfig)outputConfig;
        this.multiOutputDataTranPlugin = (MultiOutputDataTranPlugin)outputConfig.getOutputPlugin();
        if (this.taskContext == null) {
            this.taskContext = new TaskContext(this.importContext);
            taskCommandContext.setTaskContext(this.taskContext);
        }
        this.innerCommandBuilder = innerCommandBuilder;
    }

    @Override
    public String execute() {
        if (this.records != null && this.records.size() > 0) {
            ExecutorService executorService = this.multiOutputDataTranPlugin.buildmultiOutputExecutor();
            List<Future> futures = this.innerCommandBuilder.buildBaseTaskCommand(this.records, executorService);
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException e) {
                    exceptions.add(e.getCause());
                }
            }
            if (exceptions.size() > 0) {
                throw ImportExceptionUtil.buildDataImportException(this.importContext, "MultiTaskCommandImpl exceptions occur", exceptions, this.outputPlugin);
            }
        }
        this.finishTask();
        return null;
    }
}

