/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.record;

import com.frameworkset.util.SimpleStringUtil;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.Record;
import org.frameworkset.tran.TranMeta;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.exception.ImportExceptionUtil;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.status.LastValueWrapper;
import org.frameworkset.tran.util.TranUtil;

public abstract class BaseRecord
implements Record {
    protected transient TaskContext taskContext;
    protected boolean readEOFRecord;
    protected boolean removed;
    protected boolean reachEOFClosed;
    protected Map<String, Object> metaDatas;
    protected ImportContext importContext;
    protected TranMeta tranMeta;

    public BaseRecord(TaskContext taskContext, ImportContext importContext) {
        this.taskContext = taskContext;
        this.importContext = importContext;
    }

    public BaseRecord(TaskContext taskContext, ImportContext importContext, boolean removed, boolean reachEOFClosed, boolean readEOFRecord) {
        this.taskContext = taskContext;
        this.removed = removed;
        this.reachEOFClosed = reachEOFClosed;
        this.readEOFRecord = readEOFRecord;
        this.importContext = importContext;
    }

    public BaseRecord(TaskContext taskContext, ImportContext importContext, boolean removed, boolean readEOFRecord) {
        this.taskContext = taskContext;
        this.removed = removed;
        this.reachEOFClosed = true;
        this.readEOFRecord = readEOFRecord;
        this.importContext = importContext;
    }

    @Override
    public TranMeta getMetaData() {
        return this.tranMeta;
    }

    @Override
    public void setTranMeta(TranMeta tranMeta) {
        this.tranMeta = tranMeta;
    }

    @Override
    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    @Override
    public Date getDateTimeValue(String colName) throws DataImportException {
        Object value = this.getValue(colName);
        if (value == null) {
            return null;
        }
        return TranUtil.getDateTimeValue(colName, value, this.taskContext.getImportContext());
    }

    @Override
    public Date getDateTimeValue(String colName, String dateformat) throws DataImportException {
        Object value = this.getValue(colName);
        if (value == null) {
            return null;
        }
        return TranUtil.getDateTimeValue(colName, value, this.taskContext.getImportContext(), dateformat);
    }

    @Override
    public LocalDateTime getLocalDateTimeValue(String colName) throws DataImportException {
        Object value = this.getValue(colName);
        if (value == null) {
            return null;
        }
        return TranUtil.getLocalDateTimeValue(colName, value, this.taskContext.getImportContext());
    }

    @Override
    public boolean isRecordDirectIgnore() {
        return this.getAction() == 3;
    }

    @Override
    public boolean reachEOFRecord() {
        return this.readEOFRecord;
    }

    @Override
    public ImportContext getImportContext() {
        return this.importContext;
    }

    @Override
    public boolean reachEOFClosed() {
        return this.reachEOFClosed;
    }

    @Override
    public boolean removed() {
        return this.removed;
    }

    @Override
    public Map<String, Object> getMetaDatas() {
        return this.metaDatas;
    }

    public void setMetaDatas(Map<String, Object> metaDatas) {
        this.metaDatas = metaDatas;
    }

    protected Object _getMetaValue(String metaName) {
        if (this.metaDatas.containsKey(metaName)) {
            return this.metaDatas.get(metaName);
        }
        throw ImportExceptionUtil.buildDataImportException(this.importContext, "Get Meta Value failed: " + metaName + " is not a meta field" + SimpleStringUtil.object2json(this.metaDatas.keySet()) + ".");
    }

    @Override
    public Object getMetaValue(String metaName) {
        if (this.metaDatas != null) {
            return this._getMetaValue(metaName);
        }
        return this.getValue(metaName);
    }

    @Override
    public Map<String, Object> getUpdateFromDatas() {
        return null;
    }

    @Override
    public int getAction() {
        return 0;
    }

    public Long getLastValueTime() {
        return System.currentTimeMillis();
    }

    @Override
    public LastValueWrapper getLastValueWrapper() {
        LastValueWrapper lastValueWrapper = new LastValueWrapper();
        lastValueWrapper.setTimeStamp(this.getLastValueTime());
        lastValueWrapper.setLastValue(this.getLastValue());
        lastValueWrapper.setStrLastValue(this.getStrLastValue());
        return lastValueWrapper;
    }

    public Object getLastValue() {
        if (!this.importContext.useFilePointer()) {
            if (this.importContext.getLastValueColumnName() == null) {
                return -1;
            }
            return this.getLastValue(this.importContext.getLastValueColumnName());
        }
        return this.getLastOffsetValue();
    }

    public String getStrLastValue() throws DataImportException {
        return null;
    }

    public Object getLastValue(String colName) throws DataImportException {
        try {
            if (this.importContext.getLastValueType() == null || this.importContext.getLastValueType() == 0) {
                return this.getValue(colName);
            }
            if (this.importContext.getLastValueType() == 1) {
                if (this.importContext.getLastValueDateformat() == null || this.importContext.getLastValueDateformat().equals("")) {
                    return this.getDateTimeValue(colName);
                }
                return this.getDateTimeValue(colName, this.importContext.getLastValueDateformat());
            }
            if (this.importContext.getLastValueType() == 2) {
                return this.getLocalDateTimeValue(colName);
            }
            if (this.importContext.getLastValueType() == 3) {
                if (colName != null) {
                    return this.getValue(colName);
                }
                return null;
            }
        }
        catch (DataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw ImportExceptionUtil.buildDataImportException(this.importContext, e);
        }
        throw ImportExceptionUtil.buildDataImportException(this.importContext, "Unsupport last value type:" + this.importContext.getLastValueType());
    }

    public Object getLastOffsetValue() throws DataImportException {
        return this.getOffset();
    }
}

