/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.record;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.tran.record.CellMapping;

public class FieldMappingManager<T extends FieldMappingManager> {
    private String fieldSplit;
    private List<CellMapping> cellMappingList;
    private Map<Integer, CellMapping> cellMappings;

    public List<CellMapping> getCellMappingList() {
        return this.cellMappingList;
    }

    public T addCellMapping(int cell, String field) {
        CellMapping cellMapping = new CellMapping();
        cellMapping.setCell(cell);
        cellMapping.setFieldName(field);
        return this.addCellMapping(cellMapping);
    }

    public T addCellMapping(int cell, String field, Object defaultValue) {
        CellMapping cellMapping = new CellMapping();
        cellMapping.setCell(cell);
        cellMapping.setFieldName(field);
        cellMapping.setDefaultValue(defaultValue);
        return this.addCellMapping(cellMapping);
    }

    public T addDateCellMapping(int cell, String field, int cellType, Object defaultValue, String dateformat) {
        CellMapping cellMapping = new CellMapping();
        cellMapping.setCell(cell);
        cellMapping.setFieldName(field);
        cellMapping.setCellType(cellType);
        cellMapping.setDateFormat(dateformat);
        cellMapping.setDefaultValue(defaultValue);
        return this.addCellMapping(cellMapping);
    }

    public T addNumberCellMapping(int cell, String field, int cellType, Object defaultValue, String numberformat) {
        CellMapping cellMapping = new CellMapping();
        cellMapping.setCell(cell);
        cellMapping.setFieldName(field);
        cellMapping.setCellType(cellType);
        cellMapping.setNumberFormat(numberformat);
        cellMapping.setDefaultValue(defaultValue);
        return this.addCellMapping(cellMapping);
    }

    public T addDateCellMapping(int cell, String field, int cellType, String dateformat) {
        CellMapping cellMapping = new CellMapping();
        cellMapping.setCell(cell);
        cellMapping.setFieldName(field);
        cellMapping.setCellType(cellType);
        cellMapping.setDateFormat(dateformat);
        return this.addCellMapping(cellMapping);
    }

    public T addNumberCellMapping(int cell, String field, int cellType, String numberformat) {
        CellMapping cellMapping = new CellMapping();
        cellMapping.setCell(cell);
        cellMapping.setFieldName(field);
        cellMapping.setCellType(cellType);
        cellMapping.setNumberFormat(numberformat);
        return this.addCellMapping(cellMapping);
    }

    public T addCellMappingWithType(int cell, String field, int cellType) {
        CellMapping cellMapping = new CellMapping();
        cellMapping.setCell(cell);
        cellMapping.setFieldName(field);
        cellMapping.setCellType(cellType);
        return this.addCellMapping(cellMapping);
    }

    public T addCellMappingWithType(int cell, String field, int cellType, Object defaultValue) {
        CellMapping cellMapping = new CellMapping();
        cellMapping.setCell(cell);
        cellMapping.setFieldName(field);
        cellMapping.setCellType(cellType);
        cellMapping.setDefaultValue(defaultValue);
        return this.addCellMapping(cellMapping);
    }

    public T addCellMapping(CellMapping cellMapping) {
        if (this.cellMappingList == null) {
            this.cellMappingList = new ArrayList<CellMapping>();
            this.cellMappings = new LinkedHashMap<Integer, CellMapping>();
        }
        this.cellMappingList.add(cellMapping);
        this.cellMappings.put(cellMapping.getCell(), cellMapping);
        return (T)this;
    }

    protected void appendFieldList(StringBuilder stringBuilder) {
        for (int i = 0; this.cellMappingList != null && i < this.cellMappingList.size(); ++i) {
            stringBuilder.append(",").append(this.cellMappingList.get(i));
        }
    }

    public String getFieldSplit() {
        return this.fieldSplit;
    }

    public void setFieldSplit(String fieldSplit) {
        this.fieldSplit = fieldSplit;
    }
}

