/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.record;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.frameworkset.elasticsearch.entity.KeyMap;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.Record;
import org.frameworkset.tran.TranMeta;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.record.NextAssert;
import org.frameworkset.tran.record.SplitData;
import org.frameworkset.tran.record.SplitHandler;
import org.frameworkset.tran.record.SplitKeys;
import org.frameworkset.tran.record.SplitRecord;
import org.frameworkset.tran.schedule.TaskContext;

public class SplitTranResultSet
implements TranResultSet {
    private TranResultSet tranResultSet;
    private List<KeyMap> splitRecords;
    private SplitHandler splitHandler;
    private ImportContext importContext;
    private int splitSize;
    private int splitPos;
    protected Record record;
    private Record baseRecord;

    public SplitTranResultSet(ImportContext importContext, TranResultSet tranResultSet) {
        this.tranResultSet = tranResultSet;
        this.importContext = importContext;
        this.splitHandler = this.importContext.getSplitHandler();
    }

    @Override
    public Record getCurrentRecord() {
        if (this.record != null) {
            return this.record;
        }
        return this.tranResultSet.getCurrentRecord();
    }

    @Override
    public Object getValue(int i, String colName, int sqlType) throws DataImportException {
        if (this.record != null) {
            return this.record.getValue(i, colName, sqlType);
        }
        return this.tranResultSet.getValue(i, colName, sqlType);
    }

    @Override
    public Object getValue(String colName) throws DataImportException {
        if (this.record != null) {
            return this.record.getValue(colName);
        }
        return this.tranResultSet.getValue(colName);
    }

    @Override
    public Object getLastValue(String colName) throws DataImportException {
        return this.tranResultSet.getLastValue(colName);
    }

    @Override
    public Object getLastOffsetValue() throws DataImportException {
        return this.tranResultSet.getLastOffsetValue();
    }

    @Override
    public Object getValue(String colName, int sqlType) throws DataImportException {
        if (this.record != null) {
            return this.record.getValue(colName, sqlType);
        }
        return this.tranResultSet.getValue(colName, sqlType);
    }

    @Override
    public BaseDataTran getBaseDataTran() {
        return this.tranResultSet.getBaseDataTran();
    }

    @Override
    public TaskContext getTaskContext() {
        return this.tranResultSet.getTaskContext();
    }

    @Override
    public void setBaseDataTran(BaseDataTran baseDataTran) {
        this.tranResultSet.setBaseDataTran(baseDataTran);
    }

    @Override
    public Date getDateTimeValue(String colName) throws DataImportException {
        if (this.record != null) {
            return this.record.getDateTimeValue(colName);
        }
        return this.tranResultSet.getDateTimeValue(colName);
    }

    @Override
    public Date getDateTimeValue(String colName, String dateFormat) throws DataImportException {
        if (this.record != null) {
            return this.record.getDateTimeValue(colName, dateFormat);
        }
        return this.tranResultSet.getDateTimeValue(colName, dateFormat);
    }

    @Override
    public LocalDateTime getLocalDateTimeValue(String colName) throws DataImportException {
        if (this.record != null) {
            return this.record.getLocalDateTimeValue(colName);
        }
        return this.tranResultSet.getLocalDateTimeValue(colName);
    }

    @Override
    public TaskContext getRecordTaskContext() {
        return this.tranResultSet.getRecordTaskContext();
    }

    private boolean readEnd() {
        if (this.splitRecords != null && this.splitRecords.size() > 0) {
            return this.splitPos == this.splitSize;
        }
        return true;
    }

    @Override
    public NextAssert next() throws DataImportException {
        NextAssert nextAssert = null;
        if (!this.readEnd()) {
            KeyMap keyMap = this.splitRecords.get(this.splitPos);
            this.record = keyMap.getKey() != null ? new SplitRecord(this.baseRecord, keyMap.getKey(), (Map<String, Object>)keyMap) : new SplitRecord(this.baseRecord, (Map<String, Object>)keyMap);
            this.record.setTranMeta(this.getMetaData());
            ++this.splitPos;
            nextAssert = new NextAssert();
            nextAssert.setHasNext(true);
            return nextAssert;
        }
        this.record = null;
        this.splitPos = 0;
        this.splitSize = 0;
        this.baseRecord = null;
        this.splitRecords = null;
        nextAssert = this.tranResultSet.next();
        if (nextAssert.isNeedFlush() || !nextAssert.isHasNext()) {
            return nextAssert;
        }
        if (nextAssert.isHasNext()) {
            Record baseRecord = this.tranResultSet.getCurrentRecord();
            if (baseRecord.isRecordDirectIgnore()) {
                return nextAssert;
            }
            if (baseRecord.removed()) {
                return nextAssert;
            }
            List<KeyMap> splitRecords_ = this.splitHandler.splitField(this.getTaskContext(), baseRecord, baseRecord.getValue(this.getTaskContext().getImportContext().getSplitFieldName()));
            if (splitRecords_ == null || splitRecords_.size() == 0) {
                this.record = null;
                this.splitPos = 0;
                this.splitRecords = null;
                return nextAssert;
            }
            this.baseRecord = baseRecord;
            this.splitRecords = splitRecords_;
            this.splitSize = this.splitRecords.size();
            KeyMap keyMap = this.splitRecords.get(0);
            this.record = keyMap.getKey() != null ? new SplitRecord(baseRecord, keyMap.getKey(), (Map<String, Object>)keyMap) : new SplitRecord(baseRecord, (Map<String, Object>)keyMap);
            this.record.setTranMeta(this.getMetaData());
            ++this.splitPos;
        }
        return nextAssert;
    }

    @Override
    public TranMeta getMetaData() {
        return this.tranResultSet.getMetaData();
    }

    @Override
    public Object getRecord() {
        if (this.record != null) {
            Object data = this.tranResultSet.getRecord();
            if (data == null) {
                return this.record.getData();
            }
            if (data instanceof Map) {
                LinkedHashMap newData = new LinkedHashMap();
                newData.putAll((Map)data);
                newData.putAll((Map)this.record.getData());
                return newData;
            }
            SplitData splitData = new SplitData();
            splitData.setOriginData(data);
            splitData.setSplitData((Map)this.record.getData());
            return splitData;
        }
        return this.tranResultSet.getRecord();
    }

    @Override
    public void stop(boolean exception) {
        this.tranResultSet.stop(exception);
    }

    @Override
    public Object getKeys() {
        if (this.record == null) {
            return this.tranResultSet.getKeys();
        }
        Set cKeys = (Set)this.record.getKeys();
        String[] columns = cKeys.toArray(new String[cKeys.size()]);
        SplitKeys splitKeys = new SplitKeys();
        splitKeys.setBaseKeys(this.tranResultSet.getKeys());
        splitKeys.setSplitKeys(columns);
        return splitKeys;
    }

    @Override
    public Object getMetaValue(String fieldName) {
        return this.tranResultSet.getMetaValue(fieldName);
    }

    @Override
    public Map<String, Object> getMetaDatas() {
        return this.tranResultSet.getMetaDatas();
    }

    @Override
    public int getAction() {
        return this.tranResultSet.getAction();
    }

    @Override
    public Object getLastValue() {
        return this.tranResultSet.getLastValue();
    }

    @Override
    public void destroy() {
        if (this.tranResultSet != null) {
            this.tranResultSet.destroy();
        }
    }
}

