/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.schedule;

import java.util.concurrent.CountDownLatch;
import org.frameworkset.tran.schedule.ScheduleAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScheduleAssert
implements ScheduleAssert {
    private static Logger logger = LoggerFactory.getLogger(DefaultScheduleAssert.class);
    protected boolean paused = false;
    protected CountDownLatch pauseCountDownLatch;
    protected Object pauseCountDownLatchLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pausedAwait() {
        try {
            CountDownLatch countDownLatch = null;
            Object object = this.pauseCountDownLatchLock;
            synchronized (object) {
                countDownLatch = this.pauseCountDownLatch;
            }
            if (countDownLatch != null) {
                if (logger.isInfoEnabled()) {
                    logger.info("Paused Schedule Task,waiting for next resume schedule sign to continue.");
                }
                countDownLatch.await();
                if (logger.isInfoEnabled()) {
                    logger.info("Paused Schedule resume execute.");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean assertSchedule(boolean autoPause) {
        return !this.checkPaused(autoPause);
    }

    protected boolean checkPaused(boolean autoPause) {
        return this.paused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pauseCountDownLatch() {
        Object object = this.pauseCountDownLatchLock;
        synchronized (object) {
            this.pauseCountDownLatch = new CountDownLatch(1);
        }
    }

    @Override
    public boolean pauseSchedule() {
        if (!this.paused) {
            this.pauseCountDownLatch();
            this.paused = true;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void countDownPauseLatch() {
        Object object = this.pauseCountDownLatchLock;
        synchronized (object) {
            if (this.pauseCountDownLatch != null) {
                this.pauseCountDownLatch.countDown();
            }
        }
    }

    @Override
    public boolean resumeSchedule() {
        if (this.paused) {
            this.paused = false;
            this.countDownPauseLatch();
            return true;
        }
        return false;
    }

    @Override
    public boolean stopAndInteruptPause() {
        if (this.paused) {
            this.paused = false;
            this.countDownPauseLatch();
            return true;
        }
        return false;
    }
}

