/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.schedule;

import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.schedule.AfterCallException;
import org.frameworkset.tran.schedule.CallInterceptor;
import org.frameworkset.tran.schedule.PreCallException;
import org.frameworkset.tran.schedule.ScheduleConfig;
import org.frameworkset.tran.schedule.ScheduleTimer;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.schedule.timer.TimerScheduleConfig;
import org.frameworkset.tran.util.TranUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleService {
    private static Logger logger = LoggerFactory.getLogger(ScheduleService.class);
    protected boolean enablePluginTaskIntercept = true;
    private ImportContext importContext;
    private Timer timer;
    private ScheduleTimer scheduleTimer;

    public void setEnablePluginTaskIntercept(boolean enablePluginTaskIntercept) {
        this.enablePluginTaskIntercept = enablePluginTaskIntercept;
    }

    public boolean isEnablePluginTaskIntercept() {
        return this.enablePluginTaskIntercept;
    }

    public ImportContext getImportContext() {
        return this.importContext;
    }

    private void scheduleImportData(TaskContext taskContext) throws Exception {
        if (!this.importContext.assertCondition()) {
            if (logger.isWarnEnabled()) {
                logger.warn("Task Assert Execute Condition Failed, Ignore");
            }
            return;
        }
        DataTranPlugin dataTranPlugin = this.importContext.getDataTranPlugin();
        dataTranPlugin.doImportData(taskContext);
    }

    private void preCall(TaskContext taskContext) {
        List<CallInterceptor> callInterceptors = this.importContext.getCallInterceptors();
        if (callInterceptors == null || callInterceptors.size() == 0) {
            return;
        }
        for (CallInterceptor callInterceptor : callInterceptors) {
            try {
                callInterceptor.preCall(taskContext);
            }
            catch (DataImportException e) {
                throw new PreCallException(e);
            }
            catch (Exception e) {
                throw new PreCallException(e);
            }
        }
        if (taskContext.getDbmportConfig() != null) {
            TranUtil.initTaskContextSQLInfo(taskContext, this.importContext);
        }
    }

    private void afterCall(TaskContext taskContext) {
        List<CallInterceptor> callInterceptors = this.importContext.getCallInterceptors();
        if (callInterceptors == null || callInterceptors.size() == 0) {
            return;
        }
        CallInterceptor callInterceptor = null;
        for (int j = callInterceptors.size() - 1; j >= 0; --j) {
            callInterceptor = callInterceptors.get(j);
            try {
                callInterceptor.afterCall(taskContext);
                continue;
            }
            catch (Exception e) {
                logger.error("afterCall failed:", (Throwable)e);
                this.throwException(taskContext, new AfterCallException("afterCall failed:", e));
            }
        }
    }

    public boolean isSchedulePaused(boolean autoSchedulePaused) {
        return this.importContext.isSchedulePaused(autoSchedulePaused);
    }

    private void throwException(TaskContext taskContext, Exception e) {
        List<CallInterceptor> callInterceptors = this.importContext.getCallInterceptors();
        if (callInterceptors == null || callInterceptors.size() == 0) {
            logger.error("afterCall failed:", (Throwable)e);
            return;
        }
        CallInterceptor callInterceptor = null;
        for (int j = callInterceptors.size() - 1; j >= 0; --j) {
            callInterceptor = callInterceptors.get(j);
            try {
                callInterceptor.throwException(taskContext, e);
                continue;
            }
            catch (Exception e1) {
                logger.error("afterCall failed:", (Throwable)e1);
            }
        }
    }

    public boolean isEnableAutoPauseScheduled() {
        DataTranPlugin dataTranPlugin = this.importContext.getDataTranPlugin();
        return dataTranPlugin.isEnableAutoPauseScheduled();
    }

    private void jdkTimeSchedule(ScheduleConfig scheduleConfig) throws Exception {
        this.timer = new Timer("JobJdkTimeSchedule-" + this.importContext.getJobName() + "-Timer");
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                if (ScheduleService.this.isSchedulePaused(ScheduleService.this.isEnableAutoPauseScheduled()) && ScheduleService.this.importContext.getDataTranPlugin().checkTranToStop()) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Schedule Task has stopped,stop resume schedule.");
                    }
                    return;
                }
                ScheduleService.this.externalTimeSchedule();
            }
        };
        Date scheduleDate = this.importContext.getScheduleDate();
        Long delay = this.importContext.getDeyLay();
        if (scheduleDate != null) {
            if (scheduleConfig.getFixedRate() != null && scheduleConfig.getFixedRate().booleanValue()) {
                this.timer.scheduleAtFixedRate(timerTask, scheduleDate, (long)scheduleConfig.getPeriod());
            } else if (scheduleConfig.getPeriod() != null) {
                this.timer.schedule(timerTask, scheduleDate, (long)scheduleConfig.getPeriod());
            } else {
                this.timer.schedule(timerTask, scheduleDate);
            }
        } else {
            if (delay == null) {
                delay = 1000L;
            }
            if (scheduleConfig.getFixedRate() != null && scheduleConfig.getFixedRate().booleanValue()) {
                this.timer.scheduleAtFixedRate(timerTask, delay, (long)scheduleConfig.getPeriod());
            } else if (scheduleConfig.getPeriod() != null) {
                this.timer.schedule(timerTask, delay, (long)scheduleConfig.getPeriod());
            } else {
                this.timer.schedule(timerTask, delay);
            }
        }
    }

    private void innerimeSchedule(TimerScheduleConfig scheduleConfig) throws Exception {
        this.scheduleTimer = new ScheduleTimer(scheduleConfig, this);
        this.scheduleTimer.start();
    }

    public boolean timeSchedule() throws Exception {
        ScheduleConfig scheduleConfig = this.importContext.getScheduleConfig();
        if (scheduleConfig instanceof TimerScheduleConfig) {
            this.innerimeSchedule((TimerScheduleConfig)scheduleConfig);
        } else {
            this.jdkTimeSchedule(scheduleConfig);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void externalTimeSchedule() {
        TaskContext taskContext = this.isEnablePluginTaskIntercept() ? new TaskContext(this.importContext) : null;
        long importStartTime = System.currentTimeMillis();
        Exception exception = null;
        try {
            if (this.isEnablePluginTaskIntercept()) {
                this.preCall(taskContext);
            }
            this.scheduleImportData(taskContext);
            if (this.isEnablePluginTaskIntercept()) {
                this.afterCall(taskContext);
            }
        }
        catch (Exception e) {
            exception = e;
            if (this.isEnablePluginTaskIntercept()) {
                this.throwException(taskContext, e);
            }
            logger.error("Schedule job task failed:", (Throwable)e);
            if (!this.importContext.getDataTranPlugin().isMultiTran() && !this.importContext.isContinueOnError()) {
                this.importContext.finishAndWaitTran(e);
            }
        }
        finally {
            long importEndTime = System.currentTimeMillis();
            if (logger.isInfoEnabled()) {
                if (exception == null) {
                    logger.info("Schedule job task finished ,Take " + (importEndTime - importStartTime) + " ms");
                } else {
                    logger.info("Schedule job finished with exception, Take " + (importEndTime - importStartTime) + " ms");
                }
            }
        }
    }

    public void init(ImportContext importContext) {
        this.importContext = importContext;
    }

    public void stop() {
        try {
            if (this.timer != null) {
                this.timer.cancel();
            }
            if (this.scheduleTimer != null) {
                this.scheduleTimer.stop();
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }
}

