/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.schedule;

import com.frameworkset.util.UUID;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.context.JobContext;
import org.frameworkset.tran.context.ReInitAction;
import org.frameworkset.tran.context.TaskContextReinitCallback;
import org.frameworkset.tran.jobflow.context.JobFlowExecuteContext;
import org.frameworkset.tran.jobflow.context.JobFlowNodeExecuteContext;
import org.frameworkset.tran.metrics.BaseMetricsLogReport;
import org.frameworkset.tran.metrics.JobTaskMetrics;
import org.frameworkset.tran.metrics.TaskMetrics;
import org.frameworkset.tran.plugin.db.TranSQLInfo;
import org.frameworkset.tran.plugin.db.output.DBOutputConfig;
import org.frameworkset.tran.schedule.JobExecuteMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskContext
extends BaseMetricsLogReport {
    private static Logger logger = LoggerFactory.getLogger(TaskContext.class);
    public static final String taskDataKey_jobTaskStartTime = "__jobTaskStartTime";
    private Map<String, Object> taskDatas;
    private JobTaskMetrics jobTaskMetrics;
    private DBOutputConfig dbmportConfig;
    private TranSQLInfo targetSqlInfo;
    private TranSQLInfo targetUpdateSqlInfo;
    private TranSQLInfo targetDeleteSqlInfo;
    private ImportContext importContext;
    private List<TaskContextReinitCallback> taskContextReinitCallbacks;

    public void setTaskContextReinitCallback(TaskContextReinitCallback taskContextReinitCallback) {
        if (this.taskContextReinitCallbacks == null) {
            this.taskContextReinitCallbacks = new ArrayList<TaskContextReinitCallback>();
        }
        this.taskContextReinitCallbacks.add(taskContextReinitCallback);
    }

    public Object getJobContextData(String name) {
        return this.getJobContext().getJobData(name);
    }

    public boolean neadTriggerJobFlowNodeComplete() {
        return true;
    }

    public DBOutputConfig getDbmportConfig() {
        return this.dbmportConfig;
    }

    public void setDbmportConfig(DBOutputConfig dbmportConfig) {
        this.dbmportConfig = dbmportConfig;
    }

    public TaskContext() {
    }

    public synchronized void reInitContext(ReInitAction reInitAction) {
        if (this.getJobTaskMetrics().getTotalRecords() > 0L) {
            TaskContext taskContextCopy = this.copy();
            reInitAction.afterCall(taskContextCopy);
            this.initContext(false);
            reInitAction.preCall(this);
            if (this.taskContextReinitCallbacks != null) {
                for (TaskContextReinitCallback taskContextReinitCallback : this.taskContextReinitCallbacks) {
                    try {
                        taskContextReinitCallback.taskContextReinitCallback(this);
                    }
                    catch (Exception e) {
                        logger.warn("TaskContextReinitCallback.taskContextReinitCallback failed:", (Throwable)e);
                    }
                    catch (Throwable e) {
                        logger.warn("TaskContextReinitCallback.taskContextReinitCallback failed:", e);
                    }
                }
            }
        }
    }

    public void initContext(boolean useJobContextStartTime) {
        this.taskDatas = new LinkedHashMap<String, Object>();
        this.jobTaskMetrics = this.importContext.createJobTaskMetrics();
        this.jobTaskMetrics.setJobNo(UUID.randomUUID().toString());
        if (!useJobContextStartTime) {
            this.jobTaskMetrics.setJobStartTime(new Date());
        } else {
            this.jobTaskMetrics.setJobStartTime(this.importContext.getJobContext().getJobStartTime());
        }
        this.taskDatas.put(taskDataKey_jobTaskStartTime, this.jobTaskMetrics.getJobStartTime());
        this.jobTaskMetrics.setJobId(this.importContext.getJobId());
        this.jobTaskMetrics.setJobName(this.importContext.getJobName());
    }

    public TaskContext(ImportContext importContext) {
        this(importContext, false);
    }

    public TaskContext(ImportContext importContext, boolean useJobContextStartTime) {
        super(importContext.getDataTranPlugin());
        this.importContext = importContext;
        this.initContext(useJobContextStartTime);
    }

    public void await() {
        this.jobTaskMetrics.await();
    }

    public void await(long waitTime) {
        this.jobTaskMetrics.await(waitTime);
    }

    public TaskContext addTaskData(String name, Object value) {
        this.taskDatas.put(name, value);
        return this;
    }

    public synchronized void taskExecuteMetric(JobExecuteMetric jobExecuteMetric) {
        try {
            jobExecuteMetric.executeMetric(this.jobTaskMetrics);
        }
        catch (Exception e) {
            logger.debug("taskExecuteMetric failed:", (Throwable)e);
        }
        catch (Throwable throwable) {
            logger.debug("taskExecuteMetric failed:", throwable);
        }
    }

    public synchronized Object readJobExecutorData(String name) {
        try {
            return this.jobTaskMetrics.readJobExecutorData(name);
        }
        catch (Exception e) {
            logger.debug("readJobExecutorData failed:", (Throwable)e);
        }
        catch (Throwable throwable) {
            logger.debug("readJobExecutorData failed:", throwable);
        }
        return null;
    }

    public synchronized TaskContext addTaskDatas(Map<String, Object> taskDatas) {
        this.taskDatas.putAll(taskDatas);
        return this;
    }

    public synchronized Object getTaskData(String name) {
        return this.taskDatas.get(name);
    }

    public synchronized String getTaskStringData(String name) {
        Object v = this.taskDatas.get(name);
        if (v == null) {
            return null;
        }
        return String.valueOf(this.taskDatas.get(name));
    }

    public JobContext getJobContext() {
        if (this.importContext != null) {
            return this.importContext.getJobContext();
        }
        return null;
    }

    public ImportContext getImportContext() {
        return this.importContext;
    }

    public synchronized void release() {
        if (this.taskDatas != null) {
            this.taskDatas.clear();
            this.taskDatas = null;
        }
    }

    public String getSql() {
        if (this.dbmportConfig != null) {
            return this.dbmportConfig.getSql();
        }
        return null;
    }

    public String getSqlFilepath() {
        if (this.dbmportConfig != null) {
            return this.dbmportConfig.getSqlFilepath();
        }
        return null;
    }

    public String getSqlName() {
        if (this.dbmportConfig != null) {
            return this.dbmportConfig.getSqlName();
        }
        return null;
    }

    public String getInsertSqlName() {
        if (this.dbmportConfig != null) {
            return this.dbmportConfig.getInsertSqlName();
        }
        return null;
    }

    public String getInsertSql() {
        if (this.dbmportConfig != null) {
            return this.dbmportConfig.getInsertSql();
        }
        return null;
    }

    public String getDeleteSqlName() {
        if (this.dbmportConfig != null) {
            return this.dbmportConfig.getDeleteSqlName();
        }
        return null;
    }

    public String getDeleteSql() {
        if (this.dbmportConfig != null) {
            return this.dbmportConfig.getDeleteSql();
        }
        return null;
    }

    public String getUpdateSqlName() {
        if (this.dbmportConfig != null) {
            return this.dbmportConfig.getUpdateSqlName();
        }
        return null;
    }

    public String getUpdateSql() {
        if (this.dbmportConfig != null) {
            return this.dbmportConfig.getUpdateSql();
        }
        return null;
    }

    public TranSQLInfo getTargetSqlInfo() {
        return this.targetSqlInfo;
    }

    public void setTargetSqlInfo(TranSQLInfo targetSqlInfo) {
        this.targetSqlInfo = targetSqlInfo;
    }

    public TranSQLInfo getTargetUpdateSqlInfo() {
        return this.targetUpdateSqlInfo;
    }

    public void setTargetUpdateSqlInfo(TranSQLInfo sqlInfo) {
        this.targetUpdateSqlInfo = sqlInfo;
    }

    public TranSQLInfo getTargetDeleteSqlInfo() {
        return this.targetDeleteSqlInfo;
    }

    public void setTargetDeleteSqlInfo(TranSQLInfo sqlInfo) {
        this.targetDeleteSqlInfo = sqlInfo;
    }

    public DBConfig getTargetDBConfig() {
        if (this.dbmportConfig != null) {
            return this.dbmportConfig.getTargetDBConfig();
        }
        return null;
    }

    public synchronized void beginTask(TaskMetrics taskMetrics) {
        this.jobTaskMetrics.increamentTasks();
    }

    public synchronized void finishTaskMetrics(TaskMetrics taskMetrics) {
        this.jobTaskMetrics.increamentFailedRecords(taskMetrics.getFailedRecords());
        this.jobTaskMetrics.increamentIgnoreRecords(taskMetrics.getIgnoreRecords());
        this.jobTaskMetrics.increamentRecords(taskMetrics.getRecords());
        this.jobTaskMetrics.increamentSuccessRecords(taskMetrics.getSuccessRecords());
        this.jobTaskMetrics.putLastValue(this.importContext, taskMetrics.getLastValue());
    }

    public synchronized void setJobEndTime(Date jobEndTime) {
        this.jobTaskMetrics.setJobEndTime(jobEndTime);
    }

    public synchronized JobTaskMetrics getJobTaskMetrics() {
        return this.jobTaskMetrics;
    }

    public synchronized Date getJobStartTime() {
        return this.jobTaskMetrics.getJobStartTime();
    }

    public synchronized String getJobNo() {
        return this.jobTaskMetrics.getJobNo();
    }

    protected TaskContext createTaskContext() {
        return new TaskContext();
    }

    public synchronized TaskContext copy() {
        TaskContext taskContext = this.createTaskContext();
        taskContext.importContext = this.importContext;
        taskContext.dbmportConfig = this.dbmportConfig;
        taskContext.targetSqlInfo = this.targetSqlInfo;
        taskContext.targetUpdateSqlInfo = this.targetUpdateSqlInfo;
        taskContext.targetDeleteSqlInfo = this.targetDeleteSqlInfo;
        taskContext.taskDatas = this.taskDatas;
        taskContext.jobTaskMetrics = this.jobTaskMetrics;
        taskContext.setDataTranPlugin(this.getDataTranPlugin());
        return taskContext;
    }

    public synchronized int increamentErrorTasks() {
        return this.getJobTaskMetrics().increamentErrorTasks();
    }

    public synchronized int increamentExceptionTasks() {
        return this.getJobTaskMetrics().increamentExceptionTasks();
    }

    public Date getJobTaskStartTime() {
        return this.getJobTaskMetrics().getJobStartTime();
    }

    @Override
    public void reportJobMetricErrorLog(String msg, Throwable e) {
        this.dataTranPlugin.reportJobMetricErrorLog(this, msg, e);
    }

    @Override
    public void reportJobMetricLog(String msg) {
        this.dataTranPlugin.reportJobMetricLog(this, msg);
    }

    @Override
    public void reportJobMetricWarn(String msg) {
        this.dataTranPlugin.reportJobMetricWarn(this, msg);
    }

    @Override
    public void reportJobMetricDebug(String msg) {
        this.dataTranPlugin.reportJobMetricDebug(this, msg);
    }

    public String getJobId() {
        return this.importContext.getJobId();
    }

    public String getJobName() {
        return this.importContext.getJobName();
    }

    public JobFlowNodeExecuteContext getJobFlowNodeExecuteContext() {
        return this.importContext.getJobFlowNodeExecuteContext();
    }

    public JobFlowExecuteContext getJobFlowExecuteContext() {
        return this.importContext.getJobFlowExecuteContext();
    }

    public JobFlowNodeExecuteContext getContainerJobFlowNodeExecuteContext() {
        return this.importContext.getJobFlowNodeExecuteContext().getContainerJobFlowNodeExecuteContext();
    }

    public Object getJobFlowContextData(String name) {
        return this.getJobFlowExecuteContext().getContextData(name);
    }

    public Object getJobFlowContextData(String name, Object defaultValue) {
        return this.getJobFlowExecuteContext().getContextData(name, defaultValue);
    }

    public Object getJobFlowNodeContextData(String name) {
        return this.getJobFlowNodeExecuteContext().getContextData(name);
    }

    public Object getJobFlowNodeContextData(String name, Object defaultValue) {
        return this.getJobFlowNodeExecuteContext().getContextData(name, defaultValue);
    }

    public Object getContainerJobFlowNodeContextData(String name) {
        return this.getContainerJobFlowNodeExecuteContext().getContextData(name);
    }

    public Object getContainerJobFlowNodeContextData(String name, Object defaultValue) {
        return this.getContainerJobFlowNodeExecuteContext().getContextData(name, defaultValue);
    }

    public void addJobFlowNodeContextData(String name, Object data) {
        this.getJobFlowNodeExecuteContext().addContextData(name, data);
    }

    public void addJobFlowContextData(String name, Object data) {
        this.getJobFlowExecuteContext().addContextData(name, data);
    }

    public void addContainerJobFlowNodeContextData(String name, Object data) {
        this.getContainerJobFlowNodeExecuteContext().addContextData(name, data);
    }

    public String getJobFlowId() {
        return this.getJobFlowExecuteContext().getJobFlowId();
    }

    public String getJobFlowName() {
        return this.getJobFlowExecuteContext().getJobFlowName();
    }

    public String getJobFlowNodeId() {
        return this.getJobFlowNodeExecuteContext().getNodeId();
    }

    public String getJobFlowNodeName() {
        return this.getJobFlowNodeExecuteContext().getNodeName();
    }

    public String getContainerJobFlowNodeId() {
        return this.getContainerJobFlowNodeExecuteContext().getNodeId();
    }

    public String getContainerJobFlowNodeName() {
        return this.getContainerJobFlowNodeExecuteContext().getNodeName();
    }
}

