/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.status;

import com.frameworkset.common.poolman.SQLExecutor;
import com.frameworkset.common.poolman.util.DBConf;
import com.frameworkset.common.poolman.util.SQLManager;
import com.frameworkset.common.poolman.util.SQLUtil;
import com.frameworkset.util.SimpleStringUtil;
import java.io.File;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.tran.DBConfig;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.exception.ImportExceptionUtil;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.timer.TimeUtil;
import org.frameworkset.tran.status.DefaultLastValueWraperSerial;
import org.frameworkset.tran.status.InitLastValueClumnName;
import org.frameworkset.tran.status.LastValueWraperSerial;
import org.frameworkset.tran.status.LastValueWrapper;
import org.frameworkset.tran.status.LoadCurrentStatus;
import org.frameworkset.tran.status.StatusFlushThread;
import org.frameworkset.tran.status.StatusManager;
import org.frameworkset.util.shutdown.ShutdownUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStatusManager
implements StatusManager {
    private DataTranPlugin dataTranPlugin;
    private boolean increamentImport = true;
    protected ImportContext importContext;
    protected LastValueWraperSerial lastValueWraperSerial;
    protected volatile Status currentStatus;
    protected volatile Status firstStatus;
    protected String updateSQL;
    protected String updateByJobIdSQL;
    protected String updateStatusSQL;
    protected String updateByJobIdStatusSQL;
    protected String insertSQL;
    protected String insertHistorySQL;
    protected String createStatusTableSQL;
    protected String createHistoryStatusTableSQL;
    protected String selectSQL;
    protected String selectByJobIdSQL;
    protected String checkFieldSQL;
    protected String checkHisFieldSQL;
    protected String deleteSQL;
    protected String deleteByJobIdSQL;
    protected String selectAllSQL;
    protected String selectAllByJobIdSQL;
    protected String existSQL;
    protected String existHisSQL;
    protected Date initLastDate = null;
    protected LocalDateTime initLastLocalDateTime = null;
    protected String statusDbname;
    protected boolean useOuterStatusDb = false;
    protected String statusTableName;
    protected String historyStatusTableName;
    protected String statusStorePath;
    protected String statusStorePassword = "Root_123456#";
    protected String lastValueClumnName;
    private static Logger logger = LoggerFactory.getLogger(BaseStatusManager.class);
    protected int lastValueType;
    private StatusFlushThread flushThread;
    private boolean stoped;
    private ReentrantLock putStatusLock = new ReentrantLock();

    public BaseStatusManager(DataTranPlugin dataTranPlugin) {
        this.dataTranPlugin = dataTranPlugin;
        this.importContext = dataTranPlugin.getImportContext();
        this.setLastValueWraperSerial();
    }

    protected void setLastValueWraperSerial() {
        this.lastValueWraperSerial = new DefaultLastValueWraperSerial();
    }

    public DataTranPlugin getDataTranPlugin() {
        return this.dataTranPlugin;
    }

    public void init() {
        this.flushThread = new StatusFlushThread(this, this.dataTranPlugin.getImportContext().getAsynFlushStatusInterval());
        this.flushThread.start();
        ShutdownUtil.addShutdownHook((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (BaseStatusManager.this.isStoped()) {
                    return;
                }
                BaseStatusManager baseStatusManager = BaseStatusManager.this;
                synchronized (baseStatusManager) {
                    if (BaseStatusManager.this.isStoped()) {
                        return;
                    }
                    BaseStatusManager.this.flushStatus();
                }
            }
        });
    }

    protected abstract void _putStatus(Status var1);

    @Override
    public void putStatus(Status currentStatus) throws Exception {
        this.putStatusLock.lock();
        try {
            this._putStatus(currentStatus);
        }
        finally {
            this.putStatusLock.unlock();
        }
    }

    protected abstract void _flushStatus() throws Exception;

    @Override
    public void flushStatus() {
        this.putStatusLock.lock();
        try {
            this._flushStatus();
        }
        catch (Exception throwables) {
            logger.error("flushStatus failed:statusDbname[" + this.statusDbname + "],updateSQL[" + this.updateSQL + "]", (Throwable)throwables);
        }
        finally {
            this.putStatusLock.unlock();
        }
    }

    @Override
    public synchronized void stop() {
        if (this.stoped) {
            return;
        }
        this.stoped = true;
        if (this.flushThread != null) {
            this.flushThread.interrupt();
            try {
                this.flushThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized boolean isStoped() {
        return this.stoped;
    }

    protected Object convertLastValue(Object lastValue) {
        if (lastValue == null) {
            return null;
        }
        if (lastValue instanceof Date) {
            lastValue = ((Date)lastValue).getTime();
        }
        return lastValue;
    }

    protected Object convertStrLastValue(Object lastValue) {
        if (lastValue == null) {
            return null;
        }
        return lastValue;
    }

    public static boolean needUpdate(Integer lastValueType, Object oldValue, Object newValue) {
        return BaseStatusManager.compare(lastValueType, oldValue, newValue);
    }

    public static boolean max(Integer lastValueType, Object oldValue, Object newValue) {
        return BaseStatusManager.compare(lastValueType, oldValue, newValue);
    }

    private static boolean compare(Integer lastValueType, Object oldValue, Object newValue) {
        if (newValue == null) {
            return false;
        }
        if (oldValue == null) {
            return true;
        }
        if (lastValueType == null) {
            lastValueType = oldValue instanceof Date ? Integer.valueOf(1) : (oldValue instanceof LocalDateTime ? Integer.valueOf(2) : (oldValue instanceof String ? Integer.valueOf(3) : Integer.valueOf(0)));
        }
        if (lastValueType == 1) {
            Date newValueDate = (Date)newValue;
            Date oldValueDate = (Date)oldValue;
            return newValueDate.after(oldValueDate);
        }
        if (lastValueType == 2) {
            LocalDateTime newValueDate = (LocalDateTime)newValue;
            LocalDateTime oldValueDate = (LocalDateTime)oldValue;
            return newValueDate.isAfter(oldValueDate);
        }
        Number ts = (Number)oldValue;
        Number nts = (Number)newValue;
        return nts.longValue() > ts.longValue();
    }

    private void initStatusSQL(String statusDbname) {
        this.createStatusTableSQL = DBConfig.getCreateStatusTableSQL(SQLUtil.getPool((String)statusDbname).getDBType());
        this.createHistoryStatusTableSQL = DBConfig.getCreateHistoryStatusTableSQL(SQLUtil.getPool((String)statusDbname).getDBType());
        this.createStatusTableSQL = this.createStatusTableSQL.replace("$statusTableName", this.statusTableName);
        this.createHistoryStatusTableSQL = this.createHistoryStatusTableSQL.replace("$historyStatusTableName", this.historyStatusTableName);
    }

    private void addField(String field, String tableName, String defaultValue, String length, String type) {
        block3: {
            String addFiledSQL = defaultValue != null ? "ALTER TABLE " + tableName + " ADD " + field + " " + type + "(" + length + ") DEFAULT " + defaultValue : "ALTER TABLE " + tableName + " ADD " + field + " " + type + "(" + length + ") ";
            try {
                SQLExecutor.updateWithDBName((String)this.statusDbname, (String)addFiledSQL, (Object[])new Object[0]);
                if (logger.isInfoEnabled()) {
                    logger.info("add field to table success\uff1a" + addFiledSQL + ".");
                }
            }
            catch (Exception e1) {
                if (!logger.isWarnEnabled()) break block3;
                logger.warn("add field to table failed\uff1a" + addFiledSQL + ", field " + field + " alread exist.");
            }
        }
    }

    private void checkStatusFieldExist() {
        String defaultValue = DBConfig.getStatusTableDefaultValue(SQLUtil.getPool((String)this.statusDbname).getDBType());
        String type = DBConfig.getStatusTableType(SQLUtil.getPool((String)this.statusDbname).getDBType());
        try {
            SQLExecutor.queryObjectWithDBName(Status.class, (String)this.statusDbname, (String)this.checkFieldSQL, (Object[])new Object[0]);
        }
        catch (SQLException e) {
            logger.warn("filePath,status and fileId not exit in table {" + this.statusTableName + "}");
            this.addField("filePath", this.statusTableName, defaultValue, "500", type);
            this.addField("relativeParentDir", this.statusTableName, defaultValue, "500", type);
            this.addField("fileId", this.statusTableName, defaultValue, "500", type);
            this.addField("strLastValue", this.statusTableName, defaultValue, "100", type);
            this.addField("status", this.statusTableName, null, "1", DBConfig.getStatusTableTypeNumber(SQLUtil.getPool((String)this.statusDbname).getDBType()));
            this.addField("jobId", this.statusTableName, defaultValue, "500", type);
            this.addField("jobType", this.statusTableName, defaultValue, "500", type);
        }
    }

    @Override
    public void initLastValueType() {
        this.lastValueType = this.importContext.getLastValueType() != null ? this.importContext.getLastValueType() : 0;
        this.importContext.setLastValueType(this.lastValueType);
    }

    protected void initDatasource() {
        if (this.isIncreamentImport()) {
            if (this.importContext.getStatusDbConfig() == null) {
                this.statusDbname = "_status_datasource";
                String dbJNDIName = "_status_datasource_jndi";
                this.initSQLiteStatusDB(this.statusDbname, dbJNDIName);
            } else {
                DBConfig statusDBConfig = this.importContext.getStatusDbConfig();
                this.statusDbname = statusDBConfig.getDbName();
                if (statusDBConfig.getDbDriver() != null && !statusDBConfig.getDbDriver().trim().equals("")) {
                    if (this.statusDbname == null || this.statusDbname.trim().equals("")) {
                        this.statusDbname = "_status_datasource";
                    }
                    String dbJNDIName = this.statusDbname + "_jndi";
                    try {
                        DBConf tempConf = new DBConf();
                        tempConf.setPoolname(this.statusDbname);
                        tempConf.setDriver(statusDBConfig.getDbDriver());
                        tempConf.setJdbcurl(statusDBConfig.getDbUrl());
                        tempConf.setUsername(statusDBConfig.getDbUser());
                        tempConf.setPassword(statusDBConfig.getDbPassword());
                        tempConf.setReadOnly((String)null);
                        tempConf.setTxIsolationLevel((String)null);
                        tempConf.setValidationQuery(statusDBConfig.getValidateSQL());
                        tempConf.setJndiName(dbJNDIName);
                        tempConf.setInitialConnections(10);
                        tempConf.setConnectionTimeout(statusDBConfig.getConnectionTimeout());
                        tempConf.setMaxIdleTime(statusDBConfig.getMaxIdleTime());
                        tempConf.setMaxWait(statusDBConfig.getMaxWait());
                        tempConf.setMinimumSize(10);
                        tempConf.setMaximumSize(20);
                        tempConf.setUsepool(true);
                        tempConf.setExternal(false);
                        tempConf.setExternaljndiName((String)null);
                        tempConf.setShowsql(statusDBConfig.isShowSql());
                        tempConf.setEncryptdbinfo(false);
                        tempConf.setQueryfetchsize(null);
                        tempConf.setDbInfoEncryptClass(statusDBConfig.getDbInfoEncryptClass());
                        tempConf.setConnectionProperties(statusDBConfig.getConnectionProperties());
                        tempConf.setEnableBalance(statusDBConfig.isEnableBalance());
                        tempConf.setDatasource(statusDBConfig.getDataSource());
                        tempConf.setBalance(statusDBConfig.getBalance());
                        boolean ret = SQLManager.startPool((DBConf)tempConf);
                        if (!ret) {
                            logger.warn("Ignore start started Status_datasource[" + this.statusDbname + "].");
                            this.useOuterStatusDb = true;
                            this.initStatusSQL(this.statusDbname);
                        }
                    }
                    catch (Exception e) {
                        throw ImportExceptionUtil.buildDataImportException(this.importContext, e);
                    }
                    this.initStatusSQL(statusDBConfig);
                } else if (statusDBConfig.getDataSource() != null) {
                    if (this.statusDbname == null || this.statusDbname.trim().equals("")) {
                        this.statusDbname = "_status_datasource";
                    }
                    String dbJNDIName = this.statusDbname + "_jndi";
                    try {
                        DBConf tempConf = new DBConf();
                        tempConf.setPoolname(this.statusDbname);
                        tempConf.setDriver(statusDBConfig.getDbDriver());
                        tempConf.setJndiName(dbJNDIName);
                        tempConf.setShowsql(statusDBConfig.isShowSql());
                        tempConf.setDbAdaptor(statusDBConfig.getDbAdaptor());
                        tempConf.setDbtype(statusDBConfig.getDbtype());
                        tempConf.setColumnLableUpperCase(statusDBConfig.isColumnLableUpperCase());
                        tempConf.setDatasource(statusDBConfig.getDataSource());
                        boolean ret = SQLManager.startPool((DBConf)tempConf);
                        if (!ret) {
                            logger.warn("Ignore start started Status_datasource[" + this.statusDbname + "].");
                            this.useOuterStatusDb = true;
                            this.initStatusSQL(this.statusDbname);
                        }
                    }
                    catch (Exception e) {
                        throw ImportExceptionUtil.buildDataImportException(this.importContext, e);
                    }
                    this.initStatusSQL(statusDBConfig);
                } else if (this.statusStorePath != null && !this.statusStorePath.equals("")) {
                    if (this.statusDbname == null || this.statusDbname.trim().equals("")) {
                        this.statusDbname = "_status_datasource";
                    }
                    String dbJNDIName = this.statusDbname + "_jndi";
                    this.initSQLiteStatusDB(this.statusDbname, dbJNDIName);
                } else {
                    this.useOuterStatusDb = true;
                    this.initStatusSQL(statusDBConfig);
                }
            }
            this.dataTranPlugin.getSetLastValueType().set();
            this.existSQL = "select 1 from " + this.statusTableName;
            this.existHisSQL = "select 1 from " + this.historyStatusTableName;
            this.selectSQL = "select id,lasttime,lastvalue,strLastValue,lastvaluetype,filePath,relativeParentDir,fileId,status,jobId,jobType from " + this.statusTableName + " where id=? and jobType=?";
            this.selectByJobIdSQL = "select id,lasttime,lastvalue,strLastValue,lastvaluetype,filePath,relativeParentDir,fileId,status,jobId,jobType from " + this.statusTableName + " where id=? and " + " jobId=? and jobType=?";
            this.checkFieldSQL = "select filePath,fileId,relativeParentDir,status,jobId,jobType,strLastValue from " + this.statusTableName;
            this.checkHisFieldSQL = "select filePath,fileId,relativeParentDir,status,statusId,jobId,jobType,strLastValue from " + this.historyStatusTableName;
            this.selectAllSQL = "select id,lasttime,lastvalue,strLastValue,lastvaluetype,filePath,relativeParentDir,fileId,status,jobId,jobType from " + this.statusTableName + " where jobType=?";
            this.selectAllByJobIdSQL = "select id,lasttime,lastvalue,strLastValue,lastvaluetype,filePath,relativeParentDir,fileId,status,jobId,jobType from " + this.statusTableName + " where jobId = ? and jobType=?";
            this.updateSQL = "update " + this.statusTableName + " set lasttime = ?,lastvalue = ? ,strLastValue = ?,lastvaluetype= ? , filePath = ?,relativeParentDir = ?,fileId = ? ,status = ? where id=? and jobType=?";
            this.updateByJobIdSQL = "update " + this.statusTableName + " set lasttime = ?,lastvalue = ? ,strLastValue = ?,lastvaluetype= ? , filePath = ?,relativeParentDir = ?,fileId = ? ,status = ? where id=? and " + " jobId=? and jobType=?";
            this.updateStatusSQL = "update " + this.statusTableName + " set status = ?, lasttime= ?" + " where id=? and jobType=?";
            this.updateByJobIdStatusSQL = "update " + this.statusTableName + " set status = ?, lasttime= ?" + " where id=? and " + " jobId=? and jobType=?";
            this.insertSQL = "insert into " + this.statusTableName + " (id,lasttime,lastvalue,strLastValue,lastvaluetype,filePath,relativeParentDir,fileId,status,jobId,jobType) values(?,?,?,?,?,?,?,?,?,?,?)";
            this.deleteSQL = "delete from " + this.statusTableName + " where id=? and jobType=?";
            this.deleteByJobIdSQL = "delete from " + this.statusTableName + " where id=? and " + " jobId=? and jobType=?";
            this.insertHistorySQL = "insert into " + this.statusTableName + "_his (id,lasttime,lastvalue,strLastValue,lastvaluetype,filePath,relativeParentDir,fileId,status,jobId,jobType,statusId) values(?,?,?,?,?,?,?,?,?,?,?,?)";
        }
    }

    private void createTable(String tableName, String sql) {
        try {
            SQLExecutor.updateWithDBName((String)this.statusDbname, (String)sql, (Object[])new Object[0]);
            if (logger.isInfoEnabled()) {
                logger.info("table " + tableName + " create success\uff1a" + sql + ".");
            }
        }
        catch (Exception e1) {
            if (logger.isInfoEnabled()) {
                logger.info("table " + tableName + " create failed\uff1a" + sql + ".", (Throwable)e1);
            }
            throw ImportExceptionUtil.buildDataImportException(this.importContext, e1);
        }
    }

    @Override
    public void initTableAndStatus(InitLastValueClumnName initLastValueClumnName) {
        initLastValueClumnName.initLastValueClumnName();
        this.initStatusStore();
        this.initDatasource();
        if (this.isIncreamentImport() && this.importContext.getStatusTableId() == null) {
            this.dataTranPlugin.initStatusTableId();
        }
        if (this.isIncreamentImport()) {
            SimpleDateFormat dateFormat;
            try {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.initLastDate = dateFormat.parse("1970-01-01 00:00:00");
                this.initLastLocalDateTime = TimeUtil.localDateTime((String)"1970-01-01 00:00:00");
                SQLExecutor.queryObjectWithDBName(Integer.TYPE, (String)this.statusDbname, (String)this.existSQL, (Object[])new Object[0]);
                this.checkStatusFieldExist();
            }
            catch (Exception e) {
                if (logger.isInfoEnabled()) {
                    logger.info("{} table not exist\uff0c{}\uff1a{}.", new Object[]{this.statusTableName, this.statusTableName, this.createStatusTableSQL});
                }
                this.createTable(this.statusTableName, this.createStatusTableSQL);
            }
            try {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.initLastDate = dateFormat.parse("1970-01-01 00:00:00");
                this.initLastLocalDateTime = TimeUtil.localDateTime((String)"1970-01-01 00:00:00");
                SQLExecutor.queryObjectWithDBName(Integer.TYPE, (String)this.statusDbname, (String)this.existHisSQL, (Object[])new Object[0]);
                this.checkHisStatusFieldExist();
            }
            catch (Exception e) {
                if (logger.isInfoEnabled()) {
                    logger.info("{} table not exist\uff0c{}\uff1a{}.", new Object[]{this.historyStatusTableName, this.statusTableName, this.createHistoryStatusTableSQL});
                }
                this.createTable(this.historyStatusTableName, this.createHistoryStatusTableSQL);
            }
            this.init();
            this.dataTranPlugin.getLoadCurrentStatus().load();
        } else {
            try {
                Status currentStatus = new Status();
                currentStatus.setId(this.importContext.getStatusTableId());
                currentStatus.setTime(new Date().getTime());
                currentStatus.setJobId(this.importContext.getJobId());
                LastValueWrapper lastValueWrapper = new LastValueWrapper();
                currentStatus.setCurrentLastValueWrapper(lastValueWrapper);
                lastValueWrapper.setTimeStamp(currentStatus.getTime());
                this.firstStatus = currentStatus.copy();
                this.currentStatus = currentStatus;
            }
            catch (Exception e) {
                throw ImportExceptionUtil.buildDataImportException(this.importContext, e);
            }
        }
    }

    protected void initStatusStore() {
        if (this.isIncreamentImport()) {
            this.statusTableName = this.importContext.getLastValueStoreTableName();
            if (this.statusTableName == null) {
                this.statusTableName = "increament_tab";
            }
            if (this.importContext.getLastValueStorePath() == null || this.importContext.getLastValueStorePath().equals("")) {
                DBConfig statusDBConfig = this.importContext.getStatusDbConfig();
                if (statusDBConfig == null) {
                    this.statusStorePath = "StatusStoreDB";
                    if (SimpleStringUtil.isNotEmpty((String)this.importContext.getLastValueStorePassword())) {
                        this.statusStorePassword = this.importContext.getLastValueStorePassword();
                    }
                }
            } else {
                this.statusStorePath = this.importContext.getLastValueStorePath();
                if (SimpleStringUtil.isNotEmpty((String)this.importContext.getLastValueStorePassword())) {
                    this.statusStorePassword = this.importContext.getLastValueStorePassword();
                }
            }
            this.historyStatusTableName = this.statusTableName + "_his";
        }
    }

    private void initSQLiteStatusDB(String statusDbname, String dbJNDIName) {
        try {
            this.createStatusTableSQL = DBConfig.sqlitex_createStatusTableSQL.replace("$statusTableName", this.statusTableName);
            this.createHistoryStatusTableSQL = DBConfig.sqlitex_createHistoryStatusTableSQL.replace("$historyStatusTableName", this.historyStatusTableName);
            File dbpath = new File(this.statusStorePath);
            logger.info("initDatasource dbpath:" + dbpath.getCanonicalPath());
            DBConf tempConf = new DBConf();
            tempConf.setPoolname(statusDbname);
            tempConf.setDriver("org.sqlite.JDBC");
            tempConf.setJdbcurl("jdbc:sqlite://" + dbpath.getCanonicalPath());
            tempConf.setUsername("root");
            tempConf.setPassword(this.statusStorePassword);
            tempConf.setReadOnly((String)null);
            tempConf.setTxIsolationLevel((String)null);
            tempConf.setValidationQuery("select 1");
            tempConf.setJndiName(dbJNDIName);
            tempConf.setInitialConnections(1);
            tempConf.setMinimumSize(1);
            tempConf.setMaximumSize(1);
            tempConf.setUsepool(true);
            tempConf.setExternal(false);
            tempConf.setExternaljndiName((String)null);
            tempConf.setShowsql(false);
            tempConf.setEncryptdbinfo(false);
            tempConf.setQueryfetchsize(null);
            boolean ret = SQLManager.startPool((DBConf)tempConf);
            if (!ret) {
                logger.warn("Ignore start started Status_datasource[" + statusDbname + "].");
                this.useOuterStatusDb = true;
                this.initStatusSQL(statusDbname);
            } else {
                logger.warn("Start Status_datasource[" + statusDbname + "] complete.");
            }
        }
        catch (Exception e) {
            throw ImportExceptionUtil.buildDataImportException(this.importContext, e);
        }
    }

    private void initStatusSQL(DBConfig statusDBConfig) {
        this.createStatusTableSQL = statusDBConfig.getStatusTableDML();
        if (this.createStatusTableSQL == null) {
            this.createStatusTableSQL = DBConfig.getCreateStatusTableSQL(SQLUtil.getPool((String)this.statusDbname).getDBType());
        }
        this.createHistoryStatusTableSQL = statusDBConfig.getStatusHistoryTableDML();
        if (this.createHistoryStatusTableSQL == null) {
            this.createHistoryStatusTableSQL = DBConfig.getCreateHistoryStatusTableSQL(SQLUtil.getPool((String)this.statusDbname).getDBType());
        }
        this.createStatusTableSQL = this.createStatusTableSQL.replace("$statusTableName", this.statusTableName);
        this.createHistoryStatusTableSQL = this.createHistoryStatusTableSQL.replace("$historyStatusTableName", this.historyStatusTableName);
    }

    private void checkHisStatusFieldExist() {
        String defaultValue = DBConfig.getStatusTableDefaultValue(SQLUtil.getPool((String)this.statusDbname).getDBType());
        String type = DBConfig.getStatusTableType(SQLUtil.getPool((String)this.statusDbname).getDBType());
        try {
            SQLExecutor.queryObjectWithDBName(Status.class, (String)this.statusDbname, (String)this.checkHisFieldSQL, (Object[])new Object[0]);
        }
        catch (SQLException e) {
            logger.warn("filePath,status,statusId and fileId not exit in table {" + this.historyStatusTableName + "},and will be added.");
            this.addField("filePath", this.historyStatusTableName, defaultValue, "500", type);
            this.addField("relativeParentDir", this.historyStatusTableName, defaultValue, "500", type);
            this.addField("fileId", this.historyStatusTableName, defaultValue, "500", type);
            this.addField("jobId", this.historyStatusTableName, defaultValue, "500", type);
            this.addField("jobType", this.historyStatusTableName, defaultValue, "500", type);
            this.addField("strLastValue", this.historyStatusTableName, defaultValue, "100", type);
            this.addField("status", this.historyStatusTableName, null, "1", DBConfig.getStatusTableTypeNumber(SQLUtil.getPool((String)this.statusDbname).getDBType()));
            this.addField("statusId", this.historyStatusTableName, null, "10", DBConfig.getStatusTableTypeBigNumber(SQLUtil.getPool((String)this.statusDbname).getDBType()));
        }
    }

    @Override
    public void initLastValueClumnName() {
        if (this.lastValueClumnName != null) {
            return;
        }
        if (this.importContext.getLastValueColumn() != null) {
            this.lastValueClumnName = this.importContext.getLastValueColumn();
        } else if (this.dataTranPlugin.getLastValueVarName() != null) {
            this.lastValueClumnName = this.dataTranPlugin.getLastValueVarName();
        }
        if (this.lastValueClumnName == null) {
            if (!this.importContext.validateIncreamentConfig()) {
                throw ImportExceptionUtil.buildDataImportException(this.importContext, "\u914d\u7f6e\u6821\u9a8c\u5931\u8d25\uff1a\u589e\u91cf\u5bfc\u5165\u60c5\u51b5\u4e0b\uff0c\u672a\u6307\u5b9a\u589e\u91cf\u5bfc\u5165\u72b6\u6001\u5b57\u6bb5!");
            }
            this.setIncreamentImport(false);
        }
    }

    @Override
    public void handleOldedTasks(List<Status> olded) {
        for (Status status : olded) {
            this.handleOldedTask(status);
        }
    }

    @Override
    public void handleOldedTask(Status olded) {
        try {
            olded.setTime(System.currentTimeMillis());
            olded.setStatus(1);
            if (olded.getJobId() == null) {
                SQLExecutor.updateWithDBName((String)this.statusDbname, (String)this.updateStatusSQL, (Object[])new Object[]{olded.getStatus(), olded.getTime(), olded.getId()});
            } else {
                SQLExecutor.updateWithDBName((String)this.statusDbname, (String)this.updateByJobIdStatusSQL, (Object[])new Object[]{olded.getStatus(), olded.getTime(), olded.getId(), olded.getJobId()});
            }
        }
        catch (Exception e) {
            logger.error("handleCompletedTasks failed:" + SimpleStringUtil.object2json((Object)olded), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleStatus(Status currentStatus, boolean fromUpdate) {
        LastValueWrapper lastValueWrapper = currentStatus.getCurrentLastValueWrapper();
        currentStatus.setOriginCurrentLastValueWrapper(lastValueWrapper.copy());
        Object lastValue = lastValueWrapper.getLastValue();
        String strLastValue = null;
        if (this.importContext.isLastValueDateType()) {
            if (logger.isDebugEnabled()) {
                logger.debug("AddStatus: \u589e\u91cf\u5b57\u6bb5\u503c LastValue is Date Type:{},real data type is {},real last value is {}", new Object[]{this.importContext.isLastValueDateType(), lastValue.getClass().getName(), lastValue});
            }
            if (!(lastValue instanceof Date)) throw ImportExceptionUtil.buildDataImportException(this.importContext, "AddStatus: \u589e\u91cf\u5b57\u6bb5\u4e3a\u65e5\u671f\u7c7b\u578b\uff0cBut the LastValue is not a Date value:" + lastValue + ",value type is " + lastValue.getClass().getName());
            lastValue = ((Date)lastValue).getTime();
            lastValueWrapper.setLastValue(lastValue);
        } else if (this.importContext.isLastValueLocalDateTimeType()) {
            if (logger.isDebugEnabled()) {
                logger.debug("AddStatus: \u589e\u91cf\u5b57\u6bb5\u503c LastValue isLastValueLocalDateTimeType:{},real data type is {},real last value is {}", new Object[]{this.importContext.isLastValueLocalDateTimeType(), lastValue.getClass().getName(), lastValue});
            }
            if (!(lastValue instanceof LocalDateTime)) throw ImportExceptionUtil.buildDataImportException(this.importContext, "AddStatus: \u589e\u91cf\u5b57\u6bb5\u4e3aLocalDateTime\u7c7b\u578b\uff0cBut the LastValue is not a LocalDateTime value:" + lastValue + ",value type is " + lastValue.getClass().getName());
            strLastValue = TimeUtil.changeLocalDateTime2String((LocalDateTime)((LocalDateTime)lastValue), (String)this.importContext.getLastValueDateformat());
            lastValueWrapper.setStrLastValue(strLastValue);
            lastValueWrapper.setLastValue(-1);
            lastValue = null;
        } else if (logger.isDebugEnabled()) {
            logger.debug("handleStatus: \u589e\u91cf\u5b57\u6bb5\u503c LastValue is Number Type:{},real data type is {},real last value is {}", new Object[]{this.importContext.isLastValueNumberType(), lastValue.getClass().getName(), lastValue});
        }
        if (this.lastValueWraperSerial == null) return;
        this.lastValueWraperSerial.serial(currentStatus);
    }

    @Override
    public void addStatus(Status currentStatus) throws DataImportException {
        try {
            this.handleStatus(currentStatus, false);
            SQLExecutor.insertWithDBName((String)this.statusDbname, (String)this.insertSQL, (Object[])new Object[]{currentStatus.getId(), currentStatus.getTime(), currentStatus.getCurrentLastValueWrapper().getLastValue(), currentStatus.getStrLastValue(), this.lastValueType, currentStatus.getFilePath(), currentStatus.getRelativeParentDir(), currentStatus.getFileId(), currentStatus.getStatus(), currentStatus.getJobId(), currentStatus.getJobType()});
        }
        catch (SQLException throwables) {
            throw new DataImportException("Add Status failed:" + currentStatus.toString(), throwables);
        }
    }

    @Override
    public void updateStatus(Status currentStatus) throws Exception {
        if (!this.isStoped()) {
            this.handleStatus(currentStatus, true);
            this.putStatus(currentStatus);
        }
    }

    private void initLastValueStatus(boolean update) throws Exception {
        Status currentStatus = new Status();
        currentStatus.setId(this.importContext.getStatusTableId());
        currentStatus.setTime(new Date().getTime());
        LastValueWrapper lastValueWrapper = new LastValueWrapper();
        currentStatus.setCurrentLastValueWrapper(lastValueWrapper);
        lastValueWrapper.setTimeStamp(currentStatus.getTime());
        this.dataTranPlugin.initLastValueStatus(currentStatus, this);
        if (this.importContext.getJobId() != null) {
            currentStatus.setJobId(this.importContext.getJobId());
        }
        currentStatus.setJobType(this.importContext.getJobType());
        currentStatus.setLastValueType(this.lastValueType);
        Status tmp = currentStatus.copy();
        if (!update) {
            this.addStatus(tmp);
        } else {
            this.updateStatus(tmp);
        }
        this.currentStatus = currentStatus;
        this.firstStatus = currentStatus.copy();
        if (logger.isInfoEnabled()) {
            logger.info("Init Job {} LastValue Status: {}", (Object)this.importContext.getJobName(), (Object)currentStatus.toString());
        }
    }

    @Override
    public void handleLostedTasks(List<Status> losteds, boolean needSyn) {
        try {
            for (Status losted : losteds) {
                Status status = losted.copy();
                this.handleStatus(status, true);
                this.putStatus(status);
            }
        }
        catch (Exception e) {
            logger.error("handleCompletedTasks failed:" + SimpleStringUtil.object2json(losteds), (Throwable)e);
        }
    }

    @Override
    public void handleOldedRegistedRecordTasks(List<Status> completed) {
        try {
            for (Status status_ : completed) {
                File file = new File(status_.getFilePath());
                if (file.exists()) continue;
                Status status = status_.copy();
                this.handleStatus(status, true);
                SQLExecutor.insertWithDBName((String)this.statusDbname, (String)this.insertHistorySQL, (Object[])new Object[]{SimpleStringUtil.getUUID(), status.getTime(), status.getCurrentLastValueWrapper().getLastValue(), status.getStrLastValue(), status.getLastValueType(), status.getFilePath(), status.getRelativeParentDir(), status.getFileId(), status.getStatus(), status.getJobId(), status.getJobType(), status.getId()});
                if (status.getJobId() == null) {
                    SQLExecutor.deleteWithDBName((String)this.statusDbname, (String)this.deleteSQL, (Object[])new Object[]{status.getId(), status.getJobType()});
                } else {
                    SQLExecutor.deleteWithDBName((String)this.statusDbname, (String)this.deleteByJobIdSQL, (Object[])new Object[]{status.getId(), status.getJobId(), status.getJobType()});
                }
                if (!logger.isInfoEnabled()) continue;
                logger.info("Move Olded Task Registed Record to history complete {}:", (Object)status.toString());
            }
        }
        catch (Exception e) {
            logger.error("handleOldedRegistedRecordTasks failed:", (Throwable)e);
        }
    }

    @Override
    public boolean isOldRegistRecord(Status completed, long registLiveTime) {
        long lastTime;
        long now = System.currentTimeMillis();
        long deletedTime = now - registLiveTime;
        File file = new File(completed.getFilePath());
        return !file.exists() && (lastTime = completed.getTime()) <= deletedTime;
    }

    @Override
    public List<Status> getPluginStatuses() {
        try {
            if (this.importContext.getJobId() == null) {
                List statuses = SQLExecutor.queryListWithDBName(Status.class, (String)this.statusDbname, (String)this.selectAllSQL, (Object[])new Object[]{this.importContext.getJobType()});
                if (statuses != null && statuses.size() > 0) {
                    for (Status status : statuses) {
                        this.lastValueWraperSerial.deserial(status);
                    }
                }
                return statuses;
            }
            List statuses = SQLExecutor.queryListWithDBName(Status.class, (String)this.statusDbname, (String)this.selectAllByJobIdSQL, (Object[])new Object[]{this.importContext.getJobId(), this.importContext.getJobType()});
            if (statuses != null && statuses.size() > 0) {
                for (Status status : statuses) {
                    this.lastValueWraperSerial.deserial(status);
                }
            }
            return statuses;
        }
        catch (SQLException throwables) {
            throw new DataImportException(throwables);
        }
    }

    @Override
    public LoadCurrentStatus getLoadCurrentStatus() {
        return new LoadCurrentStatus(){

            @Override
            public void load() {
                BaseStatusManager.this.loadCurrentStatus();
            }
        };
    }

    @Override
    public Status getStatus(String jobId, String jobType, String statusId) {
        try {
            Status status = null;
            status = jobId == null ? (Status)SQLExecutor.queryObjectWithDBName(Status.class, (String)this.statusDbname, (String)this.selectSQL, (Object[])new Object[]{statusId, jobType}) : (Status)SQLExecutor.queryObjectWithDBName(Status.class, (String)this.statusDbname, (String)this.selectByJobIdSQL, (Object[])new Object[]{statusId, jobId, jobType});
            this.lastValueWraperSerial.deserial(status);
            return status;
        }
        catch (Exception e) {
            throw new DataImportException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadCurrentStatus() {
        try {
            block13: {
                LastValueWrapper lastValueWrapper;
                block14: {
                    this.currentStatus = this.getStatus(this.importContext.getJobId(), this.importContext.getJobType(), this.importContext.getStatusTableId());
                    if (this.currentStatus == null) {
                        this.initLastValueStatus(false);
                        return;
                    }
                    if (this.importContext.isFromFirst()) {
                        this.initLastValueStatus(true);
                        return;
                    }
                    if (this.currentStatus.getLastValueType() != this.lastValueType) {
                        if (logger.isWarnEnabled()) {
                            logger.warn("The config lastValueType is {} but from currentStatus lastValueType is {},and use the config lastValueType to releace currentStatus lastValueType.", (Object)this.lastValueType, (Object)this.currentStatus.getLastValueType());
                        }
                        this.initLastValueStatus(true);
                        return;
                    }
                    lastValueWrapper = this.currentStatus.getCurrentLastValueWrapper();
                    if (this.currentStatus.getLastValueType() != 1) break block14;
                    Object lastValue = lastValueWrapper.getLastValue();
                    if (lastValue instanceof Long) {
                        lastValueWrapper.setLastValue(new Date((Long)lastValue));
                        break block13;
                    } else if (lastValue instanceof BigDecimal) {
                        lastValueWrapper.setLastValue(new Date(((BigDecimal)lastValue).longValue()));
                        break block13;
                    } else {
                        if (!(lastValue instanceof Integer)) {
                            if (!logger.isWarnEnabled()) throw new DataImportException("InitTableAndStatus\uff1a\u589e\u91cf\u5b57\u6bb5\u7c7b\u578b\u4e3a\u65e5\u671f\u7c7b\u578b, But the LastValue from status table is not a long value:" + lastValue + ",value type is " + lastValue.getClass().getName());
                            logger.warn("initTableAndStatus\uff1a\u589e\u91cf\u5b57\u6bb5\u7c7b\u578b\u4e3a\u65e5\u671f\u7c7b\u578b, But the LastValue from status table is not a long value:{},value type is {}", lastValue, (Object)lastValue.getClass().getName());
                            throw new DataImportException("InitTableAndStatus\uff1a\u589e\u91cf\u5b57\u6bb5\u7c7b\u578b\u4e3a\u65e5\u671f\u7c7b\u578b, But the LastValue from status table is not a long value:" + lastValue + ",value type is " + lastValue.getClass().getName());
                        }
                        lastValueWrapper.setLastValue(new Date(((Integer)lastValue).longValue()));
                    }
                    break block13;
                }
                if (this.currentStatus.getLastValueType() == 2) {
                    String lastValue = lastValueWrapper.getStrLastValue();
                    lastValueWrapper.setLastValue(TimeUtil.localDateTime((String)lastValue));
                }
            }
            this.firstStatus = this.currentStatus.copy();
            return;
        }
        catch (DataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataImportException(e);
        }
    }

    @Override
    public Status getCurrentStatus() {
        return this.currentStatus;
    }

    @Override
    public void setIncreamentImport(boolean increamentImport) {
        this.increamentImport = increamentImport;
    }

    @Override
    public boolean isIncreamentImport() {
        return this.increamentImport;
    }

    @Override
    public String getLastValueClumnName() {
        return this.lastValueClumnName;
    }

    @Override
    public Object[] putLastParamValue(Map params) {
        Object[] ret = new Object[2];
        LastValueWrapper lastValueWrapper = this.currentStatus.getCurrentLastValueWrapper();
        String lastValueVarName = this.dataTranPlugin.getLastValueVarName();
        Object lastValue = lastValueWrapper.getLastValue();
        if (this.lastValueType == 0) {
            params.put(lastValueVarName, lastValue);
            if (this.importContext.increamentEndOffset() != null && this.importContext.isNumberTypeTimestamp()) {
                Date lastOffsetValue = org.frameworkset.util.TimeUtil.addDateSeconds((Date)new Date(), (int)(0 - this.importContext.increamentEndOffset()));
                ret[1] = lastOffsetValue;
                params.put(lastValueVarName + "__endTime", lastOffsetValue.getTime());
            }
        } else if (this.lastValueType == 1) {
            Date ldate = null;
            ldate = lastValue instanceof Date ? (Date)lastValue : (lastValue instanceof Long ? new Date((Long)lastValue) : (lastValue instanceof BigDecimal ? new Date(((BigDecimal)lastValue).longValue()) : (lastValue instanceof Integer ? new Date(((Integer)lastValue).longValue()) : (lastValue instanceof Short ? new Date(((Short)lastValue).longValue()) : new Date(((Number)lastValue).longValue())))));
            params.put(lastValueVarName, this.formatLastDateValue(ldate));
            if (this.importContext.increamentEndOffset() != null) {
                Date lastOffsetValue = org.frameworkset.util.TimeUtil.addDateSeconds((Date)new Date(), (int)(0 - this.importContext.increamentEndOffset()));
                ret[1] = lastOffsetValue;
                params.put(lastValueVarName + "__endTime", this.formatLastDateValue(lastOffsetValue));
            }
        } else if (this.lastValueType == 2) {
            params.put(lastValueVarName, this.formatLastLocalDateTimeValue((LocalDateTime)lastValue));
            if (this.importContext.increamentEndOffset() != null) {
                Date lastOffsetValue = org.frameworkset.util.TimeUtil.addDateSeconds((Date)new Date(), (int)(0 - this.importContext.increamentEndOffset()));
                LocalDateTime localDateTime = TimeUtil.date2LocalDateTime((Date)lastOffsetValue);
                ret[1] = localDateTime;
                params.put(lastValueVarName + "__endTime", this.formatLastLocalDateTimeValue(localDateTime));
            }
        }
        if (this.isPrintTaskLog()) {
            logger.info("Current values: " + params);
        }
        ret[0] = lastValue;
        return ret;
    }

    protected boolean isPrintTaskLog() {
        return this.importContext.isPrintTaskLog() && logger.isInfoEnabled();
    }

    protected Object formatLastDateValue(Date date) {
        return this.importContext.getInputPlugin().formatLastDateValue(date);
    }

    protected Object formatLastLocalDateTimeValue(LocalDateTime date) {
        return this.importContext.getInputPlugin().formatLastLocalDateTimeValue(date);
    }

    @Override
    public void stopStatusDatasource() {
        try {
            if (this.statusDbname != null && !this.statusDbname.equals("") && !this.useOuterStatusDb) {
                SQLUtil.stopPool((String)this.statusDbname);
            }
        }
        catch (Exception e) {
            logger.error("Stop status db pool[" + this.statusDbname + "] failed:", (Throwable)e);
        }
    }

    @Override
    public Map getParamValue(Map params) {
        LastValueWrapper lastValueWrapper = this.currentStatus.getCurrentLastValueWrapper();
        Object lastValue = lastValueWrapper.getLastValue();
        String lastValueVarName = this.dataTranPlugin.getLastValueVarName();
        if (this.lastValueType == 0) {
            params.put(lastValueVarName, lastValue);
            if (this.importContext.isNumberTypeTimestamp() && this.importContext.increamentEndOffset() != null) {
                Date lastOffsetValue = org.frameworkset.util.TimeUtil.addDateSeconds((Date)new Date(), (int)(0 - this.importContext.increamentEndOffset()));
                params.put(lastValueVarName + "__endTime", lastOffsetValue.getTime());
            }
        } else if (this.lastValueType == 1) {
            if (lastValue instanceof Date) {
                params.put(lastValueVarName, lastValue);
            } else if (lastValue instanceof Long) {
                params.put(lastValueVarName, new Date((Long)lastValue));
            } else if (lastValue instanceof BigDecimal) {
                params.put(lastValueVarName, new Date(((BigDecimal)lastValue).longValue()));
            } else if (lastValue instanceof Integer) {
                params.put(lastValueVarName, new Date(((Integer)lastValue).longValue()));
            } else if (lastValue instanceof Short) {
                params.put(lastValueVarName, new Date(((Short)lastValue).longValue()));
            } else {
                params.put(lastValueVarName, new Date(((Number)lastValue).longValue()));
            }
            if (this.importContext.increamentEndOffset() != null) {
                Date lastOffsetValue = org.frameworkset.util.TimeUtil.addDateSeconds((Date)new Date(), (int)(0 - this.importContext.increamentEndOffset()));
                params.put(lastValueVarName + "__endTime", lastOffsetValue);
            }
        } else if (this.lastValueType == 2) {
            params.put(lastValueVarName, lastValue);
            if (this.importContext.increamentEndOffset() != null) {
                Date lastOffsetValue = org.frameworkset.util.TimeUtil.addDateSeconds((Date)new Date(), (int)(0 - this.importContext.increamentEndOffset()));
                params.put(lastValueVarName + "__endTime", TimeUtil.date2LocalDateTime((Date)lastOffsetValue));
            }
        }
        if (this.isPrintTaskLog()) {
            logger.info("Current values: " + params);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushLastValue(LastValueWrapper lastValueWrapper, Status currentStatus, boolean reachEOFClosed) {
        if (lastValueWrapper != null) {
            Status status = null;
            Status status2 = currentStatus;
            synchronized (status2) {
                LastValueWrapper oldLastValueWrapper = currentStatus.getCurrentLastValueWrapper();
                if (!reachEOFClosed && !this.importContext.needUpdateLastValueWrapper(oldLastValueWrapper, lastValueWrapper)) {
                    return;
                }
                if (lastValueWrapper.getTimeStamp() != null) {
                    currentStatus.setTime(lastValueWrapper.getTimeStamp());
                } else {
                    long time = System.currentTimeMillis();
                    currentStatus.setTime(time);
                }
                currentStatus.setCurrentLastValueWrapper(lastValueWrapper);
                if (reachEOFClosed) {
                    currentStatus.setStatus(1);
                }
                if (this.isIncreamentImport()) {
                    status = currentStatus.copy();
                }
            }
            if (status != null) {
                this.storeStatus(status);
            }
        }
    }

    public void storeStatus(Status currentStatus) {
        try {
            this.updateStatus(currentStatus);
        }
        catch (DataImportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataImportException(e);
        }
    }

    @Override
    public int getLastValueType() {
        return this.lastValueType;
    }

    public Date getInitLastDate() {
        return this.initLastDate;
    }

    public LocalDateTime getInitLastLocalDateTime() {
        return this.initLastLocalDateTime;
    }
}

