/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.status;

import com.frameworkset.common.poolman.BatchHandler;
import com.frameworkset.common.poolman.SQLExecutor;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.status.BaseStatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiStatusManager
extends BaseStatusManager {
    private static Logger logger = LoggerFactory.getLogger(MultiStatusManager.class);
    private Map<String, WrapStatus> statuses = new LinkedHashMap<String, WrapStatus>();
    private long liveTime = 172800000L;

    public MultiStatusManager(DataTranPlugin dataTranPlugin) {
        super(dataTranPlugin);
    }

    @Override
    protected void _putStatus(Status currentStatus) {
        WrapStatus wrapStatus = this.statuses.get(currentStatus.getFileId());
        if (wrapStatus == null) {
            wrapStatus = new WrapStatus();
            wrapStatus.currentStatus = currentStatus;
            wrapStatus.lastPutTime = System.currentTimeMillis();
            wrapStatus.needUpdate = true;
            this.statuses.put(currentStatus.getFileId(), wrapStatus);
        } else {
            boolean needUpdate = this.importContext.needUpdateLastValueWrapper(wrapStatus.currentStatus.getOriginCurrentLastValueWrapper(), currentStatus.getOriginCurrentLastValueWrapper());
            if (needUpdate) {
                wrapStatus.currentStatus = currentStatus;
                wrapStatus.lastPutTime = System.currentTimeMillis();
                wrapStatus.needUpdate = true;
            } else if (this.importContext.getDataTranPlugin().isComplete(currentStatus)) {
                wrapStatus.currentStatus = currentStatus;
                wrapStatus.lastPutTime = System.currentTimeMillis();
                wrapStatus.needUpdate = true;
            }
        }
    }

    @Override
    protected void _flushStatus() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("flushStatus start.");
        }
        ArrayList<WrapStatus> datas = new ArrayList<WrapStatus>();
        ArrayList<Status> removeDatas = new ArrayList<Status>();
        Set<Map.Entry<String, WrapStatus>> statusSet = this.statuses.entrySet();
        WrapStatus wrapStatus = null;
        long interval = 0L;
        long ntime = System.currentTimeMillis();
        for (Map.Entry<String, WrapStatus> entry : statusSet) {
            wrapStatus = entry.getValue();
            if (wrapStatus.needUpdate) {
                datas.add(wrapStatus);
                continue;
            }
            interval = ntime - wrapStatus.lastPutTime;
            if (interval < this.liveTime) continue;
            removeDatas.add(wrapStatus.currentStatus);
        }
        if (datas.size() > 0) {
            if (this.importContext.getJobId() == null) {
                SQLExecutor.executeBatch((String)this.statusDbname, (String)this.updateSQL, datas, (int)100, (BatchHandler)new BatchHandler<WrapStatus>(){

                    public void handler(PreparedStatement stmt, WrapStatus wrapStatus1, int i) throws SQLException {
                        Status record = wrapStatus1.currentStatus;
                        stmt.setLong(1, record.getTime());
                        stmt.setObject(2, MultiStatusManager.this.convertLastValue(record.getCurrentLastValueWrapper().getLastValue()));
                        stmt.setObject(3, MultiStatusManager.this.convertStrLastValue(record.getStrLastValue()));
                        stmt.setInt(4, MultiStatusManager.this.lastValueType);
                        stmt.setString(5, record.getFilePath());
                        stmt.setString(6, record.getRelativeParentDir());
                        stmt.setString(7, record.getFileId());
                        stmt.setInt(8, record.getStatus());
                        stmt.setString(9, record.getId());
                        stmt.setString(10, record.getJobType());
                        wrapStatus1.needUpdate = false;
                    }
                });
            } else {
                SQLExecutor.executeBatch((String)this.statusDbname, (String)this.updateByJobIdSQL, datas, (int)100, (BatchHandler)new BatchHandler<WrapStatus>(){

                    public void handler(PreparedStatement stmt, WrapStatus wrapStatus1, int i) throws SQLException {
                        Status record = wrapStatus1.currentStatus;
                        stmt.setLong(1, record.getTime());
                        stmt.setObject(2, MultiStatusManager.this.convertLastValue(record.getCurrentLastValueWrapper().getLastValue()));
                        stmt.setObject(3, MultiStatusManager.this.convertStrLastValue(record.getStrLastValue()));
                        stmt.setInt(4, MultiStatusManager.this.lastValueType);
                        stmt.setString(5, record.getFilePath());
                        stmt.setString(6, record.getRelativeParentDir());
                        stmt.setString(7, record.getFileId());
                        stmt.setInt(8, record.getStatus());
                        stmt.setString(9, record.getId());
                        stmt.setString(10, MultiStatusManager.this.importContext.getJobId());
                        stmt.setString(11, MultiStatusManager.this.importContext.getJobType());
                        wrapStatus1.needUpdate = false;
                    }
                });
            }
            for (Status status : removeDatas) {
                this.statuses.remove(status.getFileId());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("flush {} Statuses end .", (Object)datas.size());
        }
    }

    static class WrapStatus {
        Status currentStatus;
        long lastPutTime;
        boolean needUpdate;

        WrapStatus() {
        }
    }
}

