/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.task;

import java.util.List;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.context.JobContext;
import org.frameworkset.tran.exception.ImportExceptionUtil;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.metrics.TaskMetrics;
import org.frameworkset.tran.plugin.OutputPlugin;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.status.LastValueWrapper;
import org.frameworkset.tran.task.TaskCommand;
import org.frameworkset.tran.task.TaskCommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTaskCommand<RESULT>
implements TaskCommand<RESULT> {
    private static Logger logger = LoggerFactory.getLogger(BaseTaskCommand.class);
    protected ImportCount importCount;
    protected ImportContext importContext;
    protected TaskMetrics taskMetrics;
    protected TaskContext taskContext;
    protected LastValueWrapper lastValue;
    protected long totalSize;
    protected Status currentStatus;
    protected List<CommonRecord> records;
    protected TaskCommandContext taskCommandContext;
    protected boolean multiOutputTran;
    protected OutputConfig outputConfig;
    protected OutputPlugin outputPlugin;

    @Override
    public boolean isMultiOutputTran() {
        return this.outputConfig.isMultiOutputTran();
    }

    @Override
    public OutputPlugin getOutputPlugin() {
        return this.outputPlugin;
    }

    @Override
    public void setRecords(List<CommonRecord> records) {
        this.records = records;
    }

    protected void logNodatas(Logger logger) {
        ImportExceptionUtil.loginfo(logger, this.importContext, "All output data is ignored and do nothing.", this.outputPlugin);
    }

    @Override
    public List<CommonRecord> getRecords() {
        return this.records;
    }

    @Override
    public Object getDatas() {
        return this.records;
    }

    @Override
    public void init() {
        TaskMetrics taskMetrics = this.getTaskMetrics();
        if (this.taskContext != null) {
            this.taskContext.beginTask(taskMetrics);
        }
    }

    @Override
    public JobContext getJobContext() {
        if (this.importContext != null) {
            return this.importContext.getJobContext();
        }
        return null;
    }

    @Override
    public LastValueWrapper getLastValue() {
        return this.lastValue;
    }

    @Override
    public long getDataSize() {
        return this.taskCommandContext.getDataSize();
    }

    @Override
    public TaskMetrics getTaskMetrics() {
        return this.taskMetrics;
    }

    @Override
    public int getTaskNo() {
        return this.taskMetrics.getTaskNo();
    }

    @Override
    public String getJobNo() {
        return this.taskMetrics.getJobNo();
    }

    @Override
    public ImportContext getImportContext() {
        return this.importContext;
    }

    @Override
    public void finishTask() {
        if (!this.isMultiOutputTran()) {
            this.importContext.flushLastValue(this.lastValue, this.currentStatus);
        }
    }

    @Override
    public long getElapsed() {
        if (this.taskMetrics != null) {
            return this.taskMetrics.getElapsed();
        }
        return -1L;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    @Override
    public OutputConfig getOutputConfig() {
        return this.outputConfig;
    }

    public BaseTaskCommand(OutputConfig outputConfig, TaskCommandContext taskCommandContext) {
        this.outputConfig = outputConfig;
        this.outputPlugin = outputConfig.getOutputPlugin();
        this.taskCommandContext = taskCommandContext;
        this.importCount = taskCommandContext.getTotalCount();
        this.importContext = taskCommandContext.getImportContext();
        this.totalSize = this.importCount.getTotalCount();
        this.taskMetrics = taskCommandContext.getTaskMetrics();
        this.lastValue = taskCommandContext.getLastValue();
        this.currentStatus = taskCommandContext.getCurrentStatus();
        this.taskContext = taskCommandContext.getTaskContext();
    }

    @Override
    public ImportCount getImportCount() {
        return this.importCount;
    }

    @Override
    public TaskCommandContext getTaskCommandContext() {
        return this.taskCommandContext;
    }

    @Override
    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    @Override
    public void finished() {
        try {
            if (this.taskContext != null && this.taskMetrics != null) {
                this.taskContext.finishTaskMetrics(this.taskMetrics);
            }
        }
        catch (Exception e) {
            logger.error("Task finished failed:", (Throwable)e);
        }
    }
}

