/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.task;

import java.util.List;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.metrics.TaskMetrics;
import org.frameworkset.tran.metrics.job.BuildMapDataContext;
import org.frameworkset.tran.plugin.InputPlugin;
import org.frameworkset.tran.plugin.OutputPlugin;
import org.frameworkset.tran.plugin.metrics.output.ETLMapData;
import org.frameworkset.tran.plugin.metrics.output.ETLMetrics;
import org.frameworkset.tran.plugin.metrics.output.MetricsData;
import org.frameworkset.tran.task.TranJob;

public abstract class BaseTranJob
implements TranJob {
    public static StringBuilder builderJobInfo(InputPlugin inputPlugin, OutputPlugin outputPlugin, StringBuilder builder, ImportContext importContext) {
        builder.append("inputJobType[").append(inputPlugin.getJobType()).append("],").append("outputJobType[").append(outputPlugin.getJobType()).append("]");
        if (importContext.getJobId() != null) {
            builder.append(",jobID[").append(importContext.getJobId()).append("]");
        }
        if (importContext.getJobName() != null) {
            builder.append(",jobName[").append(importContext.getJobName()).append("] ");
        }
        return builder;
    }

    public BuildMapDataContext buildMapDataContext(ImportContext importContext) {
        List<ETLMetrics> etlMetrics = importContext.getMetrics();
        BuildMapDataContext buildMapDataContext = null;
        if (etlMetrics != null) {
            buildMapDataContext = new BuildMapDataContext();
            String dataTimeField = importContext.getDataTimeField();
            buildMapDataContext.setDataTimeField(dataTimeField);
        }
        return buildMapDataContext;
    }

    public static void map(CommonRecord commonRecord, TaskMetrics taskMetrics, BuildMapDataContext buildMapDataContext, List<ETLMetrics> etlMetrics, boolean isUseDefaultMapData) {
        MetricsData metricsData = new MetricsData();
        metricsData.setBuildMapDataContext(buildMapDataContext);
        metricsData.setCommonRecord(commonRecord);
        metricsData.setTaskMetrics(taskMetrics);
        ETLMapData defaultMapData = null;
        if (isUseDefaultMapData) {
            defaultMapData = new ETLMapData();
            defaultMapData.setTaskMetrics(taskMetrics);
            metricsData.setData(defaultMapData, null);
        }
        for (ETLMetrics metrics : etlMetrics) {
            if (metrics.getDataTimeField() != null || metrics.getBuildMapData() != null || defaultMapData == null) {
                metrics.map(metrics.buildMapData(metricsData));
                continue;
            }
            metrics.map(defaultMapData);
        }
    }
}

