/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.task;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.frameworkset.tran.BaseDataTran;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.Record;
import org.frameworkset.tran.TranErrorWrapper;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.WaitTasksCompleteCallBack;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.exception.ImportExceptionUtil;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.metrics.ParallImportCount;
import org.frameworkset.tran.metrics.TaskMetrics;
import org.frameworkset.tran.metrics.TaskMetricsUtil;
import org.frameworkset.tran.record.NextAssert;
import org.frameworkset.tran.record.WrappedRecord;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.status.LastValueWrapper;
import org.frameworkset.tran.task.CommonRecordTranJob;
import org.frameworkset.tran.task.ParrelTranCommand;
import org.frameworkset.tran.task.TaskCommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonAsynRecordTranJob
extends CommonRecordTranJob {
    private static Logger logger = LoggerFactory.getLogger(CommonAsynRecordTranJob.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String parallelBatchExecute(ParrelTranCommand parrelTranCommand, Status currentStatus, ImportContext importContext, TranResultSet tranResultSet, BaseDataTran baseDataTran) {
        int count = 0;
        int droped = 0;
        long totalSize = 0L;
        ArrayList<Record> records = new ArrayList<Record>();
        String ret = null;
        ExecutorService service = importContext.buildThreadPool();
        ArrayList<Future> tasks = new ArrayList<Future>();
        int taskNo = 0;
        TaskMetrics taskMetrics = TaskMetricsUtil.createTaskMetrics(baseDataTran.getTaskContext(), taskNo);
        ParallImportCount totalCount = new ParallImportCount();
        Throwable exception = null;
        LastValueWrapper currentLastValueWrapper = currentStatus != null ? currentStatus.getCurrentLastValueWrapper() : null;
        LastValueWrapper lastValue = null;
        TranErrorWrapper tranErrorWrapper = new TranErrorWrapper(importContext);
        int batchsize = importContext.getStoreBatchSize();
        boolean reachEOFClosed = false;
        int ignoreCount = 0;
        long istart = 0L;
        long end = 0L;
        try {
            while (true) {
                if (!tranErrorWrapper.assertCondition()) {
                    tranResultSet.stop(true);
                    Throwable ex = tranErrorWrapper.throwError();
                    if (ex == null) break;
                    throw ex;
                }
                NextAssert hasNext = tranResultSet.next();
                if (hasNext.isNeedFlush()) {
                    if (count > 0) {
                        TaskCommandContext taskCommandContext = new TaskCommandContext();
                        taskCommandContext.setTotalCount(totalCount);
                        taskCommandContext.setDataSize(count);
                        taskCommandContext.setTaskNo(taskNo);
                        taskCommandContext.setLastValue(lastValue);
                        taskCommandContext.setRecords(records);
                        taskCommandContext.setService(service);
                        taskCommandContext.setTasks(tasks);
                        taskCommandContext.setTranErrorWrapper(tranErrorWrapper);
                        taskCommandContext.setIgnoreCount(ignoreCount);
                        taskCommandContext.setImportContext(importContext);
                        taskCommandContext.setTaskMetrics(taskMetrics);
                        count = 0;
                        droped = 0;
                        ignoreCount = 0;
                        taskNo = parrelTranCommand.hanBatchActionTask(taskCommandContext);
                        taskMetrics = TaskMetricsUtil.createTaskMetrics(baseDataTran.getTaskContext(), taskNo);
                        if (baseDataTran.isPrintTaskLog()) {
                            end = System.currentTimeMillis();
                            StringBuilder builder = CommonAsynRecordTranJob.builderJobInfo(importContext.getInputPlugin(), importContext.getOutputPlugin(), new StringBuilder(), importContext);
                            logger.info(builder.append("Batch import Force flush datas Task[").append(taskNo).append("] complete,take time:").append(end - istart).append("ms").append(",import ").append(taskCommandContext.getDataSize()).append(" records.").append("Force FlushInterval[").append(importContext.getFlushInterval()).append("ms]").toString());
                            istart = end;
                        }
                        records = new ArrayList();
                    } else if (droped > 0) {
                        importContext.flushLastValue(lastValue, currentStatus, reachEOFClosed);
                        droped = 0;
                    }
                    if (!hasNext.isHasNext()) continue;
                }
                if (!hasNext.isHasNext()) break;
                WrappedRecord resultRecord = new WrappedRecord(tranResultSet);
                lastValue = lastValue == null ? importContext.max(currentLastValueWrapper, resultRecord) : importContext.max(lastValue, resultRecord);
                if (resultRecord.isRecordDirectIgnore()) {
                    ++droped;
                    continue;
                }
                if (!reachEOFClosed) {
                    reachEOFClosed = resultRecord.reachEOFClosed();
                }
                if (resultRecord.removed()) {
                    if (reachEOFClosed) continue;
                    ((ImportCount)totalCount).increamentIgnoreTotalCount();
                    ++ignoreCount;
                    continue;
                }
                records.add(resultRecord);
                ++totalSize;
                if (++count < batchsize) continue;
                TaskCommandContext taskCommandContext = new TaskCommandContext();
                taskCommandContext.setTotalCount(totalCount);
                taskCommandContext.setDataSize(count);
                taskCommandContext.setTaskNo(taskNo);
                taskCommandContext.setLastValue(lastValue);
                taskCommandContext.setRecords(records);
                taskCommandContext.setService(service);
                taskCommandContext.setTasks(tasks);
                taskCommandContext.setTranErrorWrapper(tranErrorWrapper);
                taskCommandContext.setIgnoreCount(ignoreCount);
                taskCommandContext.setImportContext(importContext);
                taskCommandContext.setTaskMetrics(taskMetrics);
                count = 0;
                droped = 0;
                ignoreCount = 0;
                taskNo = parrelTranCommand.hanBatchActionTask(taskCommandContext);
                taskMetrics = TaskMetricsUtil.createTaskMetrics(baseDataTran.getTaskContext(), taskNo);
                records = new ArrayList();
            }
            if (count > 0) {
                Throwable e;
                if (!tranErrorWrapper.assertCondition() && (e = tranErrorWrapper.throwError()) != null) {
                    throw e;
                }
                TaskCommandContext taskCommandContext = new TaskCommandContext();
                taskCommandContext.setTotalCount(totalCount);
                taskCommandContext.setDataSize(count);
                taskCommandContext.setTaskNo(taskNo);
                taskCommandContext.setLastValue(lastValue);
                taskCommandContext.setRecords(records);
                taskCommandContext.setService(service);
                taskCommandContext.setTasks(tasks);
                taskCommandContext.setTranErrorWrapper(tranErrorWrapper);
                taskCommandContext.setIgnoreCount(ignoreCount);
                taskCommandContext.setImportContext(importContext);
                taskCommandContext.setTaskMetrics(taskMetrics);
                taskNo = parrelTranCommand.hanBatchActionTask(taskCommandContext);
            }
            if (baseDataTran.isPrintTaskLog()) {
                StringBuilder builder = CommonAsynRecordTranJob.builderJobInfo(importContext.getInputPlugin(), importContext.getOutputPlugin(), new StringBuilder(), importContext);
                logger.info(builder.append("Pararrel batch submit tasks:").append(taskNo).toString());
            }
        }
        catch (DataImportException e) {
            try {
                exception = e;
                throw e;
                catch (Exception e2) {
                    exception = e2;
                    throw ImportExceptionUtil.buildDataImportException(importContext, e2);
                }
                catch (Throwable e3) {
                    exception = e3;
                    throw ImportExceptionUtil.buildDataImportException(importContext, e3);
                }
            }
            catch (Throwable throwable) {
                baseDataTran.waitTasksComplete(tasks, service, exception, lastValue, totalCount, tranErrorWrapper, new WaitTasksCompleteCallBack(){
                    final /* synthetic */ ParrelTranCommand val$parrelTranCommand;
                    {
                        this.val$parrelTranCommand = parrelTranCommand;
                    }

                    @Override
                    public void call() {
                        this.val$parrelTranCommand.parrelCompleteAction();
                    }
                }, reachEOFClosed);
                if (tranResultSet == null) throw throwable;
                tranResultSet.destroy();
                throw throwable;
            }
        }
        baseDataTran.waitTasksComplete(tasks, service, exception, lastValue, totalCount, tranErrorWrapper, new /* invalid duplicate definition of identical inner class */, reachEOFClosed);
        if (tranResultSet == null) return ret;
        tranResultSet.destroy();
        return ret;
    }
}

