/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.task;

import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.TranErrorWrapper;
import org.frameworkset.tran.WrapedExportResultHandler;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.exception.ImportExceptionUtil;
import org.frameworkset.tran.task.BaseTranJob;
import org.frameworkset.tran.task.TaskCall;
import org.frameworkset.tran.task.TaskCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiOutputTaskCall
extends TaskCall {
    private static final Logger log = LoggerFactory.getLogger(MultiOutputTaskCall.class);

    public MultiOutputTaskCall(TaskCommand taskCommand, TranErrorWrapper errorWrapper) {
        super(taskCommand, errorWrapper);
    }

    @Override
    protected <RESULT> RESULT innerCall(TaskCommand<RESULT> taskCommand) {
        ImportContext importContext = taskCommand.getImportContext();
        try {
            RESULT data = taskCommand.execute();
            WrapedExportResultHandler wrapedExportResultHandler = importContext.getExportResultHandler(taskCommand.getOutputConfig());
            if (wrapedExportResultHandler != null) {
                try {
                    wrapedExportResultHandler.handleResult(taskCommand, data);
                }
                catch (Exception e) {
                    StringBuilder stringBuilder = BaseTranJob.builderJobInfo(importContext.getInputPlugin(), taskCommand.getOutputPlugin(), new StringBuilder(), importContext);
                    log.warn(stringBuilder.toString(), (Throwable)e);
                }
            }
            return data;
        }
        catch (DataImportException e) {
            MultiOutputTaskCall.exportResultHandler(taskCommand, importContext, e);
            throw e;
        }
        catch (Exception e) {
            MultiOutputTaskCall.exportResultHandler(taskCommand, importContext, e);
            throw ImportExceptionUtil.buildDataImportException(importContext, e);
        }
        catch (Throwable e) {
            MultiOutputTaskCall.exportResultHandler(taskCommand, importContext, e);
            throw ImportExceptionUtil.buildDataImportException(importContext, e);
        }
    }
}

