/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.util;

import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.context.DefaultReInitAction;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.util.StoppedThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventListenStoppedThread
extends StoppedThread {
    private static Logger logger = LoggerFactory.getLogger(EventListenStoppedThread.class);
    private TaskContext taskContext;
    private DataTranPlugin dataTranPlugin;
    private long metricsInterval;

    public EventListenStoppedThread(TaskContext taskContext, DataTranPlugin dataTranPlugin, long metricsInterval) {
        this.taskContext = taskContext;
        this.dataTranPlugin = dataTranPlugin;
        this.metricsInterval = metricsInterval;
    }

    @Override
    public void run() {
        while (!this.stopped) {
            try {
                this.taskContext.reInitContext(new DefaultReInitAction(this.dataTranPlugin));
            }
            catch (Exception e) {
                logger.error(this.getName() + " afterCall Exception", (Throwable)e);
            }
            if (this.stopped) break;
            try {
                EventListenStoppedThread.sleep(this.metricsInterval);
            }
            catch (InterruptedException e) {
                logger.error(this.getName() + " InterruptedException", (Throwable)e);
                break;
            }
        }
    }
}

