/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.jobflow;

import groovy.lang.GroovyClassLoader;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.frameworkset.tran.jobflow.JobFlowException;
import org.frameworkset.tran.jobflow.JobFlowNode;
import org.frameworkset.tran.jobflow.JobFlowStatus;
import org.frameworkset.tran.jobflow.OneTimeExecuteThread;
import org.frameworkset.tran.jobflow.context.AssertResult;
import org.frameworkset.tran.jobflow.context.DefaultJobFlowExecuteContext;
import org.frameworkset.tran.jobflow.context.JobFlowContext;
import org.frameworkset.tran.jobflow.context.JobFlowExecuteContext;
import org.frameworkset.tran.jobflow.listener.JobFlowListener;
import org.frameworkset.tran.jobflow.metrics.JobFlowMetrics;
import org.frameworkset.tran.jobflow.schedule.JobFlowScheduleConfig;
import org.frameworkset.tran.jobflow.schedule.JobFlowScheduleTimer;
import org.frameworkset.tran.schedule.ScheduleEndCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobFlow {
    private static final Logger logger = LoggerFactory.getLogger(JobFlow.class);
    private String jobFlowId;
    private String jobFlowName;
    private JobFlowScheduleConfig jobFlowScheduleConfig;
    private boolean externalTimer;
    private JobFlowNode startJobFlowNode;
    private JobFlowScheduleTimer jobFlowScheduleTimer;
    private JobFlowExecuteContext jobFlowExecuteContext;
    private JobFlowContext jobFlowContext;
    private JobFlowMetrics jobFlowMetrics;
    private GroovyClassLoader groovyClassLoader;
    private List<JobFlowListener> jobFlowListeners;
    private OneTimeExecuteThread oneTimeExecuteThread;
    private String jobInfo;
    private Object startEndScheduleThreadLock = new Object();
    private Thread scheduledEndThread;

    public JobFlow() {
        this.jobFlowContext = new JobFlowContext(this);
        this.initGroovyClassLoader();
        this.jobFlowMetrics = new JobFlowMetrics();
    }

    public JobFlowMetrics getJobFlowMetrics() {
        return this.jobFlowMetrics;
    }

    public void setJobFlowListeners(List<JobFlowListener> jobFlowListeners) {
        this.jobFlowListeners = jobFlowListeners;
    }

    public List<JobFlowListener> getJobFlowListeners() {
        return this.jobFlowListeners;
    }

    public GroovyClassLoader getGroovyClassLoader() {
        return this.groovyClassLoader;
    }

    public JobFlowContext getJobFlowContext() {
        return this.jobFlowContext;
    }

    private void initGroovyClassLoader() {
        if (this.groovyClassLoader != null) {
            return;
        }
        CompilerConfiguration config = new CompilerConfiguration();
        config.setSourceEncoding("UTF-8");
        this.groovyClassLoader = new GroovyClassLoader(Thread.currentThread().getContextClassLoader(), config);
        logger.info("initGroovyClassLoader with SourceEncoding UTF-8," + this.jobInfo);
    }

    public void setStartJobFlowNode(JobFlowNode startJobFlowNode) {
        this.startJobFlowNode = startJobFlowNode;
        this.startJobFlowNode.setContainerJobFlowContext(this.jobFlowContext);
    }

    public void initJobInfo() {
        StringBuilder info = new StringBuilder();
        info.append("JobFlow[jobFlowId=").append(this.getJobFlowId()).append(",jobFlowName=").append(this.getJobFlowName()).append("]");
        this.jobInfo = info.toString();
    }

    public void execute() {
        logger.info("Execute {} begin.", (Object)this.jobInfo);
        this.startEndScheduleThread(new ScheduleEndCall(){

            @Override
            public void call(boolean scheduled) {
                JobFlow.this.stop(true);
            }
        });
        this.reset();
        this.jobFlowExecuteContext = new DefaultJobFlowExecuteContext(this);
        this.jobFlowMetrics.addTotalCount();
        if (CollectionUtils.isNotEmpty(this.jobFlowListeners)) {
            for (JobFlowListener jobFlowListener : this.jobFlowListeners) {
                jobFlowListener.beforeExecute(this.jobFlowExecuteContext);
            }
        }
        Throwable throwable = null;
        try {
            this.startJobFlowNode.start();
        }
        catch (RuntimeException e) {
            throwable = e;
            throw e;
        }
        catch (Exception e) {
            throwable = e;
            throw new JobFlowException(e);
        }
        catch (Throwable e) {
            throwable = e;
            throw new JobFlowException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startEndScheduleThread(final ScheduleEndCall scheduleEndCall) {
        if (this.jobFlowScheduleConfig == null) {
            return;
        }
        Date scheduleEndDate = this.jobFlowScheduleConfig.getScheduleEndDate();
        if (scheduleEndDate != null) {
            if (this.jobFlowScheduleConfig.isExecuteOneTime()) {
                logger.info("\u4e00\u6b21\u6027\u6267\u884c\u5de5\u4f5c\u6d41\uff0c\u5ffd\u7565Start EndSchedule Thread\uff1ascheduleEndDate[{}]", (Object)DateFormatUtils.format((Date)scheduleEndDate, (String)"yyyy-MM-dd HH:mm:ss.SSS"));
                return;
            }
            Object object = this.startEndScheduleThreadLock;
            synchronized (object) {
                if (this.scheduledEndThread == null) {
                    final long waitTime = scheduleEndDate.getTime() - System.currentTimeMillis();
                    this.scheduledEndThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (waitTime > 0L) {
                                try {
                                    Thread.sleep(waitTime);
                                    scheduleEndCall.call(true);
                                }
                                catch (InterruptedException interruptedException) {}
                            } else {
                                scheduleEndCall.call(true);
                            }
                        }
                    }, "Datatran-JobFlowScheduledEndThread");
                    this.scheduledEndThread.setDaemon(true);
                    this.scheduledEndThread.start();
                }
            }
        }
    }

    private void reset() {
        this.jobFlowContext.reset();
        this.startJobFlowNode.reset();
    }

    public void initJob() {
        this.jobFlowContext.initJob();
    }

    public static void delay(String jobInfo, JobFlowScheduleConfig jobFlowScheduleConfig) {
        Date now;
        Long _deLay = null;
        Long deyLay = jobFlowScheduleConfig.getDelay();
        Date scheduleDate = jobFlowScheduleConfig.getScheduleDate();
        if (scheduleDate != null && scheduleDate.after(now = new Date())) {
            _deLay = scheduleDate.getTime() - now.getTime();
        }
        if (_deLay == null && deyLay != null) {
            _deLay = deyLay;
        }
        if (_deLay != null) {
            try {
                logger.info("{} will delay {} ms to execute.", (Object)jobInfo, (Object)_deLay);
                Thread.sleep(_deLay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void start() {
        block10: {
            AssertResult assertResult = this.jobFlowContext.assertStarted();
            if (assertResult.isTrue()) {
                logger.warn("{} \u72b6\u6001\u4e3a\uff1a{}\uff0c\u5df2\u7ecf\u542f\u52a8\u8fc7\uff0c\u5ffd\u7565\u542f\u52a8\u64cd\u4f5c\u3002", (Object)this.jobInfo, (Object)assertResult.getJobFlowStatus().name());
                return;
            }
            if (CollectionUtils.isNotEmpty(this.jobFlowListeners)) {
                for (JobFlowListener jobFlowListener : this.jobFlowListeners) {
                    jobFlowListener.beforeStart(this);
                }
            }
            if (this.jobFlowScheduleConfig == null || this.jobFlowScheduleConfig.isExecuteOneTime()) {
                this.oneTimeExecuteThread = new OneTimeExecuteThread(this.getJobFlowName(), new Runnable(){

                    @Override
                    public void run() {
                        JobFlow.this.initJob();
                        JobFlow.delay(JobFlow.this.getJobInfo(), JobFlow.this.jobFlowScheduleConfig);
                        if (JobFlow.this.jobFlowContext.assertStopped().isTrue()) {
                            logger.info("{} stopped,ignore delay execute.", (Object)JobFlow.this.jobInfo);
                            return;
                        }
                        JobFlow.this.jobFlowContext.pauseAwait();
                        JobFlow.this.execute();
                    }
                });
                this.oneTimeExecuteThread.start();
                try {
                    if (this.jobFlowScheduleConfig == null || this.jobFlowScheduleConfig.isExecuteOneTimeSyn()) {
                        logger.info("{} executeOneTime by syn.", (Object)this.jobInfo);
                        this.oneTimeExecuteThread.join();
                        break block10;
                    }
                    logger.info("{} executeOneTime by asyn.", (Object)this.jobInfo);
                }
                catch (InterruptedException interruptedException) {}
            } else if (!this.jobFlowScheduleConfig.isExternalTimer()) {
                this.initJob();
                JobFlowScheduleTimer jobFlowScheduleTimer = new JobFlowScheduleTimer(this.jobFlowScheduleConfig, this);
                jobFlowScheduleTimer.start();
                this.jobFlowScheduleTimer = jobFlowScheduleTimer;
            } else {
                logger.info("JobFlow is scheduled by externalTimer,ignore start.");
            }
        }
    }

    public String getJobInfo() {
        return this.jobInfo;
    }

    private void release() {
        if (this.groovyClassLoader != null) {
            this.groovyClassLoader.clearCache();
        }
    }

    public void stop() {
        this.stop(false);
    }

    protected void stop(final boolean fromScheduled) {
        boolean stopResult = this.jobFlowContext.stop(new Function(){

            public Object apply(Object o) {
                JobFlow.this.startJobFlowNode.stop();
                if (JobFlow.this.oneTimeExecuteThread != null) {
                    JobFlow.this.oneTimeExecuteThread.interrupt();
                    try {
                        JobFlow.this.oneTimeExecuteThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    if (JobFlow.this.jobFlowScheduleTimer != null) {
                        JobFlow.this.jobFlowScheduleTimer.stop();
                    }
                }
                catch (Exception e) {
                    logger.warn("stop jobFlowScheduleTimer exception:", (Throwable)e);
                }
                try {
                    if (JobFlow.this.groovyClassLoader != null) {
                        JobFlow.this.groovyClassLoader.clearCache();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!fromScheduled && JobFlow.this.scheduledEndThread != null) {
                    try {
                        JobFlow.this.scheduledEndThread.interrupt();
                        JobFlow.this.scheduledEndThread.join();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        }, fromScheduled);
        if (CollectionUtils.isNotEmpty(this.jobFlowListeners)) {
            for (JobFlowListener jobFlowListener : this.jobFlowListeners) {
                jobFlowListener.afterEnd(this);
            }
        }
    }

    public void pause() {
        this.jobFlowContext.pause();
    }

    public void consume() {
        this.jobFlowContext.consume();
    }

    public JobFlowExecuteContext getJobFlowExecuteContext() {
        return this.jobFlowExecuteContext;
    }

    public String getJobFlowId() {
        return this.jobFlowId;
    }

    public void setJobFlowId(String jobFlowId) {
        this.jobFlowId = jobFlowId;
    }

    public String getJobFlowName() {
        return this.jobFlowName;
    }

    public void setJobFlowName(String jobFlowName) {
        this.jobFlowName = jobFlowName;
    }

    public void setJobFlowExecuteContext(JobFlowExecuteContext jobFlowExecuteContext) {
        this.jobFlowExecuteContext = jobFlowExecuteContext;
    }

    public void complete(Throwable throwable) {
        this.jobFlowMetrics.complete(throwable);
        if (this.isExternalTimer()) {
            this.jobFlowContext.updateJobFlowStatus(JobFlowStatus.COMPLETE);
            logger.info("{} \u8c03\u5ea6\u6267\u884c\u5b8c\u6210\uff0c\u66f4\u65b0\u5de5\u4f5c\u6d41\u72b6\u6001\u4e3a\u8c03\u5ea6\u5b8c\u6210", (Object)this.jobInfo);
        } else if (this.jobFlowScheduleConfig == null || this.jobFlowScheduleConfig.isExecuteOneTime()) {
            this.jobFlowContext.updateJobFlowStatus(JobFlowStatus.STOPED);
            logger.info("{} \u4e00\u6b21\u6027\u6267\u884c\u5b8c\u6210\uff0c\u66f4\u65b0\u5de5\u4f5c\u6d41\u72b6\u6001\u4e3a\u505c\u6b62", (Object)this.jobInfo);
        } else {
            this.jobFlowContext.updateJobFlowStatus(JobFlowStatus.COMPLETE);
            logger.info("{} \u8c03\u5ea6\u6267\u884c\u5b8c\u6210\uff0c\u66f4\u65b0\u5de5\u4f5c\u6d41\u72b6\u6001\u4e3a\u8c03\u5ea6\u5b8c\u6210", (Object)this.jobInfo);
        }
        if (CollectionUtils.isNotEmpty(this.jobFlowListeners)) {
            for (JobFlowListener jobFlowListener : this.jobFlowListeners) {
                jobFlowListener.afterExecute(this.jobFlowExecuteContext, throwable);
            }
        }
        this.jobFlowExecuteContext = null;
        this.reset();
    }

    public boolean isEnableAutoPauseScheduled() {
        return false;
    }

    public boolean isSchedulePaused(boolean enableAutoPauseScheduled) {
        return false;
    }

    public JobFlowScheduleConfig getJobScheduleConfig() {
        return this.jobFlowScheduleConfig;
    }

    public void setJobScheduleConfig(JobFlowScheduleConfig jobFlowScheduleConfig) {
        this.jobFlowScheduleConfig = jobFlowScheduleConfig;
    }

    public String toString() {
        return this.jobInfo;
    }

    public boolean isExternalTimer() {
        return this.externalTimer;
    }

    public void setExternalTimer(boolean externalTimer) {
        this.externalTimer = externalTimer;
    }
}

